# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSelfServiceAppSnapshotsResult',
    'AwaitableGetSelfServiceAppSnapshotsResult',
    'get_self_service_app_snapshots',
    'get_self_service_app_snapshots_output',
]

@pulumi.output_type
class GetSelfServiceAppSnapshotsResult:
    """
    A collection of values returned by getSelfServiceAppSnapshots.
    """
    def __init__(__self__, api_version=None, app_name=None, app_uuid=None, entities=None, id=None, kind=None, length=None, offset=None, total_matches=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if app_name and not isinstance(app_name, str):
            raise TypeError("Expected argument 'app_name' to be a str")
        pulumi.set(__self__, "app_name", app_name)
        if app_uuid and not isinstance(app_uuid, str):
            raise TypeError("Expected argument 'app_uuid' to be a str")
        pulumi.set(__self__, "app_uuid", app_uuid)
        if entities and not isinstance(entities, list):
            raise TypeError("Expected argument 'entities' to be a list")
        pulumi.set(__self__, "entities", entities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if length and not isinstance(length, int):
            raise TypeError("Expected argument 'length' to be a int")
        pulumi.set(__self__, "length", length)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)
        if total_matches and not isinstance(total_matches, int):
            raise TypeError("Expected argument 'total_matches' to be a int")
        pulumi.set(__self__, "total_matches", total_matches)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        - The API version used to retrieve the snapshot data.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.GetSelfServiceAppSnapshotsEntityResult']:
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        -  The type of resource represented by the snapshot specification.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def length(self) -> _builtins.int:
        """
        - (Required) The number of snapshots to retrieve.
        """
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> _builtins.int:
        """
        - (Required) The index of the first snapshot to return (for pagination). Default value: 0
        """
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter(name="totalMatches")
    def total_matches(self) -> _builtins.int:
        """
        - The total number of recovery points available for the application.
        """
        return pulumi.get(self, "total_matches")


class AwaitableGetSelfServiceAppSnapshotsResult(GetSelfServiceAppSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSelfServiceAppSnapshotsResult(
            api_version=self.api_version,
            app_name=self.app_name,
            app_uuid=self.app_uuid,
            entities=self.entities,
            id=self.id,
            kind=self.kind,
            length=self.length,
            offset=self.offset,
            total_matches=self.total_matches)


def get_self_service_app_snapshots(app_name: Optional[_builtins.str] = None,
                                   app_uuid: Optional[_builtins.str] = None,
                                   length: Optional[_builtins.int] = None,
                                   offset: Optional[_builtins.int] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSelfServiceAppSnapshotsResult:
    """
    Describes recovery points (snapshots taken) present in an NCM Self Service Application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test = nutanix.get_self_service_app_snapshots(app_name="NAME OF APPLICATION",
        length=250,
        offset=0)
    ```


    :param _builtins.str app_name: - (Optional) The name of the application.
    :param _builtins.str app_uuid: - (Optional) The UUID of the application.
           
           Both (`app_name` and `app_uuid`) are optional but atleast one of them to be provided for this data source to work.
    :param _builtins.int length: - (Required) The number of snapshots to retrieve.
    :param _builtins.int offset: - (Required) The index of the first snapshot to return (for pagination). Default value: 0
    """
    __args__ = dict()
    __args__['appName'] = app_name
    __args__['appUuid'] = app_uuid
    __args__['length'] = length
    __args__['offset'] = offset
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getSelfServiceAppSnapshots:getSelfServiceAppSnapshots', __args__, opts=opts, typ=GetSelfServiceAppSnapshotsResult).value

    return AwaitableGetSelfServiceAppSnapshotsResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        app_name=pulumi.get(__ret__, 'app_name'),
        app_uuid=pulumi.get(__ret__, 'app_uuid'),
        entities=pulumi.get(__ret__, 'entities'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        length=pulumi.get(__ret__, 'length'),
        offset=pulumi.get(__ret__, 'offset'),
        total_matches=pulumi.get(__ret__, 'total_matches'))
def get_self_service_app_snapshots_output(app_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          app_uuid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          length: Optional[pulumi.Input[_builtins.int]] = None,
                                          offset: Optional[pulumi.Input[_builtins.int]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSelfServiceAppSnapshotsResult]:
    """
    Describes recovery points (snapshots taken) present in an NCM Self Service Application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test = nutanix.get_self_service_app_snapshots(app_name="NAME OF APPLICATION",
        length=250,
        offset=0)
    ```


    :param _builtins.str app_name: - (Optional) The name of the application.
    :param _builtins.str app_uuid: - (Optional) The UUID of the application.
           
           Both (`app_name` and `app_uuid`) are optional but atleast one of them to be provided for this data source to work.
    :param _builtins.int length: - (Required) The number of snapshots to retrieve.
    :param _builtins.int offset: - (Required) The index of the first snapshot to return (for pagination). Default value: 0
    """
    __args__ = dict()
    __args__['appName'] = app_name
    __args__['appUuid'] = app_uuid
    __args__['length'] = length
    __args__['offset'] = offset
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getSelfServiceAppSnapshots:getSelfServiceAppSnapshots', __args__, opts=opts, typ=GetSelfServiceAppSnapshotsResult)
    return __ret__.apply(lambda __response__: GetSelfServiceAppSnapshotsResult(
        api_version=pulumi.get(__response__, 'api_version'),
        app_name=pulumi.get(__response__, 'app_name'),
        app_uuid=pulumi.get(__response__, 'app_uuid'),
        entities=pulumi.get(__response__, 'entities'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        length=pulumi.get(__response__, 'length'),
        offset=pulumi.get(__response__, 'offset'),
        total_matches=pulumi.get(__response__, 'total_matches')))
