# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStaticRoutesResult',
    'AwaitableGetStaticRoutesResult',
    'get_static_routes',
    'get_static_routes_output',
]

@pulumi.output_type
class GetStaticRoutesResult:
    """
    A collection of values returned by getStaticRoutes.
    """
    def __init__(__self__, api_version=None, id=None, metadata=None, specs=None, statuses=None, vpc_name=None, vpc_reference_uuid=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if vpc_name and not isinstance(vpc_name, str):
            raise TypeError("Expected argument 'vpc_name' to be a str")
        pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_reference_uuid and not isinstance(vpc_reference_uuid, str):
            raise TypeError("Expected argument 'vpc_reference_uuid' to be a str")
        pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        API version
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        The vpc_route_table kind metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetStaticRoutesSpecResult']:
        """
        An intentful representation of a vpc_route_table spec
        """
        return pulumi.get(self, "specs")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence['outputs.GetStaticRoutesStatusResult']:
        """
        An intentful representation of a vpc_route_table status
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpc_reference_uuid")


class AwaitableGetStaticRoutesResult(GetStaticRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStaticRoutesResult(
            api_version=self.api_version,
            id=self.id,
            metadata=self.metadata,
            specs=self.specs,
            statuses=self.statuses,
            vpc_name=self.vpc_name,
            vpc_reference_uuid=self.vpc_reference_uuid)


def get_static_routes(vpc_name: Optional[_builtins.str] = None,
                      vpc_reference_uuid: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStaticRoutesResult:
    """
    Provides a datasource to retrieve static routes within VPCs given vpc_uuid.


    :param _builtins.str vpc_reference_uuid: vpc UUID
    """
    __args__ = dict()
    __args__['vpcName'] = vpc_name
    __args__['vpcReferenceUuid'] = vpc_reference_uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getStaticRoutes:getStaticRoutes', __args__, opts=opts, typ=GetStaticRoutesResult).value

    return AwaitableGetStaticRoutesResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        specs=pulumi.get(__ret__, 'specs'),
        statuses=pulumi.get(__ret__, 'statuses'),
        vpc_name=pulumi.get(__ret__, 'vpc_name'),
        vpc_reference_uuid=pulumi.get(__ret__, 'vpc_reference_uuid'))
def get_static_routes_output(vpc_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             vpc_reference_uuid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStaticRoutesResult]:
    """
    Provides a datasource to retrieve static routes within VPCs given vpc_uuid.


    :param _builtins.str vpc_reference_uuid: vpc UUID
    """
    __args__ = dict()
    __args__['vpcName'] = vpc_name
    __args__['vpcReferenceUuid'] = vpc_reference_uuid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getStaticRoutes:getStaticRoutes', __args__, opts=opts, typ=GetStaticRoutesResult)
    return __ret__.apply(lambda __response__: GetStaticRoutesResult(
        api_version=pulumi.get(__response__, 'api_version'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        specs=pulumi.get(__response__, 'specs'),
        statuses=pulumi.get(__response__, 'statuses'),
        vpc_name=pulumi.get(__response__, 'vpc_name'),
        vpc_reference_uuid=pulumi.get(__response__, 'vpc_reference_uuid')))
