# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStorageContainerV2Result',
    'AwaitableGetStorageContainerV2Result',
    'get_storage_container_v2',
    'get_storage_container_v2_output',
]

@pulumi.output_type
class GetStorageContainerV2Result:
    """
    A collection of values returned by getStorageContainerV2.
    """
    def __init__(__self__, affinity_host_ext_id=None, cache_deduplication=None, cluster_ext_id=None, cluster_name=None, compression_delay_secs=None, container_ext_id=None, erasure_code=None, erasure_code_delay_secs=None, ext_id=None, has_higher_ec_fault_domain_preference=None, id=None, is_compression_enabled=None, is_encrypted=None, is_inline_ec_enabled=None, is_internal=None, is_marked_for_removal=None, is_nfs_whitelist_inherited=None, is_software_encryption_enabled=None, links=None, logical_advertised_capacity_bytes=None, logical_explicit_reserved_capacity_bytes=None, logical_implicit_reserved_capacity_bytes=None, max_capacity_bytes=None, name=None, nfs_whitelist_addresses=None, on_disk_dedup=None, owner_ext_id=None, replication_factor=None, storage_pool_ext_id=None, tenant_id=None):
        if affinity_host_ext_id and not isinstance(affinity_host_ext_id, str):
            raise TypeError("Expected argument 'affinity_host_ext_id' to be a str")
        pulumi.set(__self__, "affinity_host_ext_id", affinity_host_ext_id)
        if cache_deduplication and not isinstance(cache_deduplication, str):
            raise TypeError("Expected argument 'cache_deduplication' to be a str")
        pulumi.set(__self__, "cache_deduplication", cache_deduplication)
        if cluster_ext_id and not isinstance(cluster_ext_id, str):
            raise TypeError("Expected argument 'cluster_ext_id' to be a str")
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if compression_delay_secs and not isinstance(compression_delay_secs, int):
            raise TypeError("Expected argument 'compression_delay_secs' to be a int")
        pulumi.set(__self__, "compression_delay_secs", compression_delay_secs)
        if container_ext_id and not isinstance(container_ext_id, str):
            raise TypeError("Expected argument 'container_ext_id' to be a str")
        pulumi.set(__self__, "container_ext_id", container_ext_id)
        if erasure_code and not isinstance(erasure_code, str):
            raise TypeError("Expected argument 'erasure_code' to be a str")
        pulumi.set(__self__, "erasure_code", erasure_code)
        if erasure_code_delay_secs and not isinstance(erasure_code_delay_secs, int):
            raise TypeError("Expected argument 'erasure_code_delay_secs' to be a int")
        pulumi.set(__self__, "erasure_code_delay_secs", erasure_code_delay_secs)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if has_higher_ec_fault_domain_preference and not isinstance(has_higher_ec_fault_domain_preference, bool):
            raise TypeError("Expected argument 'has_higher_ec_fault_domain_preference' to be a bool")
        pulumi.set(__self__, "has_higher_ec_fault_domain_preference", has_higher_ec_fault_domain_preference)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compression_enabled and not isinstance(is_compression_enabled, bool):
            raise TypeError("Expected argument 'is_compression_enabled' to be a bool")
        pulumi.set(__self__, "is_compression_enabled", is_compression_enabled)
        if is_encrypted and not isinstance(is_encrypted, bool):
            raise TypeError("Expected argument 'is_encrypted' to be a bool")
        pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_inline_ec_enabled and not isinstance(is_inline_ec_enabled, bool):
            raise TypeError("Expected argument 'is_inline_ec_enabled' to be a bool")
        pulumi.set(__self__, "is_inline_ec_enabled", is_inline_ec_enabled)
        if is_internal and not isinstance(is_internal, bool):
            raise TypeError("Expected argument 'is_internal' to be a bool")
        pulumi.set(__self__, "is_internal", is_internal)
        if is_marked_for_removal and not isinstance(is_marked_for_removal, bool):
            raise TypeError("Expected argument 'is_marked_for_removal' to be a bool")
        pulumi.set(__self__, "is_marked_for_removal", is_marked_for_removal)
        if is_nfs_whitelist_inherited and not isinstance(is_nfs_whitelist_inherited, bool):
            raise TypeError("Expected argument 'is_nfs_whitelist_inherited' to be a bool")
        pulumi.set(__self__, "is_nfs_whitelist_inherited", is_nfs_whitelist_inherited)
        if is_software_encryption_enabled and not isinstance(is_software_encryption_enabled, bool):
            raise TypeError("Expected argument 'is_software_encryption_enabled' to be a bool")
        pulumi.set(__self__, "is_software_encryption_enabled", is_software_encryption_enabled)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if logical_advertised_capacity_bytes and not isinstance(logical_advertised_capacity_bytes, int):
            raise TypeError("Expected argument 'logical_advertised_capacity_bytes' to be a int")
        pulumi.set(__self__, "logical_advertised_capacity_bytes", logical_advertised_capacity_bytes)
        if logical_explicit_reserved_capacity_bytes and not isinstance(logical_explicit_reserved_capacity_bytes, int):
            raise TypeError("Expected argument 'logical_explicit_reserved_capacity_bytes' to be a int")
        pulumi.set(__self__, "logical_explicit_reserved_capacity_bytes", logical_explicit_reserved_capacity_bytes)
        if logical_implicit_reserved_capacity_bytes and not isinstance(logical_implicit_reserved_capacity_bytes, int):
            raise TypeError("Expected argument 'logical_implicit_reserved_capacity_bytes' to be a int")
        pulumi.set(__self__, "logical_implicit_reserved_capacity_bytes", logical_implicit_reserved_capacity_bytes)
        if max_capacity_bytes and not isinstance(max_capacity_bytes, int):
            raise TypeError("Expected argument 'max_capacity_bytes' to be a int")
        pulumi.set(__self__, "max_capacity_bytes", max_capacity_bytes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nfs_whitelist_addresses and not isinstance(nfs_whitelist_addresses, list):
            raise TypeError("Expected argument 'nfs_whitelist_addresses' to be a list")
        pulumi.set(__self__, "nfs_whitelist_addresses", nfs_whitelist_addresses)
        if on_disk_dedup and not isinstance(on_disk_dedup, str):
            raise TypeError("Expected argument 'on_disk_dedup' to be a str")
        pulumi.set(__self__, "on_disk_dedup", on_disk_dedup)
        if owner_ext_id and not isinstance(owner_ext_id, str):
            raise TypeError("Expected argument 'owner_ext_id' to be a str")
        pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if replication_factor and not isinstance(replication_factor, int):
            raise TypeError("Expected argument 'replication_factor' to be a int")
        pulumi.set(__self__, "replication_factor", replication_factor)
        if storage_pool_ext_id and not isinstance(storage_pool_ext_id, str):
            raise TypeError("Expected argument 'storage_pool_ext_id' to be a str")
        pulumi.set(__self__, "storage_pool_ext_id", storage_pool_ext_id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="affinityHostExtId")
    def affinity_host_ext_id(self) -> _builtins.str:
        """
        - Affinity host extId for RF 1 Storage Container.
        """
        return pulumi.get(self, "affinity_host_ext_id")

    @_builtins.property
    @pulumi.getter(name="cacheDeduplication")
    def cache_deduplication(self) -> _builtins.str:
        """
        - Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "cache_deduplication")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> _builtins.str:
        """
        - ext id for the cluster owning the storage container.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        - Corresponding name of the Cluster owning the Storage Container instance.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="compressionDelaySecs")
    def compression_delay_secs(self) -> _builtins.int:
        """
        - The compression delay in seconds.
        """
        return pulumi.get(self, "compression_delay_secs")

    @_builtins.property
    @pulumi.getter(name="containerExtId")
    def container_ext_id(self) -> _builtins.str:
        """
        - the storage container ext id
        """
        return pulumi.get(self, "container_ext_id")

    @_builtins.property
    @pulumi.getter(name="erasureCode")
    def erasure_code(self) -> _builtins.str:
        """
        - Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`
        """
        return pulumi.get(self, "erasure_code")

    @_builtins.property
    @pulumi.getter(name="erasureCodeDelaySecs")
    def erasure_code_delay_secs(self) -> _builtins.int:
        """
        - Delay in performing ErasureCode for the current Container instance.
        """
        return pulumi.get(self, "erasure_code_delay_secs")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - the storage container uuid
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hasHigherEcFaultDomainPreference")
    def has_higher_ec_fault_domain_preference(self) -> _builtins.bool:
        """
        - Indicates whether to prefer a higher Erasure Code fault domain.
        """
        return pulumi.get(self, "has_higher_ec_fault_domain_preference")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> _builtins.bool:
        """
        - Indicates whether the compression is enabled for the Container.
        """
        return pulumi.get(self, "is_compression_enabled")

    @_builtins.property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> _builtins.bool:
        """
        - Indicates whether the Container is encrypted or not.
        """
        return pulumi.get(self, "is_encrypted")

    @_builtins.property
    @pulumi.getter(name="isInlineEcEnabled")
    def is_inline_ec_enabled(self) -> _builtins.bool:
        """
        - Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
        """
        return pulumi.get(self, "is_inline_ec_enabled")

    @_builtins.property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> _builtins.bool:
        """
        - Indicates whether the Container is internal and is managed by Nutanix.
        """
        return pulumi.get(self, "is_internal")

    @_builtins.property
    @pulumi.getter(name="isMarkedForRemoval")
    def is_marked_for_removal(self) -> _builtins.bool:
        """
        - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
        """
        return pulumi.get(self, "is_marked_for_removal")

    @_builtins.property
    @pulumi.getter(name="isNfsWhitelistInherited")
    def is_nfs_whitelist_inherited(self) -> _builtins.bool:
        """
        - Indicates whether the NFS whitelist is inherited from global config.
        """
        return pulumi.get(self, "is_nfs_whitelist_inherited")

    @_builtins.property
    @pulumi.getter(name="isSoftwareEncryptionEnabled")
    def is_software_encryption_enabled(self) -> _builtins.bool:
        """
        - Indicates whether the Container instance has software encryption enabled.
        """
        return pulumi.get(self, "is_software_encryption_enabled")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetStorageContainerV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="logicalAdvertisedCapacityBytes")
    def logical_advertised_capacity_bytes(self) -> _builtins.int:
        """
        - Max capacity of the Container as defined by the user.
        """
        return pulumi.get(self, "logical_advertised_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="logicalExplicitReservedCapacityBytes")
    def logical_explicit_reserved_capacity_bytes(self) -> _builtins.int:
        """
        - Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
        """
        return pulumi.get(self, "logical_explicit_reserved_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="logicalImplicitReservedCapacityBytes")
    def logical_implicit_reserved_capacity_bytes(self) -> _builtins.int:
        """
        - This is the summation of reservations provisioned on all vdisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
        """
        return pulumi.get(self, "logical_implicit_reserved_capacity_bytes")

    @_builtins.property
    @pulumi.getter(name="maxCapacityBytes")
    def max_capacity_bytes(self) -> _builtins.int:
        """
        - Maximum physical capacity of the Storage Container in bytes.
        """
        return pulumi.get(self, "max_capacity_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsWhitelistAddresses")
    def nfs_whitelist_addresses(self) -> Sequence['outputs.GetStorageContainerV2NfsWhitelistAddressResult']:
        """
        - List of NFS addresses which need to be whitelisted.
        """
        return pulumi.get(self, "nfs_whitelist_addresses")

    @_builtins.property
    @pulumi.getter(name="onDiskDedup")
    def on_disk_dedup(self) -> _builtins.str:
        """
        - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
        """
        return pulumi.get(self, "on_disk_dedup")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> _builtins.str:
        """
        - owner ext id
        """
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> _builtins.int:
        """
        - Replication factor of the Storage Container.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="storagePoolExtId")
    def storage_pool_ext_id(self) -> _builtins.str:
        """
        - extId of the Storage Pool owning the Storage Container instance.
        """
        return pulumi.get(self, "storage_pool_ext_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetStorageContainerV2Result(GetStorageContainerV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageContainerV2Result(
            affinity_host_ext_id=self.affinity_host_ext_id,
            cache_deduplication=self.cache_deduplication,
            cluster_ext_id=self.cluster_ext_id,
            cluster_name=self.cluster_name,
            compression_delay_secs=self.compression_delay_secs,
            container_ext_id=self.container_ext_id,
            erasure_code=self.erasure_code,
            erasure_code_delay_secs=self.erasure_code_delay_secs,
            ext_id=self.ext_id,
            has_higher_ec_fault_domain_preference=self.has_higher_ec_fault_domain_preference,
            id=self.id,
            is_compression_enabled=self.is_compression_enabled,
            is_encrypted=self.is_encrypted,
            is_inline_ec_enabled=self.is_inline_ec_enabled,
            is_internal=self.is_internal,
            is_marked_for_removal=self.is_marked_for_removal,
            is_nfs_whitelist_inherited=self.is_nfs_whitelist_inherited,
            is_software_encryption_enabled=self.is_software_encryption_enabled,
            links=self.links,
            logical_advertised_capacity_bytes=self.logical_advertised_capacity_bytes,
            logical_explicit_reserved_capacity_bytes=self.logical_explicit_reserved_capacity_bytes,
            logical_implicit_reserved_capacity_bytes=self.logical_implicit_reserved_capacity_bytes,
            max_capacity_bytes=self.max_capacity_bytes,
            name=self.name,
            nfs_whitelist_addresses=self.nfs_whitelist_addresses,
            on_disk_dedup=self.on_disk_dedup,
            owner_ext_id=self.owner_ext_id,
            replication_factor=self.replication_factor,
            storage_pool_ext_id=self.storage_pool_ext_id,
            tenant_id=self.tenant_id)


def get_storage_container_v2(ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageContainerV2Result:
    """
    Provides a datasource to Fetch the configuration details of the existing Storage Container identified by the {containerExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_storage_container = nutanix.get_storage_container_v2(ext_id="1891fd3a-1ef7-4947-af56-9ee4b973c6fd")
    ```


    :param _builtins.str ext_id: storage container UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getStorageContainerV2:getStorageContainerV2', __args__, opts=opts, typ=GetStorageContainerV2Result).value

    return AwaitableGetStorageContainerV2Result(
        affinity_host_ext_id=pulumi.get(__ret__, 'affinity_host_ext_id'),
        cache_deduplication=pulumi.get(__ret__, 'cache_deduplication'),
        cluster_ext_id=pulumi.get(__ret__, 'cluster_ext_id'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        compression_delay_secs=pulumi.get(__ret__, 'compression_delay_secs'),
        container_ext_id=pulumi.get(__ret__, 'container_ext_id'),
        erasure_code=pulumi.get(__ret__, 'erasure_code'),
        erasure_code_delay_secs=pulumi.get(__ret__, 'erasure_code_delay_secs'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        has_higher_ec_fault_domain_preference=pulumi.get(__ret__, 'has_higher_ec_fault_domain_preference'),
        id=pulumi.get(__ret__, 'id'),
        is_compression_enabled=pulumi.get(__ret__, 'is_compression_enabled'),
        is_encrypted=pulumi.get(__ret__, 'is_encrypted'),
        is_inline_ec_enabled=pulumi.get(__ret__, 'is_inline_ec_enabled'),
        is_internal=pulumi.get(__ret__, 'is_internal'),
        is_marked_for_removal=pulumi.get(__ret__, 'is_marked_for_removal'),
        is_nfs_whitelist_inherited=pulumi.get(__ret__, 'is_nfs_whitelist_inherited'),
        is_software_encryption_enabled=pulumi.get(__ret__, 'is_software_encryption_enabled'),
        links=pulumi.get(__ret__, 'links'),
        logical_advertised_capacity_bytes=pulumi.get(__ret__, 'logical_advertised_capacity_bytes'),
        logical_explicit_reserved_capacity_bytes=pulumi.get(__ret__, 'logical_explicit_reserved_capacity_bytes'),
        logical_implicit_reserved_capacity_bytes=pulumi.get(__ret__, 'logical_implicit_reserved_capacity_bytes'),
        max_capacity_bytes=pulumi.get(__ret__, 'max_capacity_bytes'),
        name=pulumi.get(__ret__, 'name'),
        nfs_whitelist_addresses=pulumi.get(__ret__, 'nfs_whitelist_addresses'),
        on_disk_dedup=pulumi.get(__ret__, 'on_disk_dedup'),
        owner_ext_id=pulumi.get(__ret__, 'owner_ext_id'),
        replication_factor=pulumi.get(__ret__, 'replication_factor'),
        storage_pool_ext_id=pulumi.get(__ret__, 'storage_pool_ext_id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_storage_container_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageContainerV2Result]:
    """
    Provides a datasource to Fetch the configuration details of the existing Storage Container identified by the {containerExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_storage_container = nutanix.get_storage_container_v2(ext_id="1891fd3a-1ef7-4947-af56-9ee4b973c6fd")
    ```


    :param _builtins.str ext_id: storage container UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getStorageContainerV2:getStorageContainerV2', __args__, opts=opts, typ=GetStorageContainerV2Result)
    return __ret__.apply(lambda __response__: GetStorageContainerV2Result(
        affinity_host_ext_id=pulumi.get(__response__, 'affinity_host_ext_id'),
        cache_deduplication=pulumi.get(__response__, 'cache_deduplication'),
        cluster_ext_id=pulumi.get(__response__, 'cluster_ext_id'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        compression_delay_secs=pulumi.get(__response__, 'compression_delay_secs'),
        container_ext_id=pulumi.get(__response__, 'container_ext_id'),
        erasure_code=pulumi.get(__response__, 'erasure_code'),
        erasure_code_delay_secs=pulumi.get(__response__, 'erasure_code_delay_secs'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        has_higher_ec_fault_domain_preference=pulumi.get(__response__, 'has_higher_ec_fault_domain_preference'),
        id=pulumi.get(__response__, 'id'),
        is_compression_enabled=pulumi.get(__response__, 'is_compression_enabled'),
        is_encrypted=pulumi.get(__response__, 'is_encrypted'),
        is_inline_ec_enabled=pulumi.get(__response__, 'is_inline_ec_enabled'),
        is_internal=pulumi.get(__response__, 'is_internal'),
        is_marked_for_removal=pulumi.get(__response__, 'is_marked_for_removal'),
        is_nfs_whitelist_inherited=pulumi.get(__response__, 'is_nfs_whitelist_inherited'),
        is_software_encryption_enabled=pulumi.get(__response__, 'is_software_encryption_enabled'),
        links=pulumi.get(__response__, 'links'),
        logical_advertised_capacity_bytes=pulumi.get(__response__, 'logical_advertised_capacity_bytes'),
        logical_explicit_reserved_capacity_bytes=pulumi.get(__response__, 'logical_explicit_reserved_capacity_bytes'),
        logical_implicit_reserved_capacity_bytes=pulumi.get(__response__, 'logical_implicit_reserved_capacity_bytes'),
        max_capacity_bytes=pulumi.get(__response__, 'max_capacity_bytes'),
        name=pulumi.get(__response__, 'name'),
        nfs_whitelist_addresses=pulumi.get(__response__, 'nfs_whitelist_addresses'),
        on_disk_dedup=pulumi.get(__response__, 'on_disk_dedup'),
        owner_ext_id=pulumi.get(__response__, 'owner_ext_id'),
        replication_factor=pulumi.get(__response__, 'replication_factor'),
        storage_pool_ext_id=pulumi.get(__response__, 'storage_pool_ext_id'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
