# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStorageContainersV2Result',
    'AwaitableGetStorageContainersV2Result',
    'get_storage_containers_v2',
    'get_storage_containers_v2_output',
]

@pulumi.output_type
class GetStorageContainersV2Result:
    """
    A collection of values returned by getStorageContainersV2.
    """
    def __init__(__self__, apply=None, filter=None, id=None, limit=None, order_by=None, page=None, select=None, storage_containers=None):
        if apply and not isinstance(apply, str):
            raise TypeError("Expected argument 'apply' to be a str")
        pulumi.set(__self__, "apply", apply)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)
        if storage_containers and not isinstance(storage_containers, list):
            raise TypeError("Expected argument 'storage_containers' to be a list")
        pulumi.set(__self__, "storage_containers", storage_containers)

    @_builtins.property
    @pulumi.getter
    def apply(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "apply")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter(name="storageContainers")
    def storage_containers(self) -> Sequence['outputs.GetStorageContainersV2StorageContainerResult']:
        """
        Lists the Storage Containers present in the system.
        """
        return pulumi.get(self, "storage_containers")


class AwaitableGetStorageContainersV2Result(GetStorageContainersV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageContainersV2Result(
            apply=self.apply,
            filter=self.filter,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select,
            storage_containers=self.storage_containers)


def get_storage_containers_v2(apply: Optional[_builtins.str] = None,
                              filter: Optional[_builtins.str] = None,
                              limit: Optional[_builtins.int] = None,
                              order_by: Optional[_builtins.str] = None,
                              page: Optional[_builtins.int] = None,
                              select: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageContainersV2Result:
    """
    Provides a datasource to Lists the Storage Containers present in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    storage_containers = nutanix.get_storage_containers_v2()
    ```

    ## Storage Container

    The `storage_containers` contains list of Storage Container objects. Each Storage Container object contains the following attributes:

    * `ext_id`: - the storage container uuid
    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    * `container_ext_id`: - the storage container ext id
    * `owner_ext_id`: - owner ext id
    * `name`: Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
    * `cluster_ext_id`: - ext id for the cluster owning the storage container.
    * `storage_pool_ext_id`: - extId of the Storage Pool owning the Storage Container instance.
    * `is_marked_for_removal`: - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
    * `max_capacity_bytes`: - Maximum physical capacity of the Storage Container in bytes.
    * `logical_explicit_reserved_capacity_bytes`: - Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
    * `logical_implicit_reserved_capacity_bytes`: - This is the summation of reservations provisioned on all VDisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
    * `logical_advertised_capacity_bytes`: - Max capacity of the Container as defined by the user.
    * `replication_factor`: - Replication factor of the Storage Container.
    * `nfs_whitelist_addresses`: - List of NFS addresses which need to be whitelisted.
    * `is_nfs_whitelist_inherited`: - Indicates whether the NFS whitelist is inherited from global config.
    * `erasure_code`: - Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`

    * `is_inline_ec_enabled`: - Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
    * `has_higher_ec_fault_domain_preference`: - Indicates whether to prefer a higher Erasure Code fault domain.
    * `erasure_code_delay_secs`: - Delay in performing ErasureCode for the current Container instance.
    * `cache_deduplication`: - Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
    * `on_disk_dedup`: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
    * `is_compression_enabled`: - Indicates whether the compression is enabled for the Container.
    * `compression_delay_secs`: - The compression delay in seconds.
    * `is_internal`: - Indicates whether the Container is internal and is managed by Nutanix.
    * `is_software_encryption_enabled`: - Indicates whether the Container instance has software encryption enabled.
    * `is_encrypted`: - Indicates whether the Container is encrypted or not.
    * `affinity_host_ext_id`: - Affinity host extId for RF 1 Storage Container.
    * `cluster_name`: - Corresponding name of the Cluster owning the Storage Container instance.

    ### nfs_whitelist_addresses

    * `ipv4`: Reference to address configuration
    * `ipv6`: Reference to address configuration
    * `fqdn`: Reference to address configuration

    ### ipv4, ipv6 (Reference to address configuration)

    * `value`: value of address
    * `prefix_length`: The prefix length of the network to which this host IPv4/IPv6 address belongs.

    ### fqdn (Reference to address configuration)

    * `value`: value of fqdn address

    See detailed information in [Nutanix List Storage Containers v4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/StorageContainers/operation/listStorageContainers).


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources.
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default.
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions.
    """
    __args__ = dict()
    __args__['apply'] = apply
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getStorageContainersV2:getStorageContainersV2', __args__, opts=opts, typ=GetStorageContainersV2Result).value

    return AwaitableGetStorageContainersV2Result(
        apply=pulumi.get(__ret__, 'apply'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'),
        storage_containers=pulumi.get(__ret__, 'storage_containers'))
def get_storage_containers_v2_output(apply: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                     order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                     select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageContainersV2Result]:
    """
    Provides a datasource to Lists the Storage Containers present in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    storage_containers = nutanix.get_storage_containers_v2()
    ```

    ## Storage Container

    The `storage_containers` contains list of Storage Container objects. Each Storage Container object contains the following attributes:

    * `ext_id`: - the storage container uuid
    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    * `container_ext_id`: - the storage container ext id
    * `owner_ext_id`: - owner ext id
    * `name`: Name of the storage container.  Note that the name of Storage Container should be unique per cluster.
    * `cluster_ext_id`: - ext id for the cluster owning the storage container.
    * `storage_pool_ext_id`: - extId of the Storage Pool owning the Storage Container instance.
    * `is_marked_for_removal`: - Indicates if the Storage Container is marked for removal. This field is set when the Storage Container is about to be destroyed.
    * `max_capacity_bytes`: - Maximum physical capacity of the Storage Container in bytes.
    * `logical_explicit_reserved_capacity_bytes`: - Total reserved size (in bytes) of the container (set by Admin). This also accounts for the container's replication factor. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity.
    * `logical_implicit_reserved_capacity_bytes`: - This is the summation of reservations provisioned on all VDisks in the container. The actual reserved capacity of the container will be the maximum of explicitReservedCapacity and implicitReservedCapacity
    * `logical_advertised_capacity_bytes`: - Max capacity of the Container as defined by the user.
    * `replication_factor`: - Replication factor of the Storage Container.
    * `nfs_whitelist_addresses`: - List of NFS addresses which need to be whitelisted.
    * `is_nfs_whitelist_inherited`: - Indicates whether the NFS whitelist is inherited from global config.
    * `erasure_code`: - Indicates the current status value for Erasure Coding for the Container. available values:  `NONE`,    `OFF`,    `ON`

    * `is_inline_ec_enabled`: - Indicates whether data written to this container should be inline erasure coded or not. This field is only considered when ErasureCoding is enabled.
    * `has_higher_ec_fault_domain_preference`: - Indicates whether to prefer a higher Erasure Code fault domain.
    * `erasure_code_delay_secs`: - Delay in performing ErasureCode for the current Container instance.
    * `cache_deduplication`: - Indicates the current status of Cache Deduplication for the Container. available values:  `NONE`,    `OFF`,    `ON`
    * `on_disk_dedup`: - Indicates the current status of Disk Deduplication for the Container. available values:  `NONE`,    `OFF`,    `POST_PROCESS`
    * `is_compression_enabled`: - Indicates whether the compression is enabled for the Container.
    * `compression_delay_secs`: - The compression delay in seconds.
    * `is_internal`: - Indicates whether the Container is internal and is managed by Nutanix.
    * `is_software_encryption_enabled`: - Indicates whether the Container instance has software encryption enabled.
    * `is_encrypted`: - Indicates whether the Container is encrypted or not.
    * `affinity_host_ext_id`: - Affinity host extId for RF 1 Storage Container.
    * `cluster_name`: - Corresponding name of the Cluster owning the Storage Container instance.

    ### nfs_whitelist_addresses

    * `ipv4`: Reference to address configuration
    * `ipv6`: Reference to address configuration
    * `fqdn`: Reference to address configuration

    ### ipv4, ipv6 (Reference to address configuration)

    * `value`: value of address
    * `prefix_length`: The prefix length of the network to which this host IPv4/IPv6 address belongs.

    ### fqdn (Reference to address configuration)

    * `value`: value of fqdn address

    See detailed information in [Nutanix List Storage Containers v4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/StorageContainers/operation/listStorageContainers).


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources.
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default.
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions.
    """
    __args__ = dict()
    __args__['apply'] = apply
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getStorageContainersV2:getStorageContainersV2', __args__, opts=opts, typ=GetStorageContainersV2Result)
    return __ret__.apply(lambda __response__: GetStorageContainersV2Result(
        apply=pulumi.get(__response__, 'apply'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select'),
        storage_containers=pulumi.get(__response__, 'storage_containers')))
