# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubnetV2Result',
    'AwaitableGetSubnetV2Result',
    'get_subnet_v2',
    'get_subnet_v2_output',
]

@pulumi.output_type
class GetSubnetV2Result:
    """
    A collection of values returned by getSubnetV2.
    """
    def __init__(__self__, bridge_name=None, cluster_name=None, cluster_reference=None, description=None, dhcp_options=None, dynamic_ip_addresses=None, ext_id=None, hypervisor_type=None, id=None, ip_configs=None, ip_prefix=None, ip_usages=None, is_advanced_networking=None, is_external=None, is_nat_enabled=None, links=None, migration_state=None, name=None, network_function_chain_reference=None, network_id=None, reserved_ip_addresses=None, subnet_type=None, virtual_switch_reference=None, virtual_switches=None, vpc_reference=None, vpcs=None):
        if bridge_name and not isinstance(bridge_name, str):
            raise TypeError("Expected argument 'bridge_name' to be a str")
        pulumi.set(__self__, "bridge_name", bridge_name)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_reference and not isinstance(cluster_reference, str):
            raise TypeError("Expected argument 'cluster_reference' to be a str")
        pulumi.set(__self__, "cluster_reference", cluster_reference)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dhcp_options and not isinstance(dhcp_options, list):
            raise TypeError("Expected argument 'dhcp_options' to be a list")
        pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dynamic_ip_addresses and not isinstance(dynamic_ip_addresses, list):
            raise TypeError("Expected argument 'dynamic_ip_addresses' to be a list")
        pulumi.set(__self__, "dynamic_ip_addresses", dynamic_ip_addresses)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if hypervisor_type and not isinstance(hypervisor_type, str):
            raise TypeError("Expected argument 'hypervisor_type' to be a str")
        pulumi.set(__self__, "hypervisor_type", hypervisor_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_configs and not isinstance(ip_configs, list):
            raise TypeError("Expected argument 'ip_configs' to be a list")
        pulumi.set(__self__, "ip_configs", ip_configs)
        if ip_prefix and not isinstance(ip_prefix, str):
            raise TypeError("Expected argument 'ip_prefix' to be a str")
        pulumi.set(__self__, "ip_prefix", ip_prefix)
        if ip_usages and not isinstance(ip_usages, list):
            raise TypeError("Expected argument 'ip_usages' to be a list")
        pulumi.set(__self__, "ip_usages", ip_usages)
        if is_advanced_networking and not isinstance(is_advanced_networking, bool):
            raise TypeError("Expected argument 'is_advanced_networking' to be a bool")
        pulumi.set(__self__, "is_advanced_networking", is_advanced_networking)
        if is_external and not isinstance(is_external, bool):
            raise TypeError("Expected argument 'is_external' to be a bool")
        pulumi.set(__self__, "is_external", is_external)
        if is_nat_enabled and not isinstance(is_nat_enabled, bool):
            raise TypeError("Expected argument 'is_nat_enabled' to be a bool")
        pulumi.set(__self__, "is_nat_enabled", is_nat_enabled)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if migration_state and not isinstance(migration_state, str):
            raise TypeError("Expected argument 'migration_state' to be a str")
        pulumi.set(__self__, "migration_state", migration_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_function_chain_reference and not isinstance(network_function_chain_reference, str):
            raise TypeError("Expected argument 'network_function_chain_reference' to be a str")
        pulumi.set(__self__, "network_function_chain_reference", network_function_chain_reference)
        if network_id and not isinstance(network_id, int):
            raise TypeError("Expected argument 'network_id' to be a int")
        pulumi.set(__self__, "network_id", network_id)
        if reserved_ip_addresses and not isinstance(reserved_ip_addresses, list):
            raise TypeError("Expected argument 'reserved_ip_addresses' to be a list")
        pulumi.set(__self__, "reserved_ip_addresses", reserved_ip_addresses)
        if subnet_type and not isinstance(subnet_type, str):
            raise TypeError("Expected argument 'subnet_type' to be a str")
        pulumi.set(__self__, "subnet_type", subnet_type)
        if virtual_switch_reference and not isinstance(virtual_switch_reference, str):
            raise TypeError("Expected argument 'virtual_switch_reference' to be a str")
        pulumi.set(__self__, "virtual_switch_reference", virtual_switch_reference)
        if virtual_switches and not isinstance(virtual_switches, list):
            raise TypeError("Expected argument 'virtual_switches' to be a list")
        pulumi.set(__self__, "virtual_switches", virtual_switches)
        if vpc_reference and not isinstance(vpc_reference, str):
            raise TypeError("Expected argument 'vpc_reference' to be a str")
        pulumi.set(__self__, "vpc_reference", vpc_reference)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="bridgeName")
    def bridge_name(self) -> _builtins.str:
        """
        Name of the bridge on the host for the subnet.
        """
        return pulumi.get(self, "bridge_name")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        Cluster Name
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> _builtins.str:
        """
        UUID of the cluster this subnet belongs to.
        """
        return pulumi.get(self, "cluster_reference")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the subnet.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Sequence['outputs.GetSubnetV2DhcpOptionResult']:
        """
        List of DHCP options to be configured.
        """
        return pulumi.get(self, "dhcp_options")

    @_builtins.property
    @pulumi.getter(name="dynamicIpAddresses")
    def dynamic_ip_addresses(self) -> Sequence['outputs.GetSubnetV2DynamicIpAddressResult']:
        """
        List of IPs, which are a subset from the reserved IP address list, that must be advertised to the SDN gateway.
        """
        return pulumi.get(self, "dynamic_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> _builtins.str:
        """
        Hypervisor Type
        """
        return pulumi.get(self, "hypervisor_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Sequence['outputs.GetSubnetV2IpConfigResult']:
        """
        IP configuration for the subnet.
        """
        return pulumi.get(self, "ip_configs")

    @_builtins.property
    @pulumi.getter(name="ipPrefix")
    def ip_prefix(self) -> _builtins.str:
        """
        IP Prefix in CIDR format.
        """
        return pulumi.get(self, "ip_prefix")

    @_builtins.property
    @pulumi.getter(name="ipUsages")
    def ip_usages(self) -> Sequence['outputs.GetSubnetV2IpUsageResult']:
        """
        IP usage statistics.
        """
        return pulumi.get(self, "ip_usages")

    @_builtins.property
    @pulumi.getter(name="isAdvancedNetworking")
    def is_advanced_networking(self) -> _builtins.bool:
        """
        Indicates whether the subnet is used for advanced networking.
        """
        return pulumi.get(self, "is_advanced_networking")

    @_builtins.property
    @pulumi.getter(name="isExternal")
    def is_external(self) -> _builtins.bool:
        """
        Indicates whether the subnet is used for external connectivity.
        """
        return pulumi.get(self, "is_external")

    @_builtins.property
    @pulumi.getter(name="isNatEnabled")
    def is_nat_enabled(self) -> _builtins.bool:
        """
        Indicates whether NAT must be enabled for VPCs attached to the subnet. This is supported only for external subnets. NAT is enabled by default on external subnets.
        """
        return pulumi.get(self, "is_nat_enabled")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetSubnetV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="migrationState")
    def migration_state(self) -> _builtins.str:
        """
        Migration state of the subnet. This field is read-only.
        """
        return pulumi.get(self, "migration_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the subnet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFunctionChainReference")
    def network_function_chain_reference(self) -> _builtins.str:
        """
        UUID of the Network function chain entity that this subnet belongs to (type VLAN only).
        """
        return pulumi.get(self, "network_function_chain_reference")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        """
        or VLAN subnet, this field represents VLAN Id, valid range is from 0 to 4095; For overlay subnet, this field represents 24-bit VNI, this field is read-only.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="reservedIpAddresses")
    def reserved_ip_addresses(self) -> Sequence['outputs.GetSubnetV2ReservedIpAddressResult']:
        """
        List of IPs that are excluded while allocating IP addresses to VM ports.
        """
        return pulumi.get(self, "reserved_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetType")
    def subnet_type(self) -> _builtins.str:
        """
        Type of subnet.
        """
        return pulumi.get(self, "subnet_type")

    @_builtins.property
    @pulumi.getter(name="virtualSwitchReference")
    def virtual_switch_reference(self) -> _builtins.str:
        """
        UUID of the virtual switch this subnet belongs to (type VLAN only).
        """
        return pulumi.get(self, "virtual_switch_reference")

    @_builtins.property
    @pulumi.getter(name="virtualSwitches")
    def virtual_switches(self) -> Sequence['outputs.GetSubnetV2VirtualSwitchResult']:
        """
        Schema to configure a virtual switch
        """
        return pulumi.get(self, "virtual_switches")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> _builtins.str:
        """
        UUID of Virtual Private Cloud this subnet belongs to (type Overlay only).
        """
        return pulumi.get(self, "vpc_reference")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetSubnetV2VpcResult']:
        """
        Networking common base object
        """
        return pulumi.get(self, "vpcs")


class AwaitableGetSubnetV2Result(GetSubnetV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetV2Result(
            bridge_name=self.bridge_name,
            cluster_name=self.cluster_name,
            cluster_reference=self.cluster_reference,
            description=self.description,
            dhcp_options=self.dhcp_options,
            dynamic_ip_addresses=self.dynamic_ip_addresses,
            ext_id=self.ext_id,
            hypervisor_type=self.hypervisor_type,
            id=self.id,
            ip_configs=self.ip_configs,
            ip_prefix=self.ip_prefix,
            ip_usages=self.ip_usages,
            is_advanced_networking=self.is_advanced_networking,
            is_external=self.is_external,
            is_nat_enabled=self.is_nat_enabled,
            links=self.links,
            migration_state=self.migration_state,
            name=self.name,
            network_function_chain_reference=self.network_function_chain_reference,
            network_id=self.network_id,
            reserved_ip_addresses=self.reserved_ip_addresses,
            subnet_type=self.subnet_type,
            virtual_switch_reference=self.virtual_switch_reference,
            virtual_switches=self.virtual_switches,
            vpc_reference=self.vpc_reference,
            vpcs=self.vpcs)


def get_subnet_v2(ext_id: Optional[_builtins.str] = None,
                  reserved_ip_addresses: Optional[Sequence[Union['GetSubnetV2ReservedIpAddressArgs', 'GetSubnetV2ReservedIpAddressArgsDict']]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetV2Result:
    """
    Get a subnet with the specified UUID.


    :param _builtins.str ext_id: - (Required) The UUID of the subnet.
    :param Sequence[Union['GetSubnetV2ReservedIpAddressArgs', 'GetSubnetV2ReservedIpAddressArgsDict']] reserved_ip_addresses: List of IPs that are excluded while allocating IP addresses to VM ports.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['reservedIpAddresses'] = reserved_ip_addresses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getSubnetV2:getSubnetV2', __args__, opts=opts, typ=GetSubnetV2Result).value

    return AwaitableGetSubnetV2Result(
        bridge_name=pulumi.get(__ret__, 'bridge_name'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        cluster_reference=pulumi.get(__ret__, 'cluster_reference'),
        description=pulumi.get(__ret__, 'description'),
        dhcp_options=pulumi.get(__ret__, 'dhcp_options'),
        dynamic_ip_addresses=pulumi.get(__ret__, 'dynamic_ip_addresses'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        hypervisor_type=pulumi.get(__ret__, 'hypervisor_type'),
        id=pulumi.get(__ret__, 'id'),
        ip_configs=pulumi.get(__ret__, 'ip_configs'),
        ip_prefix=pulumi.get(__ret__, 'ip_prefix'),
        ip_usages=pulumi.get(__ret__, 'ip_usages'),
        is_advanced_networking=pulumi.get(__ret__, 'is_advanced_networking'),
        is_external=pulumi.get(__ret__, 'is_external'),
        is_nat_enabled=pulumi.get(__ret__, 'is_nat_enabled'),
        links=pulumi.get(__ret__, 'links'),
        migration_state=pulumi.get(__ret__, 'migration_state'),
        name=pulumi.get(__ret__, 'name'),
        network_function_chain_reference=pulumi.get(__ret__, 'network_function_chain_reference'),
        network_id=pulumi.get(__ret__, 'network_id'),
        reserved_ip_addresses=pulumi.get(__ret__, 'reserved_ip_addresses'),
        subnet_type=pulumi.get(__ret__, 'subnet_type'),
        virtual_switch_reference=pulumi.get(__ret__, 'virtual_switch_reference'),
        virtual_switches=pulumi.get(__ret__, 'virtual_switches'),
        vpc_reference=pulumi.get(__ret__, 'vpc_reference'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_subnet_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                         reserved_ip_addresses: Optional[pulumi.Input[Optional[Sequence[Union['GetSubnetV2ReservedIpAddressArgs', 'GetSubnetV2ReservedIpAddressArgsDict']]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetV2Result]:
    """
    Get a subnet with the specified UUID.


    :param _builtins.str ext_id: - (Required) The UUID of the subnet.
    :param Sequence[Union['GetSubnetV2ReservedIpAddressArgs', 'GetSubnetV2ReservedIpAddressArgsDict']] reserved_ip_addresses: List of IPs that are excluded while allocating IP addresses to VM ports.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['reservedIpAddresses'] = reserved_ip_addresses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getSubnetV2:getSubnetV2', __args__, opts=opts, typ=GetSubnetV2Result)
    return __ret__.apply(lambda __response__: GetSubnetV2Result(
        bridge_name=pulumi.get(__response__, 'bridge_name'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        cluster_reference=pulumi.get(__response__, 'cluster_reference'),
        description=pulumi.get(__response__, 'description'),
        dhcp_options=pulumi.get(__response__, 'dhcp_options'),
        dynamic_ip_addresses=pulumi.get(__response__, 'dynamic_ip_addresses'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        hypervisor_type=pulumi.get(__response__, 'hypervisor_type'),
        id=pulumi.get(__response__, 'id'),
        ip_configs=pulumi.get(__response__, 'ip_configs'),
        ip_prefix=pulumi.get(__response__, 'ip_prefix'),
        ip_usages=pulumi.get(__response__, 'ip_usages'),
        is_advanced_networking=pulumi.get(__response__, 'is_advanced_networking'),
        is_external=pulumi.get(__response__, 'is_external'),
        is_nat_enabled=pulumi.get(__response__, 'is_nat_enabled'),
        links=pulumi.get(__response__, 'links'),
        migration_state=pulumi.get(__response__, 'migration_state'),
        name=pulumi.get(__response__, 'name'),
        network_function_chain_reference=pulumi.get(__response__, 'network_function_chain_reference'),
        network_id=pulumi.get(__response__, 'network_id'),
        reserved_ip_addresses=pulumi.get(__response__, 'reserved_ip_addresses'),
        subnet_type=pulumi.get(__response__, 'subnet_type'),
        virtual_switch_reference=pulumi.get(__response__, 'virtual_switch_reference'),
        virtual_switches=pulumi.get(__response__, 'virtual_switches'),
        vpc_reference=pulumi.get(__response__, 'vpc_reference'),
        vpcs=pulumi.get(__response__, 'vpcs')))
