# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSubnetsV2Result',
    'AwaitableGetSubnetsV2Result',
    'get_subnets_v2',
    'get_subnets_v2_output',
]

@pulumi.output_type
class GetSubnetsV2Result:
    """
    A collection of values returned by getSubnetsV2.
    """
    def __init__(__self__, expand=None, filter=None, id=None, limit=None, order_by=None, page=None, select=None, subnets=None):
        if expand and not isinstance(expand, str):
            raise TypeError("Expected argument 'expand' to be a str")
        pulumi.set(__self__, "expand", expand)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.GetSubnetsV2SubnetResult']:
        """
        List all of subnets
        """
        return pulumi.get(self, "subnets")


class AwaitableGetSubnetsV2Result(GetSubnetsV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetsV2Result(
            expand=self.expand,
            filter=self.filter,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select,
            subnets=self.subnets)


def get_subnets_v2(expand: Optional[_builtins.str] = None,
                   filter: Optional[_builtins.str] = None,
                   limit: Optional[_builtins.int] = None,
                   order_by: Optional[_builtins.str] = None,
                   page: Optional[_builtins.int] = None,
                   select: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetsV2Result:
    """
    Get the list of existing subnets.

    ## Subnets

    The `subnets` object contains the following attributes:

    - `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    - `name`: Name of the subnet.
    - `description`: Description of the subnet.
    - `subnet_type`: Type of subnet.
    - `network_id`: or VLAN subnet, this field represents VLAN Id, valid range is from 0 to 4095; For overlay subnet, this field represents 24-bit VNI, this field is read-only.
    - `dhcp_options`: List of DHCP options to be configured.
    - `ip_config`: IP configuration for the subnet.
    - `cluster_reference`: UUID of the cluster this subnet belongs to.
    - `virtual_switch_reference`: UUID of the virtual switch this subnet belongs to (type VLAN only).
    - `vpc_reference`: UUID of Virtual Private Cloud this subnet belongs to (type Overlay only).
    - `is_nat_enabled`: Indicates whether NAT must be enabled for VPCs attached to the subnet. This is supported only for external subnets. NAT is enabled by default on external subnets.
    - `is_external`: Indicates whether the subnet is used for external connectivity.
    - `reserved_ip_addresses`: List of IPs that are excluded while allocating IP addresses to VM ports.
    - `dynamic_ip_addresses`: List of IPs, which are a subset from the reserved IP address list, that must be advertised to the SDN gateway.
    - `network_function_chain_reference`: UUID of the Network function chain entity that this subnet belongs to (type VLAN only).
    - `bridge_name`: Name of the bridge on the host for the subnet.
    - `is_advanced_networking`: Indicates whether the subnet is used for advanced networking.
    - `cluster_name`: Cluster Name
    - `hypervisor_type`: Hypervisor Type
    - `virtual_switch`: Schema to configure a virtual switch
    - `vpc`: Networking common base object
    - `ip_prefix`: IP Prefix in CIDR format.
    - `ip_usage`: IP usage statistics.
    - `migration_state`: Migration state of the subnet. This field is read-only.
    - `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    ### dhcp_options

    - `domain_name_servers`: List of Domain Name Server addresses.
    - `domain_name`: The DNS domain name of the client.
    - `search_domains`: The DNS domain search list.
    - `tftp_server_name`: TFTP server name
    - `boot_file_name`: Boot file name
    - `ntp_servers`: List of NTP server addresses

    ### domain_name_servers, ntp_servers

    - `ipv4`: IPv4 Object
    - `ipv6`: IPv6 Object

    ### ip_config

    - `ipv4`: IP V4 configuration.
    - `ipv6`: IP V6 configuration

    ### ip_config.ipv4, ip_config.ipv6

    - `ip_subnet`: subnet ip
    - `default_gateway_ip`: Reference to address configuration
    - `dhcp_server_address`: Reference to address configuration
    - `pool_list`: Pool of IP addresses from where IPs are allocated.

    ### ip_subnet

    - `ip`: Reference to address configuration
    - `prefix_length`: The prefix length of the network to which this host IPv4 address belongs.

    ### pool_list

    - `start_ip`: Reference to address configuration
    - `end_ip`: Reference to address configuration

    ### ip_usage

    - `num_macs`: Number of MAC addresses.
    - `num_free_ips`: Number of free IPs.
    - `num_assigned_ips`: Number of assigned IPs.
    - `ip_pool_usages`: IP Pool usages

    ### ip_pool_usages

    - `num_free_ips`: Number of free IPs
    - `num_total_ips`: Total number of IPs in this pool.
    - `range`: Start/end IP address range.

    ### ipv4, ipv6 (Reference to address configuration)

    - `value`: value of address
    - `prefix_length`: The prefix length of the network to which this host IPv4/IPv6 address belongs.

    See detailed information in [Nutanix List Subnets v4](https://developers.nutanix.com/api-reference?namespace=networking&version=v4.0#tag/Subnets/operation/listSubnets).


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. The expand can be applied to the following fields:
           - `virtualSwitch`
    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The filter can be applied to the following fields:
           - `clusterReference`
           - `extId`
           - `isExternal`
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. The orderby can be applied to the following fields:
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. The select can be applied to the following fields:
           - `clusterName`
           - `clusterReference`
           - `extId`
           - `hypervisorType`
           - `subnetType`
           - `ipPrefix`
           - `isAdvancedNetworking`
           - `isExternal`
           - `isNatEnabled`
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getSubnetsV2:getSubnetsV2', __args__, opts=opts, typ=GetSubnetsV2Result).value

    return AwaitableGetSubnetsV2Result(
        expand=pulumi.get(__ret__, 'expand'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'),
        subnets=pulumi.get(__ret__, 'subnets'))
def get_subnets_v2_output(expand: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetsV2Result]:
    """
    Get the list of existing subnets.

    ## Subnets

    The `subnets` object contains the following attributes:

    - `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    - `name`: Name of the subnet.
    - `description`: Description of the subnet.
    - `subnet_type`: Type of subnet.
    - `network_id`: or VLAN subnet, this field represents VLAN Id, valid range is from 0 to 4095; For overlay subnet, this field represents 24-bit VNI, this field is read-only.
    - `dhcp_options`: List of DHCP options to be configured.
    - `ip_config`: IP configuration for the subnet.
    - `cluster_reference`: UUID of the cluster this subnet belongs to.
    - `virtual_switch_reference`: UUID of the virtual switch this subnet belongs to (type VLAN only).
    - `vpc_reference`: UUID of Virtual Private Cloud this subnet belongs to (type Overlay only).
    - `is_nat_enabled`: Indicates whether NAT must be enabled for VPCs attached to the subnet. This is supported only for external subnets. NAT is enabled by default on external subnets.
    - `is_external`: Indicates whether the subnet is used for external connectivity.
    - `reserved_ip_addresses`: List of IPs that are excluded while allocating IP addresses to VM ports.
    - `dynamic_ip_addresses`: List of IPs, which are a subset from the reserved IP address list, that must be advertised to the SDN gateway.
    - `network_function_chain_reference`: UUID of the Network function chain entity that this subnet belongs to (type VLAN only).
    - `bridge_name`: Name of the bridge on the host for the subnet.
    - `is_advanced_networking`: Indicates whether the subnet is used for advanced networking.
    - `cluster_name`: Cluster Name
    - `hypervisor_type`: Hypervisor Type
    - `virtual_switch`: Schema to configure a virtual switch
    - `vpc`: Networking common base object
    - `ip_prefix`: IP Prefix in CIDR format.
    - `ip_usage`: IP usage statistics.
    - `migration_state`: Migration state of the subnet. This field is read-only.
    - `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.

    ### dhcp_options

    - `domain_name_servers`: List of Domain Name Server addresses.
    - `domain_name`: The DNS domain name of the client.
    - `search_domains`: The DNS domain search list.
    - `tftp_server_name`: TFTP server name
    - `boot_file_name`: Boot file name
    - `ntp_servers`: List of NTP server addresses

    ### domain_name_servers, ntp_servers

    - `ipv4`: IPv4 Object
    - `ipv6`: IPv6 Object

    ### ip_config

    - `ipv4`: IP V4 configuration.
    - `ipv6`: IP V6 configuration

    ### ip_config.ipv4, ip_config.ipv6

    - `ip_subnet`: subnet ip
    - `default_gateway_ip`: Reference to address configuration
    - `dhcp_server_address`: Reference to address configuration
    - `pool_list`: Pool of IP addresses from where IPs are allocated.

    ### ip_subnet

    - `ip`: Reference to address configuration
    - `prefix_length`: The prefix length of the network to which this host IPv4 address belongs.

    ### pool_list

    - `start_ip`: Reference to address configuration
    - `end_ip`: Reference to address configuration

    ### ip_usage

    - `num_macs`: Number of MAC addresses.
    - `num_free_ips`: Number of free IPs.
    - `num_assigned_ips`: Number of assigned IPs.
    - `ip_pool_usages`: IP Pool usages

    ### ip_pool_usages

    - `num_free_ips`: Number of free IPs
    - `num_total_ips`: Total number of IPs in this pool.
    - `range`: Start/end IP address range.

    ### ipv4, ipv6 (Reference to address configuration)

    - `value`: value of address
    - `prefix_length`: The prefix length of the network to which this host IPv4/IPv6 address belongs.

    See detailed information in [Nutanix List Subnets v4](https://developers.nutanix.com/api-reference?namespace=networking&version=v4.0#tag/Subnets/operation/listSubnets).


    :param _builtins.str expand: A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. The expand can be applied to the following fields:
           - `virtualSwitch`
    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The filter can be applied to the following fields:
           - `clusterReference`
           - `extId`
           - `isExternal`
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. The orderby can be applied to the following fields:
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. The select can be applied to the following fields:
           - `clusterName`
           - `clusterReference`
           - `extId`
           - `hypervisorType`
           - `subnetType`
           - `ipPrefix`
           - `isAdvancedNetworking`
           - `isExternal`
           - `isNatEnabled`
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getSubnetsV2:getSubnetsV2', __args__, opts=opts, typ=GetSubnetsV2Result)
    return __ret__.apply(lambda __response__: GetSubnetsV2Result(
        expand=pulumi.get(__response__, 'expand'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select'),
        subnets=pulumi.get(__response__, 'subnets')))
