# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTemplateV2Result',
    'AwaitableGetTemplateV2Result',
    'get_template_v2',
    'get_template_v2_output',
]

@pulumi.output_type
class GetTemplateV2Result:
    """
    A collection of values returned by getTemplateV2.
    """
    def __init__(__self__, create_time=None, created_bies=None, ext_id=None, guest_update_statuses=None, id=None, links=None, template_description=None, template_name=None, template_version_specs=None, tenant_id=None, update_time=None, updated_bies=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if guest_update_statuses and not isinstance(guest_update_statuses, list):
            raise TypeError("Expected argument 'guest_update_statuses' to be a list")
        pulumi.set(__self__, "guest_update_statuses", guest_update_statuses)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if template_description and not isinstance(template_description, str):
            raise TypeError("Expected argument 'template_description' to be a str")
        pulumi.set(__self__, "template_description", template_description)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)
        if template_version_specs and not isinstance(template_version_specs, list):
            raise TypeError("Expected argument 'template_version_specs' to be a list")
        pulumi.set(__self__, "template_version_specs", template_version_specs)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if updated_bies and not isinstance(updated_bies, list):
            raise TypeError("Expected argument 'updated_bies' to be a list")
        pulumi.set(__self__, "updated_bies", updated_bies)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        VM creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetTemplateV2CreatedByResult']:
        """
        User or Service who created the User.
        """
        return pulumi.get(self, "created_bies")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="guestUpdateStatuses")
    def guest_update_statuses(self) -> Sequence['outputs.GetTemplateV2GuestUpdateStatusResult']:
        """
        Status of a Guest Update.
        """
        return pulumi.get(self, "guest_update_statuses")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetTemplateV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> _builtins.str:
        """
        The user defined description of a Template.
        """
        return pulumi.get(self, "template_description")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        The user defined name of a Template.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateVersionSpecs")
    def template_version_specs(self) -> Sequence['outputs.GetTemplateV2TemplateVersionSpecResult']:
        """
        A model that represents an object instance that is accessible through an API endpoint. Instances of this type get an extId field that contains the globally unique identifier for that instance
        """
        return pulumi.get(self, "template_version_specs")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        VM last updated time.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updatedBies")
    def updated_bies(self) -> Sequence['outputs.GetTemplateV2UpdatedByResult']:
        """
        Last updated by this User ID.
        """
        return pulumi.get(self, "updated_bies")


class AwaitableGetTemplateV2Result(GetTemplateV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplateV2Result(
            create_time=self.create_time,
            created_bies=self.created_bies,
            ext_id=self.ext_id,
            guest_update_statuses=self.guest_update_statuses,
            id=self.id,
            links=self.links,
            template_description=self.template_description,
            template_name=self.template_name,
            template_version_specs=self.template_version_specs,
            tenant_id=self.tenant_id,
            update_time=self.update_time,
            updated_bies=self.updated_bies)


def get_template_v2(ext_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplateV2Result:
    """
    Retrieve the Template details for the given Template identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    template = nutanix.get_template_v2(ext_id="7ad31035-9e8b-4fb1-b8fd-fa39326887d8")
    ```


    :param _builtins.str ext_id: The identifier of a Template.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getTemplateV2:getTemplateV2', __args__, opts=opts, typ=GetTemplateV2Result).value

    return AwaitableGetTemplateV2Result(
        create_time=pulumi.get(__ret__, 'create_time'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        guest_update_statuses=pulumi.get(__ret__, 'guest_update_statuses'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        template_description=pulumi.get(__ret__, 'template_description'),
        template_name=pulumi.get(__ret__, 'template_name'),
        template_version_specs=pulumi.get(__ret__, 'template_version_specs'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        update_time=pulumi.get(__ret__, 'update_time'),
        updated_bies=pulumi.get(__ret__, 'updated_bies'))
def get_template_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTemplateV2Result]:
    """
    Retrieve the Template details for the given Template identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    template = nutanix.get_template_v2(ext_id="7ad31035-9e8b-4fb1-b8fd-fa39326887d8")
    ```


    :param _builtins.str ext_id: The identifier of a Template.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getTemplateV2:getTemplateV2', __args__, opts=opts, typ=GetTemplateV2Result)
    return __ret__.apply(lambda __response__: GetTemplateV2Result(
        create_time=pulumi.get(__response__, 'create_time'),
        created_bies=pulumi.get(__response__, 'created_bies'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        guest_update_statuses=pulumi.get(__response__, 'guest_update_statuses'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        template_description=pulumi.get(__response__, 'template_description'),
        template_name=pulumi.get(__response__, 'template_name'),
        template_version_specs=pulumi.get(__response__, 'template_version_specs'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        update_time=pulumi.get(__response__, 'update_time'),
        updated_bies=pulumi.get(__response__, 'updated_bies')))
