# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, access_control_policy_reference_lists=None, api_version=None, categories=None, directory_service_users=None, display_name=None, id=None, identity_provider_users=None, metadata=None, owner_reference=None, project_reference=None, project_reference_lists=None, state=None, user_id=None, user_name=None, user_type=None):
        if access_control_policy_reference_lists and not isinstance(access_control_policy_reference_lists, list):
            raise TypeError("Expected argument 'access_control_policy_reference_lists' to be a list")
        pulumi.set(__self__, "access_control_policy_reference_lists", access_control_policy_reference_lists)
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if directory_service_users and not isinstance(directory_service_users, list):
            raise TypeError("Expected argument 'directory_service_users' to be a list")
        pulumi.set(__self__, "directory_service_users", directory_service_users)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_provider_users and not isinstance(identity_provider_users, list):
            raise TypeError("Expected argument 'identity_provider_users' to be a list")
        pulumi.set(__self__, "identity_provider_users", identity_provider_users)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if project_reference_lists and not isinstance(project_reference_lists, list):
            raise TypeError("Expected argument 'project_reference_lists' to be a list")
        pulumi.set(__self__, "project_reference_lists", project_reference_lists)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if user_type and not isinstance(user_type, str):
            raise TypeError("Expected argument 'user_type' to be a str")
        pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicyReferenceLists")
    def access_control_policy_reference_lists(self) -> Sequence['outputs.GetUserAccessControlPolicyReferenceListResult']:
        """
        - List of ACP references. See #reference for more details.
        """
        return pulumi.get(self, "access_control_policy_reference_lists")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetUserCategoryResult']:
        """
        - (Optional) Categories for the Access Control Policy.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="directoryServiceUsers")
    def directory_service_users(self) -> Sequence['outputs.GetUserDirectoryServiceUserResult']:
        """
        - (Optional) The directory service user configuration. See below for more information.
        """
        return pulumi.get(self, "directory_service_users")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        - The display name of the user (common name) provided by the directory service.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityProviderUsers")
    def identity_provider_users(self) -> Sequence['outputs.GetUserIdentityProviderUserResult']:
        """
        - (Optional) (Optional) The identity provider user configuration. See below for more information.
        """
        return pulumi.get(self, "identity_provider_users")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        - The user kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="projectReferenceLists")
    def project_reference_lists(self) -> Sequence['outputs.GetUserProjectReferenceListResult']:
        """
        - A list of projects the user is part of. See #reference for more details.
        """
        return pulumi.get(self, "project_reference_lists")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - The state of the entity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> _builtins.str:
        """
        - The name of the user.
        """
        return pulumi.get(self, "user_type")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            access_control_policy_reference_lists=self.access_control_policy_reference_lists,
            api_version=self.api_version,
            categories=self.categories,
            directory_service_users=self.directory_service_users,
            display_name=self.display_name,
            id=self.id,
            identity_provider_users=self.identity_provider_users,
            metadata=self.metadata,
            owner_reference=self.owner_reference,
            project_reference=self.project_reference,
            project_reference_lists=self.project_reference_lists,
            state=self.state,
            user_id=self.user_id,
            user_name=self.user_name,
            user_type=self.user_type)


def get_user(categories: Optional[Sequence[Union['GetUserCategoryArgs', 'GetUserCategoryArgsDict']]] = None,
             owner_reference: Optional[Mapping[str, _builtins.str]] = None,
             project_reference: Optional[Mapping[str, _builtins.str]] = None,
             user_id: Optional[_builtins.str] = None,
             user_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Provides a datasource to retrieve a user based on the input parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    user_user = nutanix.User("user", directory_service_user={
        "user_principal_name": "test-user@ntnxlab.local",
        "directory_service_reference": {
            "uuid": "<directory-service-uuid>",
        },
    })
    #Retrieve by UUID
    user = nutanix.get_user_output(user_id=user_user.id)
    #Retrieve by Name
    userbyname = nutanix.get_user_output(user_name=user_user.name)
    ```


    :param Sequence[Union['GetUserCategoryArgs', 'GetUserCategoryArgsDict']] categories: - (Optional) Categories for the Access Control Policy.
    :param Mapping[str, _builtins.str] owner_reference: - (Optional) The reference to a user.
    :param Mapping[str, _builtins.str] project_reference: - (Optional) The reference to a project.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['ownerReference'] = owner_reference
    __args__['projectReference'] = project_reference
    __args__['userId'] = user_id
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        access_control_policy_reference_lists=pulumi.get(__ret__, 'access_control_policy_reference_lists'),
        api_version=pulumi.get(__ret__, 'api_version'),
        categories=pulumi.get(__ret__, 'categories'),
        directory_service_users=pulumi.get(__ret__, 'directory_service_users'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        identity_provider_users=pulumi.get(__ret__, 'identity_provider_users'),
        metadata=pulumi.get(__ret__, 'metadata'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        project_reference_lists=pulumi.get(__ret__, 'project_reference_lists'),
        state=pulumi.get(__ret__, 'state'),
        user_id=pulumi.get(__ret__, 'user_id'),
        user_name=pulumi.get(__ret__, 'user_name'),
        user_type=pulumi.get(__ret__, 'user_type'))
def get_user_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetUserCategoryArgs', 'GetUserCategoryArgsDict']]]]] = None,
                    owner_reference: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    project_reference: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    user_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    user_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Provides a datasource to retrieve a user based on the input parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    user_user = nutanix.User("user", directory_service_user={
        "user_principal_name": "test-user@ntnxlab.local",
        "directory_service_reference": {
            "uuid": "<directory-service-uuid>",
        },
    })
    #Retrieve by UUID
    user = nutanix.get_user_output(user_id=user_user.id)
    #Retrieve by Name
    userbyname = nutanix.get_user_output(user_name=user_user.name)
    ```


    :param Sequence[Union['GetUserCategoryArgs', 'GetUserCategoryArgsDict']] categories: - (Optional) Categories for the Access Control Policy.
    :param Mapping[str, _builtins.str] owner_reference: - (Optional) The reference to a user.
    :param Mapping[str, _builtins.str] project_reference: - (Optional) The reference to a project.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['ownerReference'] = owner_reference
    __args__['projectReference'] = project_reference
    __args__['userId'] = user_id
    __args__['userName'] = user_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        access_control_policy_reference_lists=pulumi.get(__response__, 'access_control_policy_reference_lists'),
        api_version=pulumi.get(__response__, 'api_version'),
        categories=pulumi.get(__response__, 'categories'),
        directory_service_users=pulumi.get(__response__, 'directory_service_users'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        identity_provider_users=pulumi.get(__response__, 'identity_provider_users'),
        metadata=pulumi.get(__response__, 'metadata'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        project_reference_lists=pulumi.get(__response__, 'project_reference_lists'),
        state=pulumi.get(__response__, 'state'),
        user_id=pulumi.get(__response__, 'user_id'),
        user_name=pulumi.get(__response__, 'user_name'),
        user_type=pulumi.get(__response__, 'user_type')))
