# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserGroupResult',
    'AwaitableGetUserGroupResult',
    'get_user_group',
    'get_user_group_output',
]

@pulumi.output_type
class GetUserGroupResult:
    """
    A collection of values returned by getUserGroup.
    """
    def __init__(__self__, access_control_policy_reference_lists=None, api_version=None, categories=None, directory_service_user_groups=None, display_name=None, id=None, metadata=None, owner_reference=None, project_reference=None, project_reference_lists=None, state=None, user_group_distinguished_name=None, user_group_id=None, user_group_name=None, user_group_type=None):
        if access_control_policy_reference_lists and not isinstance(access_control_policy_reference_lists, list):
            raise TypeError("Expected argument 'access_control_policy_reference_lists' to be a list")
        pulumi.set(__self__, "access_control_policy_reference_lists", access_control_policy_reference_lists)
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if directory_service_user_groups and not isinstance(directory_service_user_groups, list):
            raise TypeError("Expected argument 'directory_service_user_groups' to be a list")
        pulumi.set(__self__, "directory_service_user_groups", directory_service_user_groups)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if project_reference_lists and not isinstance(project_reference_lists, list):
            raise TypeError("Expected argument 'project_reference_lists' to be a list")
        pulumi.set(__self__, "project_reference_lists", project_reference_lists)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_group_distinguished_name and not isinstance(user_group_distinguished_name, str):
            raise TypeError("Expected argument 'user_group_distinguished_name' to be a str")
        pulumi.set(__self__, "user_group_distinguished_name", user_group_distinguished_name)
        if user_group_id and not isinstance(user_group_id, str):
            raise TypeError("Expected argument 'user_group_id' to be a str")
        pulumi.set(__self__, "user_group_id", user_group_id)
        if user_group_name and not isinstance(user_group_name, str):
            raise TypeError("Expected argument 'user_group_name' to be a str")
        pulumi.set(__self__, "user_group_name", user_group_name)
        if user_group_type and not isinstance(user_group_type, str):
            raise TypeError("Expected argument 'user_group_type' to be a str")
        pulumi.set(__self__, "user_group_type", user_group_type)

    @_builtins.property
    @pulumi.getter(name="accessControlPolicyReferenceLists")
    def access_control_policy_reference_lists(self) -> Sequence['outputs.GetUserGroupAccessControlPolicyReferenceListResult']:
        """
        - List of ACP references. See #reference for more details.
        """
        return pulumi.get(self, "access_control_policy_reference_lists")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetUserGroupCategoryResult']:
        """
        - The Distinguished Categories for the user group.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="directoryServiceUserGroups")
    def directory_service_user_groups(self) -> Sequence['outputs.GetUserGroupDirectoryServiceUserGroupResult']:
        """
        - A Directory Service User Group.
        """
        return pulumi.get(self, "directory_service_user_groups")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        - The display name of the user group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        - The user group kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        - The Distinguished The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="projectReferenceLists")
    def project_reference_lists(self) -> Sequence['outputs.GetUserGroupProjectReferenceListResult']:
        """
        - A list of projects the user is part of. See #reference for more details.
        """
        return pulumi.get(self, "project_reference_lists")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - The state of the entity.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userGroupDistinguishedName")
    def user_group_distinguished_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_group_distinguished_name")

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_group_id")

    @_builtins.property
    @pulumi.getter(name="userGroupName")
    def user_group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_group_name")

    @_builtins.property
    @pulumi.getter(name="userGroupType")
    def user_group_type(self) -> _builtins.str:
        """
        - The type of the user group.
        """
        return pulumi.get(self, "user_group_type")


class AwaitableGetUserGroupResult(GetUserGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupResult(
            access_control_policy_reference_lists=self.access_control_policy_reference_lists,
            api_version=self.api_version,
            categories=self.categories,
            directory_service_user_groups=self.directory_service_user_groups,
            display_name=self.display_name,
            id=self.id,
            metadata=self.metadata,
            owner_reference=self.owner_reference,
            project_reference=self.project_reference,
            project_reference_lists=self.project_reference_lists,
            state=self.state,
            user_group_distinguished_name=self.user_group_distinguished_name,
            user_group_id=self.user_group_id,
            user_group_name=self.user_group_name,
            user_group_type=self.user_group_type)


def get_user_group(categories: Optional[Sequence[Union['GetUserGroupCategoryArgs', 'GetUserGroupCategoryArgsDict']]] = None,
                   owner_reference: Optional[Mapping[str, _builtins.str]] = None,
                   project_reference: Optional[Mapping[str, _builtins.str]] = None,
                   user_group_distinguished_name: Optional[_builtins.str] = None,
                   user_group_id: Optional[_builtins.str] = None,
                   user_group_name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupResult:
    """
    Provides a datasource to retrieve a user group based on the input parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    #Retrieve by UUID
    usergroup = nutanix.get_user_group(user_group_id="dd30a856-8e72-4158-b716-98455ceda220")
    #Retrieve by Name
    usergroupbyname = nutanix.get_user_group(user_group_name="example-group-1")
    #Retrieve by Distinguished Name
    test = nutanix.get_user_group(user_group_distinguished_name="cn=example-group-1,cn=users,dc=ntnxlab,dc=local")
    ```


    :param Sequence[Union['GetUserGroupCategoryArgs', 'GetUserGroupCategoryArgsDict']] categories: - The Distinguished Categories for the user group.
    :param Mapping[str, _builtins.str] owner_reference: - The reference to a user.
    :param Mapping[str, _builtins.str] project_reference: - The Distinguished The reference to a project.
    :param _builtins.str user_group_distinguished_name: The distinguished name for the user group
    :param _builtins.str user_group_id: - (Optional) The UUID for the user group
    :param _builtins.str user_group_name: - (Optional) The name for the user group
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['ownerReference'] = owner_reference
    __args__['projectReference'] = project_reference
    __args__['userGroupDistinguishedName'] = user_group_distinguished_name
    __args__['userGroupId'] = user_group_id
    __args__['userGroupName'] = user_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult).value

    return AwaitableGetUserGroupResult(
        access_control_policy_reference_lists=pulumi.get(__ret__, 'access_control_policy_reference_lists'),
        api_version=pulumi.get(__ret__, 'api_version'),
        categories=pulumi.get(__ret__, 'categories'),
        directory_service_user_groups=pulumi.get(__ret__, 'directory_service_user_groups'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        project_reference_lists=pulumi.get(__ret__, 'project_reference_lists'),
        state=pulumi.get(__ret__, 'state'),
        user_group_distinguished_name=pulumi.get(__ret__, 'user_group_distinguished_name'),
        user_group_id=pulumi.get(__ret__, 'user_group_id'),
        user_group_name=pulumi.get(__ret__, 'user_group_name'),
        user_group_type=pulumi.get(__ret__, 'user_group_type'))
def get_user_group_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetUserGroupCategoryArgs', 'GetUserGroupCategoryArgsDict']]]]] = None,
                          owner_reference: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          project_reference: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          user_group_distinguished_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          user_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          user_group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupResult]:
    """
    Provides a datasource to retrieve a user group based on the input parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    #Retrieve by UUID
    usergroup = nutanix.get_user_group(user_group_id="dd30a856-8e72-4158-b716-98455ceda220")
    #Retrieve by Name
    usergroupbyname = nutanix.get_user_group(user_group_name="example-group-1")
    #Retrieve by Distinguished Name
    test = nutanix.get_user_group(user_group_distinguished_name="cn=example-group-1,cn=users,dc=ntnxlab,dc=local")
    ```


    :param Sequence[Union['GetUserGroupCategoryArgs', 'GetUserGroupCategoryArgsDict']] categories: - The Distinguished Categories for the user group.
    :param Mapping[str, _builtins.str] owner_reference: - The reference to a user.
    :param Mapping[str, _builtins.str] project_reference: - The Distinguished The reference to a project.
    :param _builtins.str user_group_distinguished_name: The distinguished name for the user group
    :param _builtins.str user_group_id: - (Optional) The UUID for the user group
    :param _builtins.str user_group_name: - (Optional) The name for the user group
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['ownerReference'] = owner_reference
    __args__['projectReference'] = project_reference
    __args__['userGroupDistinguishedName'] = user_group_distinguished_name
    __args__['userGroupId'] = user_group_id
    __args__['userGroupName'] = user_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult)
    return __ret__.apply(lambda __response__: GetUserGroupResult(
        access_control_policy_reference_lists=pulumi.get(__response__, 'access_control_policy_reference_lists'),
        api_version=pulumi.get(__response__, 'api_version'),
        categories=pulumi.get(__response__, 'categories'),
        directory_service_user_groups=pulumi.get(__response__, 'directory_service_user_groups'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        project_reference_lists=pulumi.get(__response__, 'project_reference_lists'),
        state=pulumi.get(__response__, 'state'),
        user_group_distinguished_name=pulumi.get(__response__, 'user_group_distinguished_name'),
        user_group_id=pulumi.get(__response__, 'user_group_id'),
        user_group_name=pulumi.get(__response__, 'user_group_name'),
        user_group_type=pulumi.get(__response__, 'user_group_type')))
