# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserGroupV2Result',
    'AwaitableGetUserGroupV2Result',
    'get_user_group_v2',
    'get_user_group_v2_output',
]

@pulumi.output_type
class GetUserGroupV2Result:
    """
    A collection of values returned by getUserGroupV2.
    """
    def __init__(__self__, created_by=None, created_time=None, distinguished_name=None, ext_id=None, group_type=None, id=None, idp_id=None, last_updated_time=None, name=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if distinguished_name and not isinstance(distinguished_name, str):
            raise TypeError("Expected argument 'distinguished_name' to be a str")
        pulumi.set(__self__, "distinguished_name", distinguished_name)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idp_id and not isinstance(idp_id, str):
            raise TypeError("Expected argument 'idp_id' to be a str")
        pulumi.set(__self__, "idp_id", idp_id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        - User or Service who created the User Group.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        - Creation time of the User Group.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="distinguishedName")
    def distinguished_name(self) -> _builtins.str:
        """
        - Identifier for the User Group in the form of a distinguished name.
        """
        return pulumi.get(self, "distinguished_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        """
        - Type of the User Group. LDAP (User Group belonging to a Directory Service (Open LDAP/AD)),  SAML (User Group belonging to a SAML IDP.)
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> _builtins.str:
        """
        - Identifier of the IDP for the User Group.
        """
        return pulumi.get(self, "idp_id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        - Last updated time of the User Group.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Common Name of the User Group.
        """
        return pulumi.get(self, "name")


class AwaitableGetUserGroupV2Result(GetUserGroupV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupV2Result(
            created_by=self.created_by,
            created_time=self.created_time,
            distinguished_name=self.distinguished_name,
            ext_id=self.ext_id,
            group_type=self.group_type,
            id=self.id,
            idp_id=self.idp_id,
            last_updated_time=self.last_updated_time,
            name=self.name)


def get_user_group_v2(ext_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupV2Result:
    """
    Provides a datasource to retrieve a user group based on the External Identifier of the User Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_ug = nutanix.get_user_group_v2(ext_id="a2a8650a-358a-4791-90c9-7a8b6e2989d6")
    ```


    :param _builtins.str ext_id: - (Required) The External Identifier of the User Group.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getUserGroupV2:getUserGroupV2', __args__, opts=opts, typ=GetUserGroupV2Result).value

    return AwaitableGetUserGroupV2Result(
        created_by=pulumi.get(__ret__, 'created_by'),
        created_time=pulumi.get(__ret__, 'created_time'),
        distinguished_name=pulumi.get(__ret__, 'distinguished_name'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        group_type=pulumi.get(__ret__, 'group_type'),
        id=pulumi.get(__ret__, 'id'),
        idp_id=pulumi.get(__ret__, 'idp_id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        name=pulumi.get(__ret__, 'name'))
def get_user_group_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupV2Result]:
    """
    Provides a datasource to retrieve a user group based on the External Identifier of the User Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_ug = nutanix.get_user_group_v2(ext_id="a2a8650a-358a-4791-90c9-7a8b6e2989d6")
    ```


    :param _builtins.str ext_id: - (Required) The External Identifier of the User Group.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getUserGroupV2:getUserGroupV2', __args__, opts=opts, typ=GetUserGroupV2Result)
    return __ret__.apply(lambda __response__: GetUserGroupV2Result(
        created_by=pulumi.get(__response__, 'created_by'),
        created_time=pulumi.get(__response__, 'created_time'),
        distinguished_name=pulumi.get(__response__, 'distinguished_name'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        group_type=pulumi.get(__response__, 'group_type'),
        id=pulumi.get(__response__, 'id'),
        idp_id=pulumi.get(__response__, 'idp_id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        name=pulumi.get(__response__, 'name')))
