# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUserKeyV2Result',
    'AwaitableGetUserKeyV2Result',
    'get_user_key_v2',
    'get_user_key_v2_output',
]

@pulumi.output_type
class GetUserKeyV2Result:
    """
    A collection of values returned by getUserKeyV2.
    """
    def __init__(__self__, assigned_to=None, created_by=None, created_time=None, creation_type=None, description=None, expiry_time=None, ext_id=None, id=None, key_details=None, key_type=None, last_updated_by=None, last_updated_time=None, last_used_time=None, links=None, name=None, status=None, tenant_id=None, user_ext_id=None):
        if assigned_to and not isinstance(assigned_to, str):
            raise TypeError("Expected argument 'assigned_to' to be a str")
        pulumi.set(__self__, "assigned_to", assigned_to)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if creation_type and not isinstance(creation_type, str):
            raise TypeError("Expected argument 'creation_type' to be a str")
        pulumi.set(__self__, "creation_type", creation_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expiry_time and not isinstance(expiry_time, str):
            raise TypeError("Expected argument 'expiry_time' to be a str")
        pulumi.set(__self__, "expiry_time", expiry_time)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_details and not isinstance(key_details, list):
            raise TypeError("Expected argument 'key_details' to be a list")
        pulumi.set(__self__, "key_details", key_details)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if last_used_time and not isinstance(last_used_time, str):
            raise TypeError("Expected argument 'last_used_time' to be a str")
        pulumi.set(__self__, "last_used_time", last_used_time)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if user_ext_id and not isinstance(user_ext_id, str):
            raise TypeError("Expected argument 'user_ext_id' to be a str")
        pulumi.set(__self__, "user_ext_id", user_ext_id)

    @_builtins.property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> _builtins.str:
        """
        - External client to whom the given key is allocated.
        """
        return pulumi.get(self, "assigned_to")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        - User or service who created the key.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        - The creation time of the key.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> _builtins.str:
        """
        - The creation mechanism of this entity.
        """
        return pulumi.get(self, "creation_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        - Brief description of the key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> _builtins.str:
        """
        - The time when the key will expire.
        """
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        The External Identifier of the User Group.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetUserKeyV2KeyDetailResult']:
        """
        - Details specific to type of the key.
        """
        return pulumi.get(self, "key_details")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        - The type of key.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> _builtins.str:
        """
        - User who updated the key.
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        - The time when the key was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> _builtins.str:
        """
        - The time when the key was last used.
        """
        return pulumi.get(self, "last_used_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetUserKeyV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Identifier for the key in the form of a name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        - The status of the key.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "user_ext_id")


class AwaitableGetUserKeyV2Result(GetUserKeyV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserKeyV2Result(
            assigned_to=self.assigned_to,
            created_by=self.created_by,
            created_time=self.created_time,
            creation_type=self.creation_type,
            description=self.description,
            expiry_time=self.expiry_time,
            ext_id=self.ext_id,
            id=self.id,
            key_details=self.key_details,
            key_type=self.key_type,
            last_updated_by=self.last_updated_by,
            last_updated_time=self.last_updated_time,
            last_used_time=self.last_used_time,
            links=self.links,
            name=self.name,
            status=self.status,
            tenant_id=self.tenant_id,
            user_ext_id=self.user_ext_id)


def get_user_key_v2(description: Optional[_builtins.str] = None,
                    ext_id: Optional[_builtins.str] = None,
                    user_ext_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserKeyV2Result:
    """
    Fetches the requested key through the provided external identifier for the user and the key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get key
    get_key = nutanix.get_user_key_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>",
        ext_id="<USER_KEY_UUID>")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `user_ext_id`: - ( Required ) External Identifier of the User.
    * `ext_id`: - ( Required ) External identifier of the key.


    :param _builtins.str description: - Brief description of the key.
    :param _builtins.str ext_id: The External Identifier of the User Group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['extId'] = ext_id
    __args__['userExtId'] = user_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getUserKeyV2:getUserKeyV2', __args__, opts=opts, typ=GetUserKeyV2Result).value

    return AwaitableGetUserKeyV2Result(
        assigned_to=pulumi.get(__ret__, 'assigned_to'),
        created_by=pulumi.get(__ret__, 'created_by'),
        created_time=pulumi.get(__ret__, 'created_time'),
        creation_type=pulumi.get(__ret__, 'creation_type'),
        description=pulumi.get(__ret__, 'description'),
        expiry_time=pulumi.get(__ret__, 'expiry_time'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        key_details=pulumi.get(__ret__, 'key_details'),
        key_type=pulumi.get(__ret__, 'key_type'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        last_used_time=pulumi.get(__ret__, 'last_used_time'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        user_ext_id=pulumi.get(__ret__, 'user_ext_id'))
def get_user_key_v2_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                           user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserKeyV2Result]:
    """
    Fetches the requested key through the provided external identifier for the user and the key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get key
    get_key = nutanix.get_user_key_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>",
        ext_id="<USER_KEY_UUID>")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `user_ext_id`: - ( Required ) External Identifier of the User.
    * `ext_id`: - ( Required ) External identifier of the key.


    :param _builtins.str description: - Brief description of the key.
    :param _builtins.str ext_id: The External Identifier of the User Group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['extId'] = ext_id
    __args__['userExtId'] = user_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getUserKeyV2:getUserKeyV2', __args__, opts=opts, typ=GetUserKeyV2Result)
    return __ret__.apply(lambda __response__: GetUserKeyV2Result(
        assigned_to=pulumi.get(__response__, 'assigned_to'),
        created_by=pulumi.get(__response__, 'created_by'),
        created_time=pulumi.get(__response__, 'created_time'),
        creation_type=pulumi.get(__response__, 'creation_type'),
        description=pulumi.get(__response__, 'description'),
        expiry_time=pulumi.get(__response__, 'expiry_time'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        key_details=pulumi.get(__response__, 'key_details'),
        key_type=pulumi.get(__response__, 'key_type'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        last_used_time=pulumi.get(__response__, 'last_used_time'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        user_ext_id=pulumi.get(__response__, 'user_ext_id')))
