# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUserKeysV2Result',
    'AwaitableGetUserKeysV2Result',
    'get_user_keys_v2',
    'get_user_keys_v2_output',
]

@pulumi.output_type
class GetUserKeysV2Result:
    """
    A collection of values returned by getUserKeysV2.
    """
    def __init__(__self__, filter=None, id=None, keys=None, limit=None, order_by=None, page=None, select=None, user_ext_id=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)
        if user_ext_id and not isinstance(user_ext_id, str):
            raise TypeError("Expected argument 'user_ext_id' to be a str")
        pulumi.set(__self__, "user_ext_id", user_ext_id)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetUserKeysV2KeyResult']:
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")

    @_builtins.property
    @pulumi.getter(name="userExtId")
    def user_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "user_ext_id")


class AwaitableGetUserKeysV2Result(GetUserKeysV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserKeysV2Result(
            filter=self.filter,
            id=self.id,
            keys=self.keys,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select,
            user_ext_id=self.user_ext_id)


def get_user_keys_v2(filter: Optional[_builtins.str] = None,
                     limit: Optional[_builtins.int] = None,
                     order_by: Optional[_builtins.str] = None,
                     page: Optional[_builtins.int] = None,
                     select: Optional[_builtins.str] = None,
                     user_ext_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserKeysV2Result:
    """
    List all keys identified by the external identifier of a user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Data source to fetch the list of keys
    get_keys = nutanix.get_user_keys_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>")
    # Data source to fetch the key by name
    get_keys_filter = nutanix.get_user_keys_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>",
        filter="name eq '<NAME_OF_API_KEY>'")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `user_ext_id`: - ( Required ) External Identifier of the User.
    * `page`:- (Optional)A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    * `limit`:- (Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    * `filter` :- (Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
        * assignedTo
        * creationType
        * extId
        * keyType
        * lastUpdatedBy
        * name
        * status
        * tenantId
    * `orderby` :- (Optional) A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:     * createdBy
        * assignedTo
        * createdBy
        * createdTime
        * expiryTime
        * keyType
        * lastUpdatedTime
        * lastUsedTime
        * name
        * status
        * tenantId
    * `select` :- (Optional) A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. following fields:
        * assignedTo
        * createdBy
        * createdTime
        * creationType
        * description
        * expiryTime
        * extId
        * keyType
        * lastUpdatedBy
        * lastUpdatedTime
        * lastUsedTime
        * name
        * status
        * tenantId
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    __args__['userExtId'] = user_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getUserKeysV2:getUserKeysV2', __args__, opts=opts, typ=GetUserKeysV2Result).value

    return AwaitableGetUserKeysV2Result(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        keys=pulumi.get(__ret__, 'keys'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'),
        user_ext_id=pulumi.get(__ret__, 'user_ext_id'))
def get_user_keys_v2_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            user_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserKeysV2Result]:
    """
    List all keys identified by the external identifier of a user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Data source to fetch the list of keys
    get_keys = nutanix.get_user_keys_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>")
    # Data source to fetch the key by name
    get_keys_filter = nutanix.get_user_keys_v2(user_ext_id="<SERVICE_ACCOUNT_UUID>",
        filter="name eq '<NAME_OF_API_KEY>'")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `user_ext_id`: - ( Required ) External Identifier of the User.
    * `page`:- (Optional)A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    * `limit`:- (Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    * `filter` :- (Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
        * assignedTo
        * creationType
        * extId
        * keyType
        * lastUpdatedBy
        * name
        * status
        * tenantId
    * `orderby` :- (Optional) A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:     * createdBy
        * assignedTo
        * createdBy
        * createdTime
        * expiryTime
        * keyType
        * lastUpdatedTime
        * lastUsedTime
        * name
        * status
        * tenantId
    * `select` :- (Optional) A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. following fields:
        * assignedTo
        * createdBy
        * createdTime
        * creationType
        * description
        * expiryTime
        * extId
        * keyType
        * lastUpdatedBy
        * lastUpdatedTime
        * lastUsedTime
        * name
        * status
        * tenantId
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    __args__['userExtId'] = user_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getUserKeysV2:getUserKeysV2', __args__, opts=opts, typ=GetUserKeysV2Result)
    return __ret__.apply(lambda __response__: GetUserKeysV2Result(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        keys=pulumi.get(__response__, 'keys'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select'),
        user_ext_id=pulumi.get(__response__, 'user_ext_id')))
