# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVirtualMachineV2Result',
    'AwaitableGetVirtualMachineV2Result',
    'get_virtual_machine_v2',
    'get_virtual_machine_v2_output',
]

@pulumi.output_type
class GetVirtualMachineV2Result:
    """
    A collection of values returned by getVirtualMachineV2.
    """
    def __init__(__self__, apc_configs=None, availability_zones=None, bios_uuid=None, boot_configs=None, categories=None, cd_roms=None, clusters=None, create_time=None, description=None, disks=None, enabled_cpu_features=None, ext_id=None, generation_uuid=None, gpuses=None, guest_customizations=None, guest_tools=None, hardware_clock_timezone=None, hosts=None, id=None, is_agent_vm=None, is_branding_enabled=None, is_cpu_hotplug_enabled=None, is_cpu_passthrough_enabled=None, is_gpu_console_enabled=None, is_memory_overcommit_enabled=None, is_scsi_controller_enabled=None, is_vcpu_hard_pinning_enabled=None, is_vga_console_enabled=None, machine_type=None, memory_size_bytes=None, name=None, nics=None, num_cores_per_socket=None, num_numa_nodes=None, num_sockets=None, num_threads_per_core=None, ownership_infos=None, power_state=None, protection_policy_states=None, protection_type=None, serial_ports=None, sources=None, storage_configs=None, update_time=None, vtpm_configs=None):
        if apc_configs and not isinstance(apc_configs, list):
            raise TypeError("Expected argument 'apc_configs' to be a list")
        pulumi.set(__self__, "apc_configs", apc_configs)
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if bios_uuid and not isinstance(bios_uuid, str):
            raise TypeError("Expected argument 'bios_uuid' to be a str")
        pulumi.set(__self__, "bios_uuid", bios_uuid)
        if boot_configs and not isinstance(boot_configs, list):
            raise TypeError("Expected argument 'boot_configs' to be a list")
        pulumi.set(__self__, "boot_configs", boot_configs)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if cd_roms and not isinstance(cd_roms, list):
            raise TypeError("Expected argument 'cd_roms' to be a list")
        pulumi.set(__self__, "cd_roms", cd_roms)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if enabled_cpu_features and not isinstance(enabled_cpu_features, list):
            raise TypeError("Expected argument 'enabled_cpu_features' to be a list")
        pulumi.set(__self__, "enabled_cpu_features", enabled_cpu_features)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if generation_uuid and not isinstance(generation_uuid, str):
            raise TypeError("Expected argument 'generation_uuid' to be a str")
        pulumi.set(__self__, "generation_uuid", generation_uuid)
        if gpuses and not isinstance(gpuses, list):
            raise TypeError("Expected argument 'gpuses' to be a list")
        pulumi.set(__self__, "gpuses", gpuses)
        if guest_customizations and not isinstance(guest_customizations, list):
            raise TypeError("Expected argument 'guest_customizations' to be a list")
        pulumi.set(__self__, "guest_customizations", guest_customizations)
        if guest_tools and not isinstance(guest_tools, list):
            raise TypeError("Expected argument 'guest_tools' to be a list")
        pulumi.set(__self__, "guest_tools", guest_tools)
        if hardware_clock_timezone and not isinstance(hardware_clock_timezone, str):
            raise TypeError("Expected argument 'hardware_clock_timezone' to be a str")
        pulumi.set(__self__, "hardware_clock_timezone", hardware_clock_timezone)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_agent_vm and not isinstance(is_agent_vm, bool):
            raise TypeError("Expected argument 'is_agent_vm' to be a bool")
        pulumi.set(__self__, "is_agent_vm", is_agent_vm)
        if is_branding_enabled and not isinstance(is_branding_enabled, bool):
            raise TypeError("Expected argument 'is_branding_enabled' to be a bool")
        pulumi.set(__self__, "is_branding_enabled", is_branding_enabled)
        if is_cpu_hotplug_enabled and not isinstance(is_cpu_hotplug_enabled, bool):
            raise TypeError("Expected argument 'is_cpu_hotplug_enabled' to be a bool")
        pulumi.set(__self__, "is_cpu_hotplug_enabled", is_cpu_hotplug_enabled)
        if is_cpu_passthrough_enabled and not isinstance(is_cpu_passthrough_enabled, bool):
            raise TypeError("Expected argument 'is_cpu_passthrough_enabled' to be a bool")
        pulumi.set(__self__, "is_cpu_passthrough_enabled", is_cpu_passthrough_enabled)
        if is_gpu_console_enabled and not isinstance(is_gpu_console_enabled, bool):
            raise TypeError("Expected argument 'is_gpu_console_enabled' to be a bool")
        pulumi.set(__self__, "is_gpu_console_enabled", is_gpu_console_enabled)
        if is_memory_overcommit_enabled and not isinstance(is_memory_overcommit_enabled, bool):
            raise TypeError("Expected argument 'is_memory_overcommit_enabled' to be a bool")
        pulumi.set(__self__, "is_memory_overcommit_enabled", is_memory_overcommit_enabled)
        if is_scsi_controller_enabled and not isinstance(is_scsi_controller_enabled, bool):
            raise TypeError("Expected argument 'is_scsi_controller_enabled' to be a bool")
        pulumi.set(__self__, "is_scsi_controller_enabled", is_scsi_controller_enabled)
        if is_vcpu_hard_pinning_enabled and not isinstance(is_vcpu_hard_pinning_enabled, bool):
            raise TypeError("Expected argument 'is_vcpu_hard_pinning_enabled' to be a bool")
        pulumi.set(__self__, "is_vcpu_hard_pinning_enabled", is_vcpu_hard_pinning_enabled)
        if is_vga_console_enabled and not isinstance(is_vga_console_enabled, bool):
            raise TypeError("Expected argument 'is_vga_console_enabled' to be a bool")
        pulumi.set(__self__, "is_vga_console_enabled", is_vga_console_enabled)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if memory_size_bytes and not isinstance(memory_size_bytes, int):
            raise TypeError("Expected argument 'memory_size_bytes' to be a int")
        pulumi.set(__self__, "memory_size_bytes", memory_size_bytes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nics and not isinstance(nics, list):
            raise TypeError("Expected argument 'nics' to be a list")
        pulumi.set(__self__, "nics", nics)
        if num_cores_per_socket and not isinstance(num_cores_per_socket, int):
            raise TypeError("Expected argument 'num_cores_per_socket' to be a int")
        pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_numa_nodes and not isinstance(num_numa_nodes, int):
            raise TypeError("Expected argument 'num_numa_nodes' to be a int")
        pulumi.set(__self__, "num_numa_nodes", num_numa_nodes)
        if num_sockets and not isinstance(num_sockets, int):
            raise TypeError("Expected argument 'num_sockets' to be a int")
        pulumi.set(__self__, "num_sockets", num_sockets)
        if num_threads_per_core and not isinstance(num_threads_per_core, int):
            raise TypeError("Expected argument 'num_threads_per_core' to be a int")
        pulumi.set(__self__, "num_threads_per_core", num_threads_per_core)
        if ownership_infos and not isinstance(ownership_infos, list):
            raise TypeError("Expected argument 'ownership_infos' to be a list")
        pulumi.set(__self__, "ownership_infos", ownership_infos)
        if power_state and not isinstance(power_state, str):
            raise TypeError("Expected argument 'power_state' to be a str")
        pulumi.set(__self__, "power_state", power_state)
        if protection_policy_states and not isinstance(protection_policy_states, list):
            raise TypeError("Expected argument 'protection_policy_states' to be a list")
        pulumi.set(__self__, "protection_policy_states", protection_policy_states)
        if protection_type and not isinstance(protection_type, str):
            raise TypeError("Expected argument 'protection_type' to be a str")
        pulumi.set(__self__, "protection_type", protection_type)
        if serial_ports and not isinstance(serial_ports, list):
            raise TypeError("Expected argument 'serial_ports' to be a list")
        pulumi.set(__self__, "serial_ports", serial_ports)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if storage_configs and not isinstance(storage_configs, list):
            raise TypeError("Expected argument 'storage_configs' to be a list")
        pulumi.set(__self__, "storage_configs", storage_configs)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if vtpm_configs and not isinstance(vtpm_configs, list):
            raise TypeError("Expected argument 'vtpm_configs' to be a list")
        pulumi.set(__self__, "vtpm_configs", vtpm_configs)

    @_builtins.property
    @pulumi.getter(name="apcConfigs")
    def apc_configs(self) -> Sequence['outputs.GetVirtualMachineV2ApcConfigResult']:
        """
        Advanced Processor Compatibility configuration for the VM. Enabling this retains the CPU model for the VM across power cycles and migrations.
        """
        return pulumi.get(self, "apc_configs")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence['outputs.GetVirtualMachineV2AvailabilityZoneResult']:
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="biosUuid")
    def bios_uuid(self) -> _builtins.str:
        """
        BIOS UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "bios_uuid")

    @_builtins.property
    @pulumi.getter(name="bootConfigs")
    def boot_configs(self) -> Sequence['outputs.GetVirtualMachineV2BootConfigResult']:
        """
        Indicates the order of device types in which the VM should try to boot from. If the boot device order is not provided the system will decide an appropriate boot device order.
        """
        return pulumi.get(self, "boot_configs")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetVirtualMachineV2CategoryResult']:
        """
        Categories for the VM.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="cdRoms")
    def cd_roms(self) -> Sequence['outputs.GetVirtualMachineV2CdRomResult']:
        """
        CD-ROMs attached to the VM.
        """
        return pulumi.get(self, "cd_roms")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetVirtualMachineV2ClusterResult']:
        """
        Reference to a cluster.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        VM creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        VM description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetVirtualMachineV2DiskResult']:
        """
        Disks attached to the VM.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="enabledCpuFeatures")
    def enabled_cpu_features(self) -> Sequence[_builtins.str]:
        """
        The list of additional CPU features to be enabled. HardwareVirtualization: Indicates whether hardware assisted virtualization should be enabled for the Guest OS or not. Once enabled, the Guest OS can deploy a nested hypervisor
        """
        return pulumi.get(self, "enabled_cpu_features")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="generationUuid")
    def generation_uuid(self) -> _builtins.str:
        """
        Generation UUID of the VM. It should be of type UUID.
        """
        return pulumi.get(self, "generation_uuid")

    @_builtins.property
    @pulumi.getter
    def gpuses(self) -> Sequence['outputs.GetVirtualMachineV2GpusResult']:
        """
        GPUs attached to the VM.
        """
        return pulumi.get(self, "gpuses")

    @_builtins.property
    @pulumi.getter(name="guestCustomizations")
    def guest_customizations(self) -> Sequence['outputs.GetVirtualMachineV2GuestCustomizationResult']:
        """
        Stage a Sysprep or cloud-init configuration file to be used by the guest for the next boot. Note that the Sysprep command must be used to generalize the Windows VMs before triggering this API call.
        """
        return pulumi.get(self, "guest_customizations")

    @_builtins.property
    @pulumi.getter(name="guestTools")
    def guest_tools(self) -> Sequence['outputs.GetVirtualMachineV2GuestToolResult']:
        """
        The details about Nutanix Guest Tools for a VM.
        """
        return pulumi.get(self, "guest_tools")

    @_builtins.property
    @pulumi.getter(name="hardwareClockTimezone")
    def hardware_clock_timezone(self) -> _builtins.str:
        """
        VM hardware clock timezone in IANA TZDB format (America/Los_Angeles).
        """
        return pulumi.get(self, "hardware_clock_timezone")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetVirtualMachineV2HostResult']:
        """
        Reference to the host, the VM is running on.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAgentVm")
    def is_agent_vm(self) -> _builtins.bool:
        """
        Indicates whether the VM is an agent VM or not. When their host enters maintenance mode, once the normal VMs are evacuated, the agent VMs are powered off. When the host is restored, agent VMs are powered on before the normal VMs are restored. In other words, agent VMs cannot be HA-protected or live migrated.
        """
        return pulumi.get(self, "is_agent_vm")

    @_builtins.property
    @pulumi.getter(name="isBrandingEnabled")
    def is_branding_enabled(self) -> _builtins.bool:
        """
        Indicates whether to remove AHV branding from VM firmware tables or not.
        """
        return pulumi.get(self, "is_branding_enabled")

    @_builtins.property
    @pulumi.getter(name="isCpuHotplugEnabled")
    def is_cpu_hotplug_enabled(self) -> _builtins.bool:
        """
        Indicates whether the VM CPU hotplug is enabled.
        """
        return pulumi.get(self, "is_cpu_hotplug_enabled")

    @_builtins.property
    @pulumi.getter(name="isCpuPassthroughEnabled")
    def is_cpu_passthrough_enabled(self) -> _builtins.bool:
        """
        Indicates whether to passthrough the host CPU features to the guest or not. Enabling this will make VM incapable of live migration.
        """
        return pulumi.get(self, "is_cpu_passthrough_enabled")

    @_builtins.property
    @pulumi.getter(name="isGpuConsoleEnabled")
    def is_gpu_console_enabled(self) -> _builtins.bool:
        """
        Indicates whether the vGPU console is enabled or not.
        """
        return pulumi.get(self, "is_gpu_console_enabled")

    @_builtins.property
    @pulumi.getter(name="isMemoryOvercommitEnabled")
    def is_memory_overcommit_enabled(self) -> _builtins.bool:
        """
        Indicates whether the memory overcommit feature should be enabled for the VM or not. If enabled, parts of the VM memory may reside outside of the hypervisor physical memory. Once enabled, it should be expected that the VM may suffer performance degradation.
        """
        return pulumi.get(self, "is_memory_overcommit_enabled")

    @_builtins.property
    @pulumi.getter(name="isScsiControllerEnabled")
    def is_scsi_controller_enabled(self) -> _builtins.bool:
        """
        Indicates whether the VM SCSI controller is enabled.
        """
        return pulumi.get(self, "is_scsi_controller_enabled")

    @_builtins.property
    @pulumi.getter(name="isVcpuHardPinningEnabled")
    def is_vcpu_hard_pinning_enabled(self) -> _builtins.bool:
        """
        Indicates whether the vCPUs should be hard pinned to specific pCPUs or not.
        """
        return pulumi.get(self, "is_vcpu_hard_pinning_enabled")

    @_builtins.property
    @pulumi.getter(name="isVgaConsoleEnabled")
    def is_vga_console_enabled(self) -> _builtins.bool:
        """
        Indicates whether the VGA console should be disabled or not.
        """
        return pulumi.get(self, "is_vga_console_enabled")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Machine type for the VM. Machine type Q35 is required for secure boot and does not support IDE disks.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="memorySizeBytes")
    def memory_size_bytes(self) -> _builtins.int:
        """
        Memory size in bytes.
        """
        return pulumi.get(self, "memory_size_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the GPU resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Sequence['outputs.GetVirtualMachineV2NicResult']:
        """
        NICs attached to the VM.
        """
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> _builtins.int:
        """
        Number of cores per socket.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @_builtins.property
    @pulumi.getter(name="numNumaNodes")
    def num_numa_nodes(self) -> _builtins.int:
        """
        Number of NUMA nodes. 0 means NUMA is disabled.
        """
        return pulumi.get(self, "num_numa_nodes")

    @_builtins.property
    @pulumi.getter(name="numSockets")
    def num_sockets(self) -> _builtins.int:
        """
        Number of vCPU sockets.
        """
        return pulumi.get(self, "num_sockets")

    @_builtins.property
    @pulumi.getter(name="numThreadsPerCore")
    def num_threads_per_core(self) -> _builtins.int:
        """
        Number of threads per core
        """
        return pulumi.get(self, "num_threads_per_core")

    @_builtins.property
    @pulumi.getter(name="ownershipInfos")
    def ownership_infos(self) -> Sequence['outputs.GetVirtualMachineV2OwnershipInfoResult']:
        """
        Ownership information for the VM.
        """
        return pulumi.get(self, "ownership_infos")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> _builtins.str:
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="protectionPolicyStates")
    def protection_policy_states(self) -> Sequence['outputs.GetVirtualMachineV2ProtectionPolicyStateResult']:
        """
        Status of protection policy applied to this VM.
        """
        return pulumi.get(self, "protection_policy_states")

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> _builtins.str:
        """
        The type of protection applied on a VM. PD_PROTECTED indicates a VM is protected using the Prism Element. RULE_PROTECTED indicates a VM protection using the Prism Central.
        """
        return pulumi.get(self, "protection_type")

    @_builtins.property
    @pulumi.getter(name="serialPorts")
    def serial_ports(self) -> Sequence['outputs.GetVirtualMachineV2SerialPortResult']:
        """
        Serial ports configured on the VM.
        """
        return pulumi.get(self, "serial_ports")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetVirtualMachineV2SourceResult']:
        """
        Reference to an entity that the VM should be cloned or created from
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Sequence['outputs.GetVirtualMachineV2StorageConfigResult']:
        """
        Storage configuration for VM disks
        """
        return pulumi.get(self, "storage_configs")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        VM last updated time.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="vtpmConfigs")
    def vtpm_configs(self) -> Sequence['outputs.GetVirtualMachineV2VtpmConfigResult']:
        """
        Indicates how the vTPM for the VM should be configured.
        """
        return pulumi.get(self, "vtpm_configs")


class AwaitableGetVirtualMachineV2Result(GetVirtualMachineV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualMachineV2Result(
            apc_configs=self.apc_configs,
            availability_zones=self.availability_zones,
            bios_uuid=self.bios_uuid,
            boot_configs=self.boot_configs,
            categories=self.categories,
            cd_roms=self.cd_roms,
            clusters=self.clusters,
            create_time=self.create_time,
            description=self.description,
            disks=self.disks,
            enabled_cpu_features=self.enabled_cpu_features,
            ext_id=self.ext_id,
            generation_uuid=self.generation_uuid,
            gpuses=self.gpuses,
            guest_customizations=self.guest_customizations,
            guest_tools=self.guest_tools,
            hardware_clock_timezone=self.hardware_clock_timezone,
            hosts=self.hosts,
            id=self.id,
            is_agent_vm=self.is_agent_vm,
            is_branding_enabled=self.is_branding_enabled,
            is_cpu_hotplug_enabled=self.is_cpu_hotplug_enabled,
            is_cpu_passthrough_enabled=self.is_cpu_passthrough_enabled,
            is_gpu_console_enabled=self.is_gpu_console_enabled,
            is_memory_overcommit_enabled=self.is_memory_overcommit_enabled,
            is_scsi_controller_enabled=self.is_scsi_controller_enabled,
            is_vcpu_hard_pinning_enabled=self.is_vcpu_hard_pinning_enabled,
            is_vga_console_enabled=self.is_vga_console_enabled,
            machine_type=self.machine_type,
            memory_size_bytes=self.memory_size_bytes,
            name=self.name,
            nics=self.nics,
            num_cores_per_socket=self.num_cores_per_socket,
            num_numa_nodes=self.num_numa_nodes,
            num_sockets=self.num_sockets,
            num_threads_per_core=self.num_threads_per_core,
            ownership_infos=self.ownership_infos,
            power_state=self.power_state,
            protection_policy_states=self.protection_policy_states,
            protection_type=self.protection_type,
            serial_ports=self.serial_ports,
            sources=self.sources,
            storage_configs=self.storage_configs,
            update_time=self.update_time,
            vtpm_configs=self.vtpm_configs)


def get_virtual_machine_v2(ext_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualMachineV2Result:
    """
    Retrieves configuration details for a Virtual Machine.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    vm = nutanix.get_virtual_machine_v2(ext_id="{{ ext_id of vm }}")
    ```


    :param _builtins.str ext_id: Represents virtual machine UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVirtualMachineV2:getVirtualMachineV2', __args__, opts=opts, typ=GetVirtualMachineV2Result).value

    return AwaitableGetVirtualMachineV2Result(
        apc_configs=pulumi.get(__ret__, 'apc_configs'),
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        bios_uuid=pulumi.get(__ret__, 'bios_uuid'),
        boot_configs=pulumi.get(__ret__, 'boot_configs'),
        categories=pulumi.get(__ret__, 'categories'),
        cd_roms=pulumi.get(__ret__, 'cd_roms'),
        clusters=pulumi.get(__ret__, 'clusters'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        disks=pulumi.get(__ret__, 'disks'),
        enabled_cpu_features=pulumi.get(__ret__, 'enabled_cpu_features'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        generation_uuid=pulumi.get(__ret__, 'generation_uuid'),
        gpuses=pulumi.get(__ret__, 'gpuses'),
        guest_customizations=pulumi.get(__ret__, 'guest_customizations'),
        guest_tools=pulumi.get(__ret__, 'guest_tools'),
        hardware_clock_timezone=pulumi.get(__ret__, 'hardware_clock_timezone'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        is_agent_vm=pulumi.get(__ret__, 'is_agent_vm'),
        is_branding_enabled=pulumi.get(__ret__, 'is_branding_enabled'),
        is_cpu_hotplug_enabled=pulumi.get(__ret__, 'is_cpu_hotplug_enabled'),
        is_cpu_passthrough_enabled=pulumi.get(__ret__, 'is_cpu_passthrough_enabled'),
        is_gpu_console_enabled=pulumi.get(__ret__, 'is_gpu_console_enabled'),
        is_memory_overcommit_enabled=pulumi.get(__ret__, 'is_memory_overcommit_enabled'),
        is_scsi_controller_enabled=pulumi.get(__ret__, 'is_scsi_controller_enabled'),
        is_vcpu_hard_pinning_enabled=pulumi.get(__ret__, 'is_vcpu_hard_pinning_enabled'),
        is_vga_console_enabled=pulumi.get(__ret__, 'is_vga_console_enabled'),
        machine_type=pulumi.get(__ret__, 'machine_type'),
        memory_size_bytes=pulumi.get(__ret__, 'memory_size_bytes'),
        name=pulumi.get(__ret__, 'name'),
        nics=pulumi.get(__ret__, 'nics'),
        num_cores_per_socket=pulumi.get(__ret__, 'num_cores_per_socket'),
        num_numa_nodes=pulumi.get(__ret__, 'num_numa_nodes'),
        num_sockets=pulumi.get(__ret__, 'num_sockets'),
        num_threads_per_core=pulumi.get(__ret__, 'num_threads_per_core'),
        ownership_infos=pulumi.get(__ret__, 'ownership_infos'),
        power_state=pulumi.get(__ret__, 'power_state'),
        protection_policy_states=pulumi.get(__ret__, 'protection_policy_states'),
        protection_type=pulumi.get(__ret__, 'protection_type'),
        serial_ports=pulumi.get(__ret__, 'serial_ports'),
        sources=pulumi.get(__ret__, 'sources'),
        storage_configs=pulumi.get(__ret__, 'storage_configs'),
        update_time=pulumi.get(__ret__, 'update_time'),
        vtpm_configs=pulumi.get(__ret__, 'vtpm_configs'))
def get_virtual_machine_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualMachineV2Result]:
    """
    Retrieves configuration details for a Virtual Machine.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    vm = nutanix.get_virtual_machine_v2(ext_id="{{ ext_id of vm }}")
    ```


    :param _builtins.str ext_id: Represents virtual machine UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVirtualMachineV2:getVirtualMachineV2', __args__, opts=opts, typ=GetVirtualMachineV2Result)
    return __ret__.apply(lambda __response__: GetVirtualMachineV2Result(
        apc_configs=pulumi.get(__response__, 'apc_configs'),
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        bios_uuid=pulumi.get(__response__, 'bios_uuid'),
        boot_configs=pulumi.get(__response__, 'boot_configs'),
        categories=pulumi.get(__response__, 'categories'),
        cd_roms=pulumi.get(__response__, 'cd_roms'),
        clusters=pulumi.get(__response__, 'clusters'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        disks=pulumi.get(__response__, 'disks'),
        enabled_cpu_features=pulumi.get(__response__, 'enabled_cpu_features'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        generation_uuid=pulumi.get(__response__, 'generation_uuid'),
        gpuses=pulumi.get(__response__, 'gpuses'),
        guest_customizations=pulumi.get(__response__, 'guest_customizations'),
        guest_tools=pulumi.get(__response__, 'guest_tools'),
        hardware_clock_timezone=pulumi.get(__response__, 'hardware_clock_timezone'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        is_agent_vm=pulumi.get(__response__, 'is_agent_vm'),
        is_branding_enabled=pulumi.get(__response__, 'is_branding_enabled'),
        is_cpu_hotplug_enabled=pulumi.get(__response__, 'is_cpu_hotplug_enabled'),
        is_cpu_passthrough_enabled=pulumi.get(__response__, 'is_cpu_passthrough_enabled'),
        is_gpu_console_enabled=pulumi.get(__response__, 'is_gpu_console_enabled'),
        is_memory_overcommit_enabled=pulumi.get(__response__, 'is_memory_overcommit_enabled'),
        is_scsi_controller_enabled=pulumi.get(__response__, 'is_scsi_controller_enabled'),
        is_vcpu_hard_pinning_enabled=pulumi.get(__response__, 'is_vcpu_hard_pinning_enabled'),
        is_vga_console_enabled=pulumi.get(__response__, 'is_vga_console_enabled'),
        machine_type=pulumi.get(__response__, 'machine_type'),
        memory_size_bytes=pulumi.get(__response__, 'memory_size_bytes'),
        name=pulumi.get(__response__, 'name'),
        nics=pulumi.get(__response__, 'nics'),
        num_cores_per_socket=pulumi.get(__response__, 'num_cores_per_socket'),
        num_numa_nodes=pulumi.get(__response__, 'num_numa_nodes'),
        num_sockets=pulumi.get(__response__, 'num_sockets'),
        num_threads_per_core=pulumi.get(__response__, 'num_threads_per_core'),
        ownership_infos=pulumi.get(__response__, 'ownership_infos'),
        power_state=pulumi.get(__response__, 'power_state'),
        protection_policy_states=pulumi.get(__response__, 'protection_policy_states'),
        protection_type=pulumi.get(__response__, 'protection_type'),
        serial_ports=pulumi.get(__response__, 'serial_ports'),
        sources=pulumi.get(__response__, 'sources'),
        storage_configs=pulumi.get(__response__, 'storage_configs'),
        update_time=pulumi.get(__response__, 'update_time'),
        vtpm_configs=pulumi.get(__response__, 'vtpm_configs')))
