# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmRecoveryPointInfoV2Result',
    'AwaitableGetVmRecoveryPointInfoV2Result',
    'get_vm_recovery_point_info_v2',
    'get_vm_recovery_point_info_v2_output',
]

@pulumi.output_type
class GetVmRecoveryPointInfoV2Result:
    """
    A collection of values returned by getVmRecoveryPointInfoV2.
    """
    def __init__(__self__, application_consistent_properties=None, consistency_group_ext_id=None, disk_recovery_points=None, ext_id=None, id=None, links=None, location_agnostic_id=None, recovery_point_ext_id=None, tenant_id=None, vm_categories=None, vm_ext_id=None):
        if application_consistent_properties and not isinstance(application_consistent_properties, list):
            raise TypeError("Expected argument 'application_consistent_properties' to be a list")
        pulumi.set(__self__, "application_consistent_properties", application_consistent_properties)
        if consistency_group_ext_id and not isinstance(consistency_group_ext_id, str):
            raise TypeError("Expected argument 'consistency_group_ext_id' to be a str")
        pulumi.set(__self__, "consistency_group_ext_id", consistency_group_ext_id)
        if disk_recovery_points and not isinstance(disk_recovery_points, list):
            raise TypeError("Expected argument 'disk_recovery_points' to be a list")
        pulumi.set(__self__, "disk_recovery_points", disk_recovery_points)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if location_agnostic_id and not isinstance(location_agnostic_id, str):
            raise TypeError("Expected argument 'location_agnostic_id' to be a str")
        pulumi.set(__self__, "location_agnostic_id", location_agnostic_id)
        if recovery_point_ext_id and not isinstance(recovery_point_ext_id, str):
            raise TypeError("Expected argument 'recovery_point_ext_id' to be a str")
        pulumi.set(__self__, "recovery_point_ext_id", recovery_point_ext_id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vm_categories and not isinstance(vm_categories, list):
            raise TypeError("Expected argument 'vm_categories' to be a list")
        pulumi.set(__self__, "vm_categories", vm_categories)
        if vm_ext_id and not isinstance(vm_ext_id, str):
            raise TypeError("Expected argument 'vm_ext_id' to be a str")
        pulumi.set(__self__, "vm_ext_id", vm_ext_id)

    @_builtins.property
    @pulumi.getter(name="applicationConsistentProperties")
    def application_consistent_properties(self) -> Sequence['outputs.GetVmRecoveryPointInfoV2ApplicationConsistentPropertyResult']:
        """
        User-defined application-consistent properties for the recovery point.
        *
        """
        return pulumi.get(self, "application_consistent_properties")

    @_builtins.property
    @pulumi.getter(name="consistencyGroupExtId")
    def consistency_group_ext_id(self) -> _builtins.str:
        """
        External identifier of the Consistency group which the VM was part of at the time of recovery point creation.
        """
        return pulumi.get(self, "consistency_group_ext_id")

    @_builtins.property
    @pulumi.getter(name="diskRecoveryPoints")
    def disk_recovery_points(self) -> Sequence['outputs.GetVmRecoveryPointInfoV2DiskRecoveryPointResult']:
        """
        array of disk recovery points.
        """
        return pulumi.get(self, "disk_recovery_points")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        recovery point UUID
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetVmRecoveryPointInfoV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="locationAgnosticId")
    def location_agnostic_id(self) -> _builtins.str:
        """
        Location agnostic identifier of the Recovery point.
        """
        return pulumi.get(self, "location_agnostic_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPointExtId")
    def recovery_point_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "recovery_point_ext_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vmCategories")
    def vm_categories(self) -> Sequence[_builtins.str]:
        """
        Category key-value pairs associated with the VM at the time of recovery point creation. The category key and value are separated by '/'. For example, a category with key 'dept' and value 'hr' is displayed as 'dept/hr'.
        """
        return pulumi.get(self, "vm_categories")

    @_builtins.property
    @pulumi.getter(name="vmExtId")
    def vm_ext_id(self) -> _builtins.str:
        """
        VM external identifier which is captured as a part of this recovery point.
        """
        return pulumi.get(self, "vm_ext_id")


class AwaitableGetVmRecoveryPointInfoV2Result(GetVmRecoveryPointInfoV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmRecoveryPointInfoV2Result(
            application_consistent_properties=self.application_consistent_properties,
            consistency_group_ext_id=self.consistency_group_ext_id,
            disk_recovery_points=self.disk_recovery_points,
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            location_agnostic_id=self.location_agnostic_id,
            recovery_point_ext_id=self.recovery_point_ext_id,
            tenant_id=self.tenant_id,
            vm_categories=self.vm_categories,
            vm_ext_id=self.vm_ext_id)


def get_vm_recovery_point_info_v2(disk_recovery_points: Optional[Sequence[Union['GetVmRecoveryPointInfoV2DiskRecoveryPointArgs', 'GetVmRecoveryPointInfoV2DiskRecoveryPointArgsDict']]] = None,
                                  ext_id: Optional[_builtins.str] = None,
                                  recovery_point_ext_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmRecoveryPointInfoV2Result:
    """
    Get the VM recovery point identified by ex_id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # vm recovery point details
    rp_vm_info = nutanix.get_vm_recovery_point_info_v2(recovery_point_ext_id="af1070f7-c946-49da-9b17-e337e06e0a18",
        ext_id="85ac418e-c847-45ab-9816-40a3c4de148c")
    ```


    :param Sequence[Union['GetVmRecoveryPointInfoV2DiskRecoveryPointArgs', 'GetVmRecoveryPointInfoV2DiskRecoveryPointArgsDict']] disk_recovery_points: array of disk recovery points.
    :param _builtins.str ext_id: The external identifier that can be used to identify a VM recovery point.
    :param _builtins.str recovery_point_ext_id: The external identifier that can be used to retrieve the recovery point using its URL.
    """
    __args__ = dict()
    __args__['diskRecoveryPoints'] = disk_recovery_points
    __args__['extId'] = ext_id
    __args__['recoveryPointExtId'] = recovery_point_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVmRecoveryPointInfoV2:getVmRecoveryPointInfoV2', __args__, opts=opts, typ=GetVmRecoveryPointInfoV2Result).value

    return AwaitableGetVmRecoveryPointInfoV2Result(
        application_consistent_properties=pulumi.get(__ret__, 'application_consistent_properties'),
        consistency_group_ext_id=pulumi.get(__ret__, 'consistency_group_ext_id'),
        disk_recovery_points=pulumi.get(__ret__, 'disk_recovery_points'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        location_agnostic_id=pulumi.get(__ret__, 'location_agnostic_id'),
        recovery_point_ext_id=pulumi.get(__ret__, 'recovery_point_ext_id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vm_categories=pulumi.get(__ret__, 'vm_categories'),
        vm_ext_id=pulumi.get(__ret__, 'vm_ext_id'))
def get_vm_recovery_point_info_v2_output(disk_recovery_points: Optional[pulumi.Input[Optional[Sequence[Union['GetVmRecoveryPointInfoV2DiskRecoveryPointArgs', 'GetVmRecoveryPointInfoV2DiskRecoveryPointArgsDict']]]]] = None,
                                         ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         recovery_point_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmRecoveryPointInfoV2Result]:
    """
    Get the VM recovery point identified by ex_id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # vm recovery point details
    rp_vm_info = nutanix.get_vm_recovery_point_info_v2(recovery_point_ext_id="af1070f7-c946-49da-9b17-e337e06e0a18",
        ext_id="85ac418e-c847-45ab-9816-40a3c4de148c")
    ```


    :param Sequence[Union['GetVmRecoveryPointInfoV2DiskRecoveryPointArgs', 'GetVmRecoveryPointInfoV2DiskRecoveryPointArgsDict']] disk_recovery_points: array of disk recovery points.
    :param _builtins.str ext_id: The external identifier that can be used to identify a VM recovery point.
    :param _builtins.str recovery_point_ext_id: The external identifier that can be used to retrieve the recovery point using its URL.
    """
    __args__ = dict()
    __args__['diskRecoveryPoints'] = disk_recovery_points
    __args__['extId'] = ext_id
    __args__['recoveryPointExtId'] = recovery_point_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVmRecoveryPointInfoV2:getVmRecoveryPointInfoV2', __args__, opts=opts, typ=GetVmRecoveryPointInfoV2Result)
    return __ret__.apply(lambda __response__: GetVmRecoveryPointInfoV2Result(
        application_consistent_properties=pulumi.get(__response__, 'application_consistent_properties'),
        consistency_group_ext_id=pulumi.get(__response__, 'consistency_group_ext_id'),
        disk_recovery_points=pulumi.get(__response__, 'disk_recovery_points'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        location_agnostic_id=pulumi.get(__response__, 'location_agnostic_id'),
        recovery_point_ext_id=pulumi.get(__response__, 'recovery_point_ext_id'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vm_categories=pulumi.get(__response__, 'vm_categories'),
        vm_ext_id=pulumi.get(__response__, 'vm_ext_id')))
