# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVolumeGroupDiskV2Result',
    'AwaitableGetVolumeGroupDiskV2Result',
    'get_volume_group_disk_v2',
    'get_volume_group_disk_v2_output',
]

@pulumi.output_type
class GetVolumeGroupDiskV2Result:
    """
    A collection of values returned by getVolumeGroupDiskV2.
    """
    def __init__(__self__, description=None, disk_data_source_references=None, disk_size_bytes=None, disk_storage_features=None, ext_id=None, id=None, index=None, links=None, storage_container_id=None, tenant_id=None, volume_group_ext_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_data_source_references and not isinstance(disk_data_source_references, list):
            raise TypeError("Expected argument 'disk_data_source_references' to be a list")
        pulumi.set(__self__, "disk_data_source_references", disk_data_source_references)
        if disk_size_bytes and not isinstance(disk_size_bytes, int):
            raise TypeError("Expected argument 'disk_size_bytes' to be a int")
        pulumi.set(__self__, "disk_size_bytes", disk_size_bytes)
        if disk_storage_features and not isinstance(disk_storage_features, list):
            raise TypeError("Expected argument 'disk_storage_features' to be a list")
        pulumi.set(__self__, "disk_storage_features", disk_storage_features)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index and not isinstance(index, int):
            raise TypeError("Expected argument 'index' to be a int")
        pulumi.set(__self__, "index", index)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if storage_container_id and not isinstance(storage_container_id, str):
            raise TypeError("Expected argument 'storage_container_id' to be a str")
        pulumi.set(__self__, "storage_container_id", storage_container_id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if volume_group_ext_id and not isinstance(volume_group_ext_id, str):
            raise TypeError("Expected argument 'volume_group_ext_id' to be a str")
        pulumi.set(__self__, "volume_group_ext_id", volume_group_ext_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - Volume Disk description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskDataSourceReferences")
    def disk_data_source_references(self) -> Sequence['outputs.GetVolumeGroupDiskV2DiskDataSourceReferenceResult']:
        """
        - Disk Data Source Reference.
        """
        return pulumi.get(self, "disk_data_source_references")

    @_builtins.property
    @pulumi.getter(name="diskSizeBytes")
    def disk_size_bytes(self) -> _builtins.int:
        """
        - ize of the disk in bytes. This field is mandatory during Volume Group creation if a new disk is being created on the storage container.
        """
        return pulumi.get(self, "disk_size_bytes")

    @_builtins.property
    @pulumi.getter(name="diskStorageFeatures")
    def disk_storage_features(self) -> Sequence['outputs.GetVolumeGroupDiskV2DiskStorageFeatureResult']:
        """
        - Storage optimization features which must be enabled on the Volume Disks. This is an optional field. If omitted, the disks will honor the Volume Group specific storage features setting.
        """
        return pulumi.get(self, "disk_storage_features")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - The external identifier of the Data Source Reference.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.int:
        """
        - Index of the disk in a Volume Group. This field is optional and immutable.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetVolumeGroupDiskV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> _builtins.str:
        """
        - Storage container on which the disk must be created. This is a read-only field.
        """
        return pulumi.get(self, "storage_container_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="volumeGroupExtId")
    def volume_group_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "volume_group_ext_id")


class AwaitableGetVolumeGroupDiskV2Result(GetVolumeGroupDiskV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupDiskV2Result(
            description=self.description,
            disk_data_source_references=self.disk_data_source_references,
            disk_size_bytes=self.disk_size_bytes,
            disk_storage_features=self.disk_storage_features,
            ext_id=self.ext_id,
            id=self.id,
            index=self.index,
            links=self.links,
            storage_container_id=self.storage_container_id,
            tenant_id=self.tenant_id,
            volume_group_ext_id=self.volume_group_ext_id)


def get_volume_group_disk_v2(ext_id: Optional[_builtins.str] = None,
                             volume_group_ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupDiskV2Result:
    """
    Describes a Query the Volume Disk identified by {extId} in the Volume Group identified by {volumeGroupExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get the details of a Volume Disk attached to the Volume Group.
    example = nutanix.get_volume_group_disk_v2(volume_group_ext_id="3770be9d-06be-4e25-b85d-3457d9b0ceb1",
        ext_id="1d92110d-26b5-46c0-8c93-20b8171373e0")
    ```


    :param _builtins.str ext_id: - The external identifier of the Data Source Reference.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['volumeGroupExtId'] = volume_group_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVolumeGroupDiskV2:getVolumeGroupDiskV2', __args__, opts=opts, typ=GetVolumeGroupDiskV2Result).value

    return AwaitableGetVolumeGroupDiskV2Result(
        description=pulumi.get(__ret__, 'description'),
        disk_data_source_references=pulumi.get(__ret__, 'disk_data_source_references'),
        disk_size_bytes=pulumi.get(__ret__, 'disk_size_bytes'),
        disk_storage_features=pulumi.get(__ret__, 'disk_storage_features'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        index=pulumi.get(__ret__, 'index'),
        links=pulumi.get(__ret__, 'links'),
        storage_container_id=pulumi.get(__ret__, 'storage_container_id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        volume_group_ext_id=pulumi.get(__ret__, 'volume_group_ext_id'))
def get_volume_group_disk_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    volume_group_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeGroupDiskV2Result]:
    """
    Describes a Query the Volume Disk identified by {extId} in the Volume Group identified by {volumeGroupExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get the details of a Volume Disk attached to the Volume Group.
    example = nutanix.get_volume_group_disk_v2(volume_group_ext_id="3770be9d-06be-4e25-b85d-3457d9b0ceb1",
        ext_id="1d92110d-26b5-46c0-8c93-20b8171373e0")
    ```


    :param _builtins.str ext_id: - The external identifier of the Data Source Reference.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['volumeGroupExtId'] = volume_group_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVolumeGroupDiskV2:getVolumeGroupDiskV2', __args__, opts=opts, typ=GetVolumeGroupDiskV2Result)
    return __ret__.apply(lambda __response__: GetVolumeGroupDiskV2Result(
        description=pulumi.get(__response__, 'description'),
        disk_data_source_references=pulumi.get(__response__, 'disk_data_source_references'),
        disk_size_bytes=pulumi.get(__response__, 'disk_size_bytes'),
        disk_storage_features=pulumi.get(__response__, 'disk_storage_features'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        index=pulumi.get(__response__, 'index'),
        links=pulumi.get(__response__, 'links'),
        storage_container_id=pulumi.get(__response__, 'storage_container_id'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        volume_group_ext_id=pulumi.get(__response__, 'volume_group_ext_id')))
