# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVolumeGroupV2Result',
    'AwaitableGetVolumeGroupV2Result',
    'get_volume_group_v2',
    'get_volume_group_v2_output',
]

@pulumi.output_type
class GetVolumeGroupV2Result:
    """
    A collection of values returned by getVolumeGroupV2.
    """
    def __init__(__self__, cluster_reference=None, created_by=None, description=None, enabled_authentications=None, ext_id=None, id=None, is_hidden=None, iscsi_features=None, links=None, name=None, sharing_status=None, should_load_balance_vm_attachments=None, storage_features=None, target_name=None, tenant_id=None, usage_type=None):
        if cluster_reference and not isinstance(cluster_reference, str):
            raise TypeError("Expected argument 'cluster_reference' to be a str")
        pulumi.set(__self__, "cluster_reference", cluster_reference)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled_authentications and not isinstance(enabled_authentications, str):
            raise TypeError("Expected argument 'enabled_authentications' to be a str")
        pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_hidden and not isinstance(is_hidden, bool):
            raise TypeError("Expected argument 'is_hidden' to be a bool")
        pulumi.set(__self__, "is_hidden", is_hidden)
        if iscsi_features and not isinstance(iscsi_features, list):
            raise TypeError("Expected argument 'iscsi_features' to be a list")
        pulumi.set(__self__, "iscsi_features", iscsi_features)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sharing_status and not isinstance(sharing_status, str):
            raise TypeError("Expected argument 'sharing_status' to be a str")
        pulumi.set(__self__, "sharing_status", sharing_status)
        if should_load_balance_vm_attachments and not isinstance(should_load_balance_vm_attachments, bool):
            raise TypeError("Expected argument 'should_load_balance_vm_attachments' to be a bool")
        pulumi.set(__self__, "should_load_balance_vm_attachments", should_load_balance_vm_attachments)
        if storage_features and not isinstance(storage_features, list):
            raise TypeError("Expected argument 'storage_features' to be a list")
        pulumi.set(__self__, "storage_features", storage_features)
        if target_name and not isinstance(target_name, str):
            raise TypeError("Expected argument 'target_name' to be a str")
        pulumi.set(__self__, "target_name", target_name)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if usage_type and not isinstance(usage_type, str):
            raise TypeError("Expected argument 'usage_type' to be a str")
        pulumi.set(__self__, "usage_type", usage_type)

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> _builtins.str:
        """
        - The UUID of the cluster that will host the Volume Group.
        """
        return pulumi.get(self, "cluster_reference")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        - Service/user who created this Volume Group.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - Volume Group description. This is an optional field.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> _builtins.str:
        """
        - The authentication type enabled for the Volume Group.
        """
        return pulumi.get(self, "enabled_authentications")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> _builtins.bool:
        """
        - Indicates whether the Volume Group is meant to be hidden or not.
        """
        return pulumi.get(self, "is_hidden")

    @_builtins.property
    @pulumi.getter(name="iscsiFeatures")
    def iscsi_features(self) -> Sequence['outputs.GetVolumeGroupV2IscsiFeatureResult']:
        """
        - iSCSI specific settings for the Volume Group.
        """
        return pulumi.get(self, "iscsi_features")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetVolumeGroupV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        -(Required) Volume Group name. This is an optional field.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sharingStatus")
    def sharing_status(self) -> _builtins.str:
        """
        - Indicates whether the Volume Group can be shared across multiple iSCSI initiators. The mode cannot be changed from SHARED to NOT_SHARED on a Volume Group with multiple attachments. Similarly, a Volume Group cannot be associated with more than one attachment as long as it is in exclusive mode. This is an optional field. Valid values are SHARED, NOT_SHARED
        """
        return pulumi.get(self, "sharing_status")

    @_builtins.property
    @pulumi.getter(name="shouldLoadBalanceVmAttachments")
    def should_load_balance_vm_attachments(self) -> _builtins.bool:
        """
        - Indicates whether to enable Volume Group load balancing for VM attachments. This cannot be enabled if there are iSCSI client attachments already associated with the Volume Group, and vice-versa. This is an optional field.
        """
        return pulumi.get(self, "should_load_balance_vm_attachments")

    @_builtins.property
    @pulumi.getter(name="storageFeatures")
    def storage_features(self) -> Sequence['outputs.GetVolumeGroupV2StorageFeatureResult']:
        """
        - Storage optimization features which must be enabled on the Volume Group.
        """
        return pulumi.get(self, "storage_features")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> _builtins.str:
        """
        - Name of the external client target that will be visible and accessible to the client.
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> _builtins.str:
        """
        - Expected usage type for the Volume Group. This is an indicative hint on how the caller will consume the Volume Group.  Valid values are BACKUP_TARGET, INTERNAL, TEMPORARY, USER
        """
        return pulumi.get(self, "usage_type")


class AwaitableGetVolumeGroupV2Result(GetVolumeGroupV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupV2Result(
            cluster_reference=self.cluster_reference,
            created_by=self.created_by,
            description=self.description,
            enabled_authentications=self.enabled_authentications,
            ext_id=self.ext_id,
            id=self.id,
            is_hidden=self.is_hidden,
            iscsi_features=self.iscsi_features,
            links=self.links,
            name=self.name,
            sharing_status=self.sharing_status,
            should_load_balance_vm_attachments=self.should_load_balance_vm_attachments,
            storage_features=self.storage_features,
            target_name=self.target_name,
            tenant_id=self.tenant_id,
            usage_type=self.usage_type)


def get_volume_group_v2(ext_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupV2Result:
    """
    Query the Volume Group identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    volume_group = nutanix.get_volume_group_v2(ext_id="d09aeec9-5bb7-4bfd-9717-a051178f6e7c")
    ```


    :param _builtins.str ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVolumeGroupV2:getVolumeGroupV2', __args__, opts=opts, typ=GetVolumeGroupV2Result).value

    return AwaitableGetVolumeGroupV2Result(
        cluster_reference=pulumi.get(__ret__, 'cluster_reference'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        enabled_authentications=pulumi.get(__ret__, 'enabled_authentications'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        is_hidden=pulumi.get(__ret__, 'is_hidden'),
        iscsi_features=pulumi.get(__ret__, 'iscsi_features'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        sharing_status=pulumi.get(__ret__, 'sharing_status'),
        should_load_balance_vm_attachments=pulumi.get(__ret__, 'should_load_balance_vm_attachments'),
        storage_features=pulumi.get(__ret__, 'storage_features'),
        target_name=pulumi.get(__ret__, 'target_name'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        usage_type=pulumi.get(__ret__, 'usage_type'))
def get_volume_group_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeGroupV2Result]:
    """
    Query the Volume Group identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    volume_group = nutanix.get_volume_group_v2(ext_id="d09aeec9-5bb7-4bfd-9717-a051178f6e7c")
    ```


    :param _builtins.str ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVolumeGroupV2:getVolumeGroupV2', __args__, opts=opts, typ=GetVolumeGroupV2Result)
    return __ret__.apply(lambda __response__: GetVolumeGroupV2Result(
        cluster_reference=pulumi.get(__response__, 'cluster_reference'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        enabled_authentications=pulumi.get(__response__, 'enabled_authentications'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        is_hidden=pulumi.get(__response__, 'is_hidden'),
        iscsi_features=pulumi.get(__response__, 'iscsi_features'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        sharing_status=pulumi.get(__response__, 'sharing_status'),
        should_load_balance_vm_attachments=pulumi.get(__response__, 'should_load_balance_vm_attachments'),
        storage_features=pulumi.get(__response__, 'storage_features'),
        target_name=pulumi.get(__response__, 'target_name'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        usage_type=pulumi.get(__response__, 'usage_type')))
