# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeIscsiClientV2Result',
    'AwaitableGetVolumeIscsiClientV2Result',
    'get_volume_iscsi_client_v2',
    'get_volume_iscsi_client_v2_output',
]

@pulumi.output_type
class GetVolumeIscsiClientV2Result:
    """
    A collection of values returned by getVolumeIscsiClientV2.
    """
    def __init__(__self__, attached_targets=None, attachment_site=None, cluster_reference=None, enabled_authentications=None, ext_id=None, id=None, iscsi_initiator_name=None, iscsi_initiator_network_ids=None, links=None, tenant_id=None):
        if attached_targets and not isinstance(attached_targets, list):
            raise TypeError("Expected argument 'attached_targets' to be a list")
        pulumi.set(__self__, "attached_targets", attached_targets)
        if attachment_site and not isinstance(attachment_site, str):
            raise TypeError("Expected argument 'attachment_site' to be a str")
        pulumi.set(__self__, "attachment_site", attachment_site)
        if cluster_reference and not isinstance(cluster_reference, str):
            raise TypeError("Expected argument 'cluster_reference' to be a str")
        pulumi.set(__self__, "cluster_reference", cluster_reference)
        if enabled_authentications and not isinstance(enabled_authentications, str):
            raise TypeError("Expected argument 'enabled_authentications' to be a str")
        pulumi.set(__self__, "enabled_authentications", enabled_authentications)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iscsi_initiator_name and not isinstance(iscsi_initiator_name, str):
            raise TypeError("Expected argument 'iscsi_initiator_name' to be a str")
        pulumi.set(__self__, "iscsi_initiator_name", iscsi_initiator_name)
        if iscsi_initiator_network_ids and not isinstance(iscsi_initiator_network_ids, list):
            raise TypeError("Expected argument 'iscsi_initiator_network_ids' to be a list")
        pulumi.set(__self__, "iscsi_initiator_network_ids", iscsi_initiator_network_ids)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="attachedTargets")
    def attached_targets(self) -> Sequence['outputs.GetVolumeIscsiClientV2AttachedTargetResult']:
        return pulumi.get(self, "attached_targets")

    @_builtins.property
    @pulumi.getter(name="attachmentSite")
    def attachment_site(self) -> _builtins.str:
        """
        -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.
        """
        return pulumi.get(self, "attachment_site")

    @_builtins.property
    @pulumi.getter(name="clusterReference")
    def cluster_reference(self) -> _builtins.str:
        return pulumi.get(self, "cluster_reference")

    @_builtins.property
    @pulumi.getter(name="enabledAuthentications")
    def enabled_authentications(self) -> _builtins.str:
        """
        -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
        """
        return pulumi.get(self, "enabled_authentications")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorName")
    def iscsi_initiator_name(self) -> _builtins.str:
        """
        -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
        """
        return pulumi.get(self, "iscsi_initiator_name")

    @_builtins.property
    @pulumi.getter(name="iscsiInitiatorNetworkIds")
    def iscsi_initiator_network_ids(self) -> Optional[Sequence['outputs.GetVolumeIscsiClientV2IscsiInitiatorNetworkIdResult']]:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
        """
        return pulumi.get(self, "iscsi_initiator_network_ids")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetVolumeIscsiClientV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetVolumeIscsiClientV2Result(GetVolumeIscsiClientV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeIscsiClientV2Result(
            attached_targets=self.attached_targets,
            attachment_site=self.attachment_site,
            cluster_reference=self.cluster_reference,
            enabled_authentications=self.enabled_authentications,
            ext_id=self.ext_id,
            id=self.id,
            iscsi_initiator_name=self.iscsi_initiator_name,
            iscsi_initiator_network_ids=self.iscsi_initiator_network_ids,
            links=self.links,
            tenant_id=self.tenant_id)


def get_volume_iscsi_client_v2(ext_id: Optional[_builtins.str] = None,
                               iscsi_initiator_network_ids: Optional[Sequence[Union['GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgs', 'GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeIscsiClientV2Result:
    """
    Fetches the iSCSI client details identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_volume_iscsi_client_v2(ext_id="be0e4630-23da-4b9c-a76b-f24fd64b46b6")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `ext_id`: -(Required) A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.


    :param _builtins.str ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
    :param Sequence[Union['GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgs', 'GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgsDict']] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['iscsiInitiatorNetworkIds'] = iscsi_initiator_network_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVolumeIscsiClientV2:getVolumeIscsiClientV2', __args__, opts=opts, typ=GetVolumeIscsiClientV2Result).value

    return AwaitableGetVolumeIscsiClientV2Result(
        attached_targets=pulumi.get(__ret__, 'attached_targets'),
        attachment_site=pulumi.get(__ret__, 'attachment_site'),
        cluster_reference=pulumi.get(__ret__, 'cluster_reference'),
        enabled_authentications=pulumi.get(__ret__, 'enabled_authentications'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        iscsi_initiator_name=pulumi.get(__ret__, 'iscsi_initiator_name'),
        iscsi_initiator_network_ids=pulumi.get(__ret__, 'iscsi_initiator_network_ids'),
        links=pulumi.get(__ret__, 'links'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_volume_iscsi_client_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      iscsi_initiator_network_ids: Optional[pulumi.Input[Optional[Sequence[Union['GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgs', 'GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgsDict']]]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeIscsiClientV2Result]:
    """
    Fetches the iSCSI client details identified by {extId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_volume_iscsi_client_v2(ext_id="be0e4630-23da-4b9c-a76b-f24fd64b46b6")
    ```

    ## Argument Reference

    The following arguments are supported:

    * `ext_id`: -(Required) A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.


    :param _builtins.str ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
    :param Sequence[Union['GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgs', 'GetVolumeIscsiClientV2IscsiInitiatorNetworkIdArgsDict']] iscsi_initiator_network_ids: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['iscsiInitiatorNetworkIds'] = iscsi_initiator_network_ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVolumeIscsiClientV2:getVolumeIscsiClientV2', __args__, opts=opts, typ=GetVolumeIscsiClientV2Result)
    return __ret__.apply(lambda __response__: GetVolumeIscsiClientV2Result(
        attached_targets=pulumi.get(__response__, 'attached_targets'),
        attachment_site=pulumi.get(__response__, 'attachment_site'),
        cluster_reference=pulumi.get(__response__, 'cluster_reference'),
        enabled_authentications=pulumi.get(__response__, 'enabled_authentications'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        iscsi_initiator_name=pulumi.get(__response__, 'iscsi_initiator_name'),
        iscsi_initiator_network_ids=pulumi.get(__response__, 'iscsi_initiator_network_ids'),
        links=pulumi.get(__response__, 'links'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
