# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVolumeIscsiClientsV2Result',
    'AwaitableGetVolumeIscsiClientsV2Result',
    'get_volume_iscsi_clients_v2',
    'get_volume_iscsi_clients_v2_output',
]

@pulumi.output_type
class GetVolumeIscsiClientsV2Result:
    """
    A collection of values returned by getVolumeIscsiClientsV2.
    """
    def __init__(__self__, expand=None, filter=None, id=None, iscsi_clients=None, limit=None, orderby=None, page=None, select=None):
        if expand and not isinstance(expand, str):
            raise TypeError("Expected argument 'expand' to be a str")
        pulumi.set(__self__, "expand", expand)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iscsi_clients and not isinstance(iscsi_clients, list):
            raise TypeError("Expected argument 'iscsi_clients' to be a list")
        pulumi.set(__self__, "iscsi_clients", iscsi_clients)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if orderby and not isinstance(orderby, str):
            raise TypeError("Expected argument 'orderby' to be a str")
        pulumi.set(__self__, "orderby", orderby)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def expand(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expand")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iscsiClients")
    def iscsi_clients(self) -> Sequence['outputs.GetVolumeIscsiClientsV2IscsiClientResult']:
        """
        - List all the iSCSI clients.
        """
        return pulumi.get(self, "iscsi_clients")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def orderby(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "orderby")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetVolumeIscsiClientsV2Result(GetVolumeIscsiClientsV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeIscsiClientsV2Result(
            expand=self.expand,
            filter=self.filter,
            id=self.id,
            iscsi_clients=self.iscsi_clients,
            limit=self.limit,
            orderby=self.orderby,
            page=self.page,
            select=self.select)


def get_volume_iscsi_clients_v2(expand: Optional[_builtins.str] = None,
                                filter: Optional[_builtins.str] = None,
                                limit: Optional[_builtins.int] = None,
                                orderby: Optional[_builtins.str] = None,
                                page: Optional[_builtins.int] = None,
                                select: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeIscsiClientsV2Result:
    """
    Fetches the list of iSCSI clients.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # List all the iSCSI clients.
    list_iscsi_clients = nutanix.get_volume_iscsi_clients_v2()
    # list iSCSI clients with a filter.
    list_iscsi_clients_filter = nutanix.get_volume_iscsi_clients_v2(filter="clusterReference eq '00057b8b-0b7b-4b7b-0000-000000000000'")
    # list iSCSI clients with a limit and pagination.
    list_iscsi_clients_limit = nutanix.get_volume_iscsi_clients_v2(page=2,
        limit=1)
    ```

    ## Argument Reference

    The following arguments are supported:

    * `page`: - A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.
    * `limit` : A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    * `filter` : A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
      - clusterReference
      - extId
    * `orderby` : A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
      - clusterReference
      - extId
    * `expand` : A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported. The expand can be applied to the following fields:
      - cluster
    * `select` : A query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., \\*), then all properties on the matching resource will be returned. The select can be applied to the following fields:
      - clusterReference
      - extId

    ## Iscsi Clients

    The `iscsi_clients` contains list of iSCSI clients. Each iSCSI client contains the following attributes:

    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `iscsi_initiator_name`: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
    * `iscsi_initiator_network_id`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    * `client_secret`: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
    * `enabled_authentications`: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
    * `num_virtual_targets`: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
    * `attachment_site`: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.

    #### Links

    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    #### iscsi initiator network id

    The iscsi_initiator_network_id attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    ##### IPV4

    The ipv4 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv4 address belongs.

    ##### IPV6

    The ipv6 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv6 address belongs.

    ##### FQDN

    The fqdn attribute supports the following:

    * `value`: - The fully qualified domain name.

    #### Attached Targets

    The attached_targets attribute supports the following:

    * `num_virtual_targets`: - Number of virtual targets generated for the iSCSI target. This field is immutable.
    * `iscsi_target_name`: - Name of the iSCSI target that the iSCSI client is connected to. This is a read-only field.

    See detailed information in [Nutanix List iSCSI Clients V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/IscsiClients/operation/listIscsiClients).
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderby'] = orderby
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVolumeIscsiClientsV2:getVolumeIscsiClientsV2', __args__, opts=opts, typ=GetVolumeIscsiClientsV2Result).value

    return AwaitableGetVolumeIscsiClientsV2Result(
        expand=pulumi.get(__ret__, 'expand'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        iscsi_clients=pulumi.get(__ret__, 'iscsi_clients'),
        limit=pulumi.get(__ret__, 'limit'),
        orderby=pulumi.get(__ret__, 'orderby'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'))
def get_volume_iscsi_clients_v2_output(expand: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       orderby: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeIscsiClientsV2Result]:
    """
    Fetches the list of iSCSI clients.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # List all the iSCSI clients.
    list_iscsi_clients = nutanix.get_volume_iscsi_clients_v2()
    # list iSCSI clients with a filter.
    list_iscsi_clients_filter = nutanix.get_volume_iscsi_clients_v2(filter="clusterReference eq '00057b8b-0b7b-4b7b-0000-000000000000'")
    # list iSCSI clients with a limit and pagination.
    list_iscsi_clients_limit = nutanix.get_volume_iscsi_clients_v2(page=2,
        limit=1)
    ```

    ## Argument Reference

    The following arguments are supported:

    * `page`: - A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.
    * `limit` : A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    * `filter` : A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
      - clusterReference
      - extId
    * `orderby` : A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
      - clusterReference
      - extId
    * `expand` : A URL query parameter that allows clients to request related resources when a resource that satisfies a particular request is retrieved. Each expanded item is evaluated relative to the entity containing the property being expanded. Other query options can be applied to an expanded property by appending a semicolon-separated list of query options, enclosed in parentheses, to the property name. Permissible system query options are \\$filter, \\$select and \\$orderby. The following expansion keys are supported. The expand can be applied to the following fields:
      - cluster
    * `select` : A query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., \\*), then all properties on the matching resource will be returned. The select can be applied to the following fields:
      - clusterReference
      - extId

    ## Iscsi Clients

    The `iscsi_clients` contains list of iSCSI clients. Each iSCSI client contains the following attributes:

    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `iscsi_initiator_name`: -iSCSI initiator name. During the attach operation, exactly one of iscsiInitiatorName and iscsiInitiatorNetworkId must be specified. This field is immutable.
    * `iscsi_initiator_network_id`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    * `client_secret`: -(Optional) iSCSI initiator client secret in case of CHAP authentication. This field should not be provided in case the authentication type is not set to CHAP.
    * `enabled_authentications`: -(Optional) (Optional) The authentication type enabled for the Volume Group. This is an optional field. If omitted, authentication is not configured for the Volume Group. If this is set to CHAP, the target/client secret must be provided. Valid values are CHAP, NONE
    * `num_virtual_targets`: -(Optional) Number of virtual targets generated for the iSCSI target. This field is immutable.
    * `attachment_site`: -(Optional) The site where the Volume Group attach operation should be processed. This is an optional field. This field may only be set if Metro DR has been configured for this Volume Group. Valid values are SECONDARY, PRIMARY.

    #### Links

    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    #### iscsi initiator network id

    The iscsi_initiator_network_id attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    ##### IPV4

    The ipv4 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv4 address belongs.

    ##### IPV6

    The ipv6 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv6 address belongs.

    ##### FQDN

    The fqdn attribute supports the following:

    * `value`: - The fully qualified domain name.

    #### Attached Targets

    The attached_targets attribute supports the following:

    * `num_virtual_targets`: - Number of virtual targets generated for the iSCSI target. This field is immutable.
    * `iscsi_target_name`: - Name of the iSCSI target that the iSCSI client is connected to. This is a read-only field.

    See detailed information in [Nutanix List iSCSI Clients V4](https://developers.nutanix.com/api-reference?namespace=volumes&version=v4.0#tag/IscsiClients/operation/listIscsiClients).
    """
    __args__ = dict()
    __args__['expand'] = expand
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderby'] = orderby
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVolumeIscsiClientsV2:getVolumeIscsiClientsV2', __args__, opts=opts, typ=GetVolumeIscsiClientsV2Result)
    return __ret__.apply(lambda __response__: GetVolumeIscsiClientsV2Result(
        expand=pulumi.get(__response__, 'expand'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        iscsi_clients=pulumi.get(__response__, 'iscsi_clients'),
        limit=pulumi.get(__response__, 'limit'),
        orderby=pulumi.get(__response__, 'orderby'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select')))
