# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVpcV2Result',
    'AwaitableGetVpcV2Result',
    'get_vpc_v2',
    'get_vpc_v2_output',
]

@pulumi.output_type
class GetVpcV2Result:
    """
    A collection of values returned by getVpcV2.
    """
    def __init__(__self__, common_dhcp_options=None, description=None, ext_id=None, external_routing_domain_reference=None, external_subnets=None, externally_routable_prefixes=None, id=None, links=None, metadatas=None, name=None, snat_ips=None, tenant_id=None, vpc_type=None):
        if common_dhcp_options and not isinstance(common_dhcp_options, list):
            raise TypeError("Expected argument 'common_dhcp_options' to be a list")
        pulumi.set(__self__, "common_dhcp_options", common_dhcp_options)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if external_routing_domain_reference and not isinstance(external_routing_domain_reference, str):
            raise TypeError("Expected argument 'external_routing_domain_reference' to be a str")
        pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if external_subnets and not isinstance(external_subnets, list):
            raise TypeError("Expected argument 'external_subnets' to be a list")
        pulumi.set(__self__, "external_subnets", external_subnets)
        if externally_routable_prefixes and not isinstance(externally_routable_prefixes, list):
            raise TypeError("Expected argument 'externally_routable_prefixes' to be a list")
        pulumi.set(__self__, "externally_routable_prefixes", externally_routable_prefixes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snat_ips and not isinstance(snat_ips, list):
            raise TypeError("Expected argument 'snat_ips' to be a list")
        pulumi.set(__self__, "snat_ips", snat_ips)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_type and not isinstance(vpc_type, str):
            raise TypeError("Expected argument 'vpc_type' to be a str")
        pulumi.set(__self__, "vpc_type", vpc_type)

    @_builtins.property
    @pulumi.getter(name="commonDhcpOptions")
    def common_dhcp_options(self) -> Sequence['outputs.GetVpcV2CommonDhcpOptionResult']:
        """
        List of DHCP options to be configured.
        """
        return pulumi.get(self, "common_dhcp_options")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the VPC.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> _builtins.str:
        """
        External routing domain associated with this route table
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @_builtins.property
    @pulumi.getter(name="externalSubnets")
    def external_subnets(self) -> Sequence['outputs.GetVpcV2ExternalSubnetResult']:
        """
        List of external subnets that the VPC is attached to.
        """
        return pulumi.get(self, "external_subnets")

    @_builtins.property
    @pulumi.getter(name="externallyRoutablePrefixes")
    def externally_routable_prefixes(self) -> Sequence['outputs.GetVpcV2ExternallyRoutablePrefixResult']:
        """
        CIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        """
        return pulumi.get(self, "externally_routable_prefixes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetVpcV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetVpcV2MetadataResult']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the VPC.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> Sequence['outputs.GetVpcV2SnatIpResult']:
        """
        List of IP Addresses used for SNAT.
        """
        return pulumi.get(self, "snat_ips")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcType")
    def vpc_type(self) -> _builtins.str:
        """
        Type of VPC.
        """
        return pulumi.get(self, "vpc_type")


class AwaitableGetVpcV2Result(GetVpcV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcV2Result(
            common_dhcp_options=self.common_dhcp_options,
            description=self.description,
            ext_id=self.ext_id,
            external_routing_domain_reference=self.external_routing_domain_reference,
            external_subnets=self.external_subnets,
            externally_routable_prefixes=self.externally_routable_prefixes,
            id=self.id,
            links=self.links,
            metadatas=self.metadatas,
            name=self.name,
            snat_ips=self.snat_ips,
            tenant_id=self.tenant_id,
            vpc_type=self.vpc_type)


def get_vpc_v2(ext_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcV2Result:
    """
    Provides a datasource to retrieve VPC with vpc_uuid .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_vpc = nutanix.get_vpc_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: vpc UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getVpcV2:getVpcV2', __args__, opts=opts, typ=GetVpcV2Result).value

    return AwaitableGetVpcV2Result(
        common_dhcp_options=pulumi.get(__ret__, 'common_dhcp_options'),
        description=pulumi.get(__ret__, 'description'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__ret__, 'external_routing_domain_reference'),
        external_subnets=pulumi.get(__ret__, 'external_subnets'),
        externally_routable_prefixes=pulumi.get(__ret__, 'externally_routable_prefixes'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        snat_ips=pulumi.get(__ret__, 'snat_ips'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vpc_type=pulumi.get(__ret__, 'vpc_type'))
def get_vpc_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcV2Result]:
    """
    Provides a datasource to retrieve VPC with vpc_uuid .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_vpc = nutanix.get_vpc_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: vpc UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getVpcV2:getVpcV2', __args__, opts=opts, typ=GetVpcV2Result)
    return __ret__.apply(lambda __response__: GetVpcV2Result(
        common_dhcp_options=pulumi.get(__response__, 'common_dhcp_options'),
        description=pulumi.get(__response__, 'description'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__response__, 'external_routing_domain_reference'),
        external_subnets=pulumi.get(__response__, 'external_subnets'),
        externally_routable_prefixes=pulumi.get(__response__, 'externally_routable_prefixes'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        snat_ips=pulumi.get(__response__, 'snat_ips'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vpc_type=pulumi.get(__response__, 'vpc_type')))
