# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]] = None,
                 checksum: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_references: Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]] = None,
                 data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] architecture: - (Optional) The supported CPU architecture for a disk image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]] categories: - (Optional) Categories for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] checksum: - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        :param pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]] data_source_references: Reference to a data source.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for image.
        :param pulumi.Input[_builtins.str] image_type: - (Optional) The type of image.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] source_path: - (Optional) A local path to upload an image.
        :param pulumi.Input[_builtins.str] source_uri: - (Optional) The source URI points at the location of the source image which is used to create/update image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] version: - (Optional) The image version.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if cluster_references is not None:
            pulumi.set(__self__, "cluster_references", cluster_references)
        if data_source_references is not None:
            pulumi.set(__self__, "data_source_references", data_source_references)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The supported CPU architecture for a disk image.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]]:
        """
        - (Optional) Categories for the image.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter(name="clusterReferences")
    def cluster_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]]:
        return pulumi.get(self, "cluster_references")

    @cluster_references.setter
    def cluster_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]]):
        pulumi.set(self, "cluster_references", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceReferences")
    def data_source_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]]:
        """
        Reference to a data source.
        """
        return pulumi.get(self, "data_source_references")

    @data_source_references.setter
    def data_source_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]]):
        pulumi.set(self, "data_source_references", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The type of image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A local path to upload an image.
        """
        return pulumi.get(self, "source_path")

    @source_path.setter
    def source_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_path", value)

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The source URI points at the location of the source image which is used to create/update image.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uri", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The image version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]] = None,
                 checksum: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_references: Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]] = None,
                 cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 current_cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCurrentClusterReferenceListArgs']]]] = None,
                 data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 retrieval_uri_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 source_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] architecture: - (Optional) The supported CPU architecture for a disk image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]] categories: - (Optional) Categories for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] checksum: - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        :param pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]] data_source_references: Reference to a data source.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for image.
        :param pulumi.Input[_builtins.str] image_type: - (Optional) The type of image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The image kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retrieval_uri_lists: - List of URIs where the raw image data can be accessed.
        :param pulumi.Input[_builtins.int] size_bytes: - The size of the image in bytes.
        :param pulumi.Input[_builtins.str] source_path: - (Optional) A local path to upload an image.
        :param pulumi.Input[_builtins.str] source_uri: - (Optional) The source URI points at the location of the source image which is used to create/update image.
        :param pulumi.Input[_builtins.str] state: - The state of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] version: - (Optional) The image version.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if availability_zone_reference is not None:
            pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_references is not None:
            pulumi.set(__self__, "cluster_references", cluster_references)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if current_cluster_reference_lists is not None:
            pulumi.set(__self__, "current_cluster_reference_lists", current_cluster_reference_lists)
        if data_source_references is not None:
            pulumi.set(__self__, "data_source_references", data_source_references)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_reference is not None:
            pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference is not None:
            pulumi.set(__self__, "project_reference", project_reference)
        if retrieval_uri_lists is not None:
            pulumi.set(__self__, "retrieval_uri_lists", retrieval_uri_lists)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The supported CPU architecture for a disk image.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @availability_zone_reference.setter
    def availability_zone_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zone_reference", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]]:
        """
        - (Optional) Categories for the image.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterReferences")
    def cluster_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]]:
        return pulumi.get(self, "cluster_references")

    @cluster_references.setter
    def cluster_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageClusterReferenceArgs']]]]):
        pulumi.set(self, "cluster_references", value)

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="currentClusterReferenceLists")
    def current_cluster_reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageCurrentClusterReferenceListArgs']]]]:
        return pulumi.get(self, "current_cluster_reference_lists")

    @current_cluster_reference_lists.setter
    def current_cluster_reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageCurrentClusterReferenceListArgs']]]]):
        pulumi.set(self, "current_cluster_reference_lists", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceReferences")
    def data_source_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]]:
        """
        Reference to a data source.
        """
        return pulumi.get(self, "data_source_references")

    @data_source_references.setter
    def data_source_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDataSourceReferenceArgs']]]]):
        pulumi.set(self, "data_source_references", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A description for image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The type of image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - The image kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @owner_reference.setter
    def owner_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owner_reference", value)

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @project_reference.setter
    def project_reference(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_reference", value)

    @_builtins.property
    @pulumi.getter(name="retrievalUriLists")
    def retrieval_uri_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - List of URIs where the raw image data can be accessed.
        """
        return pulumi.get(self, "retrieval_uri_lists")

    @retrieval_uri_lists.setter
    def retrieval_uri_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retrieval_uri_lists", value)

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_bytes", value)

    @_builtins.property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) A local path to upload an image.
        """
        return pulumi.get(self, "source_path")

    @source_path.setter
    def source_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_path", value)

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) The source URI points at the location of the source image which is used to create/update image.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uri", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The state of the image.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        - (Optional) The image version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("nutanix:index/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageCategoryArgs', 'ImageCategoryArgsDict']]]]] = None,
                 checksum: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageClusterReferenceArgs', 'ImageClusterReferenceArgsDict']]]]] = None,
                 data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDataSourceReferenceArgs', 'ImageDataSourceReferenceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Nutanix Image resource to Create a image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.Image("test",
            name="Ubuntu",
            description="Ubuntu",
            source_uri="http://archive.ubuntu.com/ubuntu/dists/bionic/main/installer-amd64/current/images/netboot/mini.iso")
        # Create image with data_source_reference
        create_image_with_data_source_reference = nutanix.Image("create_image_with_data_source_reference",
            name="Sql Server Image",
            description="Sql Server",
            image_type="DISK_IMAGE",
            data_source_references=[{
                "kind": "vm_disk",
                "uuid": "<uuid of the vm disk>",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: - (Optional) The supported CPU architecture for a disk image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageCategoryArgs', 'ImageCategoryArgsDict']]]] categories: - (Optional) Categories for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] checksum: - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageDataSourceReferenceArgs', 'ImageDataSourceReferenceArgsDict']]]] data_source_references: Reference to a data source.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for image.
        :param pulumi.Input[_builtins.str] image_type: - (Optional) The type of image.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[_builtins.str] source_path: - (Optional) A local path to upload an image.
        :param pulumi.Input[_builtins.str] source_uri: - (Optional) The source URI points at the location of the source image which is used to create/update image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] version: - (Optional) The image version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Image resource to Create a image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        test = nutanix.Image("test",
            name="Ubuntu",
            description="Ubuntu",
            source_uri="http://archive.ubuntu.com/ubuntu/dists/bionic/main/installer-amd64/current/images/netboot/mini.iso")
        # Create image with data_source_reference
        create_image_with_data_source_reference = nutanix.Image("create_image_with_data_source_reference",
            name="Sql Server Image",
            description="Sql Server",
            image_type="DISK_IMAGE",
            data_source_references=[{
                "kind": "vm_disk",
                "uuid": "<uuid of the vm disk>",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageCategoryArgs', 'ImageCategoryArgsDict']]]]] = None,
                 checksum: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageClusterReferenceArgs', 'ImageClusterReferenceArgsDict']]]]] = None,
                 data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDataSourceReferenceArgs', 'ImageDataSourceReferenceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["availability_zone_reference"] = availability_zone_reference
            __props__.__dict__["categories"] = categories
            __props__.__dict__["checksum"] = checksum
            __props__.__dict__["cluster_references"] = cluster_references
            __props__.__dict__["data_source_references"] = data_source_references
            __props__.__dict__["description"] = description
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_reference"] = owner_reference
            __props__.__dict__["project_reference"] = project_reference
            __props__.__dict__["source_path"] = source_path
            __props__.__dict__["source_uri"] = source_uri
            __props__.__dict__["version"] = version
            __props__.__dict__["api_version"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["cluster_uuid"] = None
            __props__.__dict__["current_cluster_reference_lists"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["retrieval_uri_lists"] = None
            __props__.__dict__["size_bytes"] = None
            __props__.__dict__["state"] = None
        super(Image, __self__).__init__(
            'nutanix:index/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageCategoryArgs', 'ImageCategoryArgsDict']]]]] = None,
            checksum: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageClusterReferenceArgs', 'ImageClusterReferenceArgsDict']]]]] = None,
            cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            current_cluster_reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageCurrentClusterReferenceListArgs', 'ImageCurrentClusterReferenceListArgsDict']]]]] = None,
            data_source_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDataSourceReferenceArgs', 'ImageDataSourceReferenceArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            image_type: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_reference: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            retrieval_uri_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            source_path: Optional[pulumi.Input[_builtins.str]] = None,
            source_uri: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.str] architecture: - (Optional) The supported CPU architecture for a disk image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] availability_zone_reference: - (Optional) The reference to a availability_zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageCategoryArgs', 'ImageCategoryArgsDict']]]] categories: - (Optional) Categories for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] checksum: - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageDataSourceReferenceArgs', 'ImageDataSourceReferenceArgsDict']]]] data_source_references: Reference to a data source.
        :param pulumi.Input[_builtins.str] description: - (Optional) A description for image.
        :param pulumi.Input[_builtins.str] image_type: - (Optional) The type of image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: - The image kind metadata.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] owner_reference: - (Optional) The reference to a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] project_reference: - (Optional) The reference to a project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retrieval_uri_lists: - List of URIs where the raw image data can be accessed.
        :param pulumi.Input[_builtins.int] size_bytes: - The size of the image in bytes.
        :param pulumi.Input[_builtins.str] source_path: - (Optional) A local path to upload an image.
        :param pulumi.Input[_builtins.str] source_uri: - (Optional) The source URI points at the location of the source image which is used to create/update image.
        :param pulumi.Input[_builtins.str] state: - The state of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] version: - (Optional) The image version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["availability_zone_reference"] = availability_zone_reference
        __props__.__dict__["categories"] = categories
        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_references"] = cluster_references
        __props__.__dict__["cluster_uuid"] = cluster_uuid
        __props__.__dict__["current_cluster_reference_lists"] = current_cluster_reference_lists
        __props__.__dict__["data_source_references"] = data_source_references
        __props__.__dict__["description"] = description
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_reference"] = owner_reference
        __props__.__dict__["project_reference"] = project_reference
        __props__.__dict__["retrieval_uri_lists"] = retrieval_uri_lists
        __props__.__dict__["size_bytes"] = size_bytes
        __props__.__dict__["source_path"] = source_path
        __props__.__dict__["source_uri"] = source_uri
        __props__.__dict__["state"] = state
        __props__.__dict__["version"] = version
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The supported CPU architecture for a disk image.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.ImageCategory']]:
        """
        - (Optional) Categories for the image.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterReferences")
    def cluster_references(self) -> pulumi.Output[Sequence['outputs.ImageClusterReference']]:
        return pulumi.get(self, "cluster_references")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="currentClusterReferenceLists")
    def current_cluster_reference_lists(self) -> pulumi.Output[Sequence['outputs.ImageCurrentClusterReferenceList']]:
        return pulumi.get(self, "current_cluster_reference_lists")

    @_builtins.property
    @pulumi.getter(name="dataSourceReferences")
    def data_source_references(self) -> pulumi.Output[Sequence['outputs.ImageDataSourceReference']]:
        """
        Reference to a data source.
        """
        return pulumi.get(self, "data_source_references")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) A description for image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The type of image.
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - The image kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name for the image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        - (Optional) The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="retrievalUriLists")
    def retrieval_uri_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - List of URIs where the raw image data can be accessed.
        """
        return pulumi.get(self, "retrieval_uri_lists")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        - The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")

    @_builtins.property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) A local path to upload an image.
        """
        return pulumi.get(self, "source_path")

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) The source URI points at the location of the source image which is used to create/update image.
        """
        return pulumi.get(self, "source_uri")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        - The state of the image.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        - (Optional) The image version.
        """
        return pulumi.get(self, "version")

