# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImagePlacementPolicyV2Args', 'ImagePlacementPolicyV2']

@pulumi.input_type
class ImagePlacementPolicyV2Args:
    def __init__(__self__, *,
                 cluster_entity_filters: pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]],
                 image_entity_filters: pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]],
                 placement_type: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 should_cancel_running_tasks: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ImagePlacementPolicyV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]] cluster_entity_filters: Category-based entity filter.
        :param pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]] image_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] placement_type: Type of the image placement policy. Valid values "HARD", "SOFT"
        :param pulumi.Input[_builtins.str] action: Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        :param pulumi.Input[_builtins.str] description: Description of the image placement policy.
        :param pulumi.Input[_builtins.str] enforcement_state: Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        :param pulumi.Input[_builtins.str] name: Name of the image placement policy.
        """
        pulumi.set(__self__, "cluster_entity_filters", cluster_entity_filters)
        pulumi.set(__self__, "image_entity_filters", image_entity_filters)
        pulumi.set(__self__, "placement_type", placement_type)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforcement_state is not None:
            pulumi.set(__self__, "enforcement_state", enforcement_state)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if should_cancel_running_tasks is not None:
            pulumi.set(__self__, "should_cancel_running_tasks", should_cancel_running_tasks)

    @_builtins.property
    @pulumi.getter(name="clusterEntityFilters")
    def cluster_entity_filters(self) -> pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "cluster_entity_filters")

    @cluster_entity_filters.setter
    def cluster_entity_filters(self, value: pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]]):
        pulumi.set(self, "cluster_entity_filters", value)

    @_builtins.property
    @pulumi.getter(name="imageEntityFilters")
    def image_entity_filters(self) -> pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "image_entity_filters")

    @image_entity_filters.setter
    def image_entity_filters(self, value: pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]]):
        pulumi.set(self, "image_entity_filters", value)

    @_builtins.property
    @pulumi.getter(name="placementType")
    def placement_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        return pulumi.get(self, "placement_type")

    @placement_type.setter
    def placement_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "placement_type", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the image placement policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforcementState")
    def enforcement_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        """
        return pulumi.get(self, "enforcement_state")

    @enforcement_state.setter
    def enforcement_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_state", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image placement policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="shouldCancelRunningTasks")
    def should_cancel_running_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "should_cancel_running_tasks")

    @should_cancel_running_tasks.setter
    def should_cancel_running_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_cancel_running_tasks", value)


@pulumi.input_type
class _ImagePlacementPolicyV2State:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]]] = None,
                 last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 should_cancel_running_tasks: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ImagePlacementPolicyV2 resources.
        :param pulumi.Input[_builtins.str] action: Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        :param pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]] cluster_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] description: Description of the image placement policy.
        :param pulumi.Input[_builtins.str] enforcement_state: Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        :param pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]] image_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] name: Name of the image placement policy.
        :param pulumi.Input[_builtins.str] placement_type: Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cluster_entity_filters is not None:
            pulumi.set(__self__, "cluster_entity_filters", cluster_entity_filters)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforcement_state is not None:
            pulumi.set(__self__, "enforcement_state", enforcement_state)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if image_entity_filters is not None:
            pulumi.set(__self__, "image_entity_filters", image_entity_filters)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_ext_id is not None:
            pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if placement_type is not None:
            pulumi.set(__self__, "placement_type", placement_type)
        if should_cancel_running_tasks is not None:
            pulumi.set(__self__, "should_cancel_running_tasks", should_cancel_running_tasks)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="clusterEntityFilters")
    def cluster_entity_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]]]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "cluster_entity_filters")

    @cluster_entity_filters.setter
    def cluster_entity_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ClusterEntityFilterArgs']]]]):
        pulumi.set(self, "cluster_entity_filters", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the image placement policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforcementState")
    def enforcement_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        """
        return pulumi.get(self, "enforcement_state")

    @enforcement_state.setter
    def enforcement_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_state", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="imageEntityFilters")
    def image_entity_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]]]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "image_entity_filters")

    @image_entity_filters.setter
    def image_entity_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImagePlacementPolicyV2ImageEntityFilterArgs']]]]):
        pulumi.set(self, "image_entity_filters", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image placement policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "owner_ext_id")

    @owner_ext_id.setter
    def owner_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="placementType")
    def placement_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        return pulumi.get(self, "placement_type")

    @placement_type.setter
    def placement_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "placement_type", value)

    @_builtins.property
    @pulumi.getter(name="shouldCancelRunningTasks")
    def should_cancel_running_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "should_cancel_running_tasks")

    @should_cancel_running_tasks.setter
    def should_cancel_running_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_cancel_running_tasks", value)


@pulumi.type_token("nutanix:index/imagePlacementPolicyV2:ImagePlacementPolicyV2")
class ImagePlacementPolicyV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ClusterEntityFilterArgs', 'ImagePlacementPolicyV2ClusterEntityFilterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ImageEntityFilterArgs', 'ImagePlacementPolicyV2ImageEntityFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 should_cancel_running_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create an image placement policy using the provided request body. Name, placement_type, image_entity_filter and source are mandatory fields to create an policy.

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.ImagePlacementPolicyV2("example",
            name="image_placement_policy",
            description="%[2]s",
            placement_type="SOFT",
            cluster_entity_filters=[{
                "category_ext_ids": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                "type": "CATEGORIES_MATCH_ALL",
            }],
            image_entity_filters=[{
                "category_ext_ids": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                "type": "CATEGORIES_MATCH_ALL",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ClusterEntityFilterArgs', 'ImagePlacementPolicyV2ClusterEntityFilterArgsDict']]]] cluster_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] description: Description of the image placement policy.
        :param pulumi.Input[_builtins.str] enforcement_state: Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ImageEntityFilterArgs', 'ImagePlacementPolicyV2ImageEntityFilterArgsDict']]]] image_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] name: Name of the image placement policy.
        :param pulumi.Input[_builtins.str] placement_type: Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImagePlacementPolicyV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an image placement policy using the provided request body. Name, placement_type, image_entity_filter and source are mandatory fields to create an policy.

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.ImagePlacementPolicyV2("example",
            name="image_placement_policy",
            description="%[2]s",
            placement_type="SOFT",
            cluster_entity_filters=[{
                "category_ext_ids": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                "type": "CATEGORIES_MATCH_ALL",
            }],
            image_entity_filters=[{
                "category_ext_ids": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                "type": "CATEGORIES_MATCH_ALL",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ImagePlacementPolicyV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImagePlacementPolicyV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ClusterEntityFilterArgs', 'ImagePlacementPolicyV2ClusterEntityFilterArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_state: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ImageEntityFilterArgs', 'ImagePlacementPolicyV2ImageEntityFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 should_cancel_running_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImagePlacementPolicyV2Args.__new__(ImagePlacementPolicyV2Args)

            __props__.__dict__["action"] = action
            if cluster_entity_filters is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_entity_filters'")
            __props__.__dict__["cluster_entity_filters"] = cluster_entity_filters
            __props__.__dict__["description"] = description
            __props__.__dict__["enforcement_state"] = enforcement_state
            __props__.__dict__["ext_id"] = ext_id
            if image_entity_filters is None and not opts.urn:
                raise TypeError("Missing required property 'image_entity_filters'")
            __props__.__dict__["image_entity_filters"] = image_entity_filters
            __props__.__dict__["name"] = name
            if placement_type is None and not opts.urn:
                raise TypeError("Missing required property 'placement_type'")
            __props__.__dict__["placement_type"] = placement_type
            __props__.__dict__["should_cancel_running_tasks"] = should_cancel_running_tasks
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_update_time"] = None
            __props__.__dict__["owner_ext_id"] = None
        super(ImagePlacementPolicyV2, __self__).__init__(
            'nutanix:index/imagePlacementPolicyV2:ImagePlacementPolicyV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ClusterEntityFilterArgs', 'ImagePlacementPolicyV2ClusterEntityFilterArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enforcement_state: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_entity_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ImageEntityFilterArgs', 'ImagePlacementPolicyV2ImageEntityFilterArgsDict']]]]] = None,
            last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            placement_type: Optional[pulumi.Input[_builtins.str]] = None,
            should_cancel_running_tasks: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ImagePlacementPolicyV2':
        """
        Get an existing ImagePlacementPolicyV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ClusterEntityFilterArgs', 'ImagePlacementPolicyV2ClusterEntityFilterArgsDict']]]] cluster_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] description: Description of the image placement policy.
        :param pulumi.Input[_builtins.str] enforcement_state: Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImagePlacementPolicyV2ImageEntityFilterArgs', 'ImagePlacementPolicyV2ImageEntityFilterArgsDict']]]] image_entity_filters: Category-based entity filter.
        :param pulumi.Input[_builtins.str] name: Name of the image placement policy.
        :param pulumi.Input[_builtins.str] placement_type: Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImagePlacementPolicyV2State.__new__(_ImagePlacementPolicyV2State)

        __props__.__dict__["action"] = action
        __props__.__dict__["cluster_entity_filters"] = cluster_entity_filters
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["enforcement_state"] = enforcement_state
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["image_entity_filters"] = image_entity_filters
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_ext_id"] = owner_ext_id
        __props__.__dict__["placement_type"] = placement_type
        __props__.__dict__["should_cancel_running_tasks"] = should_cancel_running_tasks
        return ImagePlacementPolicyV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action to be performed on the image placement policy. Valid values "RESUME", "SUSPEND"
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="clusterEntityFilters")
    def cluster_entity_filters(self) -> pulumi.Output[Sequence['outputs.ImagePlacementPolicyV2ClusterEntityFilter']]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "cluster_entity_filters")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the image placement policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforcementState")
    def enforcement_state(self) -> pulumi.Output[_builtins.str]:
        """
        Enforcement status of the image placement policy. Valid values "ACTIVE", "SUSPENDED"
        """
        return pulumi.get(self, "enforcement_state")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="imageEntityFilters")
    def image_entity_filters(self) -> pulumi.Output[Sequence['outputs.ImagePlacementPolicyV2ImageEntityFilter']]:
        """
        Category-based entity filter.
        """
        return pulumi.get(self, "image_entity_filters")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the image placement policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="placementType")
    def placement_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the image placement policy. Valid values "HARD", "SOFT"
        """
        return pulumi.get(self, "placement_type")

    @_builtins.property
    @pulumi.getter(name="shouldCancelRunningTasks")
    def should_cancel_running_tasks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "should_cancel_running_tasks")

