# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KarbonClusterArgs', 'KarbonCluster']

@pulumi.input_type
class KarbonClusterArgs:
    def __init__(__self__, *,
                 cni_config: pulumi.Input['KarbonClusterCniConfigArgs'],
                 etcd_node_pool: pulumi.Input['KarbonClusterEtcdNodePoolArgs'],
                 master_node_pool: pulumi.Input['KarbonClusterMasterNodePoolArgs'],
                 storage_class_config: pulumi.Input['KarbonClusterStorageClassConfigArgs'],
                 version: pulumi.Input[_builtins.str],
                 worker_node_pool: pulumi.Input['KarbonClusterWorkerNodePoolArgs'],
                 active_passive_config: Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']] = None,
                 external_lb_config: Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_registries: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]] = None,
                 single_master_config: Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']] = None,
                 wait_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a KarbonCluster resource.
        :param pulumi.Input['KarbonClusterCniConfigArgs'] cni_config: - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterEtcdNodePoolArgs'] etcd_node_pool: - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        :param pulumi.Input['KarbonClusterMasterNodePoolArgs'] master_node_pool: - (Required) Configuration of the master node pools.
        :param pulumi.Input['KarbonClusterStorageClassConfigArgs'] storage_class_config: - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] version: - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterActivePassiveConfigArgs'] active_passive_config: - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterExternalLbConfigArgs'] external_lb_config: - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]] private_registries: - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        :param pulumi.Input['KarbonClusterSingleMasterConfigArgs'] single_master_config: - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] wait_timeout_minutes: - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        pulumi.set(__self__, "cni_config", cni_config)
        pulumi.set(__self__, "etcd_node_pool", etcd_node_pool)
        pulumi.set(__self__, "master_node_pool", master_node_pool)
        pulumi.set(__self__, "storage_class_config", storage_class_config)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "worker_node_pool", worker_node_pool)
        if active_passive_config is not None:
            pulumi.set(__self__, "active_passive_config", active_passive_config)
        if external_lb_config is not None:
            pulumi.set(__self__, "external_lb_config", external_lb_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_registries is not None:
            pulumi.set(__self__, "private_registries", private_registries)
        if single_master_config is not None:
            pulumi.set(__self__, "single_master_config", single_master_config)
        if wait_timeout_minutes is not None:
            warnings.warn("""use timeouts instead""", DeprecationWarning)
            pulumi.log.warn("""wait_timeout_minutes is deprecated: use timeouts instead""")
        if wait_timeout_minutes is not None:
            pulumi.set(__self__, "wait_timeout_minutes", wait_timeout_minutes)

    @_builtins.property
    @pulumi.getter(name="cniConfig")
    def cni_config(self) -> pulumi.Input['KarbonClusterCniConfigArgs']:
        """
        - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cni_config")

    @cni_config.setter
    def cni_config(self, value: pulumi.Input['KarbonClusterCniConfigArgs']):
        pulumi.set(self, "cni_config", value)

    @_builtins.property
    @pulumi.getter(name="etcdNodePool")
    def etcd_node_pool(self) -> pulumi.Input['KarbonClusterEtcdNodePoolArgs']:
        """
        - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        """
        return pulumi.get(self, "etcd_node_pool")

    @etcd_node_pool.setter
    def etcd_node_pool(self, value: pulumi.Input['KarbonClusterEtcdNodePoolArgs']):
        pulumi.set(self, "etcd_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="masterNodePool")
    def master_node_pool(self) -> pulumi.Input['KarbonClusterMasterNodePoolArgs']:
        """
        - (Required) Configuration of the master node pools.
        """
        return pulumi.get(self, "master_node_pool")

    @master_node_pool.setter
    def master_node_pool(self, value: pulumi.Input['KarbonClusterMasterNodePoolArgs']):
        pulumi.set(self, "master_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="storageClassConfig")
    def storage_class_config(self) -> pulumi.Input['KarbonClusterStorageClassConfigArgs']:
        """
        - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "storage_class_config")

    @storage_class_config.setter
    def storage_class_config(self, value: pulumi.Input['KarbonClusterStorageClassConfigArgs']):
        pulumi.set(self, "storage_class_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="workerNodePool")
    def worker_node_pool(self) -> pulumi.Input['KarbonClusterWorkerNodePoolArgs']:
        return pulumi.get(self, "worker_node_pool")

    @worker_node_pool.setter
    def worker_node_pool(self, value: pulumi.Input['KarbonClusterWorkerNodePoolArgs']):
        pulumi.set(self, "worker_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="activePassiveConfig")
    def active_passive_config(self) -> Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']]:
        """
        - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "active_passive_config")

    @active_passive_config.setter
    def active_passive_config(self, value: Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']]):
        pulumi.set(self, "active_passive_config", value)

    @_builtins.property
    @pulumi.getter(name="externalLbConfig")
    def external_lb_config(self) -> Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']]:
        """
        - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "external_lb_config")

    @external_lb_config.setter
    def external_lb_config(self, value: Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']]):
        pulumi.set(self, "external_lb_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateRegistries")
    def private_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]]:
        """
        - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        """
        return pulumi.get(self, "private_registries")

    @private_registries.setter
    def private_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]]):
        pulumi.set(self, "private_registries", value)

    @_builtins.property
    @pulumi.getter(name="singleMasterConfig")
    def single_master_config(self) -> Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']]:
        """
        - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "single_master_config")

    @single_master_config.setter
    def single_master_config(self, value: Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']]):
        pulumi.set(self, "single_master_config", value)

    @_builtins.property
    @pulumi.getter(name="waitTimeoutMinutes")
    @_utilities.deprecated("""use timeouts instead""")
    def wait_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        return pulumi.get(self, "wait_timeout_minutes")

    @wait_timeout_minutes.setter
    def wait_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_timeout_minutes", value)


@pulumi.input_type
class _KarbonClusterState:
    def __init__(__self__, *,
                 active_passive_config: Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']] = None,
                 cni_config: Optional[pulumi.Input['KarbonClusterCniConfigArgs']] = None,
                 deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etcd_node_pool: Optional[pulumi.Input['KarbonClusterEtcdNodePoolArgs']] = None,
                 external_lb_config: Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']] = None,
                 kubeapi_server_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 master_node_pool: Optional[pulumi.Input['KarbonClusterMasterNodePoolArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_registries: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]] = None,
                 single_master_config: Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class_config: Optional[pulumi.Input['KarbonClusterStorageClassConfigArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_node_pool: Optional[pulumi.Input['KarbonClusterWorkerNodePoolArgs']] = None):
        """
        Input properties used for looking up and filtering KarbonCluster resources.
        :param pulumi.Input['KarbonClusterActivePassiveConfigArgs'] active_passive_config: - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterCniConfigArgs'] cni_config: - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterEtcdNodePoolArgs'] etcd_node_pool: - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        :param pulumi.Input['KarbonClusterExternalLbConfigArgs'] external_lb_config: - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterMasterNodePoolArgs'] master_node_pool: - (Required) Configuration of the master node pools.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]] private_registries: - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        :param pulumi.Input['KarbonClusterSingleMasterConfigArgs'] single_master_config: - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input['KarbonClusterStorageClassConfigArgs'] storage_class_config: - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] version: - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] wait_timeout_minutes: - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        if active_passive_config is not None:
            pulumi.set(__self__, "active_passive_config", active_passive_config)
        if cni_config is not None:
            pulumi.set(__self__, "cni_config", cni_config)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if etcd_node_pool is not None:
            pulumi.set(__self__, "etcd_node_pool", etcd_node_pool)
        if external_lb_config is not None:
            pulumi.set(__self__, "external_lb_config", external_lb_config)
        if kubeapi_server_ipv4_address is not None:
            pulumi.set(__self__, "kubeapi_server_ipv4_address", kubeapi_server_ipv4_address)
        if master_node_pool is not None:
            pulumi.set(__self__, "master_node_pool", master_node_pool)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_registries is not None:
            pulumi.set(__self__, "private_registries", private_registries)
        if single_master_config is not None:
            pulumi.set(__self__, "single_master_config", single_master_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_class_config is not None:
            pulumi.set(__self__, "storage_class_config", storage_class_config)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_timeout_minutes is not None:
            warnings.warn("""use timeouts instead""", DeprecationWarning)
            pulumi.log.warn("""wait_timeout_minutes is deprecated: use timeouts instead""")
        if wait_timeout_minutes is not None:
            pulumi.set(__self__, "wait_timeout_minutes", wait_timeout_minutes)
        if worker_node_pool is not None:
            pulumi.set(__self__, "worker_node_pool", worker_node_pool)

    @_builtins.property
    @pulumi.getter(name="activePassiveConfig")
    def active_passive_config(self) -> Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']]:
        """
        - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "active_passive_config")

    @active_passive_config.setter
    def active_passive_config(self, value: Optional[pulumi.Input['KarbonClusterActivePassiveConfigArgs']]):
        pulumi.set(self, "active_passive_config", value)

    @_builtins.property
    @pulumi.getter(name="cniConfig")
    def cni_config(self) -> Optional[pulumi.Input['KarbonClusterCniConfigArgs']]:
        """
        - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cni_config")

    @cni_config.setter
    def cni_config(self, value: Optional[pulumi.Input['KarbonClusterCniConfigArgs']]):
        pulumi.set(self, "cni_config", value)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @_builtins.property
    @pulumi.getter(name="etcdNodePool")
    def etcd_node_pool(self) -> Optional[pulumi.Input['KarbonClusterEtcdNodePoolArgs']]:
        """
        - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        """
        return pulumi.get(self, "etcd_node_pool")

    @etcd_node_pool.setter
    def etcd_node_pool(self, value: Optional[pulumi.Input['KarbonClusterEtcdNodePoolArgs']]):
        pulumi.set(self, "etcd_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="externalLbConfig")
    def external_lb_config(self) -> Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']]:
        """
        - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "external_lb_config")

    @external_lb_config.setter
    def external_lb_config(self, value: Optional[pulumi.Input['KarbonClusterExternalLbConfigArgs']]):
        pulumi.set(self, "external_lb_config", value)

    @_builtins.property
    @pulumi.getter(name="kubeapiServerIpv4Address")
    def kubeapi_server_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "kubeapi_server_ipv4_address")

    @kubeapi_server_ipv4_address.setter
    def kubeapi_server_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubeapi_server_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="masterNodePool")
    def master_node_pool(self) -> Optional[pulumi.Input['KarbonClusterMasterNodePoolArgs']]:
        """
        - (Required) Configuration of the master node pools.
        """
        return pulumi.get(self, "master_node_pool")

    @master_node_pool.setter
    def master_node_pool(self, value: Optional[pulumi.Input['KarbonClusterMasterNodePoolArgs']]):
        pulumi.set(self, "master_node_pool", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateRegistries")
    def private_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]]:
        """
        - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        """
        return pulumi.get(self, "private_registries")

    @private_registries.setter
    def private_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonClusterPrivateRegistryArgs']]]]):
        pulumi.set(self, "private_registries", value)

    @_builtins.property
    @pulumi.getter(name="singleMasterConfig")
    def single_master_config(self) -> Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']]:
        """
        - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "single_master_config")

    @single_master_config.setter
    def single_master_config(self, value: Optional[pulumi.Input['KarbonClusterSingleMasterConfigArgs']]):
        pulumi.set(self, "single_master_config", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageClassConfig")
    def storage_class_config(self) -> Optional[pulumi.Input['KarbonClusterStorageClassConfigArgs']]:
        """
        - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "storage_class_config")

    @storage_class_config.setter
    def storage_class_config(self, value: Optional[pulumi.Input['KarbonClusterStorageClassConfigArgs']]):
        pulumi.set(self, "storage_class_config", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="waitTimeoutMinutes")
    @_utilities.deprecated("""use timeouts instead""")
    def wait_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        return pulumi.get(self, "wait_timeout_minutes")

    @wait_timeout_minutes.setter
    def wait_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_timeout_minutes", value)

    @_builtins.property
    @pulumi.getter(name="workerNodePool")
    def worker_node_pool(self) -> Optional[pulumi.Input['KarbonClusterWorkerNodePoolArgs']]:
        return pulumi.get(self, "worker_node_pool")

    @worker_node_pool.setter
    def worker_node_pool(self, value: Optional[pulumi.Input['KarbonClusterWorkerNodePoolArgs']]):
        pulumi.set(self, "worker_node_pool", value)


@pulumi.type_token("nutanix:index/karbonCluster:KarbonCluster")
class KarbonCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_passive_config: Optional[pulumi.Input[Union['KarbonClusterActivePassiveConfigArgs', 'KarbonClusterActivePassiveConfigArgsDict']]] = None,
                 cni_config: Optional[pulumi.Input[Union['KarbonClusterCniConfigArgs', 'KarbonClusterCniConfigArgsDict']]] = None,
                 etcd_node_pool: Optional[pulumi.Input[Union['KarbonClusterEtcdNodePoolArgs', 'KarbonClusterEtcdNodePoolArgsDict']]] = None,
                 external_lb_config: Optional[pulumi.Input[Union['KarbonClusterExternalLbConfigArgs', 'KarbonClusterExternalLbConfigArgsDict']]] = None,
                 master_node_pool: Optional[pulumi.Input[Union['KarbonClusterMasterNodePoolArgs', 'KarbonClusterMasterNodePoolArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KarbonClusterPrivateRegistryArgs', 'KarbonClusterPrivateRegistryArgsDict']]]]] = None,
                 single_master_config: Optional[pulumi.Input[Union['KarbonClusterSingleMasterConfigArgs', 'KarbonClusterSingleMasterConfigArgsDict']]] = None,
                 storage_class_config: Optional[pulumi.Input[Union['KarbonClusterStorageClassConfigArgs', 'KarbonClusterStorageClassConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_node_pool: Optional[pulumi.Input[Union['KarbonClusterWorkerNodePoolArgs', 'KarbonClusterWorkerNodePoolArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Nutanix Karbon Cluster resource to Create a k8s cluster.

        **Note:** Minimum tested version is Karbon 2.2

        **Note:** Kubernetes and Node OS upgrades are not supported using this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_cluster = nutanix.KarbonCluster("example_cluster",
            name="example_cluster",
            version="1.18.15-1",
            storage_class_config={
                "reclaim_policy": "Delete",
                "volumes_config": {
                    "file_system": "ext4",
                    "flash_mode": False,
                    "password": "my_pe_pw",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                    "storage_container": "my_storage_container_name",
                    "username": "my_pe_username",
                },
            },
            cni_config={
                "node_cidr_mask_size": 24,
                "pod_ipv4_cidr": "172.20.0.0/16",
                "service_ipv4_cidr": "172.19.0.0/16",
            },
            worker_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            etcd_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            master_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            })
        ```

        ### resource to create karbon cluster with timeouts
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_cluster = nutanix.KarbonCluster("example_cluster",
            name="example_cluster",
            version="1.18.15-1",
            storage_class_config={
                "reclaim_policy": "Delete",
                "volumes_config": {
                    "file_system": "ext4",
                    "flash_mode": False,
                    "password": "my_pe_pw",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                    "storage_container": "my_storage_container_name",
                    "username": "my_pe_username",
                },
            },
            cni_config={
                "node_cidr_mask_size": 24,
                "pod_ipv4_cidr": "172.20.0.0/16",
                "service_ipv4_cidr": "172.19.0.0/16",
            },
            worker_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            etcd_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            master_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KarbonClusterActivePassiveConfigArgs', 'KarbonClusterActivePassiveConfigArgsDict']] active_passive_config: - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterCniConfigArgs', 'KarbonClusterCniConfigArgsDict']] cni_config: - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterEtcdNodePoolArgs', 'KarbonClusterEtcdNodePoolArgsDict']] etcd_node_pool: - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        :param pulumi.Input[Union['KarbonClusterExternalLbConfigArgs', 'KarbonClusterExternalLbConfigArgsDict']] external_lb_config: - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterMasterNodePoolArgs', 'KarbonClusterMasterNodePoolArgsDict']] master_node_pool: - (Required) Configuration of the master node pools.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KarbonClusterPrivateRegistryArgs', 'KarbonClusterPrivateRegistryArgsDict']]]] private_registries: - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        :param pulumi.Input[Union['KarbonClusterSingleMasterConfigArgs', 'KarbonClusterSingleMasterConfigArgsDict']] single_master_config: - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterStorageClassConfigArgs', 'KarbonClusterStorageClassConfigArgsDict']] storage_class_config: - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] version: - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] wait_timeout_minutes: - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KarbonClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Karbon Cluster resource to Create a k8s cluster.

        **Note:** Minimum tested version is Karbon 2.2

        **Note:** Kubernetes and Node OS upgrades are not supported using this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_cluster = nutanix.KarbonCluster("example_cluster",
            name="example_cluster",
            version="1.18.15-1",
            storage_class_config={
                "reclaim_policy": "Delete",
                "volumes_config": {
                    "file_system": "ext4",
                    "flash_mode": False,
                    "password": "my_pe_pw",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                    "storage_container": "my_storage_container_name",
                    "username": "my_pe_username",
                },
            },
            cni_config={
                "node_cidr_mask_size": 24,
                "pod_ipv4_cidr": "172.20.0.0/16",
                "service_ipv4_cidr": "172.19.0.0/16",
            },
            worker_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            etcd_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            master_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            })
        ```

        ### resource to create karbon cluster with timeouts
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example_cluster = nutanix.KarbonCluster("example_cluster",
            name="example_cluster",
            version="1.18.15-1",
            storage_class_config={
                "reclaim_policy": "Delete",
                "volumes_config": {
                    "file_system": "ext4",
                    "flash_mode": False,
                    "password": "my_pe_pw",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                    "storage_container": "my_storage_container_name",
                    "username": "my_pe_username",
                },
            },
            cni_config={
                "node_cidr_mask_size": 24,
                "pod_ipv4_cidr": "172.20.0.0/16",
                "service_ipv4_cidr": "172.19.0.0/16",
            },
            worker_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            etcd_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            },
            master_node_pool={
                "node_os_version": "ntnx-1.0",
                "num_instances": 1,
                "ahv_config": {
                    "network_uuid": "my_subnet_id",
                    "prism_element_cluster_uuid": "my_pe_cluster_uuid",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param KarbonClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KarbonClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_passive_config: Optional[pulumi.Input[Union['KarbonClusterActivePassiveConfigArgs', 'KarbonClusterActivePassiveConfigArgsDict']]] = None,
                 cni_config: Optional[pulumi.Input[Union['KarbonClusterCniConfigArgs', 'KarbonClusterCniConfigArgsDict']]] = None,
                 etcd_node_pool: Optional[pulumi.Input[Union['KarbonClusterEtcdNodePoolArgs', 'KarbonClusterEtcdNodePoolArgsDict']]] = None,
                 external_lb_config: Optional[pulumi.Input[Union['KarbonClusterExternalLbConfigArgs', 'KarbonClusterExternalLbConfigArgsDict']]] = None,
                 master_node_pool: Optional[pulumi.Input[Union['KarbonClusterMasterNodePoolArgs', 'KarbonClusterMasterNodePoolArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KarbonClusterPrivateRegistryArgs', 'KarbonClusterPrivateRegistryArgsDict']]]]] = None,
                 single_master_config: Optional[pulumi.Input[Union['KarbonClusterSingleMasterConfigArgs', 'KarbonClusterSingleMasterConfigArgsDict']]] = None,
                 storage_class_config: Optional[pulumi.Input[Union['KarbonClusterStorageClassConfigArgs', 'KarbonClusterStorageClassConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 worker_node_pool: Optional[pulumi.Input[Union['KarbonClusterWorkerNodePoolArgs', 'KarbonClusterWorkerNodePoolArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KarbonClusterArgs.__new__(KarbonClusterArgs)

            __props__.__dict__["active_passive_config"] = active_passive_config
            if cni_config is None and not opts.urn:
                raise TypeError("Missing required property 'cni_config'")
            __props__.__dict__["cni_config"] = cni_config
            if etcd_node_pool is None and not opts.urn:
                raise TypeError("Missing required property 'etcd_node_pool'")
            __props__.__dict__["etcd_node_pool"] = etcd_node_pool
            __props__.__dict__["external_lb_config"] = external_lb_config
            if master_node_pool is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_pool'")
            __props__.__dict__["master_node_pool"] = master_node_pool
            __props__.__dict__["name"] = name
            __props__.__dict__["private_registries"] = private_registries
            __props__.__dict__["single_master_config"] = single_master_config
            if storage_class_config is None and not opts.urn:
                raise TypeError("Missing required property 'storage_class_config'")
            __props__.__dict__["storage_class_config"] = storage_class_config
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["wait_timeout_minutes"] = wait_timeout_minutes
            if worker_node_pool is None and not opts.urn:
                raise TypeError("Missing required property 'worker_node_pool'")
            __props__.__dict__["worker_node_pool"] = worker_node_pool
            __props__.__dict__["deployment_type"] = None
            __props__.__dict__["kubeapi_server_ipv4_address"] = None
            __props__.__dict__["status"] = None
        super(KarbonCluster, __self__).__init__(
            'nutanix:index/karbonCluster:KarbonCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_passive_config: Optional[pulumi.Input[Union['KarbonClusterActivePassiveConfigArgs', 'KarbonClusterActivePassiveConfigArgsDict']]] = None,
            cni_config: Optional[pulumi.Input[Union['KarbonClusterCniConfigArgs', 'KarbonClusterCniConfigArgsDict']]] = None,
            deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
            etcd_node_pool: Optional[pulumi.Input[Union['KarbonClusterEtcdNodePoolArgs', 'KarbonClusterEtcdNodePoolArgsDict']]] = None,
            external_lb_config: Optional[pulumi.Input[Union['KarbonClusterExternalLbConfigArgs', 'KarbonClusterExternalLbConfigArgsDict']]] = None,
            kubeapi_server_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            master_node_pool: Optional[pulumi.Input[Union['KarbonClusterMasterNodePoolArgs', 'KarbonClusterMasterNodePoolArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KarbonClusterPrivateRegistryArgs', 'KarbonClusterPrivateRegistryArgsDict']]]]] = None,
            single_master_config: Optional[pulumi.Input[Union['KarbonClusterSingleMasterConfigArgs', 'KarbonClusterSingleMasterConfigArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_class_config: Optional[pulumi.Input[Union['KarbonClusterStorageClassConfigArgs', 'KarbonClusterStorageClassConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            wait_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            worker_node_pool: Optional[pulumi.Input[Union['KarbonClusterWorkerNodePoolArgs', 'KarbonClusterWorkerNodePoolArgsDict']]] = None) -> 'KarbonCluster':
        """
        Get an existing KarbonCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KarbonClusterActivePassiveConfigArgs', 'KarbonClusterActivePassiveConfigArgsDict']] active_passive_config: - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterCniConfigArgs', 'KarbonClusterCniConfigArgsDict']] cni_config: - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterEtcdNodePoolArgs', 'KarbonClusterEtcdNodePoolArgsDict']] etcd_node_pool: - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        :param pulumi.Input[Union['KarbonClusterExternalLbConfigArgs', 'KarbonClusterExternalLbConfigArgsDict']] external_lb_config: - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterMasterNodePoolArgs', 'KarbonClusterMasterNodePoolArgsDict']] master_node_pool: - (Required) Configuration of the master node pools.
        :param pulumi.Input[_builtins.str] name: - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KarbonClusterPrivateRegistryArgs', 'KarbonClusterPrivateRegistryArgsDict']]]] private_registries: - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        :param pulumi.Input[Union['KarbonClusterSingleMasterConfigArgs', 'KarbonClusterSingleMasterConfigArgsDict']] single_master_config: - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[Union['KarbonClusterStorageClassConfigArgs', 'KarbonClusterStorageClassConfigArgsDict']] storage_class_config: - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] version: - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] wait_timeout_minutes: - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KarbonClusterState.__new__(_KarbonClusterState)

        __props__.__dict__["active_passive_config"] = active_passive_config
        __props__.__dict__["cni_config"] = cni_config
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["etcd_node_pool"] = etcd_node_pool
        __props__.__dict__["external_lb_config"] = external_lb_config
        __props__.__dict__["kubeapi_server_ipv4_address"] = kubeapi_server_ipv4_address
        __props__.__dict__["master_node_pool"] = master_node_pool
        __props__.__dict__["name"] = name
        __props__.__dict__["private_registries"] = private_registries
        __props__.__dict__["single_master_config"] = single_master_config
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_class_config"] = storage_class_config
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_timeout_minutes"] = wait_timeout_minutes
        __props__.__dict__["worker_node_pool"] = worker_node_pool
        return KarbonCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activePassiveConfig")
    def active_passive_config(self) -> pulumi.Output[Optional['outputs.KarbonClusterActivePassiveConfig']]:
        """
        - (Optional) The active passive mode uses the Virtual Router Redundancy Protocol (VRRP) protocol to provide high availability of the master. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "active_passive_config")

    @_builtins.property
    @pulumi.getter(name="cniConfig")
    def cni_config(self) -> pulumi.Output['outputs.KarbonClusterCniConfig']:
        """
        - (Required) K8s cluster networking configuration. The flannel or the calico configuration needs to be provided. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cni_config")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="etcdNodePool")
    def etcd_node_pool(self) -> pulumi.Output['outputs.KarbonClusterEtcdNodePool']:
        """
        - (Required) Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        """
        return pulumi.get(self, "etcd_node_pool")

    @_builtins.property
    @pulumi.getter(name="externalLbConfig")
    def external_lb_config(self) -> pulumi.Output[Optional['outputs.KarbonClusterExternalLbConfig']]:
        """
        - (Optional) The external load balancer configuration in the case of a multi-master-external-load-balancer type master deployment. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "external_lb_config")

    @_builtins.property
    @pulumi.getter(name="kubeapiServerIpv4Address")
    def kubeapi_server_ipv4_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "kubeapi_server_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="masterNodePool")
    def master_node_pool(self) -> pulumi.Output['outputs.KarbonClusterMasterNodePool']:
        """
        - (Required) Configuration of the master node pools.
        """
        return pulumi.get(self, "master_node_pool")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) The name for the k8s cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateRegistries")
    def private_registries(self) -> pulumi.Output[Optional[Sequence['outputs.KarbonClusterPrivateRegistry']]]:
        """
        - (Optional) Allows the Karbon cluster to pull images of a list of private registries.
        """
        return pulumi.get(self, "private_registries")

    @_builtins.property
    @pulumi.getter(name="singleMasterConfig")
    def single_master_config(self) -> pulumi.Output[Optional['outputs.KarbonClusterSingleMasterConfig']]:
        """
        - (Optional) Configuration of a single master node. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "single_master_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageClassConfig")
    def storage_class_config(self) -> pulumi.Output['outputs.KarbonClusterStorageClassConfig']:
        """
        - (Required) Storage class configuration attribute for defining the persistent volume attributes. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "storage_class_config")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) K8s version of the cluster. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="waitTimeoutMinutes")
    @_utilities.deprecated("""use timeouts instead""")
    def wait_timeout_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        - (Optional) Maximum wait time for the Karbon cluster to provision.
        """
        return pulumi.get(self, "wait_timeout_minutes")

    @_builtins.property
    @pulumi.getter(name="workerNodePool")
    def worker_node_pool(self) -> pulumi.Output['outputs.KarbonClusterWorkerNodePool']:
        return pulumi.get(self, "worker_node_pool")

