# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['KarbonPrivateRegistryArgs', 'KarbonPrivateRegistry']

@pulumi.input_type
class KarbonPrivateRegistryArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[_builtins.str],
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KarbonPrivateRegistry resource.
        :param pulumi.Input[_builtins.str] url: - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] cert: - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] password: - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] port: - (Optional) Port of the private registry.
        :param pulumi.Input[_builtins.str] username: - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        pulumi.set(__self__, "url", url)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Port of the private registry.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _KarbonPrivateRegistryState:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KarbonPrivateRegistry resources.
        :param pulumi.Input[_builtins.str] cert: - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] endpoint: - Endpoint of the private in format `url:port`.
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] password: - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] port: - (Optional) Port of the private registry.
        :param pulumi.Input[_builtins.str] url: - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] username: - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - Endpoint of the private in format `url:port`.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - (Optional) Port of the private registry.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("nutanix:index/karbonPrivateRegistry:KarbonPrivateRegistry")
class KarbonPrivateRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Nutanix Karbon Registry resource to Create a private registry entry in Karbon.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        registries = nutanix.get_karbon_private_registry()
        registry = nutanix.KarbonPrivateRegistry("registry")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] password: - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] port: - (Optional) Port of the private registry.
        :param pulumi.Input[_builtins.str] url: - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] username: - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KarbonPrivateRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Nutanix Karbon Registry resource to Create a private registry entry in Karbon.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        registries = nutanix.get_karbon_private_registry()
        registry = nutanix.KarbonPrivateRegistry("registry")
        ```

        :param str resource_name: The name of the resource.
        :param KarbonPrivateRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KarbonPrivateRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KarbonPrivateRegistryArgs.__new__(KarbonPrivateRegistryArgs)

            __props__.__dict__["cert"] = cert
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["username"] = username
            __props__.__dict__["endpoint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KarbonPrivateRegistry, __self__).__init__(
            'nutanix:index/karbonPrivateRegistry:KarbonPrivateRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'KarbonPrivateRegistry':
        """
        Get an existing KarbonPrivateRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert: - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] endpoint: - Endpoint of the private in format `url:port`.
        :param pulumi.Input[_builtins.str] name: - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] password: - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.int] port: - (Optional) Port of the private registry.
        :param pulumi.Input[_builtins.str] url: - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        :param pulumi.Input[_builtins.str] username: - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KarbonPrivateRegistryState.__new__(_KarbonPrivateRegistryState)

        __props__.__dict__["cert"] = cert
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        return KarbonPrivateRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Certificate of the private registry in format of base64-encoded byte array. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        - Endpoint of the private in format `url:port`.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        - (Required) Name of the private registry configuration. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Password for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        - (Optional) Port of the private registry.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        - (Optional) URL of the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - (Optional) Username for authentication to the private registry. **Note:** Updates to this attribute forces new resource creation.
        """
        return pulumi.get(self, "username")

