# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KarbonWorkerNodepoolArgs', 'KarbonWorkerNodepool']

@pulumi.input_type
class KarbonWorkerNodepoolArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 num_instances: pulumi.Input[_builtins.int],
                 ahv_config: Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_os_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KarbonWorkerNodepool resource.
        :param pulumi.Input[_builtins.str] cluster_name: Kubernetes cluster name
        :param pulumi.Input[_builtins.int] num_instances: number of node instances
        :param pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs'] ahv_config: VM configuration in AHV.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: labels of node
        :param pulumi.Input[_builtins.str] name: unique worker nodepool name
        :param pulumi.Input[_builtins.str] node_os_version: The version of the node OS image
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "num_instances", num_instances)
        if ahv_config is not None:
            pulumi.set(__self__, "ahv_config", ahv_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_os_version is not None:
            pulumi.set(__self__, "node_os_version", node_os_version)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Kubernetes cluster name
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> pulumi.Input[_builtins.int]:
        """
        number of node instances
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_instances", value)

    @_builtins.property
    @pulumi.getter(name="ahvConfig")
    def ahv_config(self) -> Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']]:
        """
        VM configuration in AHV.
        """
        return pulumi.get(self, "ahv_config")

    @ahv_config.setter
    def ahv_config(self, value: Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']]):
        pulumi.set(self, "ahv_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        labels of node
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        unique worker nodepool name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeOsVersion")
    def node_os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the node OS image
        """
        return pulumi.get(self, "node_os_version")

    @node_os_version.setter
    def node_os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_os_version", value)


@pulumi.input_type
class _KarbonWorkerNodepoolState:
    def __init__(__self__, *,
                 ahv_config: Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonWorkerNodepoolNodeArgs']]]] = None,
                 num_instances: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering KarbonWorkerNodepool resources.
        :param pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs'] ahv_config: VM configuration in AHV.
        :param pulumi.Input[_builtins.str] cluster_name: Kubernetes cluster name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: labels of node
        :param pulumi.Input[_builtins.str] name: unique worker nodepool name
        :param pulumi.Input[_builtins.str] node_os_version: The version of the node OS image
        :param pulumi.Input[Sequence[pulumi.Input['KarbonWorkerNodepoolNodeArgs']]] nodes: List of node details of pool.
        :param pulumi.Input[_builtins.int] num_instances: number of node instances
        """
        if ahv_config is not None:
            pulumi.set(__self__, "ahv_config", ahv_config)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_os_version is not None:
            pulumi.set(__self__, "node_os_version", node_os_version)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @_builtins.property
    @pulumi.getter(name="ahvConfig")
    def ahv_config(self) -> Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']]:
        """
        VM configuration in AHV.
        """
        return pulumi.get(self, "ahv_config")

    @ahv_config.setter
    def ahv_config(self, value: Optional[pulumi.Input['KarbonWorkerNodepoolAhvConfigArgs']]):
        pulumi.set(self, "ahv_config", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes cluster name
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        labels of node
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        unique worker nodepool name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeOsVersion")
    def node_os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the node OS image
        """
        return pulumi.get(self, "node_os_version")

    @node_os_version.setter
    def node_os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_os_version", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KarbonWorkerNodepoolNodeArgs']]]]:
        """
        List of node details of pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KarbonWorkerNodepoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        number of node instances
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_instances", value)


@pulumi.type_token("nutanix:index/karbonWorkerNodepool:KarbonWorkerNodepool")
class KarbonWorkerNodepool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ahv_config: Optional[pulumi.Input[Union['KarbonWorkerNodepoolAhvConfigArgs', 'KarbonWorkerNodepoolAhvConfigArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 num_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a resource to add/remove worker nodepool in an existing Nutanix Kubernetes Engine (NKE).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        kworker_np = nutanix.KarbonWorkerNodepool("kworkerNp",
            cluster_name="karbon",
            name="workerpool1",
            num_instances=1,
            ahv_config={
                "cpu": 4,
                "disk_mib": 122880,
                "memory_mib": 8192,
                "network_uuid": "61213511-6383-4a38-9ac8-4a552c0e5865",
            })
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        kworker_np = nutanix.KarbonWorkerNodepool("kworkerNp",
            cluster_name="karbon",
            name="workerpool1",
            num_instances=1,
            ahv_config={
                "cpu": 4,
                "disk_mib": 122880,
                "memory_mib": 8192,
                "network_uuid": "61213511-6383-4a38-9ac8-4a552c0e5865",
            },
            labels={
                "k1": "v1",
                "k2": "v2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KarbonWorkerNodepoolAhvConfigArgs', 'KarbonWorkerNodepoolAhvConfigArgsDict']] ahv_config: VM configuration in AHV.
        :param pulumi.Input[_builtins.str] cluster_name: Kubernetes cluster name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: labels of node
        :param pulumi.Input[_builtins.str] name: unique worker nodepool name
        :param pulumi.Input[_builtins.str] node_os_version: The version of the node OS image
        :param pulumi.Input[_builtins.int] num_instances: number of node instances
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KarbonWorkerNodepoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to add/remove worker nodepool in an existing Nutanix Kubernetes Engine (NKE).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        kworker_np = nutanix.KarbonWorkerNodepool("kworkerNp",
            cluster_name="karbon",
            name="workerpool1",
            num_instances=1,
            ahv_config={
                "cpu": 4,
                "disk_mib": 122880,
                "memory_mib": 8192,
                "network_uuid": "61213511-6383-4a38-9ac8-4a552c0e5865",
            })
        ```

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        kworker_np = nutanix.KarbonWorkerNodepool("kworkerNp",
            cluster_name="karbon",
            name="workerpool1",
            num_instances=1,
            ahv_config={
                "cpu": 4,
                "disk_mib": 122880,
                "memory_mib": 8192,
                "network_uuid": "61213511-6383-4a38-9ac8-4a552c0e5865",
            },
            labels={
                "k1": "v1",
                "k2": "v2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param KarbonWorkerNodepoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KarbonWorkerNodepoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ahv_config: Optional[pulumi.Input[Union['KarbonWorkerNodepoolAhvConfigArgs', 'KarbonWorkerNodepoolAhvConfigArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 num_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KarbonWorkerNodepoolArgs.__new__(KarbonWorkerNodepoolArgs)

            __props__.__dict__["ahv_config"] = ahv_config
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["node_os_version"] = node_os_version
            if num_instances is None and not opts.urn:
                raise TypeError("Missing required property 'num_instances'")
            __props__.__dict__["num_instances"] = num_instances
            __props__.__dict__["nodes"] = None
        super(KarbonWorkerNodepool, __self__).__init__(
            'nutanix:index/karbonWorkerNodepool:KarbonWorkerNodepool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ahv_config: Optional[pulumi.Input[Union['KarbonWorkerNodepoolAhvConfigArgs', 'KarbonWorkerNodepoolAhvConfigArgsDict']]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_os_version: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KarbonWorkerNodepoolNodeArgs', 'KarbonWorkerNodepoolNodeArgsDict']]]]] = None,
            num_instances: Optional[pulumi.Input[_builtins.int]] = None) -> 'KarbonWorkerNodepool':
        """
        Get an existing KarbonWorkerNodepool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KarbonWorkerNodepoolAhvConfigArgs', 'KarbonWorkerNodepoolAhvConfigArgsDict']] ahv_config: VM configuration in AHV.
        :param pulumi.Input[_builtins.str] cluster_name: Kubernetes cluster name
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: labels of node
        :param pulumi.Input[_builtins.str] name: unique worker nodepool name
        :param pulumi.Input[_builtins.str] node_os_version: The version of the node OS image
        :param pulumi.Input[Sequence[pulumi.Input[Union['KarbonWorkerNodepoolNodeArgs', 'KarbonWorkerNodepoolNodeArgsDict']]]] nodes: List of node details of pool.
        :param pulumi.Input[_builtins.int] num_instances: number of node instances
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KarbonWorkerNodepoolState.__new__(_KarbonWorkerNodepoolState)

        __props__.__dict__["ahv_config"] = ahv_config
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["node_os_version"] = node_os_version
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["num_instances"] = num_instances
        return KarbonWorkerNodepool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ahvConfig")
    def ahv_config(self) -> pulumi.Output['outputs.KarbonWorkerNodepoolAhvConfig']:
        """
        VM configuration in AHV.
        """
        return pulumi.get(self, "ahv_config")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Kubernetes cluster name
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        labels of node
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        unique worker nodepool name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeOsVersion")
    def node_os_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the node OS image
        """
        return pulumi.get(self, "node_os_version")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.KarbonWorkerNodepoolNode']]:
        """
        List of node details of pool.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> pulumi.Output[_builtins.int]:
        """
        number of node instances
        """
        return pulumi.get(self, "num_instances")

