# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LcmConfigV2Args', 'LcmConfigV2']

@pulumi.input_type
class LcmConfigV2Args:
    def __init__(__self__, *,
                 auto_inventory_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 has_module_auto_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_inventory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LcmConfigV2 resource.
        :param pulumi.Input[_builtins.str] auto_inventory_schedule: The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        :param pulumi.Input[_builtins.str] connectivity_type: This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        :param pulumi.Input[_builtins.bool] has_module_auto_upgrade_enabled: Indicates if LCM is enabled to auto-upgrade products. The default value is False.
               
               See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        :param pulumi.Input[_builtins.bool] is_auto_inventory_enabled: Indicates if the auto inventory operation is enabled. The default value is set to False.
        :param pulumi.Input[_builtins.bool] is_https_enabled: Indicates if the LCM URL has HTTPS enabled. The default value is True.
        :param pulumi.Input[_builtins.str] url: URL of the LCM repository.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        if auto_inventory_schedule is not None:
            pulumi.set(__self__, "auto_inventory_schedule", auto_inventory_schedule)
        if connectivity_type is not None:
            pulumi.set(__self__, "connectivity_type", connectivity_type)
        if has_module_auto_upgrade_enabled is not None:
            pulumi.set(__self__, "has_module_auto_upgrade_enabled", has_module_auto_upgrade_enabled)
        if is_auto_inventory_enabled is not None:
            pulumi.set(__self__, "is_auto_inventory_enabled", is_auto_inventory_enabled)
        if is_https_enabled is not None:
            pulumi.set(__self__, "is_https_enabled", is_https_enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoInventorySchedule")
    def auto_inventory_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        """
        return pulumi.get(self, "auto_inventory_schedule")

    @auto_inventory_schedule.setter
    def auto_inventory_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_inventory_schedule", value)

    @_builtins.property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        """
        return pulumi.get(self, "connectivity_type")

    @connectivity_type.setter
    def connectivity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connectivity_type", value)

    @_builtins.property
    @pulumi.getter(name="hasModuleAutoUpgradeEnabled")
    def has_module_auto_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if LCM is enabled to auto-upgrade products. The default value is False.

        See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        """
        return pulumi.get(self, "has_module_auto_upgrade_enabled")

    @has_module_auto_upgrade_enabled.setter
    def has_module_auto_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_module_auto_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isAutoInventoryEnabled")
    def is_auto_inventory_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the auto inventory operation is enabled. The default value is set to False.
        """
        return pulumi.get(self, "is_auto_inventory_enabled")

    @is_auto_inventory_enabled.setter
    def is_auto_inventory_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_inventory_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isHttpsEnabled")
    def is_https_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the LCM URL has HTTPS enabled. The default value is True.
        """
        return pulumi.get(self, "is_https_enabled")

    @is_https_enabled.setter
    def is_https_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_https_enabled", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the LCM repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.input_type
class _LcmConfigV2State:
    def __init__(__self__, *,
                 auto_inventory_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 has_module_auto_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_inventory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LcmConfigV2 resources.
        :param pulumi.Input[_builtins.str] auto_inventory_schedule: The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        :param pulumi.Input[_builtins.str] connectivity_type: This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        :param pulumi.Input[_builtins.bool] has_module_auto_upgrade_enabled: Indicates if LCM is enabled to auto-upgrade products. The default value is False.
               
               See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        :param pulumi.Input[_builtins.bool] is_auto_inventory_enabled: Indicates if the auto inventory operation is enabled. The default value is set to False.
        :param pulumi.Input[_builtins.bool] is_https_enabled: Indicates if the LCM URL has HTTPS enabled. The default value is True.
        :param pulumi.Input[_builtins.str] url: URL of the LCM repository.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        if auto_inventory_schedule is not None:
            pulumi.set(__self__, "auto_inventory_schedule", auto_inventory_schedule)
        if connectivity_type is not None:
            pulumi.set(__self__, "connectivity_type", connectivity_type)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if has_module_auto_upgrade_enabled is not None:
            pulumi.set(__self__, "has_module_auto_upgrade_enabled", has_module_auto_upgrade_enabled)
        if is_auto_inventory_enabled is not None:
            pulumi.set(__self__, "is_auto_inventory_enabled", is_auto_inventory_enabled)
        if is_https_enabled is not None:
            pulumi.set(__self__, "is_https_enabled", is_https_enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoInventorySchedule")
    def auto_inventory_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        """
        return pulumi.get(self, "auto_inventory_schedule")

    @auto_inventory_schedule.setter
    def auto_inventory_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_inventory_schedule", value)

    @_builtins.property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        """
        return pulumi.get(self, "connectivity_type")

    @connectivity_type.setter
    def connectivity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connectivity_type", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="hasModuleAutoUpgradeEnabled")
    def has_module_auto_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if LCM is enabled to auto-upgrade products. The default value is False.

        See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        """
        return pulumi.get(self, "has_module_auto_upgrade_enabled")

    @has_module_auto_upgrade_enabled.setter
    def has_module_auto_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_module_auto_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isAutoInventoryEnabled")
    def is_auto_inventory_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the auto inventory operation is enabled. The default value is set to False.
        """
        return pulumi.get(self, "is_auto_inventory_enabled")

    @is_auto_inventory_enabled.setter
    def is_auto_inventory_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_inventory_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isHttpsEnabled")
    def is_https_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the LCM URL has HTTPS enabled. The default value is True.
        """
        return pulumi.get(self, "is_https_enabled")

    @is_https_enabled.setter
    def is_https_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_https_enabled", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the LCM repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.type_token("nutanix:index/lcmConfigV2:LcmConfigV2")
class LcmConfigV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_inventory_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 has_module_auto_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_inventory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Update LCM configuration.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Enable Auto Inventory, Add Auto Inventory Schedule and enable auto upgrade
        lcm_configuration_update = nutanix.LcmConfigV2("lcm-configuration-update",
            x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b",
            is_auto_inventory_enabled=True,
            auto_inventory_schedule="16:30",
            has_module_auto_upgrade_enabled=True)
        # Update the LCM url to darksite server
        lcm_configuration_update_connectivity_type = nutanix.LcmConfigV2("lcm-configuration-update-connectivity-type",
            x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b",
            url="https://x.x.x.x:8000/builds",
            connectivity_type="DARKSITE_WEB_SERVER")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_inventory_schedule: The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        :param pulumi.Input[_builtins.str] connectivity_type: This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        :param pulumi.Input[_builtins.bool] has_module_auto_upgrade_enabled: Indicates if LCM is enabled to auto-upgrade products. The default value is False.
               
               See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        :param pulumi.Input[_builtins.bool] is_auto_inventory_enabled: Indicates if the auto inventory operation is enabled. The default value is set to False.
        :param pulumi.Input[_builtins.bool] is_https_enabled: Indicates if the LCM URL has HTTPS enabled. The default value is True.
        :param pulumi.Input[_builtins.str] url: URL of the LCM repository.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LcmConfigV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Update LCM configuration.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Enable Auto Inventory, Add Auto Inventory Schedule and enable auto upgrade
        lcm_configuration_update = nutanix.LcmConfigV2("lcm-configuration-update",
            x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b",
            is_auto_inventory_enabled=True,
            auto_inventory_schedule="16:30",
            has_module_auto_upgrade_enabled=True)
        # Update the LCM url to darksite server
        lcm_configuration_update_connectivity_type = nutanix.LcmConfigV2("lcm-configuration-update-connectivity-type",
            x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b",
            url="https://x.x.x.x:8000/builds",
            connectivity_type="DARKSITE_WEB_SERVER")
        ```

        :param str resource_name: The name of the resource.
        :param LcmConfigV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LcmConfigV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_inventory_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 has_module_auto_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_auto_inventory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LcmConfigV2Args.__new__(LcmConfigV2Args)

            __props__.__dict__["auto_inventory_schedule"] = auto_inventory_schedule
            __props__.__dict__["connectivity_type"] = connectivity_type
            __props__.__dict__["has_module_auto_upgrade_enabled"] = has_module_auto_upgrade_enabled
            __props__.__dict__["is_auto_inventory_enabled"] = is_auto_inventory_enabled
            __props__.__dict__["is_https_enabled"] = is_https_enabled
            __props__.__dict__["url"] = url
            __props__.__dict__["x_cluster_id"] = x_cluster_id
            __props__.__dict__["ext_id"] = None
        super(LcmConfigV2, __self__).__init__(
            'nutanix:index/lcmConfigV2:LcmConfigV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_inventory_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            connectivity_type: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            has_module_auto_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_auto_inventory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LcmConfigV2':
        """
        Get an existing LcmConfigV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_inventory_schedule: The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        :param pulumi.Input[_builtins.str] connectivity_type: This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        :param pulumi.Input[_builtins.bool] has_module_auto_upgrade_enabled: Indicates if LCM is enabled to auto-upgrade products. The default value is False.
               
               See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        :param pulumi.Input[_builtins.bool] is_auto_inventory_enabled: Indicates if the auto inventory operation is enabled. The default value is set to False.
        :param pulumi.Input[_builtins.bool] is_https_enabled: Indicates if the LCM URL has HTTPS enabled. The default value is True.
        :param pulumi.Input[_builtins.str] url: URL of the LCM repository.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LcmConfigV2State.__new__(_LcmConfigV2State)

        __props__.__dict__["auto_inventory_schedule"] = auto_inventory_schedule
        __props__.__dict__["connectivity_type"] = connectivity_type
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["has_module_auto_upgrade_enabled"] = has_module_auto_upgrade_enabled
        __props__.__dict__["is_auto_inventory_enabled"] = is_auto_inventory_enabled
        __props__.__dict__["is_https_enabled"] = is_https_enabled
        __props__.__dict__["url"] = url
        __props__.__dict__["x_cluster_id"] = x_cluster_id
        return LcmConfigV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoInventorySchedule")
    def auto_inventory_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        """
        return pulumi.get(self, "auto_inventory_schedule")

    @_builtins.property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode.
        """
        return pulumi.get(self, "connectivity_type")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hasModuleAutoUpgradeEnabled")
    def has_module_auto_upgrade_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if LCM is enabled to auto-upgrade products. The default value is False.

        See detailed information in [Nutanix Update LCM Config V4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Config/operation/updateConfig)
        """
        return pulumi.get(self, "has_module_auto_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="isAutoInventoryEnabled")
    def is_auto_inventory_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the auto inventory operation is enabled. The default value is set to False.
        """
        return pulumi.get(self, "is_auto_inventory_enabled")

    @_builtins.property
    @pulumi.getter(name="isHttpsEnabled")
    def is_https_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the LCM URL has HTTPS enabled. The default value is True.
        """
        return pulumi.get(self, "is_https_enabled")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of the LCM repository.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

