# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LcmPerformInventoryV2Args', 'LcmPerformInventoryV2']

@pulumi.input_type
class LcmPerformInventoryV2Args:
    def __init__(__self__, *,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LcmPerformInventoryV2 resource.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
               
               See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.

        See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.input_type
class _LcmPerformInventoryV2State:
    def __init__(__self__, *,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LcmPerformInventoryV2 resources.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
               
               See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.

        See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.type_token("nutanix:index/lcmPerformInventoryV2:LcmPerformInventoryV2")
class LcmPerformInventoryV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Perform an inventory operation to identify/scan entities on the cluster that can be updated through LCM.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # perform inventory
        inventory = nutanix.LcmPerformInventoryV2("inventory", x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
               
               See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LcmPerformInventoryV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Perform an inventory operation to identify/scan entities on the cluster that can be updated through LCM.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # perform inventory
        inventory = nutanix.LcmPerformInventoryV2("inventory", x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
        ```

        :param str resource_name: The name of the resource.
        :param LcmPerformInventoryV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LcmPerformInventoryV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LcmPerformInventoryV2Args.__new__(LcmPerformInventoryV2Args)

            __props__.__dict__["x_cluster_id"] = x_cluster_id
        super(LcmPerformInventoryV2, __self__).__init__(
            'nutanix:index/lcmPerformInventoryV2:LcmPerformInventoryV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LcmPerformInventoryV2':
        """
        Get an existing LcmPerformInventoryV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
               
               See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LcmPerformInventoryV2State.__new__(_LcmPerformInventoryV2State)

        __props__.__dict__["x_cluster_id"] = x_cluster_id
        return LcmPerformInventoryV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.

        See detailed information in [Nutanix LCM Perform Inventory v4](https://developers.nutanix.com/api-reference?namespace=lifecycle&version=v4.0#tag/Inventory/operation/performInventory)
        """
        return pulumi.get(self, "x_cluster_id")

