# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LcmPrechecksV2Args', 'LcmPrechecksV2']

@pulumi.input_type
class LcmPrechecksV2Args:
    def __init__(__self__, *,
                 entity_update_specs: pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]],
                 management_server: Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LcmPrechecksV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input['LcmPrechecksV2ManagementServerArgs'] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        pulumi.set(__self__, "entity_update_specs", entity_update_specs)
        if management_server is not None:
            pulumi.set(__self__, "management_server", management_server)
        if skipped_precheck_flags is not None:
            pulumi.set(__self__, "skipped_precheck_flags", skipped_precheck_flags)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @entity_update_specs.setter
    def entity_update_specs(self, value: pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]]):
        pulumi.set(self, "entity_update_specs", value)

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @management_server.setter
    def management_server(self, value: Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']]):
        pulumi.set(self, "management_server", value)

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @skipped_precheck_flags.setter
    def skipped_precheck_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "skipped_precheck_flags", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.input_type
class _LcmPrechecksV2State:
    def __init__(__self__, *,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 management_server: Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LcmPrechecksV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input['LcmPrechecksV2ManagementServerArgs'] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        if entity_update_specs is not None:
            pulumi.set(__self__, "entity_update_specs", entity_update_specs)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if management_server is not None:
            pulumi.set(__self__, "management_server", management_server)
        if skipped_precheck_flags is not None:
            pulumi.set(__self__, "skipped_precheck_flags", skipped_precheck_flags)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]]]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @entity_update_specs.setter
    def entity_update_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LcmPrechecksV2EntityUpdateSpecArgs']]]]):
        pulumi.set(self, "entity_update_specs", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @management_server.setter
    def management_server(self, value: Optional[pulumi.Input['LcmPrechecksV2ManagementServerArgs']]):
        pulumi.set(self, "management_server", value)

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @skipped_precheck_flags.setter
    def skipped_precheck_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "skipped_precheck_flags", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.type_token("nutanix:index/lcmPrechecksV2:LcmPrechecksV2")
class LcmPrechecksV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmPrechecksV2EntityUpdateSpecArgs', 'LcmPrechecksV2EntityUpdateSpecArgsDict']]]]] = None,
                 management_server: Optional[pulumi.Input[Union['LcmPrechecksV2ManagementServerArgs', 'LcmPrechecksV2ManagementServerArgsDict']]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Perform LCM prechecks for the intended update operation.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        pre_checks = nutanix.LcmPrechecksV2("pre-checks",
            x_cluster_id="0005a104-0b0b-4b0-8005-0b0b0b0b0b0b",
            entity_update_specs=[{
                "entity_uuid": "0c5c9e53-3551-4c5d-b13c-e41c04cbfaf7",
                "to_version": "4.0.0",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LcmPrechecksV2EntityUpdateSpecArgs', 'LcmPrechecksV2EntityUpdateSpecArgsDict']]]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input[Union['LcmPrechecksV2ManagementServerArgs', 'LcmPrechecksV2ManagementServerArgsDict']] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LcmPrechecksV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Perform LCM prechecks for the intended update operation.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        pre_checks = nutanix.LcmPrechecksV2("pre-checks",
            x_cluster_id="0005a104-0b0b-4b0-8005-0b0b0b0b0b0b",
            entity_update_specs=[{
                "entity_uuid": "0c5c9e53-3551-4c5d-b13c-e41c04cbfaf7",
                "to_version": "4.0.0",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param LcmPrechecksV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LcmPrechecksV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmPrechecksV2EntityUpdateSpecArgs', 'LcmPrechecksV2EntityUpdateSpecArgsDict']]]]] = None,
                 management_server: Optional[pulumi.Input[Union['LcmPrechecksV2ManagementServerArgs', 'LcmPrechecksV2ManagementServerArgsDict']]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LcmPrechecksV2Args.__new__(LcmPrechecksV2Args)

            if entity_update_specs is None and not opts.urn:
                raise TypeError("Missing required property 'entity_update_specs'")
            __props__.__dict__["entity_update_specs"] = entity_update_specs
            __props__.__dict__["management_server"] = management_server
            __props__.__dict__["skipped_precheck_flags"] = skipped_precheck_flags
            __props__.__dict__["x_cluster_id"] = x_cluster_id
            __props__.__dict__["ext_id"] = None
        super(LcmPrechecksV2, __self__).__init__(
            'nutanix:index/lcmPrechecksV2:LcmPrechecksV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmPrechecksV2EntityUpdateSpecArgs', 'LcmPrechecksV2EntityUpdateSpecArgsDict']]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            management_server: Optional[pulumi.Input[Union['LcmPrechecksV2ManagementServerArgs', 'LcmPrechecksV2ManagementServerArgsDict']]] = None,
            skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LcmPrechecksV2':
        """
        Get an existing LcmPrechecksV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LcmPrechecksV2EntityUpdateSpecArgs', 'LcmPrechecksV2EntityUpdateSpecArgsDict']]]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input[Union['LcmPrechecksV2ManagementServerArgs', 'LcmPrechecksV2ManagementServerArgsDict']] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LcmPrechecksV2State.__new__(_LcmPrechecksV2State)

        __props__.__dict__["entity_update_specs"] = entity_update_specs
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["management_server"] = management_server
        __props__.__dict__["skipped_precheck_flags"] = skipped_precheck_flags
        __props__.__dict__["x_cluster_id"] = x_cluster_id
        return LcmPrechecksV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> pulumi.Output[Sequence['outputs.LcmPrechecksV2EntityUpdateSpec']]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> pulumi.Output[Optional['outputs.LcmPrechecksV2ManagementServer']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

