# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LcmUpgradeV2Args', 'LcmUpgradeV2']

@pulumi.input_type
class LcmUpgradeV2Args:
    def __init__(__self__, *,
                 auto_handle_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]] = None,
                 management_server: Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']] = None,
                 max_wait_time_in_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LcmUpgradeV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_handle_flags: List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input['LcmUpgradeV2ManagementServerArgs'] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[_builtins.int] max_wait_time_in_secs: Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        if auto_handle_flags is not None:
            pulumi.set(__self__, "auto_handle_flags", auto_handle_flags)
        if entity_update_specs is not None:
            pulumi.set(__self__, "entity_update_specs", entity_update_specs)
        if management_server is not None:
            pulumi.set(__self__, "management_server", management_server)
        if max_wait_time_in_secs is not None:
            pulumi.set(__self__, "max_wait_time_in_secs", max_wait_time_in_secs)
        if skipped_precheck_flags is not None:
            pulumi.set(__self__, "skipped_precheck_flags", skipped_precheck_flags)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoHandleFlags")
    def auto_handle_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "auto_handle_flags")

    @auto_handle_flags.setter
    def auto_handle_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_handle_flags", value)

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @entity_update_specs.setter
    def entity_update_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]]):
        pulumi.set(self, "entity_update_specs", value)

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @management_server.setter
    def management_server(self, value: Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']]):
        pulumi.set(self, "management_server", value)

    @_builtins.property
    @pulumi.getter(name="maxWaitTimeInSecs")
    def max_wait_time_in_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        """
        return pulumi.get(self, "max_wait_time_in_secs")

    @max_wait_time_in_secs.setter
    def max_wait_time_in_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_wait_time_in_secs", value)

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @skipped_precheck_flags.setter
    def skipped_precheck_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "skipped_precheck_flags", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.input_type
class _LcmUpgradeV2State:
    def __init__(__self__, *,
                 auto_handle_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]] = None,
                 management_server: Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']] = None,
                 max_wait_time_in_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LcmUpgradeV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_handle_flags: List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input['LcmUpgradeV2ManagementServerArgs'] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[_builtins.int] max_wait_time_in_secs: Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        if auto_handle_flags is not None:
            pulumi.set(__self__, "auto_handle_flags", auto_handle_flags)
        if entity_update_specs is not None:
            pulumi.set(__self__, "entity_update_specs", entity_update_specs)
        if management_server is not None:
            pulumi.set(__self__, "management_server", management_server)
        if max_wait_time_in_secs is not None:
            pulumi.set(__self__, "max_wait_time_in_secs", max_wait_time_in_secs)
        if skipped_precheck_flags is not None:
            pulumi.set(__self__, "skipped_precheck_flags", skipped_precheck_flags)
        if x_cluster_id is not None:
            pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoHandleFlags")
    def auto_handle_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "auto_handle_flags")

    @auto_handle_flags.setter
    def auto_handle_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_handle_flags", value)

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @entity_update_specs.setter
    def entity_update_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LcmUpgradeV2EntityUpdateSpecArgs']]]]):
        pulumi.set(self, "entity_update_specs", value)

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @management_server.setter
    def management_server(self, value: Optional[pulumi.Input['LcmUpgradeV2ManagementServerArgs']]):
        pulumi.set(self, "management_server", value)

    @_builtins.property
    @pulumi.getter(name="maxWaitTimeInSecs")
    def max_wait_time_in_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        """
        return pulumi.get(self, "max_wait_time_in_secs")

    @max_wait_time_in_secs.setter
    def max_wait_time_in_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_wait_time_in_secs", value)

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @skipped_precheck_flags.setter
    def skipped_precheck_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "skipped_precheck_flags", value)

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

    @x_cluster_id.setter
    def x_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_cluster_id", value)


@pulumi.type_token("nutanix:index/lcmUpgradeV2:LcmUpgradeV2")
class LcmUpgradeV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_handle_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmUpgradeV2EntityUpdateSpecArgs', 'LcmUpgradeV2EntityUpdateSpecArgsDict']]]]] = None,
                 management_server: Optional[pulumi.Input[Union['LcmUpgradeV2ManagementServerArgs', 'LcmUpgradeV2ManagementServerArgsDict']]] = None,
                 max_wait_time_in_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Perform upgrade operation to a specific target version for discovered LCM entity/entities.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # upgrade the entity
        upgrade = nutanix.LcmUpgradeV2("upgrade", entity_update_specs=[{
            "entity_uuid": "0c5c9e53-3551-4c5d-b13c-e41c04cbfaf7",
            "to_version": "4.0.0",
        }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_handle_flags: List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[Sequence[pulumi.Input[Union['LcmUpgradeV2EntityUpdateSpecArgs', 'LcmUpgradeV2EntityUpdateSpecArgsDict']]]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input[Union['LcmUpgradeV2ManagementServerArgs', 'LcmUpgradeV2ManagementServerArgsDict']] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[_builtins.int] max_wait_time_in_secs: Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LcmUpgradeV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Perform upgrade operation to a specific target version for discovered LCM entity/entities.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # upgrade the entity
        upgrade = nutanix.LcmUpgradeV2("upgrade", entity_update_specs=[{
            "entity_uuid": "0c5c9e53-3551-4c5d-b13c-e41c04cbfaf7",
            "to_version": "4.0.0",
        }])
        ```

        :param str resource_name: The name of the resource.
        :param LcmUpgradeV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LcmUpgradeV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_handle_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmUpgradeV2EntityUpdateSpecArgs', 'LcmUpgradeV2EntityUpdateSpecArgsDict']]]]] = None,
                 management_server: Optional[pulumi.Input[Union['LcmUpgradeV2ManagementServerArgs', 'LcmUpgradeV2ManagementServerArgsDict']]] = None,
                 max_wait_time_in_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LcmUpgradeV2Args.__new__(LcmUpgradeV2Args)

            __props__.__dict__["auto_handle_flags"] = auto_handle_flags
            __props__.__dict__["entity_update_specs"] = entity_update_specs
            __props__.__dict__["management_server"] = management_server
            __props__.__dict__["max_wait_time_in_secs"] = max_wait_time_in_secs
            __props__.__dict__["skipped_precheck_flags"] = skipped_precheck_flags
            __props__.__dict__["x_cluster_id"] = x_cluster_id
        super(LcmUpgradeV2, __self__).__init__(
            'nutanix:index/lcmUpgradeV2:LcmUpgradeV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_handle_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            entity_update_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LcmUpgradeV2EntityUpdateSpecArgs', 'LcmUpgradeV2EntityUpdateSpecArgsDict']]]]] = None,
            management_server: Optional[pulumi.Input[Union['LcmUpgradeV2ManagementServerArgs', 'LcmUpgradeV2ManagementServerArgsDict']]] = None,
            max_wait_time_in_secs: Optional[pulumi.Input[_builtins.int]] = None,
            skipped_precheck_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            x_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LcmUpgradeV2':
        """
        Get an existing LcmUpgradeV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_handle_flags: List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[Sequence[pulumi.Input[Union['LcmUpgradeV2EntityUpdateSpecArgs', 'LcmUpgradeV2EntityUpdateSpecArgsDict']]]] entity_update_specs: List of entity update objects for getting recommendations.
        :param pulumi.Input[Union['LcmUpgradeV2ManagementServerArgs', 'LcmUpgradeV2ManagementServerArgsDict']] management_server: Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        :param pulumi.Input[_builtins.int] max_wait_time_in_secs: Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] skipped_precheck_flags: List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        :param pulumi.Input[_builtins.str] x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LcmUpgradeV2State.__new__(_LcmUpgradeV2State)

        __props__.__dict__["auto_handle_flags"] = auto_handle_flags
        __props__.__dict__["entity_update_specs"] = entity_update_specs
        __props__.__dict__["management_server"] = management_server
        __props__.__dict__["max_wait_time_in_secs"] = max_wait_time_in_secs
        __props__.__dict__["skipped_precheck_flags"] = skipped_precheck_flags
        __props__.__dict__["x_cluster_id"] = x_cluster_id
        return LcmUpgradeV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoHandleFlags")
    def auto_handle_flags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of automated system operations to perform, to avoid precheck failure and let the system restore state after an update is complete. The allowed flag is: - 'powerOffUvms': This allows the system to automatically power off user VMs which cannot be migrated to other hosts and power them on when the update is done. This option can avoid pinned VM precheck failure on the host which needs to enter maintenance mode during the update and allow the update to go through. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "auto_handle_flags")

    @_builtins.property
    @pulumi.getter(name="entityUpdateSpecs")
    def entity_update_specs(self) -> pulumi.Output[Optional[Sequence['outputs.LcmUpgradeV2EntityUpdateSpec']]]:
        """
        List of entity update objects for getting recommendations.
        """
        return pulumi.get(self, "entity_update_specs")

    @_builtins.property
    @pulumi.getter(name="managementServer")
    def management_server(self) -> pulumi.Output[Optional['outputs.LcmUpgradeV2ManagementServer']]:
        """
        Cluster management server configuration used while updating clusters with ESX or Hyper-V.
        """
        return pulumi.get(self, "management_server")

    @_builtins.property
    @pulumi.getter(name="maxWaitTimeInSecs")
    def max_wait_time_in_secs(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of seconds LCM waits for the VMs to come up after exiting host maintenance mode. Value in Range [ 60 .. 86400]
        """
        return pulumi.get(self, "max_wait_time_in_secs")

    @_builtins.property
    @pulumi.getter(name="skippedPrecheckFlags")
    def skipped_precheck_flags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of prechecks to skip. The allowed value is 'powerOffUvms' that skips the pinned VM prechecks. Items Enum: `POWER_OFF_UVMS`
        """
        return pulumi.get(self, "skipped_precheck_flags")

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "x_cluster_id")

