# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbCloneArgs', 'NdbClone']

@pulumi.input_type
class NdbCloneArgs:
    def __init__(__self__, *,
                 nodes: pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]],
                 nx_cluster_id: pulumi.Input[_builtins.str],
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_dbserver: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_parameter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 postgresql_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbClone resource.
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]] nodes: Nodes contain info about dbservers vm
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster id on where clone will be present
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]] actionarguments: if any action arguments is required
        :param pulumi.Input[_builtins.bool] clustered: clone will be clustered or not
        :param pulumi.Input[_builtins.str] compute_profile_id: specify the compute profile id
        :param pulumi.Input[_builtins.bool] create_dbserver: create new dbserver
        :param pulumi.Input[_builtins.str] database_parameter_profile_id: specify the database parameter profile id
        :param pulumi.Input[_builtins.str] dbserver_cluster_id: dbserver cluster id
        :param pulumi.Input[_builtins.str] dbserver_id: Specify if you want to create a database server. This value can be set to true or false as required.
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database clone from the VM. Default value is true
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: database instance description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] latest_snapshot: latest snapshot
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]] lcm_configs: LCM Config contains the expiry details and refresh details
        :param pulumi.Input[_builtins.str] name: database instance name
        :param pulumi.Input[_builtins.str] network_profile_id: specify the network profile id
        :param pulumi.Input[_builtins.int] node_count: Node count. Default is 1 for single instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]] postgresql_infos: postgresql info for the clone
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database clone from NDB. Default value is false
        :param pulumi.Input[_builtins.bool] remove_logical_cluster: remove logical cluster. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from where clone is created
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_public_key: ssh public key
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] time_machine_name: time machine name
        :param pulumi.Input[_builtins.str] time_zone: timezone
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: point in time for clone to be created
        :param pulumi.Input[_builtins.str] vm_password: vm password
        """
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if actionarguments is not None:
            pulumi.set(__self__, "actionarguments", actionarguments)
        if clustered is not None:
            pulumi.set(__self__, "clustered", clustered)
        if compute_profile_id is not None:
            pulumi.set(__self__, "compute_profile_id", compute_profile_id)
        if create_dbserver is not None:
            pulumi.set(__self__, "create_dbserver", create_dbserver)
        if database_parameter_profile_id is not None:
            pulumi.set(__self__, "database_parameter_profile_id", database_parameter_profile_id)
        if dbserver_cluster_id is not None:
            pulumi.set(__self__, "dbserver_cluster_id", dbserver_cluster_id)
        if dbserver_id is not None:
            pulumi.set(__self__, "dbserver_id", dbserver_id)
        if dbserver_logical_cluster_id is not None:
            pulumi.set(__self__, "dbserver_logical_cluster_id", dbserver_logical_cluster_id)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_logical_cluster is not None:
            pulumi.set(__self__, "delete_logical_cluster", delete_logical_cluster)
        if delete_time_machine is not None:
            pulumi.set(__self__, "delete_time_machine", delete_time_machine)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile_id is not None:
            pulumi.set(__self__, "network_profile_id", network_profile_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if postgresql_infos is not None:
            pulumi.set(__self__, "postgresql_infos", postgresql_infos)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if remove_logical_cluster is not None:
            pulumi.set(__self__, "remove_logical_cluster", remove_logical_cluster)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machine_name is not None:
            pulumi.set(__self__, "time_machine_name", time_machine_name)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]]:
        """
        Nodes contain info about dbservers vm
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        cluster id on where clone will be present
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]]:
        """
        if any action arguments is required
        """
        return pulumi.get(self, "actionarguments")

    @actionarguments.setter
    def actionarguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]]):
        pulumi.set(self, "actionarguments", value)

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        clone will be clustered or not
        """
        return pulumi.get(self, "clustered")

    @clustered.setter
    def clustered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clustered", value)

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the compute profile id
        """
        return pulumi.get(self, "compute_profile_id")

    @compute_profile_id.setter
    def compute_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="createDbserver")
    def create_dbserver(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        create new dbserver
        """
        return pulumi.get(self, "create_dbserver")

    @create_dbserver.setter
    def create_dbserver(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_dbserver", value)

    @_builtins.property
    @pulumi.getter(name="databaseParameterProfileId")
    def database_parameter_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the database parameter profile id
        """
        return pulumi.get(self, "database_parameter_profile_id")

    @database_parameter_profile_id.setter
    def database_parameter_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_parameter_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver cluster id
        """
        return pulumi.get(self, "dbserver_cluster_id")

    @dbserver_cluster_id.setter
    def dbserver_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify if you want to create a database server. This value can be set to true or false as required.
        """
        return pulumi.get(self, "dbserver_id")

    @dbserver_id.setter
    def dbserver_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @dbserver_logical_cluster_id.setter
    def dbserver_logical_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_logical_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database clone from the VM. Default value is true
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @delete_logical_cluster.setter
    def delete_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @delete_time_machine.setter
    def delete_time_machine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_time_machine", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database instance description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        latest snapshot
        """
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]]:
        """
        LCM Config contains the expiry details and refresh details
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database instance name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the network profile id
        """
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Node count. Default is 1 for single instance
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="postgresqlInfos")
    def postgresql_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]]:
        """
        postgresql info for the clone
        """
        return pulumi.get(self, "postgresql_infos")

    @postgresql_infos.setter
    def postgresql_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]]):
        pulumi.set(self, "postgresql_infos", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database clone from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="removeLogicalCluster")
    def remove_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        remove logical cluster. Default value is false
        """
        return pulumi.get(self, "remove_logical_cluster")

    @remove_logical_cluster.setter
    def remove_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id from where clone is created
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ssh public key
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_public_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine name
        """
        return pulumi.get(self, "time_machine_name")

    @time_machine_name.setter
    def time_machine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_name", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        point in time for clone to be created
        """
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vm password
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)


@pulumi.input_type
class _NdbCloneState:
    def __init__(__self__, *,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]] = None,
                 clone: Optional[pulumi.Input[_builtins.bool]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_dbserver: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneDatabaseNodeArgs']]]] = None,
                 database_parameter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneInfoArgs']]]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]] = None,
                 linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLinkedDatabaseArgs']]]] = None,
                 metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresql_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePropertyArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machines: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTimeMachineArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbClone resources.
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]] actionarguments: if any action arguments is required
        :param pulumi.Input[_builtins.bool] clone: cloned or not
        :param pulumi.Input[_builtins.bool] clustered: clone will be clustered or not
        :param pulumi.Input[_builtins.str] compute_profile_id: specify the compute profile id
        :param pulumi.Input[_builtins.bool] create_dbserver: create new dbserver
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: database name
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneDatabaseNodeArgs']]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_parameter_profile_id: specify the database parameter profile id
        :param pulumi.Input[_builtins.str] date_created: date created for clone
        :param pulumi.Input[_builtins.str] date_modified: last modified date for clone
        :param pulumi.Input[_builtins.str] dbserver_cluster_id: dbserver cluster id
        :param pulumi.Input[_builtins.str] dbserver_id: Specify if you want to create a database server. This value can be set to true or false as required.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database clone from the VM. Default value is true
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: database instance description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneInfoArgs']]] infos: info of clone
        :param pulumi.Input[_builtins.bool] latest_snapshot: latest snapshot
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]] lcm_configs: LCM Config contains the expiry details and refresh details
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneLinkedDatabaseArgs']]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: database instance name
        :param pulumi.Input[_builtins.str] network_profile_id: specify the network profile id
        :param pulumi.Input[_builtins.int] node_count: Node count. Default is 1 for single instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]] nodes: Nodes contain info about dbservers vm
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster id on where clone will be present
        :param pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]] postgresql_infos: postgresql info for the clone
        :param pulumi.Input[Sequence[pulumi.Input['NdbClonePropertyArgs']]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database clone from NDB. Default value is false
        :param pulumi.Input[_builtins.bool] remove_logical_cluster: remove logical cluster. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from where clone is created
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_public_key: ssh public key
        :param pulumi.Input[_builtins.str] status: status of clone
        :param pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] time_machine_name: time machine name
        :param pulumi.Input[_builtins.str] time_zone: timezone
        :param pulumi.Input[_builtins.str] type: type of clone
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: point in time for clone to be created
        :param pulumi.Input[_builtins.str] vm_password: vm password
        """
        if actionarguments is not None:
            pulumi.set(__self__, "actionarguments", actionarguments)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if clustered is not None:
            pulumi.set(__self__, "clustered", clustered)
        if compute_profile_id is not None:
            pulumi.set(__self__, "compute_profile_id", compute_profile_id)
        if create_dbserver is not None:
            pulumi.set(__self__, "create_dbserver", create_dbserver)
        if database_cluster_type is not None:
            pulumi.set(__self__, "database_cluster_type", database_cluster_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_nodes is not None:
            pulumi.set(__self__, "database_nodes", database_nodes)
        if database_parameter_profile_id is not None:
            pulumi.set(__self__, "database_parameter_profile_id", database_parameter_profile_id)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_cluster_id is not None:
            pulumi.set(__self__, "dbserver_cluster_id", dbserver_cluster_id)
        if dbserver_id is not None:
            pulumi.set(__self__, "dbserver_id", dbserver_id)
        if dbserver_logical_cluster is not None:
            pulumi.set(__self__, "dbserver_logical_cluster", dbserver_logical_cluster)
        if dbserver_logical_cluster_id is not None:
            pulumi.set(__self__, "dbserver_logical_cluster_id", dbserver_logical_cluster_id)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_logical_cluster is not None:
            pulumi.set(__self__, "delete_logical_cluster", delete_logical_cluster)
        if delete_time_machine is not None:
            pulumi.set(__self__, "delete_time_machine", delete_time_machine)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if linked_databases is not None:
            pulumi.set(__self__, "linked_databases", linked_databases)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile_id is not None:
            pulumi.set(__self__, "network_profile_id", network_profile_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if parent_database_id is not None:
            pulumi.set(__self__, "parent_database_id", parent_database_id)
        if postgresql_infos is not None:
            pulumi.set(__self__, "postgresql_infos", postgresql_infos)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if remove_logical_cluster is not None:
            pulumi.set(__self__, "remove_logical_cluster", remove_logical_cluster)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machine_name is not None:
            pulumi.set(__self__, "time_machine_name", time_machine_name)
        if time_machines is not None:
            pulumi.set(__self__, "time_machines", time_machines)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]]:
        """
        if any action arguments is required
        """
        return pulumi.get(self, "actionarguments")

    @actionarguments.setter
    def actionarguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneActionargumentArgs']]]]):
        pulumi.set(self, "actionarguments", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        cloned or not
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        clone will be clustered or not
        """
        return pulumi.get(self, "clustered")

    @clustered.setter
    def clustered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clustered", value)

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the compute profile id
        """
        return pulumi.get(self, "compute_profile_id")

    @compute_profile_id.setter
    def compute_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="createDbserver")
    def create_dbserver(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        create new dbserver
        """
        return pulumi.get(self, "create_dbserver")

    @create_dbserver.setter
    def create_dbserver(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_dbserver", value)

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @database_cluster_type.setter
    def database_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneDatabaseNodeArgs']]]]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @database_nodes.setter
    def database_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneDatabaseNodeArgs']]]]):
        pulumi.set(self, "database_nodes", value)

    @_builtins.property
    @pulumi.getter(name="databaseParameterProfileId")
    def database_parameter_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the database parameter profile id
        """
        return pulumi.get(self, "database_parameter_profile_id")

    @database_parameter_profile_id.setter
    def database_parameter_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_parameter_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date created for clone
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        last modified date for clone
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver cluster id
        """
        return pulumi.get(self, "dbserver_cluster_id")

    @dbserver_cluster_id.setter
    def dbserver_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify if you want to create a database server. This value can be set to true or false as required.
        """
        return pulumi.get(self, "dbserver_id")

    @dbserver_id.setter
    def dbserver_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @dbserver_logical_cluster.setter
    def dbserver_logical_cluster(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dbserver_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @dbserver_logical_cluster_id.setter
    def dbserver_logical_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_logical_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database clone from the VM. Default value is true
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @delete_logical_cluster.setter
    def delete_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @delete_time_machine.setter
    def delete_time_machine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_time_machine", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database instance description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced", value)

    @_builtins.property
    @pulumi.getter
    def infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneInfoArgs']]]]:
        """
        info of clone
        """
        return pulumi.get(self, "infos")

    @infos.setter
    def infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneInfoArgs']]]]):
        pulumi.set(self, "infos", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        latest snapshot
        """
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]]:
        """
        LCM Config contains the expiry details and refresh details
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLinkedDatabaseArgs']]]]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @linked_databases.setter
    def linked_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneLinkedDatabaseArgs']]]]):
        pulumi.set(self, "linked_databases", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database instance name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        specify the network profile id
        """
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Node count. Default is 1 for single instance
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]]]:
        """
        Nodes contain info about dbservers vm
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster id on where clone will be present
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "parent_database_id")

    @parent_database_id.setter
    def parent_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_database_id", value)

    @_builtins.property
    @pulumi.getter(name="postgresqlInfos")
    def postgresql_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]]:
        """
        postgresql info for the clone
        """
        return pulumi.get(self, "postgresql_infos")

    @postgresql_infos.setter
    def postgresql_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePostgresqlInfoArgs']]]]):
        pulumi.set(self, "postgresql_infos", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePropertyArgs']]]]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClonePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database clone from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="removeLogicalCluster")
    def remove_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        remove logical cluster. Default value is false
        """
        return pulumi.get(self, "remove_logical_cluster")

    @remove_logical_cluster.setter
    def remove_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id from where clone is created
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ssh public key
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_public_key", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of clone
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine name
        """
        return pulumi.get(self, "time_machine_name")

    @time_machine_name.setter
    def time_machine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_name", value)

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTimeMachineArgs']]]]:
        return pulumi.get(self, "time_machines")

    @time_machines.setter
    def time_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbCloneTimeMachineArgs']]]]):
        pulumi.set(self, "time_machines", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of clone
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        point in time for clone to be created
        """
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vm password
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)


@pulumi.type_token("nutanix:index/ndbClone:NdbClone")
class NdbClone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneActionargumentArgs', 'NdbCloneActionargumentArgsDict']]]]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_dbserver: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_parameter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLcmConfigArgs', 'NdbCloneLcmConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneNodeArgs', 'NdbCloneNodeArgsDict']]]]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresql_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePostgresqlInfoArgs', 'NdbClonePostgresqlInfoArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTagArgs', 'NdbCloneTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to perform the clone of database instance based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        ## resource for cloning using Point in time given time machine name
        name = nutanix.NdbClone("name",
            time_machine_name="test-pg-inst",
            name="test-inst-tf-check",
            nx_cluster_id="{{ nx_Cluster_id }}",
            ssh_public_key="{{ sshkey }}",
            user_pitr_timestamp="{{ point_in_time }}",
            time_zone="Asia/Calcutta",
            create_dbserver=True,
            compute_profile_id="{{ compute_profile_id }}",
            network_profile_id="{{ network_profile_id }}",
            database_parameter_profile_id="{{ databse_profile_id }}",
            nodes=[{
                "vm_name": "test_vm_clone",
                "compute_profile_id": "{{ compute_profile_id }}",
                "network_profile_id": "{{ network_profile_id }}",
                "nx_cluster_id": "{{ nx_Cluster_id }}",
            }],
            postgresql_infos=[{
                "vm_name": "test_vm_clone",
                "db_password": "pass",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneActionargumentArgs', 'NdbCloneActionargumentArgsDict']]]] actionarguments: if any action arguments is required
        :param pulumi.Input[_builtins.bool] clustered: clone will be clustered or not
        :param pulumi.Input[_builtins.str] compute_profile_id: specify the compute profile id
        :param pulumi.Input[_builtins.bool] create_dbserver: create new dbserver
        :param pulumi.Input[_builtins.str] database_parameter_profile_id: specify the database parameter profile id
        :param pulumi.Input[_builtins.str] dbserver_cluster_id: dbserver cluster id
        :param pulumi.Input[_builtins.str] dbserver_id: Specify if you want to create a database server. This value can be set to true or false as required.
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database clone from the VM. Default value is true
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: database instance description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] latest_snapshot: latest snapshot
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLcmConfigArgs', 'NdbCloneLcmConfigArgsDict']]]] lcm_configs: LCM Config contains the expiry details and refresh details
        :param pulumi.Input[_builtins.str] name: database instance name
        :param pulumi.Input[_builtins.str] network_profile_id: specify the network profile id
        :param pulumi.Input[_builtins.int] node_count: Node count. Default is 1 for single instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneNodeArgs', 'NdbCloneNodeArgsDict']]]] nodes: Nodes contain info about dbservers vm
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster id on where clone will be present
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePostgresqlInfoArgs', 'NdbClonePostgresqlInfoArgsDict']]]] postgresql_infos: postgresql info for the clone
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database clone from NDB. Default value is false
        :param pulumi.Input[_builtins.bool] remove_logical_cluster: remove logical cluster. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from where clone is created
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_public_key: ssh public key
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTagArgs', 'NdbCloneTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] time_machine_name: time machine name
        :param pulumi.Input[_builtins.str] time_zone: timezone
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: point in time for clone to be created
        :param pulumi.Input[_builtins.str] vm_password: vm password
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbCloneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to perform the clone of database instance based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        ## resource for cloning using Point in time given time machine name
        name = nutanix.NdbClone("name",
            time_machine_name="test-pg-inst",
            name="test-inst-tf-check",
            nx_cluster_id="{{ nx_Cluster_id }}",
            ssh_public_key="{{ sshkey }}",
            user_pitr_timestamp="{{ point_in_time }}",
            time_zone="Asia/Calcutta",
            create_dbserver=True,
            compute_profile_id="{{ compute_profile_id }}",
            network_profile_id="{{ network_profile_id }}",
            database_parameter_profile_id="{{ databse_profile_id }}",
            nodes=[{
                "vm_name": "test_vm_clone",
                "compute_profile_id": "{{ compute_profile_id }}",
                "network_profile_id": "{{ network_profile_id }}",
                "nx_cluster_id": "{{ nx_Cluster_id }}",
            }],
            postgresql_infos=[{
                "vm_name": "test_vm_clone",
                "db_password": "pass",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param NdbCloneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbCloneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneActionargumentArgs', 'NdbCloneActionargumentArgsDict']]]]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_dbserver: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_parameter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLcmConfigArgs', 'NdbCloneLcmConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneNodeArgs', 'NdbCloneNodeArgsDict']]]]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresql_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePostgresqlInfoArgs', 'NdbClonePostgresqlInfoArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 remove_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTagArgs', 'NdbCloneTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbCloneArgs.__new__(NdbCloneArgs)

            __props__.__dict__["actionarguments"] = actionarguments
            __props__.__dict__["clustered"] = clustered
            __props__.__dict__["compute_profile_id"] = compute_profile_id
            __props__.__dict__["create_dbserver"] = create_dbserver
            __props__.__dict__["database_parameter_profile_id"] = database_parameter_profile_id
            __props__.__dict__["dbserver_cluster_id"] = dbserver_cluster_id
            __props__.__dict__["dbserver_id"] = dbserver_id
            __props__.__dict__["dbserver_logical_cluster_id"] = dbserver_logical_cluster_id
            __props__.__dict__["delete"] = delete
            __props__.__dict__["delete_logical_cluster"] = delete_logical_cluster
            __props__.__dict__["delete_time_machine"] = delete_time_machine
            __props__.__dict__["description"] = description
            __props__.__dict__["forced"] = forced
            __props__.__dict__["latest_snapshot"] = latest_snapshot
            __props__.__dict__["lcm_configs"] = lcm_configs
            __props__.__dict__["name"] = name
            __props__.__dict__["network_profile_id"] = network_profile_id
            __props__.__dict__["node_count"] = node_count
            if nodes is None and not opts.urn:
                raise TypeError("Missing required property 'nodes'")
            __props__.__dict__["nodes"] = nodes
            if nx_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'nx_cluster_id'")
            __props__.__dict__["nx_cluster_id"] = nx_cluster_id
            __props__.__dict__["postgresql_infos"] = postgresql_infos
            __props__.__dict__["remove"] = remove
            __props__.__dict__["remove_logical_cluster"] = remove_logical_cluster
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["soft_remove"] = soft_remove
            __props__.__dict__["ssh_public_key"] = None if ssh_public_key is None else pulumi.Output.secret(ssh_public_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_machine_id"] = time_machine_id
            __props__.__dict__["time_machine_name"] = time_machine_name
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
            __props__.__dict__["vm_password"] = None if vm_password is None else pulumi.Output.secret(vm_password)
            __props__.__dict__["clone"] = None
            __props__.__dict__["database_cluster_type"] = None
            __props__.__dict__["database_name"] = None
            __props__.__dict__["database_nodes"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["dbserver_logical_cluster"] = None
            __props__.__dict__["infos"] = None
            __props__.__dict__["linked_databases"] = None
            __props__.__dict__["metric"] = None
            __props__.__dict__["parent_database_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_machines"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sshPublicKey", "vmPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NdbClone, __self__).__init__(
            'nutanix:index/ndbClone:NdbClone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneActionargumentArgs', 'NdbCloneActionargumentArgsDict']]]]] = None,
            clone: Optional[pulumi.Input[_builtins.bool]] = None,
            clustered: Optional[pulumi.Input[_builtins.bool]] = None,
            compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_dbserver: Optional[pulumi.Input[_builtins.bool]] = None,
            database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneDatabaseNodeArgs', 'NdbCloneDatabaseNodeArgsDict']]]]] = None,
            database_parameter_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            delete: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            forced: Optional[pulumi.Input[_builtins.bool]] = None,
            infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneInfoArgs', 'NdbCloneInfoArgsDict']]]]] = None,
            latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLcmConfigArgs', 'NdbCloneLcmConfigArgsDict']]]]] = None,
            linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLinkedDatabaseArgs', 'NdbCloneLinkedDatabaseArgsDict']]]]] = None,
            metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneNodeArgs', 'NdbCloneNodeArgsDict']]]]] = None,
            nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            postgresql_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePostgresqlInfoArgs', 'NdbClonePostgresqlInfoArgsDict']]]]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePropertyArgs', 'NdbClonePropertyArgsDict']]]]] = None,
            remove: Optional[pulumi.Input[_builtins.bool]] = None,
            remove_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
            ssh_public_key: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTagArgs', 'NdbCloneTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_machines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTimeMachineArgs', 'NdbCloneTimeMachineArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            vm_password: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbClone':
        """
        Get an existing NdbClone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneActionargumentArgs', 'NdbCloneActionargumentArgsDict']]]] actionarguments: if any action arguments is required
        :param pulumi.Input[_builtins.bool] clone: cloned or not
        :param pulumi.Input[_builtins.bool] clustered: clone will be clustered or not
        :param pulumi.Input[_builtins.str] compute_profile_id: specify the compute profile id
        :param pulumi.Input[_builtins.bool] create_dbserver: create new dbserver
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: database name
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneDatabaseNodeArgs', 'NdbCloneDatabaseNodeArgsDict']]]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_parameter_profile_id: specify the database parameter profile id
        :param pulumi.Input[_builtins.str] date_created: date created for clone
        :param pulumi.Input[_builtins.str] date_modified: last modified date for clone
        :param pulumi.Input[_builtins.str] dbserver_cluster_id: dbserver cluster id
        :param pulumi.Input[_builtins.str] dbserver_id: Specify if you want to create a database server. This value can be set to true or false as required.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database clone from the VM. Default value is true
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: database instance description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneInfoArgs', 'NdbCloneInfoArgsDict']]]] infos: info of clone
        :param pulumi.Input[_builtins.bool] latest_snapshot: latest snapshot
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLcmConfigArgs', 'NdbCloneLcmConfigArgsDict']]]] lcm_configs: LCM Config contains the expiry details and refresh details
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneLinkedDatabaseArgs', 'NdbCloneLinkedDatabaseArgsDict']]]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: database instance name
        :param pulumi.Input[_builtins.str] network_profile_id: specify the network profile id
        :param pulumi.Input[_builtins.int] node_count: Node count. Default is 1 for single instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneNodeArgs', 'NdbCloneNodeArgsDict']]]] nodes: Nodes contain info about dbservers vm
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster id on where clone will be present
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePostgresqlInfoArgs', 'NdbClonePostgresqlInfoArgsDict']]]] postgresql_infos: postgresql info for the clone
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClonePropertyArgs', 'NdbClonePropertyArgsDict']]]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database clone from NDB. Default value is false
        :param pulumi.Input[_builtins.bool] remove_logical_cluster: remove logical cluster. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from where clone is created
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_public_key: ssh public key
        :param pulumi.Input[_builtins.str] status: status of clone
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbCloneTagArgs', 'NdbCloneTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] time_machine_name: time machine name
        :param pulumi.Input[_builtins.str] time_zone: timezone
        :param pulumi.Input[_builtins.str] type: type of clone
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: point in time for clone to be created
        :param pulumi.Input[_builtins.str] vm_password: vm password
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbCloneState.__new__(_NdbCloneState)

        __props__.__dict__["actionarguments"] = actionarguments
        __props__.__dict__["clone"] = clone
        __props__.__dict__["clustered"] = clustered
        __props__.__dict__["compute_profile_id"] = compute_profile_id
        __props__.__dict__["create_dbserver"] = create_dbserver
        __props__.__dict__["database_cluster_type"] = database_cluster_type
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_nodes"] = database_nodes
        __props__.__dict__["database_parameter_profile_id"] = database_parameter_profile_id
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["dbserver_cluster_id"] = dbserver_cluster_id
        __props__.__dict__["dbserver_id"] = dbserver_id
        __props__.__dict__["dbserver_logical_cluster"] = dbserver_logical_cluster
        __props__.__dict__["dbserver_logical_cluster_id"] = dbserver_logical_cluster_id
        __props__.__dict__["delete"] = delete
        __props__.__dict__["delete_logical_cluster"] = delete_logical_cluster
        __props__.__dict__["delete_time_machine"] = delete_time_machine
        __props__.__dict__["description"] = description
        __props__.__dict__["forced"] = forced
        __props__.__dict__["infos"] = infos
        __props__.__dict__["latest_snapshot"] = latest_snapshot
        __props__.__dict__["lcm_configs"] = lcm_configs
        __props__.__dict__["linked_databases"] = linked_databases
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile_id"] = network_profile_id
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["nx_cluster_id"] = nx_cluster_id
        __props__.__dict__["parent_database_id"] = parent_database_id
        __props__.__dict__["postgresql_infos"] = postgresql_infos
        __props__.__dict__["properties"] = properties
        __props__.__dict__["remove"] = remove
        __props__.__dict__["remove_logical_cluster"] = remove_logical_cluster
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["soft_remove"] = soft_remove
        __props__.__dict__["ssh_public_key"] = ssh_public_key
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["time_machine_name"] = time_machine_name
        __props__.__dict__["time_machines"] = time_machines
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
        __props__.__dict__["vm_password"] = vm_password
        return NdbClone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> pulumi.Output[Optional[Sequence['outputs.NdbCloneActionargument']]]:
        """
        if any action arguments is required
        """
        return pulumi.get(self, "actionarguments")

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[_builtins.bool]:
        """
        cloned or not
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        clone will be clustered or not
        """
        return pulumi.get(self, "clustered")

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        specify the compute profile id
        """
        return pulumi.get(self, "compute_profile_id")

    @_builtins.property
    @pulumi.getter(name="createDbserver")
    def create_dbserver(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        create new dbserver
        """
        return pulumi.get(self, "create_dbserver")

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        database name
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> pulumi.Output[Sequence['outputs.NdbCloneDatabaseNode']]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @_builtins.property
    @pulumi.getter(name="databaseParameterProfileId")
    def database_parameter_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        specify the database parameter profile id
        """
        return pulumi.get(self, "database_parameter_profile_id")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        date created for clone
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        last modified date for clone
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        dbserver cluster id
        """
        return pulumi.get(self, "dbserver_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify if you want to create a database server. This value can be set to true or false as required.
        """
        return pulumi.get(self, "dbserver_id")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the database clone from the VM. Default value is true
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        database instance description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def forced(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @_builtins.property
    @pulumi.getter
    def infos(self) -> pulumi.Output[Sequence['outputs.NdbCloneInfo']]:
        """
        info of clone
        """
        return pulumi.get(self, "infos")

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        latest snapshot
        """
        return pulumi.get(self, "latest_snapshot")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> pulumi.Output[Optional[Sequence['outputs.NdbCloneLcmConfig']]]:
        """
        LCM Config contains the expiry details and refresh details
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> pulumi.Output[Sequence['outputs.NdbCloneLinkedDatabase']]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        database instance name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        specify the network profile id
        """
        return pulumi.get(self, "network_profile_id")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Node count. Default is 1 for single instance
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.NdbCloneNode']]:
        """
        Nodes contain info about dbservers vm
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        cluster id on where clone will be present
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "parent_database_id")

    @_builtins.property
    @pulumi.getter(name="postgresqlInfos")
    def postgresql_infos(self) -> pulumi.Output[Optional[Sequence['outputs.NdbClonePostgresqlInfo']]]:
        """
        postgresql info for the clone
        """
        return pulumi.get(self, "postgresql_infos")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbCloneProperty']]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Unregister the database clone from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter(name="removeLogicalCluster")
    def remove_logical_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        remove logical cluster. Default value is false
        """
        return pulumi.get(self, "remove_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        snapshot id from where clone is created
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @_builtins.property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ssh public key
        """
        return pulumi.get(self, "ssh_public_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of clone
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbCloneTag']]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        time machine name
        """
        return pulumi.get(self, "time_machine_name")

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> pulumi.Output[Sequence['outputs.NdbCloneTimeMachine']]:
        return pulumi.get(self, "time_machines")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        timezone
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of clone
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        point in time for clone to be created
        """
        return pulumi.get(self, "user_pitr_timestamp")

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        vm password
        """
        return pulumi.get(self, "vm_password")

