# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NdbCloneRefreshArgs', 'NdbCloneRefresh']

@pulumi.input_type
class NdbCloneRefreshArgs:
    def __init__(__self__, *,
                 clone_id: pulumi.Input[_builtins.str],
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbCloneRefresh resource.
        :param pulumi.Input[_builtins.str] clone_id: clone id
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id where clone has to be refreshed
        :param pulumi.Input[_builtins.str] timezone: timezone. Default is Asia/Calcutta. 
               
               See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        pulumi.set(__self__, "clone_id", clone_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)

    @_builtins.property
    @pulumi.getter(name="cloneId")
    def clone_id(self) -> pulumi.Input[_builtins.str]:
        """
        clone id
        """
        return pulumi.get(self, "clone_id")

    @clone_id.setter
    def clone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "clone_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id where clone has to be refreshed
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone. Default is Asia/Calcutta. 

        See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)


@pulumi.input_type
class _NdbCloneRefreshState:
    def __init__(__self__, *,
                 clone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbCloneRefresh resources.
        :param pulumi.Input[_builtins.str] clone_id: clone id
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id where clone has to be refreshed
        :param pulumi.Input[_builtins.str] timezone: timezone. Default is Asia/Calcutta. 
               
               See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        if clone_id is not None:
            pulumi.set(__self__, "clone_id", clone_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)

    @_builtins.property
    @pulumi.getter(name="cloneId")
    def clone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        clone id
        """
        return pulumi.get(self, "clone_id")

    @clone_id.setter
    def clone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clone_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id where clone has to be refreshed
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone. Default is Asia/Calcutta. 

        See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)


@pulumi.type_token("nutanix:index/ndbCloneRefresh:NdbCloneRefresh")
class NdbCloneRefresh(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to perform the refresh clone of database based on the input parameters.

        ## Example Usage

        ### resource to refresh clone with snapshot id

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbCloneRefresh("acctest-managed",
            clone_id="{{ clone_id }}",
            snapshot_id="{{ snapshot_id }}",
            timezone="Asia/Calcutta")
        ```

        ### resource to refresh clone with user pitr timestamp

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbCloneRefresh("acctest-managed",
            clone_id="{{ clone_id }}",
            user_pitr_stamp="{{ timestamp }}",
            timezone="Asia/Calcutta")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] clone_id: clone id
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id where clone has to be refreshed
        :param pulumi.Input[_builtins.str] timezone: timezone. Default is Asia/Calcutta. 
               
               See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbCloneRefreshArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to perform the refresh clone of database based on the input parameters.

        ## Example Usage

        ### resource to refresh clone with snapshot id

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbCloneRefresh("acctest-managed",
            clone_id="{{ clone_id }}",
            snapshot_id="{{ snapshot_id }}",
            timezone="Asia/Calcutta")
        ```

        ### resource to refresh clone with user pitr timestamp

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbCloneRefresh("acctest-managed",
            clone_id="{{ clone_id }}",
            user_pitr_stamp="{{ timestamp }}",
            timezone="Asia/Calcutta")
        ```

        :param str resource_name: The name of the resource.
        :param NdbCloneRefreshArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbCloneRefreshArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbCloneRefreshArgs.__new__(NdbCloneRefreshArgs)

            if clone_id is None and not opts.urn:
                raise TypeError("Missing required property 'clone_id'")
            __props__.__dict__["clone_id"] = clone_id
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
        super(NdbCloneRefresh, __self__).__init__(
            'nutanix:index/ndbCloneRefresh:NdbCloneRefresh',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clone_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbCloneRefresh':
        """
        Get an existing NdbCloneRefresh resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] clone_id: clone id
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id where clone has to be refreshed
        :param pulumi.Input[_builtins.str] timezone: timezone. Default is Asia/Calcutta. 
               
               See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbCloneRefreshState.__new__(_NdbCloneRefreshState)

        __props__.__dict__["clone_id"] = clone_id
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
        return NdbCloneRefresh(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloneId")
    def clone_id(self) -> pulumi.Output[_builtins.str]:
        """
        clone id
        """
        return pulumi.get(self, "clone_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        snapshot id where clone has to be refreshed
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        timezone. Default is Asia/Calcutta. 

        See detailed information in [NDB Clone Refresh](https://www.nutanix.dev/api_references/ndb/#/d4e53fff274fa-start-refresh-operation-for-the-given-clone).
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "user_pitr_timestamp")

