# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbClusterArgs', 'NdbCluster']

@pulumi.input_type
class NdbClusterArgs:
    def __init__(__self__, *,
                 agent_network_infos: pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]],
                 cluster_ip: pulumi.Input[_builtins.str],
                 networks_infos: pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]],
                 password: pulumi.Input[_builtins.str],
                 storage_container: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 agent_vm_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]] agent_network_infos: agent network info to register cluster
        :param pulumi.Input[_builtins.str] cluster_ip: Prism Element IP address
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]] networks_infos: network segmentation to segment the network traffic of the agent VM.
        :param pulumi.Input[_builtins.str] password: Prism Element password
        :param pulumi.Input[_builtins.str] storage_container: select a storage container which is used for performing database operations in the cluster
        :param pulumi.Input[_builtins.str] username: username of the Prism Element administrator
        :param pulumi.Input[_builtins.str] description: description of cluster
        :param pulumi.Input[_builtins.str] name: name of the cluster to be registered
        :param pulumi.Input[_builtins.str] version: - version
        """
        pulumi.set(__self__, "agent_network_infos", agent_network_infos)
        pulumi.set(__self__, "cluster_ip", cluster_ip)
        pulumi.set(__self__, "networks_infos", networks_infos)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "storage_container", storage_container)
        pulumi.set(__self__, "username", username)
        if agent_vm_prefix is not None:
            pulumi.set(__self__, "agent_vm_prefix", agent_vm_prefix)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="agentNetworkInfos")
    def agent_network_infos(self) -> pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]]:
        """
        agent network info to register cluster
        """
        return pulumi.get(self, "agent_network_infos")

    @agent_network_infos.setter
    def agent_network_infos(self, value: pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]]):
        pulumi.set(self, "agent_network_infos", value)

    @_builtins.property
    @pulumi.getter(name="clusterIp")
    def cluster_ip(self) -> pulumi.Input[_builtins.str]:
        """
        Prism Element IP address
        """
        return pulumi.get(self, "cluster_ip")

    @cluster_ip.setter
    def cluster_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_ip", value)

    @_builtins.property
    @pulumi.getter(name="networksInfos")
    def networks_infos(self) -> pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]]:
        """
        network segmentation to segment the network traffic of the agent VM.
        """
        return pulumi.get(self, "networks_infos")

    @networks_infos.setter
    def networks_infos(self, value: pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]]):
        pulumi.set(self, "networks_infos", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Prism Element password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="storageContainer")
    def storage_container(self) -> pulumi.Input[_builtins.str]:
        """
        select a storage container which is used for performing database operations in the cluster
        """
        return pulumi.get(self, "storage_container")

    @storage_container.setter
    def storage_container(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        username of the Prism Element administrator
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="agentVmPrefix")
    def agent_vm_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agent_vm_prefix")

    @agent_vm_prefix.setter
    def agent_vm_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_vm_prefix", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of cluster
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the cluster to be registered
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _NdbClusterState:
    def __init__(__self__, *,
                 agent_network_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]]] = None,
                 agent_vm_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_info: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_counts: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterEntityCountArgs']]]] = None,
                 fqdns: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisor_type: Optional[pulumi.Input[_builtins.str]] = None,
                 hypervisor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_server_info: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]]] = None,
                 nx_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterPropertyArgs']]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterResourceConfigArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container: Optional[pulumi.Input[_builtins.str]] = None,
                 unique_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]] agent_network_infos: agent network info to register cluster
        :param pulumi.Input[_builtins.str] cloud_info: - cloud info
        :param pulumi.Input[_builtins.str] cloud_type: - cloud type
        :param pulumi.Input[_builtins.str] cluster_ip: Prism Element IP address
        :param pulumi.Input[_builtins.str] date_created: - creation date
        :param pulumi.Input[_builtins.str] date_modified: - date modified
        :param pulumi.Input[_builtins.str] description: description of cluster
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterEntityCountArgs']]] entity_counts: - no. of entities related
        :param pulumi.Input[_builtins.str] fqdns: - fqdn
        :param pulumi.Input[_builtins.bool] healthy: - if healthy status
        :param pulumi.Input[_builtins.str] hypervisor_type: - hypervisor type
        :param pulumi.Input[_builtins.str] hypervisor_version: - hypervisor version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_addresses: - IP address
        :param pulumi.Input[_builtins.str] management_server_info: - NA
        :param pulumi.Input[_builtins.str] name: name of the cluster to be registered
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]] networks_infos: network segmentation to segment the network traffic of the agent VM.
        :param pulumi.Input[_builtins.str] nx_cluster_uuid: - nutanix cluster uuid
        :param pulumi.Input[_builtins.str] owner_id: - owner UUID
        :param pulumi.Input[_builtins.str] password: Prism Element password
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterPropertyArgs']]] properties: - list of properties
        :param pulumi.Input[_builtins.int] reference_count: - NA
        :param pulumi.Input[Sequence[pulumi.Input['NdbClusterResourceConfigArgs']]] resource_configs: - resource related consumption info
        :param pulumi.Input[_builtins.str] status: - current status
        :param pulumi.Input[_builtins.str] storage_container: select a storage container which is used for performing database operations in the cluster
        :param pulumi.Input[_builtins.str] unique_name: - unique name of cluster
        :param pulumi.Input[_builtins.str] username: username of the Prism Element administrator
        :param pulumi.Input[_builtins.str] version: - version
        """
        if agent_network_infos is not None:
            pulumi.set(__self__, "agent_network_infos", agent_network_infos)
        if agent_vm_prefix is not None:
            pulumi.set(__self__, "agent_vm_prefix", agent_vm_prefix)
        if cloud_info is not None:
            pulumi.set(__self__, "cloud_info", cloud_info)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if cluster_ip is not None:
            pulumi.set(__self__, "cluster_ip", cluster_ip)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_counts is not None:
            pulumi.set(__self__, "entity_counts", entity_counts)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if hypervisor_type is not None:
            pulumi.set(__self__, "hypervisor_type", hypervisor_type)
        if hypervisor_version is not None:
            pulumi.set(__self__, "hypervisor_version", hypervisor_version)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if management_server_info is not None:
            pulumi.set(__self__, "management_server_info", management_server_info)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks_infos is not None:
            pulumi.set(__self__, "networks_infos", networks_infos)
        if nx_cluster_uuid is not None:
            pulumi.set(__self__, "nx_cluster_uuid", nx_cluster_uuid)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if reference_count is not None:
            pulumi.set(__self__, "reference_count", reference_count)
        if resource_configs is not None:
            pulumi.set(__self__, "resource_configs", resource_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_container is not None:
            pulumi.set(__self__, "storage_container", storage_container)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="agentNetworkInfos")
    def agent_network_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]]]:
        """
        agent network info to register cluster
        """
        return pulumi.get(self, "agent_network_infos")

    @agent_network_infos.setter
    def agent_network_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterAgentNetworkInfoArgs']]]]):
        pulumi.set(self, "agent_network_infos", value)

    @_builtins.property
    @pulumi.getter(name="agentVmPrefix")
    def agent_vm_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agent_vm_prefix")

    @agent_vm_prefix.setter
    def agent_vm_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_vm_prefix", value)

    @_builtins.property
    @pulumi.getter(name="cloudInfo")
    def cloud_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - cloud info
        """
        return pulumi.get(self, "cloud_info")

    @cloud_info.setter
    def cloud_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_info", value)

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - cloud type
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterIp")
    def cluster_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prism Element IP address
        """
        return pulumi.get(self, "cluster_ip")

    @cluster_ip.setter
    def cluster_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ip", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - creation date
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - date modified
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of cluster
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entityCounts")
    def entity_counts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterEntityCountArgs']]]]:
        """
        - no. of entities related
        """
        return pulumi.get(self, "entity_counts")

    @entity_counts.setter
    def entity_counts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterEntityCountArgs']]]]):
        pulumi.set(self, "entity_counts", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - fqdn
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def healthy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - if healthy status
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "healthy", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - hypervisor type
        """
        return pulumi.get(self, "hypervisor_type")

    @hypervisor_type.setter
    def hypervisor_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_type", value)

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - hypervisor version
        """
        return pulumi.get(self, "hypervisor_version")

    @hypervisor_version.setter
    def hypervisor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hypervisor_version", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - IP address
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="managementServerInfo")
    def management_server_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - NA
        """
        return pulumi.get(self, "management_server_info")

    @management_server_info.setter
    def management_server_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_server_info", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the cluster to be registered
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networksInfos")
    def networks_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]]]:
        """
        network segmentation to segment the network traffic of the agent VM.
        """
        return pulumi.get(self, "networks_infos")

    @networks_infos.setter
    def networks_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterNetworksInfoArgs']]]]):
        pulumi.set(self, "networks_infos", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterUuid")
    def nx_cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - nutanix cluster uuid
        """
        return pulumi.get(self, "nx_cluster_uuid")

    @nx_cluster_uuid.setter
    def nx_cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - owner UUID
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prism Element password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterPropertyArgs']]]]:
        """
        - list of properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        - NA
        """
        return pulumi.get(self, "reference_count")

    @reference_count.setter
    def reference_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigs")
    def resource_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterResourceConfigArgs']]]]:
        """
        - resource related consumption info
        """
        return pulumi.get(self, "resource_configs")

    @resource_configs.setter
    def resource_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbClusterResourceConfigArgs']]]]):
        pulumi.set(self, "resource_configs", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - current status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageContainer")
    def storage_container(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        select a storage container which is used for performing database operations in the cluster
        """
        return pulumi.get(self, "storage_container")

    @storage_container.setter
    def storage_container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container", value)

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - unique name of cluster
        """
        return pulumi.get(self, "unique_name")

    @unique_name.setter
    def unique_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        username of the Prism Element administrator
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("nutanix:index/ndbCluster:NdbCluster")
class NdbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_network_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterAgentNetworkInfoArgs', 'NdbClusterAgentNetworkInfoArgsDict']]]]] = None,
                 agent_vm_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterNetworksInfoArgs', 'NdbClusterNetworksInfoArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to add a Nutanix cluster based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clsname = nutanix.index.NdbClusters("clsname",
            name={{ test-cluster }},
            description=test description,
            cluster_ip={{ cluster_ip }},
            username={{ username of cluster }},
            password={{ password of cluster }},
            storage_container={{ storage_container }},
            agent_network_info=[{
                dns: {{ DNS servers available in the }},
                ntp: {{ NTP servers available }},
            }],
            networks_info=[{
                type: DHCP,
                networkInfo: [{
                    vlanName: vlan_static,
                    staticIp: {{ static_ip }},
                    gateway: {{ gateway }},
                    subnetMask: {{ subnet_mask }},
                }],
                accessType: [
                    PRISM,
                    DSIP,
                    DBSERVER,
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterAgentNetworkInfoArgs', 'NdbClusterAgentNetworkInfoArgsDict']]]] agent_network_infos: agent network info to register cluster
        :param pulumi.Input[_builtins.str] cluster_ip: Prism Element IP address
        :param pulumi.Input[_builtins.str] description: description of cluster
        :param pulumi.Input[_builtins.str] name: name of the cluster to be registered
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterNetworksInfoArgs', 'NdbClusterNetworksInfoArgsDict']]]] networks_infos: network segmentation to segment the network traffic of the agent VM.
        :param pulumi.Input[_builtins.str] password: Prism Element password
        :param pulumi.Input[_builtins.str] storage_container: select a storage container which is used for performing database operations in the cluster
        :param pulumi.Input[_builtins.str] username: username of the Prism Element administrator
        :param pulumi.Input[_builtins.str] version: - version
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to add a Nutanix cluster based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        clsname = nutanix.index.NdbClusters("clsname",
            name={{ test-cluster }},
            description=test description,
            cluster_ip={{ cluster_ip }},
            username={{ username of cluster }},
            password={{ password of cluster }},
            storage_container={{ storage_container }},
            agent_network_info=[{
                dns: {{ DNS servers available in the }},
                ntp: {{ NTP servers available }},
            }],
            networks_info=[{
                type: DHCP,
                networkInfo: [{
                    vlanName: vlan_static,
                    staticIp: {{ static_ip }},
                    gateway: {{ gateway }},
                    subnetMask: {{ subnet_mask }},
                }],
                accessType: [
                    PRISM,
                    DSIP,
                    DBSERVER,
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param NdbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_network_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterAgentNetworkInfoArgs', 'NdbClusterAgentNetworkInfoArgsDict']]]]] = None,
                 agent_vm_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterNetworksInfoArgs', 'NdbClusterNetworksInfoArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbClusterArgs.__new__(NdbClusterArgs)

            if agent_network_infos is None and not opts.urn:
                raise TypeError("Missing required property 'agent_network_infos'")
            __props__.__dict__["agent_network_infos"] = agent_network_infos
            __props__.__dict__["agent_vm_prefix"] = agent_vm_prefix
            if cluster_ip is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ip'")
            __props__.__dict__["cluster_ip"] = cluster_ip
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if networks_infos is None and not opts.urn:
                raise TypeError("Missing required property 'networks_infos'")
            __props__.__dict__["networks_infos"] = networks_infos
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            if storage_container is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container'")
            __props__.__dict__["storage_container"] = storage_container
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["version"] = version
            __props__.__dict__["cloud_info"] = None
            __props__.__dict__["cloud_type"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["entity_counts"] = None
            __props__.__dict__["fqdns"] = None
            __props__.__dict__["healthy"] = None
            __props__.__dict__["hypervisor_type"] = None
            __props__.__dict__["hypervisor_version"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["management_server_info"] = None
            __props__.__dict__["nx_cluster_uuid"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["reference_count"] = None
            __props__.__dict__["resource_configs"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["unique_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NdbCluster, __self__).__init__(
            'nutanix:index/ndbCluster:NdbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_network_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterAgentNetworkInfoArgs', 'NdbClusterAgentNetworkInfoArgsDict']]]]] = None,
            agent_vm_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_info: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ip: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entity_counts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterEntityCountArgs', 'NdbClusterEntityCountArgsDict']]]]] = None,
            fqdns: Optional[pulumi.Input[_builtins.str]] = None,
            healthy: Optional[pulumi.Input[_builtins.bool]] = None,
            hypervisor_type: Optional[pulumi.Input[_builtins.str]] = None,
            hypervisor_version: Optional[pulumi.Input[_builtins.str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            management_server_info: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterNetworksInfoArgs', 'NdbClusterNetworksInfoArgsDict']]]]] = None,
            nx_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterPropertyArgs', 'NdbClusterPropertyArgsDict']]]]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            reference_count: Optional[pulumi.Input[_builtins.int]] = None,
            resource_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterResourceConfigArgs', 'NdbClusterResourceConfigArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container: Optional[pulumi.Input[_builtins.str]] = None,
            unique_name: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbCluster':
        """
        Get an existing NdbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterAgentNetworkInfoArgs', 'NdbClusterAgentNetworkInfoArgsDict']]]] agent_network_infos: agent network info to register cluster
        :param pulumi.Input[_builtins.str] cloud_info: - cloud info
        :param pulumi.Input[_builtins.str] cloud_type: - cloud type
        :param pulumi.Input[_builtins.str] cluster_ip: Prism Element IP address
        :param pulumi.Input[_builtins.str] date_created: - creation date
        :param pulumi.Input[_builtins.str] date_modified: - date modified
        :param pulumi.Input[_builtins.str] description: description of cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterEntityCountArgs', 'NdbClusterEntityCountArgsDict']]]] entity_counts: - no. of entities related
        :param pulumi.Input[_builtins.str] fqdns: - fqdn
        :param pulumi.Input[_builtins.bool] healthy: - if healthy status
        :param pulumi.Input[_builtins.str] hypervisor_type: - hypervisor type
        :param pulumi.Input[_builtins.str] hypervisor_version: - hypervisor version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_addresses: - IP address
        :param pulumi.Input[_builtins.str] management_server_info: - NA
        :param pulumi.Input[_builtins.str] name: name of the cluster to be registered
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterNetworksInfoArgs', 'NdbClusterNetworksInfoArgsDict']]]] networks_infos: network segmentation to segment the network traffic of the agent VM.
        :param pulumi.Input[_builtins.str] nx_cluster_uuid: - nutanix cluster uuid
        :param pulumi.Input[_builtins.str] owner_id: - owner UUID
        :param pulumi.Input[_builtins.str] password: Prism Element password
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterPropertyArgs', 'NdbClusterPropertyArgsDict']]]] properties: - list of properties
        :param pulumi.Input[_builtins.int] reference_count: - NA
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbClusterResourceConfigArgs', 'NdbClusterResourceConfigArgsDict']]]] resource_configs: - resource related consumption info
        :param pulumi.Input[_builtins.str] status: - current status
        :param pulumi.Input[_builtins.str] storage_container: select a storage container which is used for performing database operations in the cluster
        :param pulumi.Input[_builtins.str] unique_name: - unique name of cluster
        :param pulumi.Input[_builtins.str] username: username of the Prism Element administrator
        :param pulumi.Input[_builtins.str] version: - version
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbClusterState.__new__(_NdbClusterState)

        __props__.__dict__["agent_network_infos"] = agent_network_infos
        __props__.__dict__["agent_vm_prefix"] = agent_vm_prefix
        __props__.__dict__["cloud_info"] = cloud_info
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["cluster_ip"] = cluster_ip
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_counts"] = entity_counts
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["healthy"] = healthy
        __props__.__dict__["hypervisor_type"] = hypervisor_type
        __props__.__dict__["hypervisor_version"] = hypervisor_version
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["management_server_info"] = management_server_info
        __props__.__dict__["name"] = name
        __props__.__dict__["networks_infos"] = networks_infos
        __props__.__dict__["nx_cluster_uuid"] = nx_cluster_uuid
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["properties"] = properties
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["reference_count"] = reference_count
        __props__.__dict__["resource_configs"] = resource_configs
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_container"] = storage_container
        __props__.__dict__["unique_name"] = unique_name
        __props__.__dict__["username"] = username
        __props__.__dict__["version"] = version
        return NdbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentNetworkInfos")
    def agent_network_infos(self) -> pulumi.Output[Sequence['outputs.NdbClusterAgentNetworkInfo']]:
        """
        agent network info to register cluster
        """
        return pulumi.get(self, "agent_network_infos")

    @_builtins.property
    @pulumi.getter(name="agentVmPrefix")
    def agent_vm_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "agent_vm_prefix")

    @_builtins.property
    @pulumi.getter(name="cloudInfo")
    def cloud_info(self) -> pulumi.Output[_builtins.str]:
        """
        - cloud info
        """
        return pulumi.get(self, "cloud_info")

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[_builtins.str]:
        """
        - cloud type
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter(name="clusterIp")
    def cluster_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Prism Element IP address
        """
        return pulumi.get(self, "cluster_ip")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        - creation date
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        - date modified
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        description of cluster
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityCounts")
    def entity_counts(self) -> pulumi.Output[Sequence['outputs.NdbClusterEntityCount']]:
        """
        - no. of entities related
        """
        return pulumi.get(self, "entity_counts")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[_builtins.str]:
        """
        - fqdn
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def healthy(self) -> pulumi.Output[_builtins.bool]:
        """
        - if healthy status
        """
        return pulumi.get(self, "healthy")

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> pulumi.Output[_builtins.str]:
        """
        - hypervisor type
        """
        return pulumi.get(self, "hypervisor_type")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> pulumi.Output[_builtins.str]:
        """
        - hypervisor version
        """
        return pulumi.get(self, "hypervisor_version")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - IP address
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="managementServerInfo")
    def management_server_info(self) -> pulumi.Output[_builtins.str]:
        """
        - NA
        """
        return pulumi.get(self, "management_server_info")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name of the cluster to be registered
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networksInfos")
    def networks_infos(self) -> pulumi.Output[Sequence['outputs.NdbClusterNetworksInfo']]:
        """
        network segmentation to segment the network traffic of the agent VM.
        """
        return pulumi.get(self, "networks_infos")

    @_builtins.property
    @pulumi.getter(name="nxClusterUuid")
    def nx_cluster_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        - nutanix cluster uuid
        """
        return pulumi.get(self, "nx_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        - owner UUID
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Prism Element password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbClusterProperty']]:
        """
        - list of properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> pulumi.Output[_builtins.int]:
        """
        - NA
        """
        return pulumi.get(self, "reference_count")

    @_builtins.property
    @pulumi.getter(name="resourceConfigs")
    def resource_configs(self) -> pulumi.Output[Sequence['outputs.NdbClusterResourceConfig']]:
        """
        - resource related consumption info
        """
        return pulumi.get(self, "resource_configs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        - current status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageContainer")
    def storage_container(self) -> pulumi.Output[_builtins.str]:
        """
        select a storage container which is used for performing database operations in the cluster
        """
        return pulumi.get(self, "storage_container")

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> pulumi.Output[_builtins.str]:
        """
        - unique name of cluster
        """
        return pulumi.get(self, "unique_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        username of the Prism Element administrator
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        - version
        """
        return pulumi.get(self, "version")

