# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbDatabaseRestoreArgs', 'NdbDatabaseRestore']

@pulumi.input_type
class NdbDatabaseRestoreArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 latest_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_version: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]] = None,
                 time_zone_pitr: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbDatabaseRestore resource.
        :param pulumi.Input[_builtins.str] database_id: database id
        :param pulumi.Input[_builtins.str] latest_snapshot: latest snapshot id
        :param pulumi.Input[_builtins.int] restore_version: helps to restore the database with same config.
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from you want to use for restoring the instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_zone_pitr: timezone . Should be used with  `user_pitr_timestamp`
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: the time to which you want to restore your instance.
        """
        pulumi.set(__self__, "database_id", database_id)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if restore_version is not None:
            pulumi.set(__self__, "restore_version", restore_version)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone_pitr is not None:
            pulumi.set(__self__, "time_zone_pitr", time_zone_pitr)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        database id
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        latest snapshot id
        """
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="restoreVersion")
    def restore_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        helps to restore the database with same config.
        """
        return pulumi.get(self, "restore_version")

    @restore_version.setter
    def restore_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_version", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id from you want to use for restoring the instance
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZonePitr")
    def time_zone_pitr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone . Should be used with  `user_pitr_timestamp`
        """
        return pulumi.get(self, "time_zone_pitr")

    @time_zone_pitr.setter
    def time_zone_pitr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone_pitr", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the time to which you want to restore your instance.
        """
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)


@pulumi.input_type
class _NdbDatabaseRestoreState:
    def __init__(__self__, *,
                 clone: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreDatabaseNodeArgs']]]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreInfoArgs']]]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLcmConfigArgs']]]] = None,
                 linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLinkedDatabaseArgs']]]] = None,
                 metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestorePropertyArgs']]]] = None,
                 restore_version: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machines: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTimeMachineArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_pitr: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbDatabaseRestore resources.
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_id: database id
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreDatabaseNodeArgs']]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.str] description: description of database instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreInfoArgs']]] infos: info of instance
        :param pulumi.Input[_builtins.str] latest_snapshot: latest snapshot id
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLcmConfigArgs']]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLinkedDatabaseArgs']]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestorePropertyArgs']]] properties: properties of database created
        :param pulumi.Input[_builtins.int] restore_version: helps to restore the database with same config.
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from you want to use for restoring the instance
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTimeMachineArgs']]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] time_zone_pitr: timezone . Should be used with  `user_pitr_timestamp`
        :param pulumi.Input[_builtins.str] type: type of database
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: the time to which you want to restore your instance.
        """
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if database_cluster_type is not None:
            pulumi.set(__self__, "database_cluster_type", database_cluster_type)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_instance_id is not None:
            pulumi.set(__self__, "database_instance_id", database_instance_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_nodes is not None:
            pulumi.set(__self__, "database_nodes", database_nodes)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_logical_cluster is not None:
            pulumi.set(__self__, "dbserver_logical_cluster", dbserver_logical_cluster)
        if dbserver_logical_cluster_id is not None:
            pulumi.set(__self__, "dbserver_logical_cluster_id", dbserver_logical_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if linked_databases is not None:
            pulumi.set(__self__, "linked_databases", linked_databases)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_database_id is not None:
            pulumi.set(__self__, "parent_database_id", parent_database_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if restore_version is not None:
            pulumi.set(__self__, "restore_version", restore_version)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machines is not None:
            pulumi.set(__self__, "time_machines", time_machines)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if time_zone_pitr is not None:
            pulumi.set(__self__, "time_zone_pitr", time_zone_pitr)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_pitr_timestamp is not None:
            pulumi.set(__self__, "user_pitr_timestamp", user_pitr_timestamp)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @database_cluster_type.setter
    def database_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database id
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceId")
    def database_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "database_instance_id")

    @database_instance_id.setter
    def database_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreDatabaseNodeArgs']]]]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @database_nodes.setter
    def database_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreDatabaseNodeArgs']]]]):
        pulumi.set(self, "database_nodes", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @dbserver_logical_cluster.setter
    def dbserver_logical_cluster(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dbserver_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @dbserver_logical_cluster_id.setter
    def dbserver_logical_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_logical_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of database instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreInfoArgs']]]]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @infos.setter
    def infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreInfoArgs']]]]):
        pulumi.set(self, "infos", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        latest snapshot id
        """
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLcmConfigArgs']]]]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLinkedDatabaseArgs']]]]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @linked_databases.setter
    def linked_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreLinkedDatabaseArgs']]]]):
        pulumi.set(self, "linked_databases", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @parent_database_id.setter
    def parent_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_database_id", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestorePropertyArgs']]]]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestorePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="restoreVersion")
    def restore_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        helps to restore the database with same config.
        """
        return pulumi.get(self, "restore_version")

    @restore_version.setter
    def restore_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_version", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot id from you want to use for restoring the instance
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTimeMachineArgs']]]]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @time_machines.setter
    def time_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseRestoreTimeMachineArgs']]]]):
        pulumi.set(self, "time_machines", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="timeZonePitr")
    def time_zone_pitr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone . Should be used with  `user_pitr_timestamp`
        """
        return pulumi.get(self, "time_zone_pitr")

    @time_zone_pitr.setter
    def time_zone_pitr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone_pitr", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of database
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the time to which you want to restore your instance.
        """
        return pulumi.get(self, "user_pitr_timestamp")

    @user_pitr_timestamp.setter
    def user_pitr_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pitr_timestamp", value)


@pulumi.type_token("nutanix:index/ndbDatabaseRestore:NdbDatabaseRestore")
class NdbDatabaseRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_version: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTagArgs', 'NdbDatabaseRestoreTagArgsDict']]]]] = None,
                 time_zone_pitr: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to restore the database instance based on the input parameters.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: database id
        :param pulumi.Input[_builtins.str] latest_snapshot: latest snapshot id
        :param pulumi.Input[_builtins.int] restore_version: helps to restore the database with same config.
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from you want to use for restoring the instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTagArgs', 'NdbDatabaseRestoreTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_zone_pitr: timezone . Should be used with  `user_pitr_timestamp`
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: the time to which you want to restore your instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbDatabaseRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to restore the database instance based on the input parameters.

        :param str resource_name: The name of the resource.
        :param NdbDatabaseRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbDatabaseRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_version: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTagArgs', 'NdbDatabaseRestoreTagArgsDict']]]]] = None,
                 time_zone_pitr: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbDatabaseRestoreArgs.__new__(NdbDatabaseRestoreArgs)

            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["latest_snapshot"] = latest_snapshot
            __props__.__dict__["restore_version"] = restore_version
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone_pitr"] = time_zone_pitr
            __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
            __props__.__dict__["clone"] = None
            __props__.__dict__["database_cluster_type"] = None
            __props__.__dict__["database_instance_id"] = None
            __props__.__dict__["database_name"] = None
            __props__.__dict__["database_nodes"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["dbserver_logical_cluster"] = None
            __props__.__dict__["dbserver_logical_cluster_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["infos"] = None
            __props__.__dict__["lcm_configs"] = None
            __props__.__dict__["linked_databases"] = None
            __props__.__dict__["metric"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["parent_database_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_machine_id"] = None
            __props__.__dict__["time_machines"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["type"] = None
        super(NdbDatabaseRestore, __self__).__init__(
            'nutanix:index/ndbDatabaseRestore:NdbDatabaseRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clone: Optional[pulumi.Input[_builtins.bool]] = None,
            database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreDatabaseNodeArgs', 'NdbDatabaseRestoreDatabaseNodeArgsDict']]]]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreInfoArgs', 'NdbDatabaseRestoreInfoArgsDict']]]]] = None,
            latest_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
            lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreLcmConfigArgs', 'NdbDatabaseRestoreLcmConfigArgsDict']]]]] = None,
            linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreLinkedDatabaseArgs', 'NdbDatabaseRestoreLinkedDatabaseArgsDict']]]]] = None,
            metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestorePropertyArgs', 'NdbDatabaseRestorePropertyArgsDict']]]]] = None,
            restore_version: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTagArgs', 'NdbDatabaseRestoreTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_machines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTimeMachineArgs', 'NdbDatabaseRestoreTimeMachineArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone_pitr: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_pitr_timestamp: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbDatabaseRestore':
        """
        Get an existing NdbDatabaseRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_id: database id
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreDatabaseNodeArgs', 'NdbDatabaseRestoreDatabaseNodeArgsDict']]]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.str] description: description of database instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreInfoArgs', 'NdbDatabaseRestoreInfoArgsDict']]]] infos: info of instance
        :param pulumi.Input[_builtins.str] latest_snapshot: latest snapshot id
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreLcmConfigArgs', 'NdbDatabaseRestoreLcmConfigArgsDict']]]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreLinkedDatabaseArgs', 'NdbDatabaseRestoreLinkedDatabaseArgsDict']]]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestorePropertyArgs', 'NdbDatabaseRestorePropertyArgsDict']]]] properties: properties of database created
        :param pulumi.Input[_builtins.int] restore_version: helps to restore the database with same config.
        :param pulumi.Input[_builtins.str] snapshot_id: snapshot id from you want to use for restoring the instance
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTagArgs', 'NdbDatabaseRestoreTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseRestoreTimeMachineArgs', 'NdbDatabaseRestoreTimeMachineArgsDict']]]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] time_zone_pitr: timezone . Should be used with  `user_pitr_timestamp`
        :param pulumi.Input[_builtins.str] type: type of database
        :param pulumi.Input[_builtins.str] user_pitr_timestamp: the time to which you want to restore your instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbDatabaseRestoreState.__new__(_NdbDatabaseRestoreState)

        __props__.__dict__["clone"] = clone
        __props__.__dict__["database_cluster_type"] = database_cluster_type
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_instance_id"] = database_instance_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_nodes"] = database_nodes
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["dbserver_logical_cluster"] = dbserver_logical_cluster
        __props__.__dict__["dbserver_logical_cluster_id"] = dbserver_logical_cluster_id
        __props__.__dict__["description"] = description
        __props__.__dict__["infos"] = infos
        __props__.__dict__["latest_snapshot"] = latest_snapshot
        __props__.__dict__["lcm_configs"] = lcm_configs
        __props__.__dict__["linked_databases"] = linked_databases
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_database_id"] = parent_database_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["restore_version"] = restore_version
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["time_machines"] = time_machines
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["time_zone_pitr"] = time_zone_pitr
        __props__.__dict__["type"] = type
        __props__.__dict__["user_pitr_timestamp"] = user_pitr_timestamp
        return NdbDatabaseRestore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[_builtins.bool]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        database id
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceId")
    def database_instance_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "database_instance_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreDatabaseNode']]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        description of database instance
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def infos(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreInfo']]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        latest snapshot id
        """
        return pulumi.get(self, "latest_snapshot")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreLcmConfig']]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreLinkedDatabase']]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreProperty']]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="restoreVersion")
    def restore_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        helps to restore the database with same config.
        """
        return pulumi.get(self, "restore_version")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        snapshot id from you want to use for restoring the instance
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreTag']]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseRestoreTimeMachine']]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="timeZonePitr")
    def time_zone_pitr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        timezone . Should be used with  `user_pitr_timestamp`
        """
        return pulumi.get(self, "time_zone_pitr")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of database
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userPitrTimestamp")
    def user_pitr_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the time to which you want to restore your instance.
        """
        return pulumi.get(self, "user_pitr_timestamp")

