# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbDatabaseScaleArgs', 'NdbDatabaseScale']

@pulumi.input_type
class NdbDatabaseScaleArgs:
    def __init__(__self__, *,
                 application_type: pulumi.Input[_builtins.str],
                 data_storage_size: pulumi.Input[_builtins.int],
                 database_uuid: pulumi.Input[_builtins.str],
                 post_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]] = None):
        """
        The set of arguments for constructing a NdbDatabaseScale resource.
        :param pulumi.Input[_builtins.str] application_type: type of instance. eg: postgres_database
        :param pulumi.Input[_builtins.int] data_storage_size: data area (in GiB) to be added to the existing database.
        :param pulumi.Input[_builtins.str] database_uuid: Database id
        :param pulumi.Input[_builtins.str] post_script_cmd: post script command
        :param pulumi.Input[_builtins.str] pre_script_cmd: pre script command
        :param pulumi.Input[_builtins.int] scale_count: scale count helps to scale the same instance with same config
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "data_storage_size", data_storage_size)
        pulumi.set(__self__, "database_uuid", database_uuid)
        if post_script_cmd is not None:
            pulumi.set(__self__, "post_script_cmd", post_script_cmd)
        if pre_script_cmd is not None:
            pulumi.set(__self__, "pre_script_cmd", pre_script_cmd)
        if scale_count is not None:
            pulumi.set(__self__, "scale_count", scale_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Input[_builtins.str]:
        """
        type of instance. eg: postgres_database
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_type", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSize")
    def data_storage_size(self) -> pulumi.Input[_builtins.int]:
        """
        data area (in GiB) to be added to the existing database.
        """
        return pulumi.get(self, "data_storage_size")

    @data_storage_size.setter
    def data_storage_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="databaseUuid")
    def database_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        Database id
        """
        return pulumi.get(self, "database_uuid")

    @database_uuid.setter
    def database_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_uuid", value)

    @_builtins.property
    @pulumi.getter(name="postScriptCmd")
    def post_script_cmd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        post script command
        """
        return pulumi.get(self, "post_script_cmd")

    @post_script_cmd.setter
    def post_script_cmd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_script_cmd", value)

    @_builtins.property
    @pulumi.getter(name="preScriptCmd")
    def pre_script_cmd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        pre script command
        """
        return pulumi.get(self, "pre_script_cmd")

    @pre_script_cmd.setter
    def pre_script_cmd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_script_cmd", value)

    @_builtins.property
    @pulumi.getter(name="scaleCount")
    def scale_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scale count helps to scale the same instance with same config
        """
        return pulumi.get(self, "scale_count")

    @scale_count.setter
    def scale_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_count", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NdbDatabaseScaleState:
    def __init__(__self__, *,
                 application_type: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleDatabaseNodeArgs']]]] = None,
                 database_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 databasetype: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleInfoArgs']]]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLcmConfigArgs']]]] = None,
                 linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLinkedDatabaseArgs']]]] = None,
                 metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 post_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScalePropertyArgs']]]] = None,
                 scale_count: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machines: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTimeMachineArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbDatabaseScale resources.
        :param pulumi.Input[_builtins.str] application_type: type of instance. eg: postgres_database
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.int] data_storage_size: data area (in GiB) to be added to the existing database.
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleDatabaseNodeArgs']]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_uuid: Database id
        :param pulumi.Input[_builtins.str] databasetype: type of database
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.str] description: description of database instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleInfoArgs']]] infos: info of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLcmConfigArgs']]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLinkedDatabaseArgs']]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[_builtins.str] post_script_cmd: post script command
        :param pulumi.Input[_builtins.str] pre_script_cmd: pre script command
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScalePropertyArgs']]] properties: properties of database created
        :param pulumi.Input[_builtins.int] scale_count: scale count helps to scale the same instance with same config
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTimeMachineArgs']]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] type: type of database
        """
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if data_storage_size is not None:
            pulumi.set(__self__, "data_storage_size", data_storage_size)
        if database_cluster_type is not None:
            pulumi.set(__self__, "database_cluster_type", database_cluster_type)
        if database_instance_id is not None:
            pulumi.set(__self__, "database_instance_id", database_instance_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_nodes is not None:
            pulumi.set(__self__, "database_nodes", database_nodes)
        if database_uuid is not None:
            pulumi.set(__self__, "database_uuid", database_uuid)
        if databasetype is not None:
            pulumi.set(__self__, "databasetype", databasetype)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_logical_cluster is not None:
            pulumi.set(__self__, "dbserver_logical_cluster", dbserver_logical_cluster)
        if dbserver_logical_cluster_id is not None:
            pulumi.set(__self__, "dbserver_logical_cluster_id", dbserver_logical_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if linked_databases is not None:
            pulumi.set(__self__, "linked_databases", linked_databases)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_database_id is not None:
            pulumi.set(__self__, "parent_database_id", parent_database_id)
        if parent_source_database_id is not None:
            pulumi.set(__self__, "parent_source_database_id", parent_source_database_id)
        if post_script_cmd is not None:
            pulumi.set(__self__, "post_script_cmd", post_script_cmd)
        if pre_script_cmd is not None:
            pulumi.set(__self__, "pre_script_cmd", pre_script_cmd)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if scale_count is not None:
            pulumi.set(__self__, "scale_count", scale_count)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machines is not None:
            pulumi.set(__self__, "time_machines", time_machines)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of instance. eg: postgres_database
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_type", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSize")
    def data_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        data area (in GiB) to be added to the existing database.
        """
        return pulumi.get(self, "data_storage_size")

    @data_storage_size.setter
    def data_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @database_cluster_type.setter
    def database_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceId")
    def database_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "database_instance_id")

    @database_instance_id.setter
    def database_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleDatabaseNodeArgs']]]]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @database_nodes.setter
    def database_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleDatabaseNodeArgs']]]]):
        pulumi.set(self, "database_nodes", value)

    @_builtins.property
    @pulumi.getter(name="databaseUuid")
    def database_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database id
        """
        return pulumi.get(self, "database_uuid")

    @database_uuid.setter
    def database_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_uuid", value)

    @_builtins.property
    @pulumi.getter
    def databasetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of database
        """
        return pulumi.get(self, "databasetype")

    @databasetype.setter
    def databasetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "databasetype", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @dbserver_logical_cluster.setter
    def dbserver_logical_cluster(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dbserver_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @dbserver_logical_cluster_id.setter
    def dbserver_logical_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_logical_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of database instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleInfoArgs']]]]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @infos.setter
    def infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleInfoArgs']]]]):
        pulumi.set(self, "infos", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLcmConfigArgs']]]]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLinkedDatabaseArgs']]]]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @linked_databases.setter
    def linked_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleLinkedDatabaseArgs']]]]):
        pulumi.set(self, "linked_databases", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @parent_database_id.setter
    def parent_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_database_id", value)

    @_builtins.property
    @pulumi.getter(name="parentSourceDatabaseId")
    def parent_source_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "parent_source_database_id")

    @parent_source_database_id.setter
    def parent_source_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_source_database_id", value)

    @_builtins.property
    @pulumi.getter(name="postScriptCmd")
    def post_script_cmd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        post script command
        """
        return pulumi.get(self, "post_script_cmd")

    @post_script_cmd.setter
    def post_script_cmd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "post_script_cmd", value)

    @_builtins.property
    @pulumi.getter(name="preScriptCmd")
    def pre_script_cmd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        pre script command
        """
        return pulumi.get(self, "pre_script_cmd")

    @pre_script_cmd.setter
    def pre_script_cmd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_script_cmd", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScalePropertyArgs']]]]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScalePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="scaleCount")
    def scale_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scale count helps to scale the same instance with same config
        """
        return pulumi.get(self, "scale_count")

    @scale_count.setter
    def scale_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_count", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTimeMachineArgs']]]]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @time_machines.setter
    def time_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseScaleTimeMachineArgs']]]]):
        pulumi.set(self, "time_machines", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of database
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("nutanix:index/ndbDatabaseScale:NdbDatabaseScale")
class NdbDatabaseScale(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 database_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 post_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTagArgs', 'NdbDatabaseScaleTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a resource to scale the database instance based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # resource to scale the database
        scale = nutanix.NdbDatabaseScale("scale",
            application_type="{{ Application Type }}",
            database_uuid="{{ database_id }}",
            data_storage_size=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_type: type of instance. eg: postgres_database
        :param pulumi.Input[_builtins.int] data_storage_size: data area (in GiB) to be added to the existing database.
        :param pulumi.Input[_builtins.str] database_uuid: Database id
        :param pulumi.Input[_builtins.str] post_script_cmd: post script command
        :param pulumi.Input[_builtins.str] pre_script_cmd: pre script command
        :param pulumi.Input[_builtins.int] scale_count: scale count helps to scale the same instance with same config
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTagArgs', 'NdbDatabaseScaleTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbDatabaseScaleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to scale the database instance based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # resource to scale the database
        scale = nutanix.NdbDatabaseScale("scale",
            application_type="{{ Application Type }}",
            database_uuid="{{ database_id }}",
            data_storage_size=1)
        ```

        :param str resource_name: The name of the resource.
        :param NdbDatabaseScaleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbDatabaseScaleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 database_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 post_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTagArgs', 'NdbDatabaseScaleTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbDatabaseScaleArgs.__new__(NdbDatabaseScaleArgs)

            if application_type is None and not opts.urn:
                raise TypeError("Missing required property 'application_type'")
            __props__.__dict__["application_type"] = application_type
            if data_storage_size is None and not opts.urn:
                raise TypeError("Missing required property 'data_storage_size'")
            __props__.__dict__["data_storage_size"] = data_storage_size
            if database_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'database_uuid'")
            __props__.__dict__["database_uuid"] = database_uuid
            __props__.__dict__["post_script_cmd"] = post_script_cmd
            __props__.__dict__["pre_script_cmd"] = pre_script_cmd
            __props__.__dict__["scale_count"] = scale_count
            __props__.__dict__["tags"] = tags
            __props__.__dict__["clone"] = None
            __props__.__dict__["database_cluster_type"] = None
            __props__.__dict__["database_instance_id"] = None
            __props__.__dict__["database_name"] = None
            __props__.__dict__["database_nodes"] = None
            __props__.__dict__["databasetype"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["dbserver_logical_cluster"] = None
            __props__.__dict__["dbserver_logical_cluster_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["infos"] = None
            __props__.__dict__["lcm_configs"] = None
            __props__.__dict__["linked_databases"] = None
            __props__.__dict__["metric"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["parent_database_id"] = None
            __props__.__dict__["parent_source_database_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_machine_id"] = None
            __props__.__dict__["time_machines"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["type"] = None
        super(NdbDatabaseScale, __self__).__init__(
            'nutanix:index/ndbDatabaseScale:NdbDatabaseScale',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_type: Optional[pulumi.Input[_builtins.str]] = None,
            clone: Optional[pulumi.Input[_builtins.bool]] = None,
            data_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            database_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleDatabaseNodeArgs', 'NdbDatabaseScaleDatabaseNodeArgsDict']]]]] = None,
            database_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            databasetype: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleInfoArgs', 'NdbDatabaseScaleInfoArgsDict']]]]] = None,
            lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleLcmConfigArgs', 'NdbDatabaseScaleLcmConfigArgsDict']]]]] = None,
            linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleLinkedDatabaseArgs', 'NdbDatabaseScaleLinkedDatabaseArgsDict']]]]] = None,
            metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            post_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
            pre_script_cmd: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScalePropertyArgs', 'NdbDatabaseScalePropertyArgsDict']]]]] = None,
            scale_count: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTagArgs', 'NdbDatabaseScaleTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_machines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTimeMachineArgs', 'NdbDatabaseScaleTimeMachineArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbDatabaseScale':
        """
        Get an existing NdbDatabaseScale resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_type: type of instance. eg: postgres_database
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.int] data_storage_size: data area (in GiB) to be added to the existing database.
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleDatabaseNodeArgs', 'NdbDatabaseScaleDatabaseNodeArgsDict']]]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_uuid: Database id
        :param pulumi.Input[_builtins.str] databasetype: type of database
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.str] description: description of database instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleInfoArgs', 'NdbDatabaseScaleInfoArgsDict']]]] infos: info of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleLcmConfigArgs', 'NdbDatabaseScaleLcmConfigArgsDict']]]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleLinkedDatabaseArgs', 'NdbDatabaseScaleLinkedDatabaseArgsDict']]]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[_builtins.str] post_script_cmd: post script command
        :param pulumi.Input[_builtins.str] pre_script_cmd: pre script command
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScalePropertyArgs', 'NdbDatabaseScalePropertyArgsDict']]]] properties: properties of database created
        :param pulumi.Input[_builtins.int] scale_count: scale count helps to scale the same instance with same config
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTagArgs', 'NdbDatabaseScaleTagArgsDict']]]] tags: allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseScaleTimeMachineArgs', 'NdbDatabaseScaleTimeMachineArgsDict']]]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] type: type of database
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbDatabaseScaleState.__new__(_NdbDatabaseScaleState)

        __props__.__dict__["application_type"] = application_type
        __props__.__dict__["clone"] = clone
        __props__.__dict__["data_storage_size"] = data_storage_size
        __props__.__dict__["database_cluster_type"] = database_cluster_type
        __props__.__dict__["database_instance_id"] = database_instance_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_nodes"] = database_nodes
        __props__.__dict__["database_uuid"] = database_uuid
        __props__.__dict__["databasetype"] = databasetype
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["dbserver_logical_cluster"] = dbserver_logical_cluster
        __props__.__dict__["dbserver_logical_cluster_id"] = dbserver_logical_cluster_id
        __props__.__dict__["description"] = description
        __props__.__dict__["infos"] = infos
        __props__.__dict__["lcm_configs"] = lcm_configs
        __props__.__dict__["linked_databases"] = linked_databases
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_database_id"] = parent_database_id
        __props__.__dict__["parent_source_database_id"] = parent_source_database_id
        __props__.__dict__["post_script_cmd"] = post_script_cmd
        __props__.__dict__["pre_script_cmd"] = pre_script_cmd
        __props__.__dict__["properties"] = properties
        __props__.__dict__["scale_count"] = scale_count
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["time_machines"] = time_machines
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        return NdbDatabaseScale(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Output[_builtins.str]:
        """
        type of instance. eg: postgres_database
        """
        return pulumi.get(self, "application_type")

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[_builtins.bool]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter(name="dataStorageSize")
    def data_storage_size(self) -> pulumi.Output[_builtins.int]:
        """
        data area (in GiB) to be added to the existing database.
        """
        return pulumi.get(self, "data_storage_size")

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceId")
    def database_instance_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "database_instance_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleDatabaseNode']]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @_builtins.property
    @pulumi.getter(name="databaseUuid")
    def database_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Database id
        """
        return pulumi.get(self, "database_uuid")

    @_builtins.property
    @pulumi.getter
    def databasetype(self) -> pulumi.Output[_builtins.str]:
        """
        type of database
        """
        return pulumi.get(self, "databasetype")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        description of database instance
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def infos(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleInfo']]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleLcmConfig']]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleLinkedDatabase']]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @_builtins.property
    @pulumi.getter(name="parentSourceDatabaseId")
    def parent_source_database_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "parent_source_database_id")

    @_builtins.property
    @pulumi.getter(name="postScriptCmd")
    def post_script_cmd(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        post script command
        """
        return pulumi.get(self, "post_script_cmd")

    @_builtins.property
    @pulumi.getter(name="preScriptCmd")
    def pre_script_cmd(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        pre script command
        """
        return pulumi.get(self, "pre_script_cmd")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleProperty']]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="scaleCount")
    def scale_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        scale count helps to scale the same instance with same config
        """
        return pulumi.get(self, "scale_count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleTag']]:
        """
        allows you to assign metadata to entities (clones, time machines, databases, and database servers) by using tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseScaleTimeMachine']]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of database
        """
        return pulumi.get(self, "type")

