# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbDatabaseSnapshotArgs', 'NdbDatabaseSnapshot']

@pulumi.input_type
class NdbDatabaseSnapshotArgs:
    def __init__(__self__, *,
                 expiry_date_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remove_schedule_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 replicate_to_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbDatabaseSnapshot resource.
        :param pulumi.Input[_builtins.str] expiry_date_timezone: Default is set to Asia/Calcutta
        :param pulumi.Input[_builtins.str] name: Snapshot name. Default value is era_manual_snapshot.
        :param pulumi.Input[_builtins.int] remove_schedule_in_days: Removal schedule after which the snapshot should be removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicate_to_clusters: snapshots to be replicated to clusters.
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine Id
        :param pulumi.Input[_builtins.str] time_machine_name: Time Machine Name
        """
        if expiry_date_timezone is not None:
            pulumi.set(__self__, "expiry_date_timezone", expiry_date_timezone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remove_schedule_in_days is not None:
            pulumi.set(__self__, "remove_schedule_in_days", remove_schedule_in_days)
        if replicate_to_clusters is not None:
            pulumi.set(__self__, "replicate_to_clusters", replicate_to_clusters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machine_name is not None:
            pulumi.set(__self__, "time_machine_name", time_machine_name)

    @_builtins.property
    @pulumi.getter(name="expiryDateTimezone")
    def expiry_date_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default is set to Asia/Calcutta
        """
        return pulumi.get(self, "expiry_date_timezone")

    @expiry_date_timezone.setter
    def expiry_date_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_date_timezone", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot name. Default value is era_manual_snapshot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="removeScheduleInDays")
    def remove_schedule_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Removal schedule after which the snapshot should be removed.
        """
        return pulumi.get(self, "remove_schedule_in_days")

    @remove_schedule_in_days.setter
    def remove_schedule_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remove_schedule_in_days", value)

    @_builtins.property
    @pulumi.getter(name="replicateToClusters")
    def replicate_to_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        snapshots to be replicated to clusters.
        """
        return pulumi.get(self, "replicate_to_clusters")

    @replicate_to_clusters.setter
    def replicate_to_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replicate_to_clusters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine Id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine Name
        """
        return pulumi.get(self, "time_machine_name")

    @time_machine_name.setter
    def time_machine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_name", value)


@pulumi.input_type
class _NdbDatabaseSnapshotState:
    def __init__(__self__, *,
                 app_info_version: Optional[pulumi.Input[_builtins.str]] = None,
                 applicable_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 database_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_storage_metadata_version: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_date_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 from_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotLcmConfigArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 parent_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 processed: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotPropertyArgs']]]] = None,
                 protection_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remove_schedule_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 replicate_to_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replicated_snapshots: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 santized: Optional[pulumi.Input[_builtins.bool]] = None,
                 santized_from_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 santized_snapshots: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_family: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_timestamp_date: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 software_database_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 software_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 software_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 to_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbDatabaseSnapshot resources.
        :param pulumi.Input[_builtins.str] app_info_version: App info version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applicable_types: Applicable types
        :param pulumi.Input[_builtins.str] database_node_id: database node id
        :param pulumi.Input[_builtins.bool] database_snapshot: database snapshot
        :param pulumi.Input[_builtins.str] date_created: created date
        :param pulumi.Input[_builtins.str] date_modified: modified date
        :param pulumi.Input[_builtins.str] dbserver_id: dbserver id
        :param pulumi.Input[_builtins.str] dbserver_ip: dbserver ip
        :param pulumi.Input[_builtins.str] dbserver_name: dbserver name
        :param pulumi.Input[_builtins.int] dbserver_storage_metadata_version: dbserver storage metadata version
        :param pulumi.Input[_builtins.str] description: description of snapshot
        :param pulumi.Input[_builtins.str] expiry_date_timezone: Default is set to Asia/Calcutta
        :param pulumi.Input[_builtins.str] from_timestamp: from timestamp
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotLcmConfigArgs']]] lcm_configs: LCM config
        :param pulumi.Input[_builtins.str] name: Snapshot name. Default value is era_manual_snapshot.
        :param pulumi.Input[_builtins.str] nx_cluster_id: nx cluster id
        :param pulumi.Input[_builtins.bool] parent_snapshot: parent snapshot
        :param pulumi.Input[_builtins.str] parent_snapshot_id: parent snapshot id
        :param pulumi.Input[_builtins.bool] processed: processed
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotPropertyArgs']]] properties: properties
        :param pulumi.Input[_builtins.str] protection_domain_id: protection domain
        :param pulumi.Input[_builtins.int] remove_schedule_in_days: Removal schedule after which the snapshot should be removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicate_to_clusters: snapshots to be replicated to clusters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicated_snapshots: replicated snapshots
        :param pulumi.Input[_builtins.str] snapshot_family: snapshot family
        :param pulumi.Input[_builtins.float] snapshot_size: snapshot size
        :param pulumi.Input[_builtins.str] snapshot_timestamp: snapshot timeStamp
        :param pulumi.Input[_builtins.int] snapshot_timestamp_date: snapshot timestamp date
        :param pulumi.Input[_builtins.str] snapshot_uuid: snapshot uuid
        :param pulumi.Input[_builtins.bool] software_database_snapshot: software database snapshot
        :param pulumi.Input[_builtins.str] software_snapshot: software snapshot
        :param pulumi.Input[_builtins.str] software_snapshot_id: software snapshot id
        :param pulumi.Input[_builtins.str] status: status
        :param pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine Id
        :param pulumi.Input[_builtins.str] time_machine_name: Time Machine Name
        :param pulumi.Input[_builtins.str] timezone: timezone
        :param pulumi.Input[_builtins.str] to_timestamp: to timestamp
        :param pulumi.Input[_builtins.str] type: type
        """
        if app_info_version is not None:
            pulumi.set(__self__, "app_info_version", app_info_version)
        if applicable_types is not None:
            pulumi.set(__self__, "applicable_types", applicable_types)
        if database_node_id is not None:
            pulumi.set(__self__, "database_node_id", database_node_id)
        if database_snapshot is not None:
            pulumi.set(__self__, "database_snapshot", database_snapshot)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_id is not None:
            pulumi.set(__self__, "dbserver_id", dbserver_id)
        if dbserver_ip is not None:
            pulumi.set(__self__, "dbserver_ip", dbserver_ip)
        if dbserver_name is not None:
            pulumi.set(__self__, "dbserver_name", dbserver_name)
        if dbserver_storage_metadata_version is not None:
            pulumi.set(__self__, "dbserver_storage_metadata_version", dbserver_storage_metadata_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_date_timezone is not None:
            pulumi.set(__self__, "expiry_date_timezone", expiry_date_timezone)
        if from_timestamp is not None:
            pulumi.set(__self__, "from_timestamp", from_timestamp)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if parent_snapshot is not None:
            pulumi.set(__self__, "parent_snapshot", parent_snapshot)
        if parent_snapshot_id is not None:
            pulumi.set(__self__, "parent_snapshot_id", parent_snapshot_id)
        if processed is not None:
            pulumi.set(__self__, "processed", processed)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protection_domain_id is not None:
            pulumi.set(__self__, "protection_domain_id", protection_domain_id)
        if remove_schedule_in_days is not None:
            pulumi.set(__self__, "remove_schedule_in_days", remove_schedule_in_days)
        if replicate_to_clusters is not None:
            pulumi.set(__self__, "replicate_to_clusters", replicate_to_clusters)
        if replicated_snapshots is not None:
            pulumi.set(__self__, "replicated_snapshots", replicated_snapshots)
        if santized is not None:
            pulumi.set(__self__, "santized", santized)
        if santized_from_snapshot_id is not None:
            pulumi.set(__self__, "santized_from_snapshot_id", santized_from_snapshot_id)
        if santized_snapshots is not None:
            pulumi.set(__self__, "santized_snapshots", santized_snapshots)
        if snapshot_family is not None:
            pulumi.set(__self__, "snapshot_family", snapshot_family)
        if snapshot_size is not None:
            pulumi.set(__self__, "snapshot_size", snapshot_size)
        if snapshot_timestamp is not None:
            pulumi.set(__self__, "snapshot_timestamp", snapshot_timestamp)
        if snapshot_timestamp_date is not None:
            pulumi.set(__self__, "snapshot_timestamp_date", snapshot_timestamp_date)
        if snapshot_uuid is not None:
            pulumi.set(__self__, "snapshot_uuid", snapshot_uuid)
        if software_database_snapshot is not None:
            pulumi.set(__self__, "software_database_snapshot", software_database_snapshot)
        if software_snapshot is not None:
            pulumi.set(__self__, "software_snapshot", software_snapshot)
        if software_snapshot_id is not None:
            pulumi.set(__self__, "software_snapshot_id", software_snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machine_name is not None:
            pulumi.set(__self__, "time_machine_name", time_machine_name)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if to_timestamp is not None:
            pulumi.set(__self__, "to_timestamp", to_timestamp)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="appInfoVersion")
    def app_info_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App info version
        """
        return pulumi.get(self, "app_info_version")

    @app_info_version.setter
    def app_info_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_info_version", value)

    @_builtins.property
    @pulumi.getter(name="applicableTypes")
    def applicable_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Applicable types
        """
        return pulumi.get(self, "applicable_types")

    @applicable_types.setter
    def applicable_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applicable_types", value)

    @_builtins.property
    @pulumi.getter(name="databaseNodeId")
    def database_node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database node id
        """
        return pulumi.get(self, "database_node_id")

    @database_node_id.setter
    def database_node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_node_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseSnapshot")
    def database_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        database snapshot
        """
        return pulumi.get(self, "database_snapshot")

    @database_snapshot.setter
    def database_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "database_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        created date
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        modified date
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver id
        """
        return pulumi.get(self, "dbserver_id")

    @dbserver_id.setter
    def dbserver_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_id", value)

    @_builtins.property
    @pulumi.getter(name="dbserverIp")
    def dbserver_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver ip
        """
        return pulumi.get(self, "dbserver_ip")

    @dbserver_ip.setter
    def dbserver_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_ip", value)

    @_builtins.property
    @pulumi.getter(name="dbserverName")
    def dbserver_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver name
        """
        return pulumi.get(self, "dbserver_name")

    @dbserver_name.setter
    def dbserver_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_name", value)

    @_builtins.property
    @pulumi.getter(name="dbserverStorageMetadataVersion")
    def dbserver_storage_metadata_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        dbserver storage metadata version
        """
        return pulumi.get(self, "dbserver_storage_metadata_version")

    @dbserver_storage_metadata_version.setter
    def dbserver_storage_metadata_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dbserver_storage_metadata_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of snapshot
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiryDateTimezone")
    def expiry_date_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default is set to Asia/Calcutta
        """
        return pulumi.get(self, "expiry_date_timezone")

    @expiry_date_timezone.setter
    def expiry_date_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_date_timezone", value)

    @_builtins.property
    @pulumi.getter(name="fromTimestamp")
    def from_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        from timestamp
        """
        return pulumi.get(self, "from_timestamp")

    @from_timestamp.setter
    def from_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "from_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotLcmConfigArgs']]]]:
        """
        LCM config
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot name. Default value is era_manual_snapshot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        nx cluster id
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="parentSnapshot")
    def parent_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        parent snapshot
        """
        return pulumi.get(self, "parent_snapshot")

    @parent_snapshot.setter
    def parent_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "parent_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="parentSnapshotId")
    def parent_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent snapshot id
        """
        return pulumi.get(self, "parent_snapshot_id")

    @parent_snapshot_id.setter
    def parent_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def processed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        processed
        """
        return pulumi.get(self, "processed")

    @processed.setter
    def processed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "processed", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotPropertyArgs']]]]:
        """
        properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="protectionDomainId")
    def protection_domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        protection domain
        """
        return pulumi.get(self, "protection_domain_id")

    @protection_domain_id.setter
    def protection_domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_domain_id", value)

    @_builtins.property
    @pulumi.getter(name="removeScheduleInDays")
    def remove_schedule_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Removal schedule after which the snapshot should be removed.
        """
        return pulumi.get(self, "remove_schedule_in_days")

    @remove_schedule_in_days.setter
    def remove_schedule_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remove_schedule_in_days", value)

    @_builtins.property
    @pulumi.getter(name="replicateToClusters")
    def replicate_to_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        snapshots to be replicated to clusters.
        """
        return pulumi.get(self, "replicate_to_clusters")

    @replicate_to_clusters.setter
    def replicate_to_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replicate_to_clusters", value)

    @_builtins.property
    @pulumi.getter(name="replicatedSnapshots")
    def replicated_snapshots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        replicated snapshots
        """
        return pulumi.get(self, "replicated_snapshots")

    @replicated_snapshots.setter
    def replicated_snapshots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replicated_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def santized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "santized")

    @santized.setter
    def santized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "santized", value)

    @_builtins.property
    @pulumi.getter(name="santizedFromSnapshotId")
    def santized_from_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "santized_from_snapshot_id")

    @santized_from_snapshot_id.setter
    def santized_from_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "santized_from_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="santizedSnapshots")
    def santized_snapshots(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "santized_snapshots")

    @santized_snapshots.setter
    def santized_snapshots(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "santized_snapshots", value)

    @_builtins.property
    @pulumi.getter(name="snapshotFamily")
    def snapshot_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot family
        """
        return pulumi.get(self, "snapshot_family")

    @snapshot_family.setter
    def snapshot_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_family", value)

    @_builtins.property
    @pulumi.getter(name="snapshotSize")
    def snapshot_size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        snapshot size
        """
        return pulumi.get(self, "snapshot_size")

    @snapshot_size.setter
    def snapshot_size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "snapshot_size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotTimestamp")
    def snapshot_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot timeStamp
        """
        return pulumi.get(self, "snapshot_timestamp")

    @snapshot_timestamp.setter
    def snapshot_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="snapshotTimestampDate")
    def snapshot_timestamp_date(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        snapshot timestamp date
        """
        return pulumi.get(self, "snapshot_timestamp_date")

    @snapshot_timestamp_date.setter
    def snapshot_timestamp_date(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_timestamp_date", value)

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        snapshot uuid
        """
        return pulumi.get(self, "snapshot_uuid")

    @snapshot_uuid.setter
    def snapshot_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_uuid", value)

    @_builtins.property
    @pulumi.getter(name="softwareDatabaseSnapshot")
    def software_database_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        software database snapshot
        """
        return pulumi.get(self, "software_database_snapshot")

    @software_database_snapshot.setter
    def software_database_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "software_database_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="softwareSnapshot")
    def software_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        software snapshot
        """
        return pulumi.get(self, "software_snapshot")

    @software_snapshot.setter
    def software_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="softwareSnapshotId")
    def software_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        software snapshot id
        """
        return pulumi.get(self, "software_snapshot_id")

    @software_snapshot_id.setter
    def software_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDatabaseSnapshotTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine Id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine Name
        """
        return pulumi.get(self, "time_machine_name")

    @time_machine_name.setter
    def time_machine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_name", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="toTimestamp")
    def to_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        to timestamp
        """
        return pulumi.get(self, "to_timestamp")

    @to_timestamp.setter
    def to_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("nutanix:index/ndbDatabaseSnapshot:NdbDatabaseSnapshot")
class NdbDatabaseSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_date_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remove_schedule_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 replicate_to_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotTagArgs', 'NdbDatabaseSnapshotTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to perform the snapshot for database instance based on the input parameters.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] expiry_date_timezone: Default is set to Asia/Calcutta
        :param pulumi.Input[_builtins.str] name: Snapshot name. Default value is era_manual_snapshot.
        :param pulumi.Input[_builtins.int] remove_schedule_in_days: Removal schedule after which the snapshot should be removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicate_to_clusters: snapshots to be replicated to clusters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotTagArgs', 'NdbDatabaseSnapshotTagArgsDict']]]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine Id
        :param pulumi.Input[_builtins.str] time_machine_name: Time Machine Name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NdbDatabaseSnapshotArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to perform the snapshot for database instance based on the input parameters.

        :param str resource_name: The name of the resource.
        :param NdbDatabaseSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbDatabaseSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_date_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remove_schedule_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 replicate_to_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotTagArgs', 'NdbDatabaseSnapshotTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbDatabaseSnapshotArgs.__new__(NdbDatabaseSnapshotArgs)

            __props__.__dict__["expiry_date_timezone"] = expiry_date_timezone
            __props__.__dict__["name"] = name
            __props__.__dict__["remove_schedule_in_days"] = remove_schedule_in_days
            __props__.__dict__["replicate_to_clusters"] = replicate_to_clusters
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_machine_id"] = time_machine_id
            __props__.__dict__["time_machine_name"] = time_machine_name
            __props__.__dict__["app_info_version"] = None
            __props__.__dict__["applicable_types"] = None
            __props__.__dict__["database_node_id"] = None
            __props__.__dict__["database_snapshot"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["dbserver_id"] = None
            __props__.__dict__["dbserver_ip"] = None
            __props__.__dict__["dbserver_name"] = None
            __props__.__dict__["dbserver_storage_metadata_version"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["from_timestamp"] = None
            __props__.__dict__["lcm_configs"] = None
            __props__.__dict__["nx_cluster_id"] = None
            __props__.__dict__["parent_snapshot"] = None
            __props__.__dict__["parent_snapshot_id"] = None
            __props__.__dict__["processed"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["protection_domain_id"] = None
            __props__.__dict__["replicated_snapshots"] = None
            __props__.__dict__["santized"] = None
            __props__.__dict__["santized_from_snapshot_id"] = None
            __props__.__dict__["santized_snapshots"] = None
            __props__.__dict__["snapshot_family"] = None
            __props__.__dict__["snapshot_size"] = None
            __props__.__dict__["snapshot_timestamp"] = None
            __props__.__dict__["snapshot_timestamp_date"] = None
            __props__.__dict__["snapshot_uuid"] = None
            __props__.__dict__["software_database_snapshot"] = None
            __props__.__dict__["software_snapshot"] = None
            __props__.__dict__["software_snapshot_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["timezone"] = None
            __props__.__dict__["to_timestamp"] = None
            __props__.__dict__["type"] = None
        super(NdbDatabaseSnapshot, __self__).__init__(
            'nutanix:index/ndbDatabaseSnapshot:NdbDatabaseSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_info_version: Optional[pulumi.Input[_builtins.str]] = None,
            applicable_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            database_node_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_id: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_ip: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_name: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_storage_metadata_version: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expiry_date_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            from_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotLcmConfigArgs', 'NdbDatabaseSnapshotLcmConfigArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            parent_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            processed: Optional[pulumi.Input[_builtins.bool]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotPropertyArgs', 'NdbDatabaseSnapshotPropertyArgsDict']]]]] = None,
            protection_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            remove_schedule_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            replicate_to_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            replicated_snapshots: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            santized: Optional[pulumi.Input[_builtins.bool]] = None,
            santized_from_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            santized_snapshots: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_family: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_size: Optional[pulumi.Input[_builtins.float]] = None,
            snapshot_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_timestamp_date: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            software_database_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            software_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
            software_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotTagArgs', 'NdbDatabaseSnapshotTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_machine_name: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            to_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbDatabaseSnapshot':
        """
        Get an existing NdbDatabaseSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_info_version: App info version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applicable_types: Applicable types
        :param pulumi.Input[_builtins.str] database_node_id: database node id
        :param pulumi.Input[_builtins.bool] database_snapshot: database snapshot
        :param pulumi.Input[_builtins.str] date_created: created date
        :param pulumi.Input[_builtins.str] date_modified: modified date
        :param pulumi.Input[_builtins.str] dbserver_id: dbserver id
        :param pulumi.Input[_builtins.str] dbserver_ip: dbserver ip
        :param pulumi.Input[_builtins.str] dbserver_name: dbserver name
        :param pulumi.Input[_builtins.int] dbserver_storage_metadata_version: dbserver storage metadata version
        :param pulumi.Input[_builtins.str] description: description of snapshot
        :param pulumi.Input[_builtins.str] expiry_date_timezone: Default is set to Asia/Calcutta
        :param pulumi.Input[_builtins.str] from_timestamp: from timestamp
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotLcmConfigArgs', 'NdbDatabaseSnapshotLcmConfigArgsDict']]]] lcm_configs: LCM config
        :param pulumi.Input[_builtins.str] name: Snapshot name. Default value is era_manual_snapshot.
        :param pulumi.Input[_builtins.str] nx_cluster_id: nx cluster id
        :param pulumi.Input[_builtins.bool] parent_snapshot: parent snapshot
        :param pulumi.Input[_builtins.str] parent_snapshot_id: parent snapshot id
        :param pulumi.Input[_builtins.bool] processed: processed
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotPropertyArgs', 'NdbDatabaseSnapshotPropertyArgsDict']]]] properties: properties
        :param pulumi.Input[_builtins.str] protection_domain_id: protection domain
        :param pulumi.Input[_builtins.int] remove_schedule_in_days: Removal schedule after which the snapshot should be removed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicate_to_clusters: snapshots to be replicated to clusters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicated_snapshots: replicated snapshots
        :param pulumi.Input[_builtins.str] snapshot_family: snapshot family
        :param pulumi.Input[_builtins.float] snapshot_size: snapshot size
        :param pulumi.Input[_builtins.str] snapshot_timestamp: snapshot timeStamp
        :param pulumi.Input[_builtins.int] snapshot_timestamp_date: snapshot timestamp date
        :param pulumi.Input[_builtins.str] snapshot_uuid: snapshot uuid
        :param pulumi.Input[_builtins.bool] software_database_snapshot: software database snapshot
        :param pulumi.Input[_builtins.str] software_snapshot: software snapshot
        :param pulumi.Input[_builtins.str] software_snapshot_id: software snapshot id
        :param pulumi.Input[_builtins.str] status: status
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDatabaseSnapshotTagArgs', 'NdbDatabaseSnapshotTagArgsDict']]]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine Id
        :param pulumi.Input[_builtins.str] time_machine_name: Time Machine Name
        :param pulumi.Input[_builtins.str] timezone: timezone
        :param pulumi.Input[_builtins.str] to_timestamp: to timestamp
        :param pulumi.Input[_builtins.str] type: type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbDatabaseSnapshotState.__new__(_NdbDatabaseSnapshotState)

        __props__.__dict__["app_info_version"] = app_info_version
        __props__.__dict__["applicable_types"] = applicable_types
        __props__.__dict__["database_node_id"] = database_node_id
        __props__.__dict__["database_snapshot"] = database_snapshot
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["dbserver_id"] = dbserver_id
        __props__.__dict__["dbserver_ip"] = dbserver_ip
        __props__.__dict__["dbserver_name"] = dbserver_name
        __props__.__dict__["dbserver_storage_metadata_version"] = dbserver_storage_metadata_version
        __props__.__dict__["description"] = description
        __props__.__dict__["expiry_date_timezone"] = expiry_date_timezone
        __props__.__dict__["from_timestamp"] = from_timestamp
        __props__.__dict__["lcm_configs"] = lcm_configs
        __props__.__dict__["name"] = name
        __props__.__dict__["nx_cluster_id"] = nx_cluster_id
        __props__.__dict__["parent_snapshot"] = parent_snapshot
        __props__.__dict__["parent_snapshot_id"] = parent_snapshot_id
        __props__.__dict__["processed"] = processed
        __props__.__dict__["properties"] = properties
        __props__.__dict__["protection_domain_id"] = protection_domain_id
        __props__.__dict__["remove_schedule_in_days"] = remove_schedule_in_days
        __props__.__dict__["replicate_to_clusters"] = replicate_to_clusters
        __props__.__dict__["replicated_snapshots"] = replicated_snapshots
        __props__.__dict__["santized"] = santized
        __props__.__dict__["santized_from_snapshot_id"] = santized_from_snapshot_id
        __props__.__dict__["santized_snapshots"] = santized_snapshots
        __props__.__dict__["snapshot_family"] = snapshot_family
        __props__.__dict__["snapshot_size"] = snapshot_size
        __props__.__dict__["snapshot_timestamp"] = snapshot_timestamp
        __props__.__dict__["snapshot_timestamp_date"] = snapshot_timestamp_date
        __props__.__dict__["snapshot_uuid"] = snapshot_uuid
        __props__.__dict__["software_database_snapshot"] = software_database_snapshot
        __props__.__dict__["software_snapshot"] = software_snapshot
        __props__.__dict__["software_snapshot_id"] = software_snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["time_machine_name"] = time_machine_name
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["to_timestamp"] = to_timestamp
        __props__.__dict__["type"] = type
        return NdbDatabaseSnapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appInfoVersion")
    def app_info_version(self) -> pulumi.Output[_builtins.str]:
        """
        App info version
        """
        return pulumi.get(self, "app_info_version")

    @_builtins.property
    @pulumi.getter(name="applicableTypes")
    def applicable_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Applicable types
        """
        return pulumi.get(self, "applicable_types")

    @_builtins.property
    @pulumi.getter(name="databaseNodeId")
    def database_node_id(self) -> pulumi.Output[_builtins.str]:
        """
        database node id
        """
        return pulumi.get(self, "database_node_id")

    @_builtins.property
    @pulumi.getter(name="databaseSnapshot")
    def database_snapshot(self) -> pulumi.Output[_builtins.bool]:
        """
        database snapshot
        """
        return pulumi.get(self, "database_snapshot")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        created date
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        modified date
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver id
        """
        return pulumi.get(self, "dbserver_id")

    @_builtins.property
    @pulumi.getter(name="dbserverIp")
    def dbserver_ip(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver ip
        """
        return pulumi.get(self, "dbserver_ip")

    @_builtins.property
    @pulumi.getter(name="dbserverName")
    def dbserver_name(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver name
        """
        return pulumi.get(self, "dbserver_name")

    @_builtins.property
    @pulumi.getter(name="dbserverStorageMetadataVersion")
    def dbserver_storage_metadata_version(self) -> pulumi.Output[_builtins.int]:
        """
        dbserver storage metadata version
        """
        return pulumi.get(self, "dbserver_storage_metadata_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        description of snapshot
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiryDateTimezone")
    def expiry_date_timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default is set to Asia/Calcutta
        """
        return pulumi.get(self, "expiry_date_timezone")

    @_builtins.property
    @pulumi.getter(name="fromTimestamp")
    def from_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        from timestamp
        """
        return pulumi.get(self, "from_timestamp")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseSnapshotLcmConfig']]:
        """
        LCM config
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Snapshot name. Default value is era_manual_snapshot.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        nx cluster id
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="parentSnapshot")
    def parent_snapshot(self) -> pulumi.Output[_builtins.bool]:
        """
        parent snapshot
        """
        return pulumi.get(self, "parent_snapshot")

    @_builtins.property
    @pulumi.getter(name="parentSnapshotId")
    def parent_snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent snapshot id
        """
        return pulumi.get(self, "parent_snapshot_id")

    @_builtins.property
    @pulumi.getter
    def processed(self) -> pulumi.Output[_builtins.bool]:
        """
        processed
        """
        return pulumi.get(self, "processed")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseSnapshotProperty']]:
        """
        properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="protectionDomainId")
    def protection_domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        protection domain
        """
        return pulumi.get(self, "protection_domain_id")

    @_builtins.property
    @pulumi.getter(name="removeScheduleInDays")
    def remove_schedule_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Removal schedule after which the snapshot should be removed.
        """
        return pulumi.get(self, "remove_schedule_in_days")

    @_builtins.property
    @pulumi.getter(name="replicateToClusters")
    def replicate_to_clusters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        snapshots to be replicated to clusters.
        """
        return pulumi.get(self, "replicate_to_clusters")

    @_builtins.property
    @pulumi.getter(name="replicatedSnapshots")
    def replicated_snapshots(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        replicated snapshots
        """
        return pulumi.get(self, "replicated_snapshots")

    @_builtins.property
    @pulumi.getter
    def santized(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "santized")

    @_builtins.property
    @pulumi.getter(name="santizedFromSnapshotId")
    def santized_from_snapshot_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "santized_from_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="santizedSnapshots")
    def santized_snapshots(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "santized_snapshots")

    @_builtins.property
    @pulumi.getter(name="snapshotFamily")
    def snapshot_family(self) -> pulumi.Output[_builtins.str]:
        """
        snapshot family
        """
        return pulumi.get(self, "snapshot_family")

    @_builtins.property
    @pulumi.getter(name="snapshotSize")
    def snapshot_size(self) -> pulumi.Output[_builtins.float]:
        """
        snapshot size
        """
        return pulumi.get(self, "snapshot_size")

    @_builtins.property
    @pulumi.getter(name="snapshotTimestamp")
    def snapshot_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        snapshot timeStamp
        """
        return pulumi.get(self, "snapshot_timestamp")

    @_builtins.property
    @pulumi.getter(name="snapshotTimestampDate")
    def snapshot_timestamp_date(self) -> pulumi.Output[_builtins.int]:
        """
        snapshot timestamp date
        """
        return pulumi.get(self, "snapshot_timestamp_date")

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        snapshot uuid
        """
        return pulumi.get(self, "snapshot_uuid")

    @_builtins.property
    @pulumi.getter(name="softwareDatabaseSnapshot")
    def software_database_snapshot(self) -> pulumi.Output[_builtins.bool]:
        """
        software database snapshot
        """
        return pulumi.get(self, "software_database_snapshot")

    @_builtins.property
    @pulumi.getter(name="softwareSnapshot")
    def software_snapshot(self) -> pulumi.Output[_builtins.str]:
        """
        software snapshot
        """
        return pulumi.get(self, "software_snapshot")

    @_builtins.property
    @pulumi.getter(name="softwareSnapshotId")
    def software_snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        software snapshot id
        """
        return pulumi.get(self, "software_snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbDatabaseSnapshotTag']]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time Machine Id
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter(name="timeMachineName")
    def time_machine_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time Machine Name
        """
        return pulumi.get(self, "time_machine_name")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        timezone
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="toTimestamp")
    def to_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        to timestamp
        """
        return pulumi.get(self, "to_timestamp")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type
        """
        return pulumi.get(self, "type")

