# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbDbserverVmArgs', 'NdbDbserverVm']

@pulumi.input_type
class NdbDbserverVmArgs:
    def __init__(__self__, *,
                 compute_profile_id: pulumi.Input[_builtins.str],
                 database_type: pulumi.Input[_builtins.str],
                 network_profile_id: pulumi.Input[_builtins.str],
                 nx_cluster_id: pulumi.Input[_builtins.str],
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_tasks: Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 software_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_profile_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbDbserverVm resource.
        :param pulumi.Input[_builtins.str] compute_profile_id: Compute profile id.
        :param pulumi.Input[_builtins.str] database_type: database type. Valid values: postgres_database
        :param pulumi.Input[_builtins.str] network_profile_id: Network profile id.
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: Type a description for the database server VM.
        :param pulumi.Input['NdbDbserverVmMaintenanceTasksArgs'] maintenance_tasks: maintenance window configured to enable automated patching.
        :param pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]] postgres_databases: Postgres database server vm
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] software_profile_id: software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        :param pulumi.Input[_builtins.str] software_profile_version_id: SOftware Profile Version Id.
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        """
        pulumi.set(__self__, "compute_profile_id", compute_profile_id)
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "network_profile_id", network_profile_id)
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_vgs is not None:
            pulumi.set(__self__, "delete_vgs", delete_vgs)
        if delete_vm_snapshots is not None:
            pulumi.set(__self__, "delete_vm_snapshots", delete_vm_snapshots)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if maintenance_tasks is not None:
            pulumi.set(__self__, "maintenance_tasks", maintenance_tasks)
        if postgres_databases is not None:
            pulumi.set(__self__, "postgres_databases", postgres_databases)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if software_profile_id is not None:
            pulumi.set(__self__, "software_profile_id", software_profile_id)
        if software_profile_version_id is not None:
            pulumi.set(__self__, "software_profile_version_id", software_profile_version_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compute profile id.
        """
        return pulumi.get(self, "compute_profile_id")

    @compute_profile_id.setter
    def compute_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[_builtins.str]:
        """
        database type. Valid values: postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Network profile id.
        """
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is true
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @delete_vgs.setter
    def delete_vgs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vgs", value)

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @delete_vm_snapshots.setter
    def delete_vm_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vm_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type a description for the database server VM.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTasks")
    def maintenance_tasks(self) -> Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']]:
        """
        maintenance window configured to enable automated patching.
        """
        return pulumi.get(self, "maintenance_tasks")

    @maintenance_tasks.setter
    def maintenance_tasks(self, value: Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']]):
        pulumi.set(self, "maintenance_tasks", value)

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]]:
        """
        Postgres database server vm
        """
        return pulumi.get(self, "postgres_databases")

    @postgres_databases.setter
    def postgres_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]]):
        pulumi.set(self, "postgres_databases", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="softwareProfileId")
    def software_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        """
        return pulumi.get(self, "software_profile_id")

    @software_profile_id.setter
    def software_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="softwareProfileVersionId")
    def software_profile_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SOftware Profile Version Id.
        """
        return pulumi.get(self, "software_profile_version_id")

    @software_profile_version_id.setter
    def software_profile_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_profile_version_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)


@pulumi.input_type
class _NdbDbserverVmState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 era_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
                 era_version: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 maintenance_tasks: Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPropertyArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 software_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_profile_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbDbserverVm resources.
        :param pulumi.Input[_builtins.str] compute_profile_id: Compute profile id.
        :param pulumi.Input[_builtins.str] database_type: database type. Valid values: postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: Type a description for the database server VM.
        :param pulumi.Input['NdbDbserverVmMaintenanceTasksArgs'] maintenance_tasks: maintenance window configured to enable automated patching.
        :param pulumi.Input[_builtins.str] network_profile_id: Network profile id.
        :param pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]] postgres_databases: Postgres database server vm
        :param pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPropertyArgs']]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] software_profile_id: software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        :param pulumi.Input[_builtins.str] software_profile_version_id: SOftware Profile Version Id.
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if compute_profile_id is not None:
            pulumi.set(__self__, "compute_profile_id", compute_profile_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if dbserver_cluster_id is not None:
            pulumi.set(__self__, "dbserver_cluster_id", dbserver_cluster_id)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_vgs is not None:
            pulumi.set(__self__, "delete_vgs", delete_vgs)
        if delete_vm_snapshots is not None:
            pulumi.set(__self__, "delete_vm_snapshots", delete_vm_snapshots)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if era_drive_id is not None:
            pulumi.set(__self__, "era_drive_id", era_drive_id)
        if era_version is not None:
            pulumi.set(__self__, "era_version", era_version)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if latest_snapshot is not None:
            pulumi.set(__self__, "latest_snapshot", latest_snapshot)
        if mac_addresses is not None:
            pulumi.set(__self__, "mac_addresses", mac_addresses)
        if maintenance_tasks is not None:
            pulumi.set(__self__, "maintenance_tasks", maintenance_tasks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile_id is not None:
            pulumi.set(__self__, "network_profile_id", network_profile_id)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if postgres_databases is not None:
            pulumi.set(__self__, "postgres_databases", postgres_databases)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if software_profile_id is not None:
            pulumi.set(__self__, "software_profile_id", software_profile_id)
        if software_profile_version_id is not None:
            pulumi.set(__self__, "software_profile_version_id", software_profile_version_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vm_cluster_name is not None:
            pulumi.set(__self__, "vm_cluster_name", vm_cluster_name)
        if vm_cluster_uuid is not None:
            pulumi.set(__self__, "vm_cluster_uuid", vm_cluster_uuid)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)
        if vm_timezone is not None:
            pulumi.set(__self__, "vm_timezone", vm_timezone)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compute profile id.
        """
        return pulumi.get(self, "compute_profile_id")

    @compute_profile_id.setter
    def compute_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database type. Valid values: postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dbserver_cluster_id")

    @dbserver_cluster_id.setter
    def dbserver_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is true
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @delete_vgs.setter
    def delete_vgs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vgs", value)

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @delete_vm_snapshots.setter
    def delete_vm_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vm_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type a description for the database server VM.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eraDriveId")
    def era_drive_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "era_drive_id")

    @era_drive_id.setter
    def era_drive_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "era_drive_id", value)

    @_builtins.property
    @pulumi.getter(name="eraVersion")
    def era_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "era_version")

    @era_version.setter
    def era_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "era_version", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "latest_snapshot")

    @latest_snapshot.setter
    def latest_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "mac_addresses")

    @mac_addresses.setter
    def mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mac_addresses", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTasks")
    def maintenance_tasks(self) -> Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']]:
        """
        maintenance window configured to enable automated patching.
        """
        return pulumi.get(self, "maintenance_tasks")

    @maintenance_tasks.setter
    def maintenance_tasks(self, value: Optional[pulumi.Input['NdbDbserverVmMaintenanceTasksArgs']]):
        pulumi.set(self, "maintenance_tasks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network profile id.
        """
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]]:
        """
        Postgres database server vm
        """
        return pulumi.get(self, "postgres_databases")

    @postgres_databases.setter
    def postgres_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPostgresDatabaseArgs']]]]):
        pulumi.set(self, "postgres_databases", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPropertyArgs']]]]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="softwareProfileId")
    def software_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        """
        return pulumi.get(self, "software_profile_id")

    @software_profile_id.setter
    def software_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="softwareProfileVersionId")
    def software_profile_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SOftware Profile Version Id.
        """
        return pulumi.get(self, "software_profile_version_id")

    @software_profile_version_id.setter
    def software_profile_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_profile_version_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbDbserverVmTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterName")
    def vm_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_cluster_name")

    @vm_cluster_name.setter
    def vm_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterUuid")
    def vm_cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_cluster_uuid")

    @vm_cluster_uuid.setter
    def vm_cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)

    @_builtins.property
    @pulumi.getter(name="vmTimezone")
    def vm_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_timezone")

    @vm_timezone.setter
    def vm_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_timezone", value)


@pulumi.type_token("nutanix:index/ndbDbserverVm:NdbDbserverVm")
class NdbDbserverVm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmCredentialArgs', 'NdbDbserverVmCredentialArgsDict']]]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_tasks: Optional[pulumi.Input[Union['NdbDbserverVmMaintenanceTasksArgs', 'NdbDbserverVmMaintenanceTasksArgsDict']]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPostgresDatabaseArgs', 'NdbDbserverVmPostgresDatabaseArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 software_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_profile_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmTagArgs', 'NdbDbserverVmTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create database server VMs based on the input parameters. For 1.8.0 release, only postgress database type is qualified and officially supported.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_profile_id: Compute profile id.
        :param pulumi.Input[_builtins.str] database_type: database type. Valid values: postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: Type a description for the database server VM.
        :param pulumi.Input[Union['NdbDbserverVmMaintenanceTasksArgs', 'NdbDbserverVmMaintenanceTasksArgsDict']] maintenance_tasks: maintenance window configured to enable automated patching.
        :param pulumi.Input[_builtins.str] network_profile_id: Network profile id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPostgresDatabaseArgs', 'NdbDbserverVmPostgresDatabaseArgsDict']]]] postgres_databases: Postgres database server vm
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] software_profile_id: software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        :param pulumi.Input[_builtins.str] software_profile_version_id: SOftware Profile Version Id.
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbDbserverVmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create database server VMs based on the input parameters. For 1.8.0 release, only postgress database type is qualified and officially supported.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param NdbDbserverVmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbDbserverVmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmCredentialArgs', 'NdbDbserverVmCredentialArgsDict']]]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintenance_tasks: Optional[pulumi.Input[Union['NdbDbserverVmMaintenanceTasksArgs', 'NdbDbserverVmMaintenanceTasksArgsDict']]] = None,
                 network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPostgresDatabaseArgs', 'NdbDbserverVmPostgresDatabaseArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 software_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 software_profile_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmTagArgs', 'NdbDbserverVmTagArgsDict']]]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbDbserverVmArgs.__new__(NdbDbserverVmArgs)

            if compute_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_profile_id'")
            __props__.__dict__["compute_profile_id"] = compute_profile_id
            __props__.__dict__["credentials"] = credentials
            if database_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_type'")
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["delete"] = delete
            __props__.__dict__["delete_vgs"] = delete_vgs
            __props__.__dict__["delete_vm_snapshots"] = delete_vm_snapshots
            __props__.__dict__["description"] = description
            __props__.__dict__["latest_snapshot"] = latest_snapshot
            __props__.__dict__["maintenance_tasks"] = maintenance_tasks
            if network_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_profile_id'")
            __props__.__dict__["network_profile_id"] = network_profile_id
            if nx_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'nx_cluster_id'")
            __props__.__dict__["nx_cluster_id"] = nx_cluster_id
            __props__.__dict__["postgres_databases"] = postgres_databases
            __props__.__dict__["remove"] = remove
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["soft_remove"] = soft_remove
            __props__.__dict__["software_profile_id"] = software_profile_id
            __props__.__dict__["software_profile_version_id"] = software_profile_version_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_machine_id"] = time_machine_id
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["vm_password"] = None if vm_password is None else pulumi.Output.secret(vm_password)
            __props__.__dict__["client_id"] = None
            __props__.__dict__["dbserver_cluster_id"] = None
            __props__.__dict__["era_drive_id"] = None
            __props__.__dict__["era_version"] = None
            __props__.__dict__["fqdns"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["mac_addresses"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vm_cluster_name"] = None
            __props__.__dict__["vm_cluster_uuid"] = None
            __props__.__dict__["vm_timezone"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["vmPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NdbDbserverVm, __self__).__init__(
            'nutanix:index/ndbDbserverVm:NdbDbserverVm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmCredentialArgs', 'NdbDbserverVmCredentialArgsDict']]]]] = None,
            database_type: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            delete: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            era_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
            era_version: Optional[pulumi.Input[_builtins.str]] = None,
            fqdns: Optional[pulumi.Input[_builtins.str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            latest_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            maintenance_tasks: Optional[pulumi.Input[Union['NdbDbserverVmMaintenanceTasksArgs', 'NdbDbserverVmMaintenanceTasksArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPostgresDatabaseArgs', 'NdbDbserverVmPostgresDatabaseArgsDict']]]]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPropertyArgs', 'NdbDbserverVmPropertyArgsDict']]]]] = None,
            remove: Optional[pulumi.Input[_builtins.bool]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
            software_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            software_profile_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmTagArgs', 'NdbDbserverVmTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vm_password: Optional[pulumi.Input[_builtins.str]] = None,
            vm_timezone: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbDbserverVm':
        """
        Get an existing NdbDbserverVm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_profile_id: Compute profile id.
        :param pulumi.Input[_builtins.str] database_type: database type. Valid values: postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: Type a description for the database server VM.
        :param pulumi.Input[Union['NdbDbserverVmMaintenanceTasksArgs', 'NdbDbserverVmMaintenanceTasksArgsDict']] maintenance_tasks: maintenance window configured to enable automated patching.
        :param pulumi.Input[_builtins.str] network_profile_id: Network profile id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPostgresDatabaseArgs', 'NdbDbserverVmPostgresDatabaseArgsDict']]]] postgres_databases: Postgres database server vm
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbDbserverVmPropertyArgs', 'NdbDbserverVmPropertyArgsDict']]]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is false
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] software_profile_id: software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        :param pulumi.Input[_builtins.str] software_profile_version_id: SOftware Profile Version Id.
        :param pulumi.Input[_builtins.str] time_machine_id: Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbDbserverVmState.__new__(_NdbDbserverVmState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["compute_profile_id"] = compute_profile_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["dbserver_cluster_id"] = dbserver_cluster_id
        __props__.__dict__["delete"] = delete
        __props__.__dict__["delete_vgs"] = delete_vgs
        __props__.__dict__["delete_vm_snapshots"] = delete_vm_snapshots
        __props__.__dict__["description"] = description
        __props__.__dict__["era_drive_id"] = era_drive_id
        __props__.__dict__["era_version"] = era_version
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["latest_snapshot"] = latest_snapshot
        __props__.__dict__["mac_addresses"] = mac_addresses
        __props__.__dict__["maintenance_tasks"] = maintenance_tasks
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile_id"] = network_profile_id
        __props__.__dict__["nx_cluster_id"] = nx_cluster_id
        __props__.__dict__["postgres_databases"] = postgres_databases
        __props__.__dict__["properties"] = properties
        __props__.__dict__["remove"] = remove
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["soft_remove"] = soft_remove
        __props__.__dict__["software_profile_id"] = software_profile_id
        __props__.__dict__["software_profile_version_id"] = software_profile_version_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["type"] = type
        __props__.__dict__["vm_cluster_name"] = vm_cluster_name
        __props__.__dict__["vm_cluster_uuid"] = vm_cluster_uuid
        __props__.__dict__["vm_password"] = vm_password
        __props__.__dict__["vm_timezone"] = vm_timezone
        return NdbDbserverVm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="computeProfileId")
    def compute_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compute profile id.
        """
        return pulumi.get(self, "compute_profile_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[Sequence['outputs.NdbDbserverVmCredential']]]:
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[_builtins.str]:
        """
        database type. Valid values: postgres_database
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "dbserver_cluster_id")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is true
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Type a description for the database server VM.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eraDriveId")
    def era_drive_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "era_drive_id")

    @_builtins.property
    @pulumi.getter(name="eraVersion")
    def era_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "era_version")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="latestSnapshot")
    def latest_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "latest_snapshot")

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "mac_addresses")

    @_builtins.property
    @pulumi.getter(name="maintenanceTasks")
    def maintenance_tasks(self) -> pulumi.Output[Optional['outputs.NdbDbserverVmMaintenanceTasks']]:
        """
        maintenance window configured to enable automated patching.
        """
        return pulumi.get(self, "maintenance_tasks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfileId")
    def network_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Network profile id.
        """
        return pulumi.get(self, "network_profile_id")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> pulumi.Output[Optional[Sequence['outputs.NdbDbserverVmPostgresDatabase']]]:
        """
        Postgres database server vm
        """
        return pulumi.get(self, "postgres_databases")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbDbserverVmProperty']]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is false
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Snapshot id. If not given, it will use latest snapshot to provision db server vm.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @_builtins.property
    @pulumi.getter(name="softwareProfileId")
    def software_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        software profile id you want to provision a database server VM from an existing software profile.Required with software_profile_version_id. Conflicts with time_machine_id .
        """
        return pulumi.get(self, "software_profile_id")

    @_builtins.property
    @pulumi.getter(name="softwareProfileVersionId")
    def software_profile_version_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SOftware Profile Version Id.
        """
        return pulumi.get(self, "software_profile_version_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbDbserverVmTag']]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time Machine id you want to provision a database server VM by using the database and operating system software stored in a time machine. Conflicts with software_profile_id.
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vmClusterName")
    def vm_cluster_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_cluster_name")

    @_builtins.property
    @pulumi.getter(name="vmClusterUuid")
    def vm_cluster_uuid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @_builtins.property
    @pulumi.getter(name="vmTimezone")
    def vm_timezone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_timezone")

