# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbMaintenanceWindowArgs', 'NdbMaintenanceWindow']

@pulumi.input_type
class NdbMaintenanceWindowArgs:
    def __init__(__self__, *,
                 recurrence: pulumi.Input[_builtins.str],
                 start_time: pulumi.Input[_builtins.str],
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_month: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NdbMaintenanceWindow resource.
        :param pulumi.Input[_builtins.str] recurrence: Supported values [ MONTHLY, WEEKLY ]
        :param pulumi.Input[_builtins.str] start_time: start time for maintenance window to trigger
        :param pulumi.Input[_builtins.str] day_of_week: Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        :param pulumi.Input[_builtins.str] description: Description for maintenance window
        :param pulumi.Input[_builtins.int] duration: duration in hours. Default is 2
        :param pulumi.Input[_builtins.str] name: Name for the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]] tags: tags of maintenance window
        :param pulumi.Input[_builtins.str] timezone: timezone . Default is Asia/Calcutta .
        :param pulumi.Input[_builtins.int] week_of_month: week of the month. Supports [1, 2, 3, 4] .
        """
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_of_month is not None:
            pulumi.set(__self__, "week_of_month", week_of_month)

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> pulumi.Input[_builtins.str]:
        """
        Supported values [ MONTHLY, WEEKLY ]
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recurrence", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        start time for maintenance window to trigger
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for maintenance window
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        duration in hours. Default is 2
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the maintenance window.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]]:
        """
        tags of maintenance window
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone . Default is Asia/Calcutta .
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="weekOfMonth")
    def week_of_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        week of the month. Supports [1, 2, 3, 4] .
        """
        return pulumi.get(self, "week_of_month")

    @week_of_month.setter
    def week_of_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_month", value)


@pulumi.input_type
class _NdbMaintenanceWindowState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 entity_task_assocs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowEntityTaskAssocArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_time: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowPropertyArgs']]]] = None,
                 recurrence: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowScheduleArgs']]]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_month: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NdbMaintenanceWindow resources.
        :param pulumi.Input[_builtins.str] access_level: access level
        :param pulumi.Input[_builtins.str] date_created: created date of maintenance window
        :param pulumi.Input[_builtins.str] date_modified: modified date of maintenance window
        :param pulumi.Input[_builtins.str] day_of_week: Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        :param pulumi.Input[_builtins.str] description: Description for maintenance window
        :param pulumi.Input[_builtins.int] duration: duration in hours. Default is 2
        :param pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowEntityTaskAssocArgs']]] entity_task_assocs: entity task association for maintenance window
        :param pulumi.Input[_builtins.str] name: Name for the maintenance window.
        :param pulumi.Input[_builtins.str] next_run_time: next run time for maintenance window to trigger
        :param pulumi.Input[_builtins.str] owner_id: owner id of maintenance window
        :param pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowPropertyArgs']]] properties: properties of maintenance window
        :param pulumi.Input[_builtins.str] recurrence: Supported values [ MONTHLY, WEEKLY ]
        :param pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowScheduleArgs']]] schedules: schedule of maintenance window
        :param pulumi.Input[_builtins.str] start_time: start time for maintenance window to trigger
        :param pulumi.Input[_builtins.str] status: status of maintennace window
        :param pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]] tags: tags of maintenance window
        :param pulumi.Input[_builtins.str] timezone: timezone . Default is Asia/Calcutta .
        :param pulumi.Input[_builtins.int] week_of_month: week of the month. Supports [1, 2, 3, 4] .
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if entity_task_assocs is not None:
            pulumi.set(__self__, "entity_task_assocs", entity_task_assocs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_run_time is not None:
            pulumi.set(__self__, "next_run_time", next_run_time)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_of_month is not None:
            pulumi.set(__self__, "week_of_month", week_of_month)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        access level
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        created date of maintenance window
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        modified date of maintenance window
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for maintenance window
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        duration in hours. Default is 2
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="entityTaskAssocs")
    def entity_task_assocs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowEntityTaskAssocArgs']]]]:
        """
        entity task association for maintenance window
        """
        return pulumi.get(self, "entity_task_assocs")

    @entity_task_assocs.setter
    def entity_task_assocs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowEntityTaskAssocArgs']]]]):
        pulumi.set(self, "entity_task_assocs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the maintenance window.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextRunTime")
    def next_run_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        next run time for maintenance window to trigger
        """
        return pulumi.get(self, "next_run_time")

    @next_run_time.setter
    def next_run_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run_time", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        owner id of maintenance window
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowPropertyArgs']]]]:
        """
        properties of maintenance window
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported values [ MONTHLY, WEEKLY ]
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recurrence", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowScheduleArgs']]]]:
        """
        schedule of maintenance window
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        start time for maintenance window to trigger
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of maintennace window
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]]:
        """
        tags of maintenance window
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbMaintenanceWindowTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone . Default is Asia/Calcutta .
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="weekOfMonth")
    def week_of_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        week of the month. Supports [1, 2, 3, 4] .
        """
        return pulumi.get(self, "week_of_month")

    @week_of_month.setter
    def week_of_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_month", value)


@pulumi.type_token("nutanix:index/ndbMaintenanceWindow:NdbMaintenanceWindow")
class NdbMaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowTagArgs', 'NdbMaintenanceWindowTagArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a resource to create maintenance window based on the input parameters.

        ## Example Usage

        ### resource to create weekly maintenance window
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbMaintenanceWindow("acctest-managed",
            name="test-maintenance",
            description="desc",
            duration=3,
            recurrence="WEEKLY",
            day_of_week="TUESDAY",
            start_time="17:04:47")
        ```

        ### resource to create monthly maintenance window
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbMaintenanceWindow("acctest-managed",
            name="test-maintenance",
            description="description",
            duration=2,
            recurrence="MONTHLY",
            day_of_week="TUESDAY",
            start_time="17:04:47",
            week_of_month=4)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] day_of_week: Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        :param pulumi.Input[_builtins.str] description: Description for maintenance window
        :param pulumi.Input[_builtins.int] duration: duration in hours. Default is 2
        :param pulumi.Input[_builtins.str] name: Name for the maintenance window.
        :param pulumi.Input[_builtins.str] recurrence: Supported values [ MONTHLY, WEEKLY ]
        :param pulumi.Input[_builtins.str] start_time: start time for maintenance window to trigger
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowTagArgs', 'NdbMaintenanceWindowTagArgsDict']]]] tags: tags of maintenance window
        :param pulumi.Input[_builtins.str] timezone: timezone . Default is Asia/Calcutta .
        :param pulumi.Input[_builtins.int] week_of_month: week of the month. Supports [1, 2, 3, 4] .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbMaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create maintenance window based on the input parameters.

        ## Example Usage

        ### resource to create weekly maintenance window
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbMaintenanceWindow("acctest-managed",
            name="test-maintenance",
            description="desc",
            duration=3,
            recurrence="WEEKLY",
            day_of_week="TUESDAY",
            start_time="17:04:47")
        ```

        ### resource to create monthly maintenance window
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        acctest_managed = nutanix.NdbMaintenanceWindow("acctest-managed",
            name="test-maintenance",
            description="description",
            duration=2,
            recurrence="MONTHLY",
            day_of_week="TUESDAY",
            start_time="17:04:47",
            week_of_month=4)
        ```

        :param str resource_name: The name of the resource.
        :param NdbMaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbMaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowTagArgs', 'NdbMaintenanceWindowTagArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbMaintenanceWindowArgs.__new__(NdbMaintenanceWindowArgs)

            __props__.__dict__["day_of_week"] = day_of_week
            __props__.__dict__["description"] = description
            __props__.__dict__["duration"] = duration
            __props__.__dict__["name"] = name
            if recurrence is None and not opts.urn:
                raise TypeError("Missing required property 'recurrence'")
            __props__.__dict__["recurrence"] = recurrence
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["week_of_month"] = week_of_month
            __props__.__dict__["access_level"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["entity_task_assocs"] = None
            __props__.__dict__["next_run_time"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["schedules"] = None
            __props__.__dict__["status"] = None
        super(NdbMaintenanceWindow, __self__).__init__(
            'nutanix:index/ndbMaintenanceWindow:NdbMaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            day_of_week: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            entity_task_assocs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowEntityTaskAssocArgs', 'NdbMaintenanceWindowEntityTaskAssocArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            next_run_time: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowPropertyArgs', 'NdbMaintenanceWindowPropertyArgsDict']]]]] = None,
            recurrence: Optional[pulumi.Input[_builtins.str]] = None,
            schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowScheduleArgs', 'NdbMaintenanceWindowScheduleArgsDict']]]]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowTagArgs', 'NdbMaintenanceWindowTagArgsDict']]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            week_of_month: Optional[pulumi.Input[_builtins.int]] = None) -> 'NdbMaintenanceWindow':
        """
        Get an existing NdbMaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: access level
        :param pulumi.Input[_builtins.str] date_created: created date of maintenance window
        :param pulumi.Input[_builtins.str] date_modified: modified date of maintenance window
        :param pulumi.Input[_builtins.str] day_of_week: Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        :param pulumi.Input[_builtins.str] description: Description for maintenance window
        :param pulumi.Input[_builtins.int] duration: duration in hours. Default is 2
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowEntityTaskAssocArgs', 'NdbMaintenanceWindowEntityTaskAssocArgsDict']]]] entity_task_assocs: entity task association for maintenance window
        :param pulumi.Input[_builtins.str] name: Name for the maintenance window.
        :param pulumi.Input[_builtins.str] next_run_time: next run time for maintenance window to trigger
        :param pulumi.Input[_builtins.str] owner_id: owner id of maintenance window
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowPropertyArgs', 'NdbMaintenanceWindowPropertyArgsDict']]]] properties: properties of maintenance window
        :param pulumi.Input[_builtins.str] recurrence: Supported values [ MONTHLY, WEEKLY ]
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowScheduleArgs', 'NdbMaintenanceWindowScheduleArgsDict']]]] schedules: schedule of maintenance window
        :param pulumi.Input[_builtins.str] start_time: start time for maintenance window to trigger
        :param pulumi.Input[_builtins.str] status: status of maintennace window
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbMaintenanceWindowTagArgs', 'NdbMaintenanceWindowTagArgsDict']]]] tags: tags of maintenance window
        :param pulumi.Input[_builtins.str] timezone: timezone . Default is Asia/Calcutta .
        :param pulumi.Input[_builtins.int] week_of_month: week of the month. Supports [1, 2, 3, 4] .
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbMaintenanceWindowState.__new__(_NdbMaintenanceWindowState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["day_of_week"] = day_of_week
        __props__.__dict__["description"] = description
        __props__.__dict__["duration"] = duration
        __props__.__dict__["entity_task_assocs"] = entity_task_assocs
        __props__.__dict__["name"] = name
        __props__.__dict__["next_run_time"] = next_run_time
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["recurrence"] = recurrence
        __props__.__dict__["schedules"] = schedules
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["week_of_month"] = week_of_month
        return NdbMaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[_builtins.str]:
        """
        access level
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        created date of maintenance window
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        modified date of maintenance window
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Day of the week to trigger maintenance window. Supports [ MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY ]
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for maintenance window
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        duration in hours. Default is 2
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="entityTaskAssocs")
    def entity_task_assocs(self) -> pulumi.Output[Sequence['outputs.NdbMaintenanceWindowEntityTaskAssoc']]:
        """
        entity task association for maintenance window
        """
        return pulumi.get(self, "entity_task_assocs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the maintenance window.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextRunTime")
    def next_run_time(self) -> pulumi.Output[_builtins.str]:
        """
        next run time for maintenance window to trigger
        """
        return pulumi.get(self, "next_run_time")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        owner id of maintenance window
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbMaintenanceWindowProperty']]:
        """
        properties of maintenance window
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> pulumi.Output[_builtins.str]:
        """
        Supported values [ MONTHLY, WEEKLY ]
        """
        return pulumi.get(self, "recurrence")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Sequence['outputs.NdbMaintenanceWindowSchedule']]:
        """
        schedule of maintenance window
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        start time for maintenance window to trigger
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of maintennace window
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbMaintenanceWindowTag']]:
        """
        tags of maintenance window
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        timezone . Default is Asia/Calcutta .
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="weekOfMonth")
    def week_of_month(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        week of the month. Supports [1, 2, 3, 4] .
        """
        return pulumi.get(self, "week_of_month")

