# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbNetworkArgs', 'NdbNetwork']

@pulumi.input_type
class NdbNetworkArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbNetwork resource.
        :param pulumi.Input[_builtins.str] cluster_id: Select the Nutanix cluster on which you want to add the VLAN.
        :param pulumi.Input[_builtins.str] type: Vlan type. Supports [DHCP, Static]
        :param pulumi.Input[_builtins.str] dns_domain: dns domain for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] gateway: Gateway for vlan. Supports in Static IP address assignment only
        :param pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]] ip_pools: Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        :param pulumi.Input[_builtins.str] name: Name of the vlan to be attached in NDB
        :param pulumi.Input[_builtins.str] primary_dns: primary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] secondary_dns: secondary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet mask for vlan. (Static IP address assignment only)
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_dns is not None:
            pulumi.set(__self__, "primary_dns", primary_dns)
        if secondary_dns is not None:
            pulumi.set(__self__, "secondary_dns", secondary_dns)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Select the Nutanix cluster on which you want to add the VLAN.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Vlan type. Supports [DHCP, Static]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dns domain for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_domain", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway for vlan. Supports in Static IP address assignment only
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]]:
        """
        Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        """
        return pulumi.get(self, "ip_pools")

    @ip_pools.setter
    def ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]]):
        pulumi.set(self, "ip_pools", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the vlan to be attached in NDB
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        primary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "primary_dns")

    @primary_dns.setter
    def primary_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_dns", value)

    @_builtins.property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        secondary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "secondary_dns")

    @secondary_dns.setter
    def secondary_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_dns", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet mask for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask", value)


@pulumi.input_type
class _NdbNetworkState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]] = None,
                 managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertyArgs']]]] = None,
                 properties_maps: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertiesMapArgs']]]] = None,
                 secondary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 stretched_vlan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbNetwork resources.
        :param pulumi.Input[_builtins.str] cluster_id: Select the Nutanix cluster on which you want to add the VLAN.
        :param pulumi.Input[_builtins.str] dns_domain: dns domain for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] gateway: Gateway for vlan. Supports in Static IP address assignment only
        :param pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]] ip_pools: Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        :param pulumi.Input[_builtins.bool] managed: Managed by NDB or not
        :param pulumi.Input[_builtins.str] name: Name of the vlan to be attached in NDB
        :param pulumi.Input[_builtins.str] primary_dns: primary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertyArgs']]] properties: properties of network
        :param pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertiesMapArgs']]] properties_maps: properties map of network
        :param pulumi.Input[_builtins.str] secondary_dns: secondary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] stretched_vlan_id: stretched vlan id
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet mask for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] type: Vlan type. Supports [DHCP, Static]
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_dns is not None:
            pulumi.set(__self__, "primary_dns", primary_dns)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if properties_maps is not None:
            pulumi.set(__self__, "properties_maps", properties_maps)
        if secondary_dns is not None:
            pulumi.set(__self__, "secondary_dns", secondary_dns)
        if stretched_vlan_id is not None:
            pulumi.set(__self__, "stretched_vlan_id", stretched_vlan_id)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the Nutanix cluster on which you want to add the VLAN.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dns domain for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_domain", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway for vlan. Supports in Static IP address assignment only
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]]:
        """
        Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        """
        return pulumi.get(self, "ip_pools")

    @ip_pools.setter
    def ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkIpPoolArgs']]]]):
        pulumi.set(self, "ip_pools", value)

    @_builtins.property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Managed by NDB or not
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "managed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the vlan to be attached in NDB
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        primary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "primary_dns")

    @primary_dns.setter
    def primary_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_dns", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertyArgs']]]]:
        """
        properties of network
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="propertiesMaps")
    def properties_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertiesMapArgs']]]]:
        """
        properties map of network
        """
        return pulumi.get(self, "properties_maps")

    @properties_maps.setter
    def properties_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbNetworkPropertiesMapArgs']]]]):
        pulumi.set(self, "properties_maps", value)

    @_builtins.property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        secondary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "secondary_dns")

    @secondary_dns.setter
    def secondary_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_dns", value)

    @_builtins.property
    @pulumi.getter(name="stretchedVlanId")
    def stretched_vlan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        stretched vlan id
        """
        return pulumi.get(self, "stretched_vlan_id")

    @stretched_vlan_id.setter
    def stretched_vlan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stretched_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet mask for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vlan type. Supports [DHCP, Static]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("nutanix:index/ndbNetwork:NdbNetwork")
class NdbNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkIpPoolArgs', 'NdbNetworkIpPoolArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create VLANs and IP address pools that are managed both in NDB and outside NDB.

        ## Example Usage

        ### resource to create network for NDB
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbNetwork("name",
            name="test-sub",
            type="Static",
            cluster_id="{{ cluster_id }}",
            gateway="{{ gatway for the vlan }}",
            subnet_mask="{{ subnet mask for the vlan}}",
            primary_dns=" {{ primary dns for the vlan }}",
            secondary_dns="{{secondary dns for the vlan }}",
            ip_pools=[{
                "start_ip": "{{ starting address range}}",
                "end_ip": "{{ ending address range }}",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Select the Nutanix cluster on which you want to add the VLAN.
        :param pulumi.Input[_builtins.str] dns_domain: dns domain for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] gateway: Gateway for vlan. Supports in Static IP address assignment only
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkIpPoolArgs', 'NdbNetworkIpPoolArgsDict']]]] ip_pools: Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        :param pulumi.Input[_builtins.str] name: Name of the vlan to be attached in NDB
        :param pulumi.Input[_builtins.str] primary_dns: primary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] secondary_dns: secondary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet mask for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] type: Vlan type. Supports [DHCP, Static]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create VLANs and IP address pools that are managed both in NDB and outside NDB.

        ## Example Usage

        ### resource to create network for NDB
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbNetwork("name",
            name="test-sub",
            type="Static",
            cluster_id="{{ cluster_id }}",
            gateway="{{ gatway for the vlan }}",
            subnet_mask="{{ subnet mask for the vlan}}",
            primary_dns=" {{ primary dns for the vlan }}",
            secondary_dns="{{secondary dns for the vlan }}",
            ip_pools=[{
                "start_ip": "{{ starting address range}}",
                "end_ip": "{{ ending address range }}",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param NdbNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkIpPoolArgs', 'NdbNetworkIpPoolArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbNetworkArgs.__new__(NdbNetworkArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["dns_domain"] = dns_domain
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["ip_pools"] = ip_pools
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_dns"] = primary_dns
            __props__.__dict__["secondary_dns"] = secondary_dns
            __props__.__dict__["subnet_mask"] = subnet_mask
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["managed"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["properties_maps"] = None
            __props__.__dict__["stretched_vlan_id"] = None
        super(NdbNetwork, __self__).__init__(
            'nutanix:index/ndbNetwork:NdbNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
            gateway: Optional[pulumi.Input[_builtins.str]] = None,
            ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkIpPoolArgs', 'NdbNetworkIpPoolArgsDict']]]]] = None,
            managed: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_dns: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkPropertyArgs', 'NdbNetworkPropertyArgsDict']]]]] = None,
            properties_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkPropertiesMapArgs', 'NdbNetworkPropertiesMapArgsDict']]]]] = None,
            secondary_dns: Optional[pulumi.Input[_builtins.str]] = None,
            stretched_vlan_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbNetwork':
        """
        Get an existing NdbNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Select the Nutanix cluster on which you want to add the VLAN.
        :param pulumi.Input[_builtins.str] dns_domain: dns domain for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] gateway: Gateway for vlan. Supports in Static IP address assignment only
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkIpPoolArgs', 'NdbNetworkIpPoolArgsDict']]]] ip_pools: Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        :param pulumi.Input[_builtins.bool] managed: Managed by NDB or not
        :param pulumi.Input[_builtins.str] name: Name of the vlan to be attached in NDB
        :param pulumi.Input[_builtins.str] primary_dns: primary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkPropertyArgs', 'NdbNetworkPropertyArgsDict']]]] properties: properties of network
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbNetworkPropertiesMapArgs', 'NdbNetworkPropertiesMapArgsDict']]]] properties_maps: properties map of network
        :param pulumi.Input[_builtins.str] secondary_dns: secondary dns for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] stretched_vlan_id: stretched vlan id
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet mask for vlan. (Static IP address assignment only)
        :param pulumi.Input[_builtins.str] type: Vlan type. Supports [DHCP, Static]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbNetworkState.__new__(_NdbNetworkState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["dns_domain"] = dns_domain
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["ip_pools"] = ip_pools
        __props__.__dict__["managed"] = managed
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_dns"] = primary_dns
        __props__.__dict__["properties"] = properties
        __props__.__dict__["properties_maps"] = properties_maps
        __props__.__dict__["secondary_dns"] = secondary_dns
        __props__.__dict__["stretched_vlan_id"] = stretched_vlan_id
        __props__.__dict__["subnet_mask"] = subnet_mask
        __props__.__dict__["type"] = type
        return NdbNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Select the Nutanix cluster on which you want to add the VLAN.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        dns domain for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Gateway for vlan. Supports in Static IP address assignment only
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> pulumi.Output[Sequence['outputs.NdbNetworkIpPool']]:
        """
        Manage IP Address Pool in NDB option if you want to assign static IP addresses to your database server VMs
        """
        return pulumi.get(self, "ip_pools")

    @_builtins.property
    @pulumi.getter
    def managed(self) -> pulumi.Output[_builtins.bool]:
        """
        Managed by NDB or not
        """
        return pulumi.get(self, "managed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the vlan to be attached in NDB
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        primary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "primary_dns")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbNetworkProperty']]:
        """
        properties of network
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="propertiesMaps")
    def properties_maps(self) -> pulumi.Output[Sequence['outputs.NdbNetworkPropertiesMap']]:
        """
        properties map of network
        """
        return pulumi.get(self, "properties_maps")

    @_builtins.property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        secondary dns for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "secondary_dns")

    @_builtins.property
    @pulumi.getter(name="stretchedVlanId")
    def stretched_vlan_id(self) -> pulumi.Output[_builtins.str]:
        """
        stretched vlan id
        """
        return pulumi.get(self, "stretched_vlan_id")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subnet mask for vlan. (Static IP address assignment only)
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Vlan type. Supports [DHCP, Static]
        """
        return pulumi.get(self, "type")

