# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbRegisterDatabaseArgs', 'NdbRegisterDatabase']

@pulumi.input_type
class NdbRegisterDatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 database_type: pulumi.Input[_builtins.str],
                 vm_ip: pulumi.Input[_builtins.str],
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]] = None,
                 auto_tune_staging_drive: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgress_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 reset_description_in_nx_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]] = None,
                 time_machine_info: Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']] = None,
                 vm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_sshkey: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbRegisterDatabase resource.
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[_builtins.str] database_type: type of database. Required value: postgres_database
        :param pulumi.Input[_builtins.str] vm_ip: IP address of dbserver VM
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]] actionarguments: action arguments
        :param pulumi.Input[_builtins.bool] auto_tune_staging_drive: auto tune staging drive. Default is true
        :param pulumi.Input[_builtins.str] category: category of database. Default is "DEFAULT"
        :param pulumi.Input[_builtins.bool] clustered: clustered or not. Default is false
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database from the VM. Default value is false
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] forced_install: forced install. Default:  true
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster on which NDB is present
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]] postgress_infos: Postgress_Info for registering.
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] reset_description_in_nx_cluster: Reset description in cluster
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]] tags: tags
        :param pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs'] time_machine_info: Time Machine info
        :param pulumi.Input[_builtins.str] vm_description: description for VM
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        :param pulumi.Input[_builtins.str] vm_sshkey: ssh key for vm
        :param pulumi.Input[_builtins.str] vm_username: username of the NDB drive user account that has sudo access.
        :param pulumi.Input[_builtins.str] working_directory: working directory. Default is /tmp
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "vm_ip", vm_ip)
        if actionarguments is not None:
            pulumi.set(__self__, "actionarguments", actionarguments)
        if auto_tune_staging_drive is not None:
            pulumi.set(__self__, "auto_tune_staging_drive", auto_tune_staging_drive)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if clustered is not None:
            pulumi.set(__self__, "clustered", clustered)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_logical_cluster is not None:
            pulumi.set(__self__, "delete_logical_cluster", delete_logical_cluster)
        if delete_time_machine is not None:
            pulumi.set(__self__, "delete_time_machine", delete_time_machine)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)
        if forced_install is not None:
            pulumi.set(__self__, "forced_install", forced_install)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if postgress_infos is not None:
            pulumi.set(__self__, "postgress_infos", postgress_infos)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if reset_description_in_nx_cluster is not None:
            pulumi.set(__self__, "reset_description_in_nx_cluster", reset_description_in_nx_cluster)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_info is not None:
            pulumi.set(__self__, "time_machine_info", time_machine_info)
        if vm_description is not None:
            pulumi.set(__self__, "vm_description", vm_description)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)
        if vm_sshkey is not None:
            pulumi.set(__self__, "vm_sshkey", vm_sshkey)
        if vm_username is not None:
            pulumi.set(__self__, "vm_username", vm_username)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[_builtins.str]:
        """
        type of database. Required value: postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> pulumi.Input[_builtins.str]:
        """
        IP address of dbserver VM
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_ip", value)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]]:
        """
        action arguments
        """
        return pulumi.get(self, "actionarguments")

    @actionarguments.setter
    def actionarguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]]):
        pulumi.set(self, "actionarguments", value)

    @_builtins.property
    @pulumi.getter(name="autoTuneStagingDrive")
    def auto_tune_staging_drive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        auto tune staging drive. Default is true
        """
        return pulumi.get(self, "auto_tune_staging_drive")

    @auto_tune_staging_drive.setter
    def auto_tune_staging_drive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_tune_staging_drive", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        category of database. Default is "DEFAULT"
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        clustered or not. Default is false
        """
        return pulumi.get(self, "clustered")

    @clustered.setter
    def clustered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clustered", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database from the VM. Default value is false
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @delete_logical_cluster.setter
    def delete_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @delete_time_machine.setter
    def delete_time_machine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_time_machine", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced", value)

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        forced install. Default:  true
        """
        return pulumi.get(self, "forced_install")

    @forced_install.setter
    def forced_install(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced_install", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster on which NDB is present
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="postgressInfos")
    def postgress_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]]:
        """
        Postgress_Info for registering.
        """
        return pulumi.get(self, "postgress_infos")

    @postgress_infos.setter
    def postgress_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]]):
        pulumi.set(self, "postgress_infos", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="resetDescriptionInNxCluster")
    def reset_description_in_nx_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reset description in cluster
        """
        return pulumi.get(self, "reset_description_in_nx_cluster")

    @reset_description_in_nx_cluster.setter
    def reset_description_in_nx_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset_description_in_nx_cluster", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineInfo")
    def time_machine_info(self) -> Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']]:
        """
        Time Machine info
        """
        return pulumi.get(self, "time_machine_info")

    @time_machine_info.setter
    def time_machine_info(self, value: Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']]):
        pulumi.set(self, "time_machine_info", value)

    @_builtins.property
    @pulumi.getter(name="vmDescription")
    def vm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for VM
        """
        return pulumi.get(self, "vm_description")

    @vm_description.setter
    def vm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_description", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)

    @_builtins.property
    @pulumi.getter(name="vmSshkey")
    def vm_sshkey(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ssh key for vm
        """
        return pulumi.get(self, "vm_sshkey")

    @vm_sshkey.setter
    def vm_sshkey(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_sshkey", value)

    @_builtins.property
    @pulumi.getter(name="vmUsername")
    def vm_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access.
        """
        return pulumi.get(self, "vm_username")

    @vm_username.setter
    def vm_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_username", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        working directory. Default is /tmp
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class _NdbRegisterDatabaseState:
    def __init__(__self__, *,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]] = None,
                 auto_tune_staging_drive: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input[_builtins.bool]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseDatabaseNodeArgs']]]] = None,
                 database_status: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseInfoArgs']]]] = None,
                 lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLcmConfigArgs']]]] = None,
                 linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLinkedDatabaseArgs']]]] = None,
                 metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgress_infos: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePropertyArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 reset_description_in_nx_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_info: Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']] = None,
                 time_machines: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTimeMachineArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_sshkey: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbRegisterDatabase resources.
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]] actionarguments: action arguments
        :param pulumi.Input[_builtins.bool] auto_tune_staging_drive: auto tune staging drive. Default is true
        :param pulumi.Input[_builtins.str] category: category of database. Default is "DEFAULT"
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.bool] clustered: clustered or not. Default is false
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseDatabaseNodeArgs']]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_status: status of database
        :param pulumi.Input[_builtins.str] database_type: type of database. Required value: postgres_database
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database from the VM. Default value is false
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] forced_install: forced install. Default:  true
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseInfoArgs']]] infos: info of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLcmConfigArgs']]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLinkedDatabaseArgs']]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster on which NDB is present
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[_builtins.str] parent_source_database_id: parent source database id
        :param pulumi.Input[_builtins.str] parent_time_machine_id: parent time machine id
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]] postgress_infos: Postgress_Info for registering.
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePropertyArgs']]] properties: properties of database created
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] reset_description_in_nx_cluster: Reset description in cluster
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs'] time_machine_info: Time Machine info
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTimeMachineArgs']]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] type: type of database
        :param pulumi.Input[_builtins.str] vm_description: description for VM
        :param pulumi.Input[_builtins.str] vm_ip: IP address of dbserver VM
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        :param pulumi.Input[_builtins.str] vm_sshkey: ssh key for vm
        :param pulumi.Input[_builtins.str] vm_username: username of the NDB drive user account that has sudo access.
        :param pulumi.Input[_builtins.str] working_directory: working directory. Default is /tmp
        """
        if actionarguments is not None:
            pulumi.set(__self__, "actionarguments", actionarguments)
        if auto_tune_staging_drive is not None:
            pulumi.set(__self__, "auto_tune_staging_drive", auto_tune_staging_drive)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if clustered is not None:
            pulumi.set(__self__, "clustered", clustered)
        if database_cluster_type is not None:
            pulumi.set(__self__, "database_cluster_type", database_cluster_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_nodes is not None:
            pulumi.set(__self__, "database_nodes", database_nodes)
        if database_status is not None:
            pulumi.set(__self__, "database_status", database_status)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_logical_cluster is not None:
            pulumi.set(__self__, "dbserver_logical_cluster", dbserver_logical_cluster)
        if dbserver_logical_cluster_id is not None:
            pulumi.set(__self__, "dbserver_logical_cluster_id", dbserver_logical_cluster_id)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_logical_cluster is not None:
            pulumi.set(__self__, "delete_logical_cluster", delete_logical_cluster)
        if delete_time_machine is not None:
            pulumi.set(__self__, "delete_time_machine", delete_time_machine)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)
        if forced_install is not None:
            pulumi.set(__self__, "forced_install", forced_install)
        if group_info is not None:
            pulumi.set(__self__, "group_info", group_info)
        if infos is not None:
            pulumi.set(__self__, "infos", infos)
        if lcm_configs is not None:
            pulumi.set(__self__, "lcm_configs", lcm_configs)
        if linked_databases is not None:
            pulumi.set(__self__, "linked_databases", linked_databases)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if parent_database_id is not None:
            pulumi.set(__self__, "parent_database_id", parent_database_id)
        if parent_source_database_id is not None:
            pulumi.set(__self__, "parent_source_database_id", parent_source_database_id)
        if parent_time_machine_id is not None:
            pulumi.set(__self__, "parent_time_machine_id", parent_time_machine_id)
        if postgress_infos is not None:
            pulumi.set(__self__, "postgress_infos", postgress_infos)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if reset_description_in_nx_cluster is not None:
            pulumi.set(__self__, "reset_description_in_nx_cluster", reset_description_in_nx_cluster)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if time_machine_info is not None:
            pulumi.set(__self__, "time_machine_info", time_machine_info)
        if time_machines is not None:
            pulumi.set(__self__, "time_machines", time_machines)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vm_description is not None:
            pulumi.set(__self__, "vm_description", vm_description)
        if vm_ip is not None:
            pulumi.set(__self__, "vm_ip", vm_ip)
        if vm_password is not None:
            pulumi.set(__self__, "vm_password", vm_password)
        if vm_sshkey is not None:
            pulumi.set(__self__, "vm_sshkey", vm_sshkey)
        if vm_username is not None:
            pulumi.set(__self__, "vm_username", vm_username)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]]:
        """
        action arguments
        """
        return pulumi.get(self, "actionarguments")

    @actionarguments.setter
    def actionarguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseActionargumentArgs']]]]):
        pulumi.set(self, "actionarguments", value)

    @_builtins.property
    @pulumi.getter(name="autoTuneStagingDrive")
    def auto_tune_staging_drive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        auto tune staging drive. Default is true
        """
        return pulumi.get(self, "auto_tune_staging_drive")

    @auto_tune_staging_drive.setter
    def auto_tune_staging_drive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_tune_staging_drive", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        category of database. Default is "DEFAULT"
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        clustered or not. Default is false
        """
        return pulumi.get(self, "clustered")

    @clustered.setter
    def clustered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clustered", value)

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @database_cluster_type.setter
    def database_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseDatabaseNodeArgs']]]]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @database_nodes.setter
    def database_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseDatabaseNodeArgs']]]]):
        pulumi.set(self, "database_nodes", value)

    @_builtins.property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of database
        """
        return pulumi.get(self, "database_status")

    @database_status.setter
    def database_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_status", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of database. Required value: postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @dbserver_logical_cluster.setter
    def dbserver_logical_cluster(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dbserver_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @dbserver_logical_cluster_id.setter
    def dbserver_logical_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_logical_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database from the VM. Default value is false
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @delete_logical_cluster.setter
    def delete_logical_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_logical_cluster", value)

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @delete_time_machine.setter
    def delete_time_machine(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_time_machine", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced", value)

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        forced install. Default:  true
        """
        return pulumi.get(self, "forced_install")

    @forced_install.setter
    def forced_install(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced_install", value)

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "group_info")

    @group_info.setter
    def group_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_info", value)

    @_builtins.property
    @pulumi.getter
    def infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseInfoArgs']]]]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @infos.setter
    def infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseInfoArgs']]]]):
        pulumi.set(self, "infos", value)

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLcmConfigArgs']]]]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @lcm_configs.setter
    def lcm_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLcmConfigArgs']]]]):
        pulumi.set(self, "lcm_configs", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLinkedDatabaseArgs']]]]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @linked_databases.setter
    def linked_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseLinkedDatabaseArgs']]]]):
        pulumi.set(self, "linked_databases", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster on which NDB is present
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @parent_database_id.setter
    def parent_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_database_id", value)

    @_builtins.property
    @pulumi.getter(name="parentSourceDatabaseId")
    def parent_source_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent source database id
        """
        return pulumi.get(self, "parent_source_database_id")

    @parent_source_database_id.setter
    def parent_source_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_source_database_id", value)

    @_builtins.property
    @pulumi.getter(name="parentTimeMachineId")
    def parent_time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        parent time machine id
        """
        return pulumi.get(self, "parent_time_machine_id")

    @parent_time_machine_id.setter
    def parent_time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="postgressInfos")
    def postgress_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]]:
        """
        Postgress_Info for registering.
        """
        return pulumi.get(self, "postgress_infos")

    @postgress_infos.setter
    def postgress_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePostgressInfoArgs']]]]):
        pulumi.set(self, "postgress_infos", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePropertyArgs']]]]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabasePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="resetDescriptionInNxCluster")
    def reset_description_in_nx_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reset description in cluster
        """
        return pulumi.get(self, "reset_description_in_nx_cluster")

    @reset_description_in_nx_cluster.setter
    def reset_description_in_nx_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset_description_in_nx_cluster", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineInfo")
    def time_machine_info(self) -> Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']]:
        """
        Time Machine info
        """
        return pulumi.get(self, "time_machine_info")

    @time_machine_info.setter
    def time_machine_info(self, value: Optional[pulumi.Input['NdbRegisterDatabaseTimeMachineInfoArgs']]):
        pulumi.set(self, "time_machine_info", value)

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTimeMachineArgs']]]]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @time_machines.setter
    def time_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDatabaseTimeMachineArgs']]]]):
        pulumi.set(self, "time_machines", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of database
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vmDescription")
    def vm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for VM
        """
        return pulumi.get(self, "vm_description")

    @vm_description.setter
    def vm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_description", value)

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of dbserver VM
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_ip", value)

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @vm_password.setter
    def vm_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_password", value)

    @_builtins.property
    @pulumi.getter(name="vmSshkey")
    def vm_sshkey(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ssh key for vm
        """
        return pulumi.get(self, "vm_sshkey")

    @vm_sshkey.setter
    def vm_sshkey(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_sshkey", value)

    @_builtins.property
    @pulumi.getter(name="vmUsername")
    def vm_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access.
        """
        return pulumi.get(self, "vm_username")

    @vm_username.setter
    def vm_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_username", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        working directory. Default is /tmp
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.type_token("nutanix:index/ndbRegisterDatabase:NdbRegisterDatabase")
class NdbRegisterDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseActionargumentArgs', 'NdbRegisterDatabaseActionargumentArgsDict']]]]] = None,
                 auto_tune_staging_drive: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgress_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePostgressInfoArgs', 'NdbRegisterDatabasePostgressInfoArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 reset_description_in_nx_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTagArgs', 'NdbRegisterDatabaseTagArgsDict']]]]] = None,
                 time_machine_info: Optional[pulumi.Input[Union['NdbRegisterDatabaseTimeMachineInfoArgs', 'NdbRegisterDatabaseTimeMachineInfoArgsDict']]] = None,
                 vm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_sshkey: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to register the database based on the input parameters.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseActionargumentArgs', 'NdbRegisterDatabaseActionargumentArgsDict']]]] actionarguments: action arguments
        :param pulumi.Input[_builtins.bool] auto_tune_staging_drive: auto tune staging drive. Default is true
        :param pulumi.Input[_builtins.str] category: category of database. Default is "DEFAULT"
        :param pulumi.Input[_builtins.bool] clustered: clustered or not. Default is false
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[_builtins.str] database_type: type of database. Required value: postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database from the VM. Default value is false
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] forced_install: forced install. Default:  true
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster on which NDB is present
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePostgressInfoArgs', 'NdbRegisterDatabasePostgressInfoArgsDict']]]] postgress_infos: Postgress_Info for registering.
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] reset_description_in_nx_cluster: Reset description in cluster
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTagArgs', 'NdbRegisterDatabaseTagArgsDict']]]] tags: tags
        :param pulumi.Input[Union['NdbRegisterDatabaseTimeMachineInfoArgs', 'NdbRegisterDatabaseTimeMachineInfoArgsDict']] time_machine_info: Time Machine info
        :param pulumi.Input[_builtins.str] vm_description: description for VM
        :param pulumi.Input[_builtins.str] vm_ip: IP address of dbserver VM
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        :param pulumi.Input[_builtins.str] vm_sshkey: ssh key for vm
        :param pulumi.Input[_builtins.str] vm_username: username of the NDB drive user account that has sudo access.
        :param pulumi.Input[_builtins.str] working_directory: working directory. Default is /tmp
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbRegisterDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to register the database based on the input parameters.

        :param str resource_name: The name of the resource.
        :param NdbRegisterDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbRegisterDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseActionargumentArgs', 'NdbRegisterDatabaseActionargumentArgsDict']]]]] = None,
                 auto_tune_staging_drive: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 clustered: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 postgress_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePostgressInfoArgs', 'NdbRegisterDatabasePostgressInfoArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 reset_description_in_nx_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTagArgs', 'NdbRegisterDatabaseTagArgsDict']]]]] = None,
                 time_machine_info: Optional[pulumi.Input[Union['NdbRegisterDatabaseTimeMachineInfoArgs', 'NdbRegisterDatabaseTimeMachineInfoArgsDict']]] = None,
                 vm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_sshkey: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbRegisterDatabaseArgs.__new__(NdbRegisterDatabaseArgs)

            __props__.__dict__["actionarguments"] = actionarguments
            __props__.__dict__["auto_tune_staging_drive"] = auto_tune_staging_drive
            __props__.__dict__["category"] = category
            __props__.__dict__["clustered"] = clustered
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if database_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_type'")
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["delete"] = delete
            __props__.__dict__["delete_logical_cluster"] = delete_logical_cluster
            __props__.__dict__["delete_time_machine"] = delete_time_machine
            __props__.__dict__["description"] = description
            __props__.__dict__["forced"] = forced
            __props__.__dict__["forced_install"] = forced_install
            __props__.__dict__["nx_cluster_id"] = nx_cluster_id
            __props__.__dict__["postgress_infos"] = postgress_infos
            __props__.__dict__["remove"] = remove
            __props__.__dict__["reset_description_in_nx_cluster"] = reset_description_in_nx_cluster
            __props__.__dict__["soft_remove"] = soft_remove
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_machine_info"] = time_machine_info
            __props__.__dict__["vm_description"] = vm_description
            if vm_ip is None and not opts.urn:
                raise TypeError("Missing required property 'vm_ip'")
            __props__.__dict__["vm_ip"] = vm_ip
            __props__.__dict__["vm_password"] = None if vm_password is None else pulumi.Output.secret(vm_password)
            __props__.__dict__["vm_sshkey"] = None if vm_sshkey is None else pulumi.Output.secret(vm_sshkey)
            __props__.__dict__["vm_username"] = vm_username
            __props__.__dict__["working_directory"] = working_directory
            __props__.__dict__["clone"] = None
            __props__.__dict__["database_cluster_type"] = None
            __props__.__dict__["database_nodes"] = None
            __props__.__dict__["database_status"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["dbserver_logical_cluster"] = None
            __props__.__dict__["dbserver_logical_cluster_id"] = None
            __props__.__dict__["group_info"] = None
            __props__.__dict__["infos"] = None
            __props__.__dict__["lcm_configs"] = None
            __props__.__dict__["linked_databases"] = None
            __props__.__dict__["metric"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["parent_database_id"] = None
            __props__.__dict__["parent_source_database_id"] = None
            __props__.__dict__["parent_time_machine_id"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_machine_id"] = None
            __props__.__dict__["time_machines"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["vmPassword", "vmSshkey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NdbRegisterDatabase, __self__).__init__(
            'nutanix:index/ndbRegisterDatabase:NdbRegisterDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actionarguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseActionargumentArgs', 'NdbRegisterDatabaseActionargumentArgsDict']]]]] = None,
            auto_tune_staging_drive: Optional[pulumi.Input[_builtins.bool]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            clone: Optional[pulumi.Input[_builtins.bool]] = None,
            clustered: Optional[pulumi.Input[_builtins.bool]] = None,
            database_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseDatabaseNodeArgs', 'NdbRegisterDatabaseDatabaseNodeArgsDict']]]]] = None,
            database_status: Optional[pulumi.Input[_builtins.str]] = None,
            database_type: Optional[pulumi.Input[_builtins.str]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_logical_cluster: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            dbserver_logical_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            delete: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_logical_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_time_machine: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            forced: Optional[pulumi.Input[_builtins.bool]] = None,
            forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
            group_info: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseInfoArgs', 'NdbRegisterDatabaseInfoArgsDict']]]]] = None,
            lcm_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseLcmConfigArgs', 'NdbRegisterDatabaseLcmConfigArgsDict']]]]] = None,
            linked_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseLinkedDatabaseArgs', 'NdbRegisterDatabaseLinkedDatabaseArgsDict']]]]] = None,
            metric: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            postgress_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePostgressInfoArgs', 'NdbRegisterDatabasePostgressInfoArgsDict']]]]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePropertyArgs', 'NdbRegisterDatabasePropertyArgsDict']]]]] = None,
            remove: Optional[pulumi.Input[_builtins.bool]] = None,
            reset_description_in_nx_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTagArgs', 'NdbRegisterDatabaseTagArgsDict']]]]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_machine_info: Optional[pulumi.Input[Union['NdbRegisterDatabaseTimeMachineInfoArgs', 'NdbRegisterDatabaseTimeMachineInfoArgsDict']]] = None,
            time_machines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTimeMachineArgs', 'NdbRegisterDatabaseTimeMachineArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vm_description: Optional[pulumi.Input[_builtins.str]] = None,
            vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
            vm_password: Optional[pulumi.Input[_builtins.str]] = None,
            vm_sshkey: Optional[pulumi.Input[_builtins.str]] = None,
            vm_username: Optional[pulumi.Input[_builtins.str]] = None,
            working_directory: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbRegisterDatabase':
        """
        Get an existing NdbRegisterDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseActionargumentArgs', 'NdbRegisterDatabaseActionargumentArgsDict']]]] actionarguments: action arguments
        :param pulumi.Input[_builtins.bool] auto_tune_staging_drive: auto tune staging drive. Default is true
        :param pulumi.Input[_builtins.str] category: category of database. Default is "DEFAULT"
        :param pulumi.Input[_builtins.bool] clone: whether instance is cloned or not
        :param pulumi.Input[_builtins.bool] clustered: clustered or not. Default is false
        :param pulumi.Input[_builtins.str] database_cluster_type: database cluster type
        :param pulumi.Input[_builtins.str] database_name: name of database
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseDatabaseNodeArgs', 'NdbRegisterDatabaseDatabaseNodeArgsDict']]]] database_nodes: database nodes associated with database instance
        :param pulumi.Input[_builtins.str] database_status: status of database
        :param pulumi.Input[_builtins.str] database_type: type of database. Required value: postgres_database
        :param pulumi.Input[_builtins.str] date_created: date created for db instance
        :param pulumi.Input[_builtins.str] date_modified: date modified for instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dbserver_logical_cluster: dbserver logical cluster
        :param pulumi.Input[_builtins.str] dbserver_logical_cluster_id: dbserver logical cluster id
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the database from the VM. Default value is false
        :param pulumi.Input[_builtins.bool] delete_logical_cluster: - (Optional) Delete the logical cluster. Default is true
        :param pulumi.Input[_builtins.bool] delete_time_machine: - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        :param pulumi.Input[_builtins.str] description: description
        :param pulumi.Input[_builtins.bool] forced: - (Optional) Force delete of instance. Default is false
        :param pulumi.Input[_builtins.bool] forced_install: forced install. Default:  true
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseInfoArgs', 'NdbRegisterDatabaseInfoArgsDict']]]] infos: info of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseLcmConfigArgs', 'NdbRegisterDatabaseLcmConfigArgsDict']]]] lcm_configs: LCM config of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseLinkedDatabaseArgs', 'NdbRegisterDatabaseLinkedDatabaseArgsDict']]]] linked_databases: linked databases within database instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metric: Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        :param pulumi.Input[_builtins.str] name: Name of database instance
        :param pulumi.Input[_builtins.str] nx_cluster_id: cluster on which NDB is present
        :param pulumi.Input[_builtins.str] parent_database_id: parent database id
        :param pulumi.Input[_builtins.str] parent_source_database_id: parent source database id
        :param pulumi.Input[_builtins.str] parent_time_machine_id: parent time machine id
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePostgressInfoArgs', 'NdbRegisterDatabasePostgressInfoArgsDict']]]] postgress_infos: Postgress_Info for registering.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabasePropertyArgs', 'NdbRegisterDatabasePropertyArgsDict']]]] properties: properties of database created
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] reset_description_in_nx_cluster: Reset description in cluster
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] status: status of instance
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTagArgs', 'NdbRegisterDatabaseTagArgsDict']]]] tags: tags
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id of instance
        :param pulumi.Input[Union['NdbRegisterDatabaseTimeMachineInfoArgs', 'NdbRegisterDatabaseTimeMachineInfoArgsDict']] time_machine_info: Time Machine info
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDatabaseTimeMachineArgs', 'NdbRegisterDatabaseTimeMachineArgsDict']]]] time_machines: Time Machine details of instance
        :param pulumi.Input[_builtins.str] time_zone: timezone on which instance is created xw
        :param pulumi.Input[_builtins.str] type: type of database
        :param pulumi.Input[_builtins.str] vm_description: description for VM
        :param pulumi.Input[_builtins.str] vm_ip: IP address of dbserver VM
        :param pulumi.Input[_builtins.str] vm_password: password of the NDB drive user account.
        :param pulumi.Input[_builtins.str] vm_sshkey: ssh key for vm
        :param pulumi.Input[_builtins.str] vm_username: username of the NDB drive user account that has sudo access.
        :param pulumi.Input[_builtins.str] working_directory: working directory. Default is /tmp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbRegisterDatabaseState.__new__(_NdbRegisterDatabaseState)

        __props__.__dict__["actionarguments"] = actionarguments
        __props__.__dict__["auto_tune_staging_drive"] = auto_tune_staging_drive
        __props__.__dict__["category"] = category
        __props__.__dict__["clone"] = clone
        __props__.__dict__["clustered"] = clustered
        __props__.__dict__["database_cluster_type"] = database_cluster_type
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_nodes"] = database_nodes
        __props__.__dict__["database_status"] = database_status
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["dbserver_logical_cluster"] = dbserver_logical_cluster
        __props__.__dict__["dbserver_logical_cluster_id"] = dbserver_logical_cluster_id
        __props__.__dict__["delete"] = delete
        __props__.__dict__["delete_logical_cluster"] = delete_logical_cluster
        __props__.__dict__["delete_time_machine"] = delete_time_machine
        __props__.__dict__["description"] = description
        __props__.__dict__["forced"] = forced
        __props__.__dict__["forced_install"] = forced_install
        __props__.__dict__["group_info"] = group_info
        __props__.__dict__["infos"] = infos
        __props__.__dict__["lcm_configs"] = lcm_configs
        __props__.__dict__["linked_databases"] = linked_databases
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["nx_cluster_id"] = nx_cluster_id
        __props__.__dict__["parent_database_id"] = parent_database_id
        __props__.__dict__["parent_source_database_id"] = parent_source_database_id
        __props__.__dict__["parent_time_machine_id"] = parent_time_machine_id
        __props__.__dict__["postgress_infos"] = postgress_infos
        __props__.__dict__["properties"] = properties
        __props__.__dict__["remove"] = remove
        __props__.__dict__["reset_description_in_nx_cluster"] = reset_description_in_nx_cluster
        __props__.__dict__["soft_remove"] = soft_remove
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["time_machine_info"] = time_machine_info
        __props__.__dict__["time_machines"] = time_machines
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        __props__.__dict__["vm_description"] = vm_description
        __props__.__dict__["vm_ip"] = vm_ip
        __props__.__dict__["vm_password"] = vm_password
        __props__.__dict__["vm_sshkey"] = vm_sshkey
        __props__.__dict__["vm_username"] = vm_username
        __props__.__dict__["working_directory"] = working_directory
        return NdbRegisterDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actionarguments(self) -> pulumi.Output[Optional[Sequence['outputs.NdbRegisterDatabaseActionargument']]]:
        """
        action arguments
        """
        return pulumi.get(self, "actionarguments")

    @_builtins.property
    @pulumi.getter(name="autoTuneStagingDrive")
    def auto_tune_staging_drive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        auto tune staging drive. Default is true
        """
        return pulumi.get(self, "auto_tune_staging_drive")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        category of database. Default is "DEFAULT"
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[_builtins.bool]:
        """
        whether instance is cloned or not
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        clustered or not. Default is false
        """
        return pulumi.get(self, "clustered")

    @_builtins.property
    @pulumi.getter(name="databaseClusterType")
    def database_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        database cluster type
        """
        return pulumi.get(self, "database_cluster_type")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of database
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseNodes")
    def database_nodes(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseDatabaseNode']]:
        """
        database nodes associated with database instance
        """
        return pulumi.get(self, "database_nodes")

    @_builtins.property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> pulumi.Output[_builtins.str]:
        """
        status of database
        """
        return pulumi.get(self, "database_status")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[_builtins.str]:
        """
        type of database. Required value: postgres_database
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        date created for db instance
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        date modified for instance
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalCluster")
    def dbserver_logical_cluster(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        dbserver logical cluster
        """
        return pulumi.get(self, "dbserver_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="dbserverLogicalClusterId")
    def dbserver_logical_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        dbserver logical cluster id
        """
        return pulumi.get(self, "dbserver_logical_cluster_id")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the database from the VM. Default value is false
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter(name="deleteLogicalCluster")
    def delete_logical_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the logical cluster. Default is true
        """
        return pulumi.get(self, "delete_logical_cluster")

    @_builtins.property
    @pulumi.getter(name="deleteTimeMachine")
    def delete_time_machine(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the database's Time Machine (snapshots/logs) from the NDB. Default value is true
        """
        return pulumi.get(self, "delete_time_machine")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def forced(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Force delete of instance. Default is false
        """
        return pulumi.get(self, "forced")

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        forced install. Default:  true
        """
        return pulumi.get(self, "forced_install")

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "group_info")

    @_builtins.property
    @pulumi.getter
    def infos(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseInfo']]:
        """
        info of instance
        """
        return pulumi.get(self, "infos")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseLcmConfig']]:
        """
        LCM config of instance
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseLinkedDatabase']]:
        """
        linked databases within database instance
        """
        return pulumi.get(self, "linked_databases")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Stores storage info regarding size, allocatedSize, usedSize and unit of calculation that seems to have been fetched from PRISM.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of database instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        cluster on which NDB is present
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="parentDatabaseId")
    def parent_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent database id
        """
        return pulumi.get(self, "parent_database_id")

    @_builtins.property
    @pulumi.getter(name="parentSourceDatabaseId")
    def parent_source_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent source database id
        """
        return pulumi.get(self, "parent_source_database_id")

    @_builtins.property
    @pulumi.getter(name="parentTimeMachineId")
    def parent_time_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        parent time machine id
        """
        return pulumi.get(self, "parent_time_machine_id")

    @_builtins.property
    @pulumi.getter(name="postgressInfos")
    def postgress_infos(self) -> pulumi.Output[Optional[Sequence['outputs.NdbRegisterDatabasePostgressInfo']]]:
        """
        Postgress_Info for registering.
        """
        return pulumi.get(self, "postgress_infos")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseProperty']]:
        """
        properties of database created
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter(name="resetDescriptionInNxCluster")
    def reset_description_in_nx_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Reset description in cluster
        """
        return pulumi.get(self, "reset_description_in_nx_cluster")

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of instance
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseTag']]:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        time machine id of instance
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter(name="timeMachineInfo")
    def time_machine_info(self) -> pulumi.Output[Optional['outputs.NdbRegisterDatabaseTimeMachineInfo']]:
        """
        Time Machine info
        """
        return pulumi.get(self, "time_machine_info")

    @_builtins.property
    @pulumi.getter(name="timeMachines")
    def time_machines(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDatabaseTimeMachine']]:
        """
        Time Machine details of instance
        """
        return pulumi.get(self, "time_machines")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        timezone on which instance is created xw
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of database
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vmDescription")
    def vm_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        description for VM
        """
        return pulumi.get(self, "vm_description")

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP address of dbserver VM
        """
        return pulumi.get(self, "vm_ip")

    @_builtins.property
    @pulumi.getter(name="vmPassword")
    def vm_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        password of the NDB drive user account.
        """
        return pulumi.get(self, "vm_password")

    @_builtins.property
    @pulumi.getter(name="vmSshkey")
    def vm_sshkey(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ssh key for vm
        """
        return pulumi.get(self, "vm_sshkey")

    @_builtins.property
    @pulumi.getter(name="vmUsername")
    def vm_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access.
        """
        return pulumi.get(self, "vm_username")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        working directory. Default is /tmp
        """
        return pulumi.get(self, "working_directory")

