# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbRegisterDbserverArgs', 'NdbRegisterDbserver']

@pulumi.input_type
class NdbRegisterDbserverArgs:
    def __init__(__self__, *,
                 database_type: pulumi.Input[_builtins.str],
                 vm_ip: pulumi.Input[_builtins.str],
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nxcluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]] = None,
                 update_name_description_in_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbRegisterDbserver resource.
        :param pulumi.Input[_builtins.str] database_type: database type i.e. postgres_database
        :param pulumi.Input[_builtins.str] vm_ip: IP address of the database server VM
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is false
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: description of db server vm. Should be used in update Method only .
        :param pulumi.Input[_builtins.bool] forced_install: forced install the packages. Default is true
        :param pulumi.Input[_builtins.str] name: Name of db server vm. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] nxcluster_id: cluster on which you want to register the database server VM.
        :param pulumi.Input[_builtins.str] password: password of the NDB drive user account. Conflicts with ssh_key.
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]] postgres_databases: postgres info for dbserver
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_key: the private key. Conflicts with password.
        :param pulumi.Input[_builtins.bool] update_name_description_in_cluster: Updates the name and description in cluster. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] username: username of the NDB drive user account that has sudo access
        :param pulumi.Input[_builtins.str] working_directory: working directory of postgres. Default is "/tmp"
        """
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "vm_ip", vm_ip)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_vgs is not None:
            pulumi.set(__self__, "delete_vgs", delete_vgs)
        if delete_vm_snapshots is not None:
            pulumi.set(__self__, "delete_vm_snapshots", delete_vm_snapshots)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forced_install is not None:
            pulumi.set(__self__, "forced_install", forced_install)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nxcluster_id is not None:
            pulumi.set(__self__, "nxcluster_id", nxcluster_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postgres_databases is not None:
            pulumi.set(__self__, "postgres_databases", postgres_databases)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_name_description_in_cluster is not None:
            pulumi.set(__self__, "update_name_description_in_cluster", update_name_description_in_cluster)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[_builtins.str]:
        """
        database type i.e. postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> pulumi.Input[_builtins.str]:
        """
        IP address of the database server VM
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_ip", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is false
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @delete_vgs.setter
    def delete_vgs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vgs", value)

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @delete_vm_snapshots.setter
    def delete_vm_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vm_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of db server vm. Should be used in update Method only .
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        forced install the packages. Default is true
        """
        return pulumi.get(self, "forced_install")

    @forced_install.setter
    def forced_install(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced_install", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of db server vm. Should be used in Update Method only.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nxclusterId")
    def nxcluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster on which you want to register the database server VM.
        """
        return pulumi.get(self, "nxcluster_id")

    @nxcluster_id.setter
    def nxcluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nxcluster_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account. Conflicts with ssh_key.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]]:
        """
        postgres info for dbserver
        """
        return pulumi.get(self, "postgres_databases")

    @postgres_databases.setter
    def postgres_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]]):
        pulumi.set(self, "postgres_databases", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the private key. Conflicts with password.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updateNameDescriptionInCluster")
    def update_name_description_in_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Updates the name and description in cluster. Should be used in Update Method only.
        """
        return pulumi.get(self, "update_name_description_in_cluster")

    @update_name_description_in_cluster.setter
    def update_name_description_in_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_name_description_in_cluster", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        working directory of postgres. Default is "/tmp"
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class _NdbRegisterDbserverState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 era_created: Optional[pulumi.Input[_builtins.bool]] = None,
                 era_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
                 era_version: Optional[pulumi.Input[_builtins.str]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nxcluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPropertyArgs']]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_name_description_in_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbRegisterDbserver resources.
        :param pulumi.Input[_builtins.str] database_type: database type i.e. postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is false
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: description of db server vm. Should be used in update Method only .
        :param pulumi.Input[_builtins.bool] forced_install: forced install the packages. Default is true
        :param pulumi.Input[_builtins.str] name: Name of db server vm. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] nxcluster_id: cluster on which you want to register the database server VM.
        :param pulumi.Input[_builtins.str] password: password of the NDB drive user account. Conflicts with ssh_key.
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]] postgres_databases: postgres info for dbserver
        :param pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPropertyArgs']]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_key: the private key. Conflicts with password.
        :param pulumi.Input[_builtins.bool] update_name_description_in_cluster: Updates the name and description in cluster. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] username: username of the NDB drive user account that has sudo access
        :param pulumi.Input[_builtins.str] vm_ip: IP address of the database server VM
        :param pulumi.Input[_builtins.str] working_directory: working directory of postgres. Default is "/tmp"
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if dbserver_cluster_id is not None:
            pulumi.set(__self__, "dbserver_cluster_id", dbserver_cluster_id)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if delete_vgs is not None:
            pulumi.set(__self__, "delete_vgs", delete_vgs)
        if delete_vm_snapshots is not None:
            pulumi.set(__self__, "delete_vm_snapshots", delete_vm_snapshots)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if era_created is not None:
            pulumi.set(__self__, "era_created", era_created)
        if era_drive_id is not None:
            pulumi.set(__self__, "era_drive_id", era_drive_id)
        if era_version is not None:
            pulumi.set(__self__, "era_version", era_version)
        if forced_install is not None:
            pulumi.set(__self__, "forced_install", forced_install)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if mac_addresses is not None:
            pulumi.set(__self__, "mac_addresses", mac_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nxcluster_id is not None:
            pulumi.set(__self__, "nxcluster_id", nxcluster_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postgres_databases is not None:
            pulumi.set(__self__, "postgres_databases", postgres_databases)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if soft_remove is not None:
            pulumi.set(__self__, "soft_remove", soft_remove)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_name_description_in_cluster is not None:
            pulumi.set(__self__, "update_name_description_in_cluster", update_name_description_in_cluster)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vm_cluster_name is not None:
            pulumi.set(__self__, "vm_cluster_name", vm_cluster_name)
        if vm_cluster_uuid is not None:
            pulumi.set(__self__, "vm_cluster_uuid", vm_cluster_uuid)
        if vm_ip is not None:
            pulumi.set(__self__, "vm_ip", vm_ip)
        if vm_timezone is not None:
            pulumi.set(__self__, "vm_timezone", vm_timezone)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        database type i.e. postgres_database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_type", value)

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dbserver_cluster_id")

    @dbserver_cluster_id.setter
    def dbserver_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbserver_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is false
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @delete_vgs.setter
    def delete_vgs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vgs", value)

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @delete_vm_snapshots.setter
    def delete_vm_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_vm_snapshots", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of db server vm. Should be used in update Method only .
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eraCreated")
    def era_created(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "era_created")

    @era_created.setter
    def era_created(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "era_created", value)

    @_builtins.property
    @pulumi.getter(name="eraDriveId")
    def era_drive_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "era_drive_id")

    @era_drive_id.setter
    def era_drive_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "era_drive_id", value)

    @_builtins.property
    @pulumi.getter(name="eraVersion")
    def era_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "era_version")

    @era_version.setter
    def era_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "era_version", value)

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        forced install the packages. Default is true
        """
        return pulumi.get(self, "forced_install")

    @forced_install.setter
    def forced_install(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forced_install", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "mac_addresses")

    @mac_addresses.setter
    def mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mac_addresses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of db server vm. Should be used in Update Method only.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nxclusterId")
    def nxcluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster on which you want to register the database server VM.
        """
        return pulumi.get(self, "nxcluster_id")

    @nxcluster_id.setter
    def nxcluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nxcluster_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        password of the NDB drive user account. Conflicts with ssh_key.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]]:
        """
        postgres info for dbserver
        """
        return pulumi.get(self, "postgres_databases")

    @postgres_databases.setter
    def postgres_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPostgresDatabaseArgs']]]]):
        pulumi.set(self, "postgres_databases", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPropertyArgs']]]]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove", value)

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @soft_remove.setter
    def soft_remove(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_remove", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the private key. Conflicts with password.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_key", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbRegisterDbserverTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateNameDescriptionInCluster")
    def update_name_description_in_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Updates the name and description in cluster. Should be used in Update Method only.
        """
        return pulumi.get(self, "update_name_description_in_cluster")

    @update_name_description_in_cluster.setter
    def update_name_description_in_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_name_description_in_cluster", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterName")
    def vm_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_cluster_name")

    @vm_cluster_name.setter
    def vm_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterUuid")
    def vm_cluster_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_cluster_uuid")

    @vm_cluster_uuid.setter
    def vm_cluster_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_uuid", value)

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of the database server VM
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_ip", value)

    @_builtins.property
    @pulumi.getter(name="vmTimezone")
    def vm_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vm_timezone")

    @vm_timezone.setter
    def vm_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_timezone", value)

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        working directory of postgres. Default is "/tmp"
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.type_token("nutanix:index/ndbRegisterDbserver:NdbRegisterDbserver")
class NdbRegisterDbserver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverCredentialArgs', 'NdbRegisterDbserverCredentialArgsDict']]]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nxcluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPostgresDatabaseArgs', 'NdbRegisterDbserverPostgresDatabaseArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverTagArgs', 'NdbRegisterDbserverTagArgsDict']]]]] = None,
                 update_name_description_in_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to register database server VMs based on the input parameters. For 1.8.0 release, only postgress database type is qualified and officially supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_type: database type i.e. postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is false
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: description of db server vm. Should be used in update Method only .
        :param pulumi.Input[_builtins.bool] forced_install: forced install the packages. Default is true
        :param pulumi.Input[_builtins.str] name: Name of db server vm. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] nxcluster_id: cluster on which you want to register the database server VM.
        :param pulumi.Input[_builtins.str] password: password of the NDB drive user account. Conflicts with ssh_key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPostgresDatabaseArgs', 'NdbRegisterDbserverPostgresDatabaseArgsDict']]]] postgres_databases: postgres info for dbserver
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_key: the private key. Conflicts with password.
        :param pulumi.Input[_builtins.bool] update_name_description_in_cluster: Updates the name and description in cluster. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] username: username of the NDB drive user account that has sudo access
        :param pulumi.Input[_builtins.str] vm_ip: IP address of the database server VM
        :param pulumi.Input[_builtins.str] working_directory: working directory of postgres. Default is "/tmp"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbRegisterDbserverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to register database server VMs based on the input parameters. For 1.8.0 release, only postgress database type is qualified and officially supported.

        :param str resource_name: The name of the resource.
        :param NdbRegisterDbserverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbRegisterDbserverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverCredentialArgs', 'NdbRegisterDbserverCredentialArgsDict']]]]] = None,
                 database_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nxcluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPostgresDatabaseArgs', 'NdbRegisterDbserverPostgresDatabaseArgsDict']]]]] = None,
                 remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverTagArgs', 'NdbRegisterDbserverTagArgsDict']]]]] = None,
                 update_name_description_in_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbRegisterDbserverArgs.__new__(NdbRegisterDbserverArgs)

            __props__.__dict__["credentials"] = credentials
            if database_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_type'")
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["delete"] = delete
            __props__.__dict__["delete_vgs"] = delete_vgs
            __props__.__dict__["delete_vm_snapshots"] = delete_vm_snapshots
            __props__.__dict__["description"] = description
            __props__.__dict__["forced_install"] = forced_install
            __props__.__dict__["name"] = name
            __props__.__dict__["nxcluster_id"] = nxcluster_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["postgres_databases"] = postgres_databases
            __props__.__dict__["remove"] = remove
            __props__.__dict__["soft_remove"] = soft_remove
            __props__.__dict__["ssh_key"] = None if ssh_key is None else pulumi.Output.secret(ssh_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_name_description_in_cluster"] = update_name_description_in_cluster
            __props__.__dict__["username"] = username
            if vm_ip is None and not opts.urn:
                raise TypeError("Missing required property 'vm_ip'")
            __props__.__dict__["vm_ip"] = vm_ip
            __props__.__dict__["working_directory"] = working_directory
            __props__.__dict__["client_id"] = None
            __props__.__dict__["dbserver_cluster_id"] = None
            __props__.__dict__["era_created"] = None
            __props__.__dict__["era_drive_id"] = None
            __props__.__dict__["era_version"] = None
            __props__.__dict__["fqdns"] = None
            __props__.__dict__["internal"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["mac_addresses"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vm_cluster_name"] = None
            __props__.__dict__["vm_cluster_uuid"] = None
            __props__.__dict__["vm_timezone"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "sshKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NdbRegisterDbserver, __self__).__init__(
            'nutanix:index/ndbRegisterDbserver:NdbRegisterDbserver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverCredentialArgs', 'NdbRegisterDbserverCredentialArgsDict']]]]] = None,
            database_type: Optional[pulumi.Input[_builtins.str]] = None,
            dbserver_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            delete: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_vgs: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_vm_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            era_created: Optional[pulumi.Input[_builtins.bool]] = None,
            era_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
            era_version: Optional[pulumi.Input[_builtins.str]] = None,
            forced_install: Optional[pulumi.Input[_builtins.bool]] = None,
            fqdns: Optional[pulumi.Input[_builtins.str]] = None,
            internal: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nxcluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            postgres_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPostgresDatabaseArgs', 'NdbRegisterDbserverPostgresDatabaseArgsDict']]]]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPropertyArgs', 'NdbRegisterDbserverPropertyArgsDict']]]]] = None,
            remove: Optional[pulumi.Input[_builtins.bool]] = None,
            soft_remove: Optional[pulumi.Input[_builtins.bool]] = None,
            ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverTagArgs', 'NdbRegisterDbserverTagArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_name_description_in_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vm_ip: Optional[pulumi.Input[_builtins.str]] = None,
            vm_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            working_directory: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbRegisterDbserver':
        """
        Get an existing NdbRegisterDbserver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_type: database type i.e. postgres_database
        :param pulumi.Input[_builtins.bool] delete: - (Optional) Delete the VM and associated storage. Default value is false
        :param pulumi.Input[_builtins.bool] delete_vgs: - (Optional) Delete volume grous. Default value is true
        :param pulumi.Input[_builtins.bool] delete_vm_snapshots: - (Optional) Delete the vm snapshots. Default is true
        :param pulumi.Input[_builtins.str] description: description of db server vm. Should be used in update Method only .
        :param pulumi.Input[_builtins.bool] forced_install: forced install the packages. Default is true
        :param pulumi.Input[_builtins.str] name: Name of db server vm. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] nxcluster_id: cluster on which you want to register the database server VM.
        :param pulumi.Input[_builtins.str] password: password of the NDB drive user account. Conflicts with ssh_key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPostgresDatabaseArgs', 'NdbRegisterDbserverPostgresDatabaseArgsDict']]]] postgres_databases: postgres info for dbserver
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbRegisterDbserverPropertyArgs', 'NdbRegisterDbserverPropertyArgsDict']]]] properties: List of all the properties
        :param pulumi.Input[_builtins.bool] remove: - (Optional) Unregister the database from NDB. Default value is true
        :param pulumi.Input[_builtins.bool] soft_remove: - (Optional) Soft remove. Default will be false
        :param pulumi.Input[_builtins.str] ssh_key: the private key. Conflicts with password.
        :param pulumi.Input[_builtins.bool] update_name_description_in_cluster: Updates the name and description in cluster. Should be used in Update Method only.
        :param pulumi.Input[_builtins.str] username: username of the NDB drive user account that has sudo access
        :param pulumi.Input[_builtins.str] vm_ip: IP address of the database server VM
        :param pulumi.Input[_builtins.str] working_directory: working directory of postgres. Default is "/tmp"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbRegisterDbserverState.__new__(_NdbRegisterDbserverState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["dbserver_cluster_id"] = dbserver_cluster_id
        __props__.__dict__["delete"] = delete
        __props__.__dict__["delete_vgs"] = delete_vgs
        __props__.__dict__["delete_vm_snapshots"] = delete_vm_snapshots
        __props__.__dict__["description"] = description
        __props__.__dict__["era_created"] = era_created
        __props__.__dict__["era_drive_id"] = era_drive_id
        __props__.__dict__["era_version"] = era_version
        __props__.__dict__["forced_install"] = forced_install
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["internal"] = internal
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["mac_addresses"] = mac_addresses
        __props__.__dict__["name"] = name
        __props__.__dict__["nxcluster_id"] = nxcluster_id
        __props__.__dict__["password"] = password
        __props__.__dict__["postgres_databases"] = postgres_databases
        __props__.__dict__["properties"] = properties
        __props__.__dict__["remove"] = remove
        __props__.__dict__["soft_remove"] = soft_remove
        __props__.__dict__["ssh_key"] = ssh_key
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["update_name_description_in_cluster"] = update_name_description_in_cluster
        __props__.__dict__["username"] = username
        __props__.__dict__["vm_cluster_name"] = vm_cluster_name
        __props__.__dict__["vm_cluster_uuid"] = vm_cluster_uuid
        __props__.__dict__["vm_ip"] = vm_ip
        __props__.__dict__["vm_timezone"] = vm_timezone
        __props__.__dict__["working_directory"] = working_directory
        return NdbRegisterDbserver(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[Sequence['outputs.NdbRegisterDbserverCredential']]]:
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[_builtins.str]:
        """
        database type i.e. postgres_database
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "dbserver_cluster_id")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the VM and associated storage. Default value is false
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter(name="deleteVgs")
    def delete_vgs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete volume grous. Default value is true
        """
        return pulumi.get(self, "delete_vgs")

    @_builtins.property
    @pulumi.getter(name="deleteVmSnapshots")
    def delete_vm_snapshots(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Delete the vm snapshots. Default is true
        """
        return pulumi.get(self, "delete_vm_snapshots")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        description of db server vm. Should be used in update Method only .
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eraCreated")
    def era_created(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "era_created")

    @_builtins.property
    @pulumi.getter(name="eraDriveId")
    def era_drive_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "era_drive_id")

    @_builtins.property
    @pulumi.getter(name="eraVersion")
    def era_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "era_version")

    @_builtins.property
    @pulumi.getter(name="forcedInstall")
    def forced_install(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        forced install the packages. Default is true
        """
        return pulumi.get(self, "forced_install")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "mac_addresses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of db server vm. Should be used in Update Method only.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxclusterId")
    def nxcluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        cluster on which you want to register the database server VM.
        """
        return pulumi.get(self, "nxcluster_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        password of the NDB drive user account. Conflicts with ssh_key.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="postgresDatabases")
    def postgres_databases(self) -> pulumi.Output[Optional[Sequence['outputs.NdbRegisterDbserverPostgresDatabase']]]:
        """
        postgres info for dbserver
        """
        return pulumi.get(self, "postgres_databases")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDbserverProperty']]:
        """
        List of all the properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Unregister the database from NDB. Default value is true
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter(name="softRemove")
    def soft_remove(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        - (Optional) Soft remove. Default will be false
        """
        return pulumi.get(self, "soft_remove")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        the private key. Conflicts with password.
        """
        return pulumi.get(self, "ssh_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.NdbRegisterDbserverTag']]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateNameDescriptionInCluster")
    def update_name_description_in_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Updates the name and description in cluster. Should be used in Update Method only.
        """
        return pulumi.get(self, "update_name_description_in_cluster")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        username of the NDB drive user account that has sudo access
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="vmClusterName")
    def vm_cluster_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_cluster_name")

    @_builtins.property
    @pulumi.getter(name="vmClusterUuid")
    def vm_cluster_uuid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP address of the database server VM
        """
        return pulumi.get(self, "vm_ip")

    @_builtins.property
    @pulumi.getter(name="vmTimezone")
    def vm_timezone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vm_timezone")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        working directory of postgres. Default is "/tmp"
        """
        return pulumi.get(self, "working_directory")

