# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NdbSlaArgs', 'NdbSla']

@pulumi.input_type
class NdbSlaArgs:
    def __init__(__self__, *,
                 continuous_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 daily_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quarterly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NdbSla resource.
        :param pulumi.Input[_builtins.int] continuous_retention: Duration in days for which transaction logs are retained in NDB.
        :param pulumi.Input[_builtins.int] daily_retention: Duration in days for which a daily snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.str] description: Description of profile
        :param pulumi.Input[_builtins.int] monthly_retention: Duration in months for which a monthly snapshot must be retained in NDB
        :param pulumi.Input[_builtins.str] name: Name of profile
        :param pulumi.Input[_builtins.int] quarterly_retention: Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] weekly_retention: Duration in weeks for which a weekly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] yearly_retention: Not supported as of now.
        """
        if continuous_retention is not None:
            pulumi.set(__self__, "continuous_retention", continuous_retention)
        if daily_retention is not None:
            pulumi.set(__self__, "daily_retention", daily_retention)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quarterly_retention is not None:
            pulumi.set(__self__, "quarterly_retention", quarterly_retention)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @_builtins.property
    @pulumi.getter(name="continuousRetention")
    def continuous_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in days for which transaction logs are retained in NDB.
        """
        return pulumi.get(self, "continuous_retention")

    @continuous_retention.setter
    def continuous_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "continuous_retention", value)

    @_builtins.property
    @pulumi.getter(name="dailyRetention")
    def daily_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in days for which a daily snapshot must be retained in NDB.
        """
        return pulumi.get(self, "daily_retention")

    @daily_retention.setter
    def daily_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_retention", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in months for which a monthly snapshot must be retained in NDB
        """
        return pulumi.get(self, "monthly_retention")

    @monthly_retention.setter
    def monthly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_retention", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="quarterlyRetention")
    def quarterly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "quarterly_retention")

    @quarterly_retention.setter
    def quarterly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quarterly_retention", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in weeks for which a weekly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "weekly_retention")

    @weekly_retention.setter
    def weekly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_retention", value)

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Not supported as of now.
        """
        return pulumi.get(self, "yearly_retention")

    @yearly_retention.setter
    def yearly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "yearly_retention", value)


@pulumi.input_type
class _NdbSlaState:
    def __init__(__self__, *,
                 continuous_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 current_active_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 daily_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pitr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quarterly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 reference_count: Optional[pulumi.Input[_builtins.int]] = None,
                 system_sla: Optional[pulumi.Input[_builtins.bool]] = None,
                 unique_name: Optional[pulumi.Input[_builtins.str]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NdbSla resources.
        :param pulumi.Input[_builtins.int] continuous_retention: Duration in days for which transaction logs are retained in NDB.
        :param pulumi.Input[_builtins.str] current_active_frequency: slas current frequency
        :param pulumi.Input[_builtins.int] daily_retention: Duration in days for which a daily snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.str] date_created: sla created data
        :param pulumi.Input[_builtins.str] date_modified: sla last modified date
        :param pulumi.Input[_builtins.str] description: Description of profile
        :param pulumi.Input[_builtins.int] monthly_retention: Duration in months for which a monthly snapshot must be retained in NDB
        :param pulumi.Input[_builtins.str] name: Name of profile
        :param pulumi.Input[_builtins.str] owner_id: owner id
        :param pulumi.Input[_builtins.bool] pitr_enabled: pitr enabled
        :param pulumi.Input[_builtins.int] quarterly_retention: Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] reference_count: reference count
        :param pulumi.Input[_builtins.bool] system_sla: refers whether sla is custom or built-in
        :param pulumi.Input[_builtins.str] unique_name: name of sla
        :param pulumi.Input[_builtins.int] weekly_retention: Duration in weeks for which a weekly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] yearly_retention: Not supported as of now.
        """
        if continuous_retention is not None:
            pulumi.set(__self__, "continuous_retention", continuous_retention)
        if current_active_frequency is not None:
            pulumi.set(__self__, "current_active_frequency", current_active_frequency)
        if daily_retention is not None:
            pulumi.set(__self__, "daily_retention", daily_retention)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if pitr_enabled is not None:
            pulumi.set(__self__, "pitr_enabled", pitr_enabled)
        if quarterly_retention is not None:
            pulumi.set(__self__, "quarterly_retention", quarterly_retention)
        if reference_count is not None:
            pulumi.set(__self__, "reference_count", reference_count)
        if system_sla is not None:
            pulumi.set(__self__, "system_sla", system_sla)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @_builtins.property
    @pulumi.getter(name="continuousRetention")
    def continuous_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in days for which transaction logs are retained in NDB.
        """
        return pulumi.get(self, "continuous_retention")

    @continuous_retention.setter
    def continuous_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "continuous_retention", value)

    @_builtins.property
    @pulumi.getter(name="currentActiveFrequency")
    def current_active_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        slas current frequency
        """
        return pulumi.get(self, "current_active_frequency")

    @current_active_frequency.setter
    def current_active_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_active_frequency", value)

    @_builtins.property
    @pulumi.getter(name="dailyRetention")
    def daily_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in days for which a daily snapshot must be retained in NDB.
        """
        return pulumi.get(self, "daily_retention")

    @daily_retention.setter
    def daily_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_retention", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sla created data
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        sla last modified date
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in months for which a monthly snapshot must be retained in NDB
        """
        return pulumi.get(self, "monthly_retention")

    @monthly_retention.setter
    def monthly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_retention", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        owner id
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter(name="pitrEnabled")
    def pitr_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        pitr enabled
        """
        return pulumi.get(self, "pitr_enabled")

    @pitr_enabled.setter
    def pitr_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pitr_enabled", value)

    @_builtins.property
    @pulumi.getter(name="quarterlyRetention")
    def quarterly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "quarterly_retention")

    @quarterly_retention.setter
    def quarterly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quarterly_retention", value)

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        reference count
        """
        return pulumi.get(self, "reference_count")

    @reference_count.setter
    def reference_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_count", value)

    @_builtins.property
    @pulumi.getter(name="systemSla")
    def system_sla(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        refers whether sla is custom or built-in
        """
        return pulumi.get(self, "system_sla")

    @system_sla.setter
    def system_sla(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_sla", value)

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of sla
        """
        return pulumi.get(self, "unique_name")

    @unique_name.setter
    def unique_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_name", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration in weeks for which a weekly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "weekly_retention")

    @weekly_retention.setter
    def weekly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_retention", value)

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Not supported as of now.
        """
        return pulumi.get(self, "yearly_retention")

    @yearly_retention.setter
    def yearly_retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "yearly_retention", value)


@pulumi.type_token("nutanix:index/ndbSla:NdbSla")
class NdbSla(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continuous_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 daily_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quarterly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a resource to create SLAs based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        sla = nutanix.NdbSla("sla",
            name="test-sla",
            description="here goes description",
            continuous_retention=30,
            daily_retention=3,
            weekly_retention=2,
            monthly_retention=1,
            quarterly_retention=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] continuous_retention: Duration in days for which transaction logs are retained in NDB.
        :param pulumi.Input[_builtins.int] daily_retention: Duration in days for which a daily snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.str] description: Description of profile
        :param pulumi.Input[_builtins.int] monthly_retention: Duration in months for which a monthly snapshot must be retained in NDB
        :param pulumi.Input[_builtins.str] name: Name of profile
        :param pulumi.Input[_builtins.int] quarterly_retention: Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] weekly_retention: Duration in weeks for which a weekly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] yearly_retention: Not supported as of now.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NdbSlaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create SLAs based on the input parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        sla = nutanix.NdbSla("sla",
            name="test-sla",
            description="here goes description",
            continuous_retention=30,
            daily_retention=3,
            weekly_retention=2,
            monthly_retention=1,
            quarterly_retention=1)
        ```

        :param str resource_name: The name of the resource.
        :param NdbSlaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbSlaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continuous_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 daily_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quarterly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbSlaArgs.__new__(NdbSlaArgs)

            __props__.__dict__["continuous_retention"] = continuous_retention
            __props__.__dict__["daily_retention"] = daily_retention
            __props__.__dict__["description"] = description
            __props__.__dict__["monthly_retention"] = monthly_retention
            __props__.__dict__["name"] = name
            __props__.__dict__["quarterly_retention"] = quarterly_retention
            __props__.__dict__["weekly_retention"] = weekly_retention
            __props__.__dict__["yearly_retention"] = yearly_retention
            __props__.__dict__["current_active_frequency"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["pitr_enabled"] = None
            __props__.__dict__["reference_count"] = None
            __props__.__dict__["system_sla"] = None
            __props__.__dict__["unique_name"] = None
        super(NdbSla, __self__).__init__(
            'nutanix:index/ndbSla:NdbSla',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            continuous_retention: Optional[pulumi.Input[_builtins.int]] = None,
            current_active_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            daily_retention: Optional[pulumi.Input[_builtins.int]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            monthly_retention: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            pitr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            quarterly_retention: Optional[pulumi.Input[_builtins.int]] = None,
            reference_count: Optional[pulumi.Input[_builtins.int]] = None,
            system_sla: Optional[pulumi.Input[_builtins.bool]] = None,
            unique_name: Optional[pulumi.Input[_builtins.str]] = None,
            weekly_retention: Optional[pulumi.Input[_builtins.int]] = None,
            yearly_retention: Optional[pulumi.Input[_builtins.int]] = None) -> 'NdbSla':
        """
        Get an existing NdbSla resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] continuous_retention: Duration in days for which transaction logs are retained in NDB.
        :param pulumi.Input[_builtins.str] current_active_frequency: slas current frequency
        :param pulumi.Input[_builtins.int] daily_retention: Duration in days for which a daily snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.str] date_created: sla created data
        :param pulumi.Input[_builtins.str] date_modified: sla last modified date
        :param pulumi.Input[_builtins.str] description: Description of profile
        :param pulumi.Input[_builtins.int] monthly_retention: Duration in months for which a monthly snapshot must be retained in NDB
        :param pulumi.Input[_builtins.str] name: Name of profile
        :param pulumi.Input[_builtins.str] owner_id: owner id
        :param pulumi.Input[_builtins.bool] pitr_enabled: pitr enabled
        :param pulumi.Input[_builtins.int] quarterly_retention: Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] reference_count: reference count
        :param pulumi.Input[_builtins.bool] system_sla: refers whether sla is custom or built-in
        :param pulumi.Input[_builtins.str] unique_name: name of sla
        :param pulumi.Input[_builtins.int] weekly_retention: Duration in weeks for which a weekly snapshot must be retained in NDB.
        :param pulumi.Input[_builtins.int] yearly_retention: Not supported as of now.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbSlaState.__new__(_NdbSlaState)

        __props__.__dict__["continuous_retention"] = continuous_retention
        __props__.__dict__["current_active_frequency"] = current_active_frequency
        __props__.__dict__["daily_retention"] = daily_retention
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["description"] = description
        __props__.__dict__["monthly_retention"] = monthly_retention
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["pitr_enabled"] = pitr_enabled
        __props__.__dict__["quarterly_retention"] = quarterly_retention
        __props__.__dict__["reference_count"] = reference_count
        __props__.__dict__["system_sla"] = system_sla
        __props__.__dict__["unique_name"] = unique_name
        __props__.__dict__["weekly_retention"] = weekly_retention
        __props__.__dict__["yearly_retention"] = yearly_retention
        return NdbSla(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="continuousRetention")
    def continuous_retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration in days for which transaction logs are retained in NDB.
        """
        return pulumi.get(self, "continuous_retention")

    @_builtins.property
    @pulumi.getter(name="currentActiveFrequency")
    def current_active_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        slas current frequency
        """
        return pulumi.get(self, "current_active_frequency")

    @_builtins.property
    @pulumi.getter(name="dailyRetention")
    def daily_retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration in days for which a daily snapshot must be retained in NDB.
        """
        return pulumi.get(self, "daily_retention")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        sla created data
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        sla last modified date
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration in months for which a monthly snapshot must be retained in NDB
        """
        return pulumi.get(self, "monthly_retention")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        owner id
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="pitrEnabled")
    def pitr_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        pitr enabled
        """
        return pulumi.get(self, "pitr_enabled")

    @_builtins.property
    @pulumi.getter(name="quarterlyRetention")
    def quarterly_retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration in number of quarters for which a quarterly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "quarterly_retention")

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> pulumi.Output[_builtins.int]:
        """
        reference count
        """
        return pulumi.get(self, "reference_count")

    @_builtins.property
    @pulumi.getter(name="systemSla")
    def system_sla(self) -> pulumi.Output[_builtins.bool]:
        """
        refers whether sla is custom or built-in
        """
        return pulumi.get(self, "system_sla")

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of sla
        """
        return pulumi.get(self, "unique_name")

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration in weeks for which a weekly snapshot must be retained in NDB.
        """
        return pulumi.get(self, "weekly_retention")

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> pulumi.Output[_builtins.int]:
        """
        Not supported as of now.
        """
        return pulumi.get(self, "yearly_retention")

