# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NdbStretchedVlanArgs', 'NdbStretchedVlan']

@pulumi.input_type
class NdbStretchedVlanArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 vlan_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbStretchedVlan resource.
        :param pulumi.Input[_builtins.str] type: type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vlan_ids: list of vlan ids to be added in NDB
        :param pulumi.Input[_builtins.str] description: Description of stretched vlan
        :param pulumi.Input['NdbStretchedVlanMetadataArgs'] metadata: Update the stretched VLAN Gateway and Subnet Mask IP address
               * `metadata.gateway`: Update the gateway of stretched vlan
               * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        :param pulumi.Input[_builtins.str] name: name for the stretched VLAN
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_ids", vlan_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vlanIds")
    def vlan_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        list of vlan ids to be added in NDB
        """
        return pulumi.get(self, "vlan_ids")

    @vlan_ids.setter
    def vlan_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "vlan_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of stretched vlan
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']]:
        """
        Update the stretched VLAN Gateway and Subnet Mask IP address
        * `metadata.gateway`: Update the gateway of stretched vlan
        * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name for the stretched VLAN
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NdbStretchedVlanState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vlans_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NdbStretchedVlanVlansListArgs']]]] = None):
        """
        Input properties used for looking up and filtering NdbStretchedVlan resources.
        :param pulumi.Input[_builtins.str] description: Description of stretched vlan
        :param pulumi.Input['NdbStretchedVlanMetadataArgs'] metadata: Update the stretched VLAN Gateway and Subnet Mask IP address
               * `metadata.gateway`: Update the gateway of stretched vlan
               * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        :param pulumi.Input[_builtins.str] name: name for the stretched VLAN
        :param pulumi.Input[_builtins.str] type: type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vlan_ids: list of vlan ids to be added in NDB
        :param pulumi.Input[Sequence[pulumi.Input['NdbStretchedVlanVlansListArgs']]] vlans_lists: properties of vlans
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_ids is not None:
            pulumi.set(__self__, "vlan_ids", vlan_ids)
        if vlans_lists is not None:
            pulumi.set(__self__, "vlans_lists", vlans_lists)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of stretched vlan
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']]:
        """
        Update the stretched VLAN Gateway and Subnet Mask IP address
        * `metadata.gateway`: Update the gateway of stretched vlan
        * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['NdbStretchedVlanMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name for the stretched VLAN
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vlanIds")
    def vlan_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        list of vlan ids to be added in NDB
        """
        return pulumi.get(self, "vlan_ids")

    @vlan_ids.setter
    def vlan_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vlan_ids", value)

    @_builtins.property
    @pulumi.getter(name="vlansLists")
    def vlans_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NdbStretchedVlanVlansListArgs']]]]:
        """
        properties of vlans
        """
        return pulumi.get(self, "vlans_lists")

    @vlans_lists.setter
    def vlans_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NdbStretchedVlanVlansListArgs']]]]):
        pulumi.set(self, "vlans_lists", value)


@pulumi.type_token("nutanix:index/ndbStretchedVlan:NdbStretchedVlan")
class NdbStretchedVlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['NdbStretchedVlanMetadataArgs', 'NdbStretchedVlanMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to create stretched vlans based on the input parameters.

        ## Example Usage

        ### resource to add stretched vlan in NDB
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbStretchedVlan("name",
            name="test-stretcName",
            description="vlan desc updated",
            type="Static",
            vlan_ids=[
                "{{ vlan_id_1 }}",
                "{{ vlan_id_2 }}",
            ])
        ```

        ### resource to update the strteched vlan with new gateway and subnet mask
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbStretchedVlan("name",
            name="test-stretcName",
            description="vlan desc updated",
            type="Static",
            vlan_ids=[
                "{{ vlan_id_1 }}",
                "{{ vlan_id_2 }}",
            ],
            metadata={
                "gateway": "{{ gateway of vlans }}",
                "subnet_mask": "{{ subnet mask of vlans }}",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of stretched vlan
        :param pulumi.Input[Union['NdbStretchedVlanMetadataArgs', 'NdbStretchedVlanMetadataArgsDict']] metadata: Update the stretched VLAN Gateway and Subnet Mask IP address
               * `metadata.gateway`: Update the gateway of stretched vlan
               * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        :param pulumi.Input[_builtins.str] name: name for the stretched VLAN
        :param pulumi.Input[_builtins.str] type: type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vlan_ids: list of vlan ids to be added in NDB
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbStretchedVlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create stretched vlans based on the input parameters.

        ## Example Usage

        ### resource to add stretched vlan in NDB
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbStretchedVlan("name",
            name="test-stretcName",
            description="vlan desc updated",
            type="Static",
            vlan_ids=[
                "{{ vlan_id_1 }}",
                "{{ vlan_id_2 }}",
            ])
        ```

        ### resource to update the strteched vlan with new gateway and subnet mask
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbStretchedVlan("name",
            name="test-stretcName",
            description="vlan desc updated",
            type="Static",
            vlan_ids=[
                "{{ vlan_id_1 }}",
                "{{ vlan_id_2 }}",
            ],
            metadata={
                "gateway": "{{ gateway of vlans }}",
                "subnet_mask": "{{ subnet mask of vlans }}",
            })
        ```

        :param str resource_name: The name of the resource.
        :param NdbStretchedVlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbStretchedVlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['NdbStretchedVlanMetadataArgs', 'NdbStretchedVlanMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbStretchedVlanArgs.__new__(NdbStretchedVlanArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if vlan_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_ids'")
            __props__.__dict__["vlan_ids"] = vlan_ids
            __props__.__dict__["vlans_lists"] = None
        super(NdbStretchedVlan, __self__).__init__(
            'nutanix:index/ndbStretchedVlan:NdbStretchedVlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['NdbStretchedVlanMetadataArgs', 'NdbStretchedVlanMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vlans_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NdbStretchedVlanVlansListArgs', 'NdbStretchedVlanVlansListArgsDict']]]]] = None) -> 'NdbStretchedVlan':
        """
        Get an existing NdbStretchedVlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of stretched vlan
        :param pulumi.Input[Union['NdbStretchedVlanMetadataArgs', 'NdbStretchedVlanMetadataArgsDict']] metadata: Update the stretched VLAN Gateway and Subnet Mask IP address
               * `metadata.gateway`: Update the gateway of stretched vlan
               * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        :param pulumi.Input[_builtins.str] name: name for the stretched VLAN
        :param pulumi.Input[_builtins.str] type: type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vlan_ids: list of vlan ids to be added in NDB
        :param pulumi.Input[Sequence[pulumi.Input[Union['NdbStretchedVlanVlansListArgs', 'NdbStretchedVlanVlansListArgsDict']]]] vlans_lists: properties of vlans
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbStretchedVlanState.__new__(_NdbStretchedVlanState)

        __props__.__dict__["description"] = description
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["vlan_ids"] = vlan_ids
        __props__.__dict__["vlans_lists"] = vlans_lists
        return NdbStretchedVlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of stretched vlan
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.NdbStretchedVlanMetadata']:
        """
        Update the stretched VLAN Gateway and Subnet Mask IP address
        * `metadata.gateway`: Update the gateway of stretched vlan
        * `metadata.subnet_mask`: Update the subnet_mask of stretched vlan
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name for the stretched VLAN
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of vlan. static VLANs that are managed in NDB can be added to a stretched VLAN.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vlanIds")
    def vlan_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        list of vlan ids to be added in NDB
        """
        return pulumi.get(self, "vlan_ids")

    @_builtins.property
    @pulumi.getter(name="vlansLists")
    def vlans_lists(self) -> pulumi.Output[Sequence['outputs.NdbStretchedVlanVlansList']]:
        """
        properties of vlans
        """
        return pulumi.get(self, "vlans_lists")

