# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NdbTagArgs', 'NdbTag']

@pulumi.input_type
class NdbTagArgs:
    def __init__(__self__, *,
                 entity_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbTag resource.
        :param pulumi.Input[_builtins.str] entity_type: entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        :param pulumi.Input[_builtins.str] description: description for the tag
        :param pulumi.Input[_builtins.str] name: name for the tag
        :param pulumi.Input[_builtins.bool] required: provide a tag value for entities.
        :param pulumi.Input[_builtins.str] status: Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        """
        pulumi.set(__self__, "entity_type", entity_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[_builtins.str]:
        """
        entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for the tag
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name for the tag
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        provide a tag value for entities.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _NdbTagState:
    def __init__(__self__, *,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NdbTag resources.
        :param pulumi.Input[_builtins.str] date_created: date created of the tag
        :param pulumi.Input[_builtins.str] date_modified: modified date of tha tag
        :param pulumi.Input[_builtins.str] description: description for the tag
        :param pulumi.Input[_builtins.str] entity_type: entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        :param pulumi.Input[_builtins.str] name: name for the tag
        :param pulumi.Input[_builtins.str] owner: owner id of the tag
        :param pulumi.Input[_builtins.bool] required: provide a tag value for entities.
        :param pulumi.Input[_builtins.str] status: Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        :param pulumi.Input[_builtins.int] values: value for the tag
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        date created of the tag
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        modified date of tha tag
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for the tag
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name for the tag
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        owner id of the tag
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        provide a tag value for entities.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        value for the tag
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("nutanix:index/ndbTag:NdbTag")
class NdbTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create tags based on the input parameters.

        ## Example Usage

        ### resource to create tag
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbTag("name",
            name="testst-up",
            description="this is desc ok",
            entity_type="DATABASE",
            required=True)
        ```

        ### resource to update tag with status
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbTag("name",
            name="testst-up",
            description="this is desc ok",
            entity_type="DATABASE",
            required=True,
            status="DEPRECATED")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: description for the tag
        :param pulumi.Input[_builtins.str] entity_type: entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        :param pulumi.Input[_builtins.str] name: name for the tag
        :param pulumi.Input[_builtins.bool] required: provide a tag value for entities.
        :param pulumi.Input[_builtins.str] status: Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create tags based on the input parameters.

        ## Example Usage

        ### resource to create tag
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbTag("name",
            name="testst-up",
            description="this is desc ok",
            entity_type="DATABASE",
            required=True)
        ```

        ### resource to update tag with status
        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        name = nutanix.NdbTag("name",
            name="testst-up",
            description="this is desc ok",
            entity_type="DATABASE",
            required=True,
            status="DEPRECATED")
        ```

        :param str resource_name: The name of the resource.
        :param NdbTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbTagArgs.__new__(NdbTagArgs)

            __props__.__dict__["description"] = description
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            __props__.__dict__["name"] = name
            __props__.__dict__["required"] = required
            __props__.__dict__["status"] = status
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["values"] = None
        super(NdbTag, __self__).__init__(
            'nutanix:index/ndbTag:NdbTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            required: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[_builtins.int]] = None) -> 'NdbTag':
        """
        Get an existing NdbTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] date_created: date created of the tag
        :param pulumi.Input[_builtins.str] date_modified: modified date of tha tag
        :param pulumi.Input[_builtins.str] description: description for the tag
        :param pulumi.Input[_builtins.str] entity_type: entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        :param pulumi.Input[_builtins.str] name: name for the tag
        :param pulumi.Input[_builtins.str] owner: owner id of the tag
        :param pulumi.Input[_builtins.bool] required: provide a tag value for entities.
        :param pulumi.Input[_builtins.str] status: Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        :param pulumi.Input[_builtins.int] values: value for the tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbTagState.__new__(_NdbTagState)

        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["required"] = required
        __props__.__dict__["status"] = status
        __props__.__dict__["values"] = values
        return NdbTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        date created of the tag
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        modified date of tha tag
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        description for the tag
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        entity for the tag to be associated with. Supported values [ DATABASE, TIME_MACHINE, CLONE, DATABASE_SERVER ].
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name for the tag
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        owner id of the tag
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        provide a tag value for entities.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the tag. Supported values are [ ENABLED, DEPRECATED ]
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[_builtins.int]:
        """
        value for the tag
        """
        return pulumi.get(self, "values")

