# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NdbTmsClusterArgs', 'NdbTmsCluster']

@pulumi.input_type
class NdbTmsClusterArgs:
    def __init__(__self__, *,
                 nx_cluster_id: pulumi.Input[_builtins.str],
                 sla_id: pulumi.Input[_builtins.str],
                 time_machine_id: pulumi.Input[_builtins.str],
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NdbTmsCluster resource.
        :param pulumi.Input[_builtins.str] nx_cluster_id: Nutanix cluster id on the associated registered clusters.
        :param pulumi.Input[_builtins.str] sla_id: SLA id for the associated cluster.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] type: Default value is "OTHER"
        """
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        pulumi.set(__self__, "sla_id", sla_id)
        pulumi.set(__self__, "time_machine_id", time_machine_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Nutanix cluster id on the associated registered clusters.
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="slaId")
    def sla_id(self) -> pulumi.Input[_builtins.str]:
        """
        SLA id for the associated cluster.
        """
        return pulumi.get(self, "sla_id")

    @sla_id.setter
    def sla_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sla_id", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default value is "OTHER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NdbTmsClusterState:
    def __init__(__self__, *,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 date_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 log_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_drive_status: Optional[pulumi.Input[_builtins.str]] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NdbTmsCluster resources.
        :param pulumi.Input[_builtins.str] date_created: created date of time machine associated with cluster
        :param pulumi.Input[_builtins.str] date_modified: modified date of time machine associated with cluster
        :param pulumi.Input[_builtins.str] description: description of nutanix cluster associated with time machine
        :param pulumi.Input[_builtins.str] log_drive_id: log drive id
        :param pulumi.Input[_builtins.str] log_drive_status: log drive status of time machine
        :param pulumi.Input[_builtins.str] nx_cluster_id: Nutanix cluster id on the associated registered clusters.
        :param pulumi.Input[_builtins.str] owner_id: owner id
        :param pulumi.Input[_builtins.str] schedule_id: schedule id of the data associated with time machine
        :param pulumi.Input[_builtins.str] sla_id: SLA id for the associated cluster.
        :param pulumi.Input[_builtins.bool] source: source is present or not
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_clusters: source clusters in time machines
        :param pulumi.Input[_builtins.str] status: status of the cluster associated with time machine
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] type: Default value is "OTHER"
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_modified is not None:
            pulumi.set(__self__, "date_modified", date_modified)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_drive_id is not None:
            pulumi.set(__self__, "log_drive_id", log_drive_id)
        if log_drive_status is not None:
            pulumi.set(__self__, "log_drive_status", log_drive_status)
        if nx_cluster_id is not None:
            pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if schedule_id is not None:
            pulumi.set(__self__, "schedule_id", schedule_id)
        if sla_id is not None:
            pulumi.set(__self__, "sla_id", sla_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_clusters is not None:
            pulumi.set(__self__, "source_clusters", source_clusters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_machine_id is not None:
            pulumi.set(__self__, "time_machine_id", time_machine_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        created date of time machine associated with cluster
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        modified date of time machine associated with cluster
        """
        return pulumi.get(self, "date_modified")

    @date_modified.setter
    def date_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_modified", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description of nutanix cluster associated with time machine
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="logDriveId")
    def log_drive_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        log drive id
        """
        return pulumi.get(self, "log_drive_id")

    @log_drive_id.setter
    def log_drive_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_drive_id", value)

    @_builtins.property
    @pulumi.getter(name="logDriveStatus")
    def log_drive_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        log drive status of time machine
        """
        return pulumi.get(self, "log_drive_status")

    @log_drive_status.setter
    def log_drive_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_drive_status", value)

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nutanix cluster id on the associated registered clusters.
        """
        return pulumi.get(self, "nx_cluster_id")

    @nx_cluster_id.setter
    def nx_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nx_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        owner id
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schedule id of the data associated with time machine
        """
        return pulumi.get(self, "schedule_id")

    @schedule_id.setter
    def schedule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_id", value)

    @_builtins.property
    @pulumi.getter(name="slaId")
    def sla_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SLA id for the associated cluster.
        """
        return pulumi.get(self, "sla_id")

    @sla_id.setter
    def sla_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sla_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        source is present or not
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceClusters")
    def source_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        source clusters in time machines
        """
        return pulumi.get(self, "source_clusters")

    @source_clusters.setter
    def source_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_clusters", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        status of the cluster associated with time machine
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @time_machine_id.setter
    def time_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default value is "OTHER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("nutanix:index/ndbTmsCluster:NdbTmsCluster")
class NdbTmsCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage time machine data availability across all the registered Nutanix clusters in NDB.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cls = nutanix.NdbTmsCluster("cls",
            time_machine_id="{{ tms_id }}",
            nx_cluster_id="{{ cluster_id }}",
            sla_id="{{ sla_id }}")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] nx_cluster_id: Nutanix cluster id on the associated registered clusters.
        :param pulumi.Input[_builtins.str] sla_id: SLA id for the associated cluster.
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] type: Default value is "OTHER"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NdbTmsClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage time machine data availability across all the registered Nutanix clusters in NDB.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cls = nutanix.NdbTmsCluster("cls",
            time_machine_id="{{ tms_id }}",
            nx_cluster_id="{{ cluster_id }}",
            sla_id="{{ sla_id }}")
        ```

        :param str resource_name: The name of the resource.
        :param NdbTmsClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NdbTmsClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sla_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NdbTmsClusterArgs.__new__(NdbTmsClusterArgs)

            if nx_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'nx_cluster_id'")
            __props__.__dict__["nx_cluster_id"] = nx_cluster_id
            if sla_id is None and not opts.urn:
                raise TypeError("Missing required property 'sla_id'")
            __props__.__dict__["sla_id"] = sla_id
            if time_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'time_machine_id'")
            __props__.__dict__["time_machine_id"] = time_machine_id
            __props__.__dict__["type"] = type
            __props__.__dict__["date_created"] = None
            __props__.__dict__["date_modified"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["log_drive_id"] = None
            __props__.__dict__["log_drive_status"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["schedule_id"] = None
            __props__.__dict__["source"] = None
            __props__.__dict__["source_clusters"] = None
            __props__.__dict__["status"] = None
        super(NdbTmsCluster, __self__).__init__(
            'nutanix:index/ndbTmsCluster:NdbTmsCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            date_modified: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            log_drive_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_drive_status: Optional[pulumi.Input[_builtins.str]] = None,
            nx_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_id: Optional[pulumi.Input[_builtins.str]] = None,
            sla_id: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.bool]] = None,
            source_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            time_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NdbTmsCluster':
        """
        Get an existing NdbTmsCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] date_created: created date of time machine associated with cluster
        :param pulumi.Input[_builtins.str] date_modified: modified date of time machine associated with cluster
        :param pulumi.Input[_builtins.str] description: description of nutanix cluster associated with time machine
        :param pulumi.Input[_builtins.str] log_drive_id: log drive id
        :param pulumi.Input[_builtins.str] log_drive_status: log drive status of time machine
        :param pulumi.Input[_builtins.str] nx_cluster_id: Nutanix cluster id on the associated registered clusters.
        :param pulumi.Input[_builtins.str] owner_id: owner id
        :param pulumi.Input[_builtins.str] schedule_id: schedule id of the data associated with time machine
        :param pulumi.Input[_builtins.str] sla_id: SLA id for the associated cluster.
        :param pulumi.Input[_builtins.bool] source: source is present or not
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_clusters: source clusters in time machines
        :param pulumi.Input[_builtins.str] status: status of the cluster associated with time machine
        :param pulumi.Input[_builtins.str] time_machine_id: time machine id
        :param pulumi.Input[_builtins.str] type: Default value is "OTHER"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NdbTmsClusterState.__new__(_NdbTmsClusterState)

        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["date_modified"] = date_modified
        __props__.__dict__["description"] = description
        __props__.__dict__["log_drive_id"] = log_drive_id
        __props__.__dict__["log_drive_status"] = log_drive_status
        __props__.__dict__["nx_cluster_id"] = nx_cluster_id
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["schedule_id"] = schedule_id
        __props__.__dict__["sla_id"] = sla_id
        __props__.__dict__["source"] = source
        __props__.__dict__["source_clusters"] = source_clusters
        __props__.__dict__["status"] = status
        __props__.__dict__["time_machine_id"] = time_machine_id
        __props__.__dict__["type"] = type
        return NdbTmsCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        created date of time machine associated with cluster
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> pulumi.Output[_builtins.str]:
        """
        modified date of time machine associated with cluster
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        description of nutanix cluster associated with time machine
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="logDriveId")
    def log_drive_id(self) -> pulumi.Output[_builtins.str]:
        """
        log drive id
        """
        return pulumi.get(self, "log_drive_id")

    @_builtins.property
    @pulumi.getter(name="logDriveStatus")
    def log_drive_status(self) -> pulumi.Output[_builtins.str]:
        """
        log drive status of time machine
        """
        return pulumi.get(self, "log_drive_status")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Nutanix cluster id on the associated registered clusters.
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        owner id
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> pulumi.Output[_builtins.str]:
        """
        schedule id of the data associated with time machine
        """
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter(name="slaId")
    def sla_id(self) -> pulumi.Output[_builtins.str]:
        """
        SLA id for the associated cluster.
        """
        return pulumi.get(self, "sla_id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.bool]:
        """
        source is present or not
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceClusters")
    def source_clusters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        source clusters in time machines
        """
        return pulumi.get(self, "source_clusters")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        status of the cluster associated with time machine
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        time machine id
        """
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default value is "OTHER"
        """
        return pulumi.get(self, "type")

