# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkSecurityPolicyV2Args', 'NetworkSecurityPolicyV2']

@pulumi.input_type
class NetworkSecurityPolicyV2Args:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hitlog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_ipv6_traffic_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkSecurityPolicyV2 resource.
        :param pulumi.Input[_builtins.str] type: Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        :param pulumi.Input[_builtins.str] description: A user defined annotation for a policy.
        :param pulumi.Input[_builtins.bool] is_hitlog_enabled: If Hitlog is enabled.
        :param pulumi.Input[_builtins.bool] is_ipv6_traffic_allowed: If Ipv6 Traffic is allowed.
        :param pulumi.Input[_builtins.str] name: Name of the Flow Network Security Policy.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]] rules: A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        :param pulumi.Input[_builtins.str] scope: Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        :param pulumi.Input[_builtins.str] state: Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_references: A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_hitlog_enabled is not None:
            pulumi.set(__self__, "is_hitlog_enabled", is_hitlog_enabled)
        if is_ipv6_traffic_allowed is not None:
            pulumi.set(__self__, "is_ipv6_traffic_allowed", is_ipv6_traffic_allowed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vpc_references is not None:
            pulumi.set(__self__, "vpc_references", vpc_references)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user defined annotation for a policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isHitlogEnabled")
    def is_hitlog_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Hitlog is enabled.
        """
        return pulumi.get(self, "is_hitlog_enabled")

    @is_hitlog_enabled.setter
    def is_hitlog_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hitlog_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6TrafficAllowed")
    def is_ipv6_traffic_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Ipv6 Traffic is allowed.
        """
        return pulumi.get(self, "is_ipv6_traffic_allowed")

    @is_ipv6_traffic_allowed.setter
    def is_ipv6_traffic_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6_traffic_allowed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Flow Network Security Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]]:
        """
        A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferences")
    def vpc_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        return pulumi.get(self, "vpc_references")

    @vpc_references.setter
    def vpc_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_references", value)


@pulumi.input_type
class _NetworkSecurityPolicyV2State:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hitlog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_ipv6_traffic_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2LinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 secured_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkSecurityPolicyV2 resources.
        :param pulumi.Input[_builtins.str] created_by: created by.
        :param pulumi.Input[_builtins.str] creation_time: creation time of NSP
        :param pulumi.Input[_builtins.str] description: A user defined annotation for a policy.
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_hitlog_enabled: If Hitlog is enabled.
        :param pulumi.Input[_builtins.bool] is_ipv6_traffic_allowed: If Ipv6 Traffic is allowed.
        :param pulumi.Input[_builtins.bool] is_system_defined: Is system defined NSP
        :param pulumi.Input[_builtins.str] last_update_time: last updated time
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2LinkArgs']]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: Name of the Flow Network Security Policy.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]] rules: A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        :param pulumi.Input[_builtins.str] scope: Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secured_groups: Uuids of the secured groups in the NSP.
        :param pulumi.Input[_builtins.str] state: Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity
        :param pulumi.Input[_builtins.str] type: Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_references: A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_hitlog_enabled is not None:
            pulumi.set(__self__, "is_hitlog_enabled", is_hitlog_enabled)
        if is_ipv6_traffic_allowed is not None:
            pulumi.set(__self__, "is_ipv6_traffic_allowed", is_ipv6_traffic_allowed)
        if is_system_defined is not None:
            pulumi.set(__self__, "is_system_defined", is_system_defined)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if secured_groups is not None:
            pulumi.set(__self__, "secured_groups", secured_groups)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_references is not None:
            pulumi.set(__self__, "vpc_references", vpc_references)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        created by.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        creation time of NSP
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user defined annotation for a policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isHitlogEnabled")
    def is_hitlog_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Hitlog is enabled.
        """
        return pulumi.get(self, "is_hitlog_enabled")

    @is_hitlog_enabled.setter
    def is_hitlog_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hitlog_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6TrafficAllowed")
    def is_ipv6_traffic_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Ipv6 Traffic is allowed.
        """
        return pulumi.get(self, "is_ipv6_traffic_allowed")

    @is_ipv6_traffic_allowed.setter
    def is_ipv6_traffic_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6_traffic_allowed", value)

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is system defined NSP
        """
        return pulumi.get(self, "is_system_defined")

    @is_system_defined.setter
    def is_system_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_defined", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        last updated time
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2LinkArgs']]]]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Flow Network Security Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]]:
        """
        A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityPolicyV2RuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="securedGroups")
    def secured_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Uuids of the secured groups in the NSP.
        """
        return pulumi.get(self, "secured_groups")

    @secured_groups.setter
    def secured_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secured_groups", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferences")
    def vpc_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        return pulumi.get(self, "vpc_references")

    @vpc_references.setter
    def vpc_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_references", value)


@pulumi.type_token("nutanix:index/networkSecurityPolicyV2:NetworkSecurityPolicyV2")
class NetworkSecurityPolicyV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hitlog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_ipv6_traffic_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2RuleArgs', 'NetworkSecurityPolicyV2RuleArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Create a Network Security Policy

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Network Security Policy TWO_ENV_ISOLATION Rule
        isolation_nsp = nutanix.NetworkSecurityPolicyV2("isolation-nsp",
            name="isolation_policy",
            description="isolation policy example",
            state="SAVE",
            type="ISOLATION",
            rules=[{
                "type": "TWO_ENV_ISOLATION",
                "specs": [{
                    "two_env_isolation_rule_specs": [{
                        "first_isolation_groups": ["ba250e3e-1db1-4950-917f-a9e2ea35b8e3"],
                        "second_isolation_groups": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                    }],
                }],
            }],
            is_hitlog_enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A user defined annotation for a policy.
        :param pulumi.Input[_builtins.bool] is_hitlog_enabled: If Hitlog is enabled.
        :param pulumi.Input[_builtins.bool] is_ipv6_traffic_allowed: If Ipv6 Traffic is allowed.
        :param pulumi.Input[_builtins.str] name: Name of the Flow Network Security Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2RuleArgs', 'NetworkSecurityPolicyV2RuleArgsDict']]]] rules: A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        :param pulumi.Input[_builtins.str] scope: Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        :param pulumi.Input[_builtins.str] state: Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        :param pulumi.Input[_builtins.str] type: Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_references: A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSecurityPolicyV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Network Security Policy

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        # Network Security Policy TWO_ENV_ISOLATION Rule
        isolation_nsp = nutanix.NetworkSecurityPolicyV2("isolation-nsp",
            name="isolation_policy",
            description="isolation policy example",
            state="SAVE",
            type="ISOLATION",
            rules=[{
                "type": "TWO_ENV_ISOLATION",
                "specs": [{
                    "two_env_isolation_rule_specs": [{
                        "first_isolation_groups": ["ba250e3e-1db1-4950-917f-a9e2ea35b8e3"],
                        "second_isolation_groups": ["ab520e1d-4950-1db1-917f-a9e2ea35b8e3"],
                    }],
                }],
            }],
            is_hitlog_enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSecurityPolicyV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSecurityPolicyV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hitlog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_ipv6_traffic_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2RuleArgs', 'NetworkSecurityPolicyV2RuleArgsDict']]]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSecurityPolicyV2Args.__new__(NetworkSecurityPolicyV2Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["is_hitlog_enabled"] = is_hitlog_enabled
            __props__.__dict__["is_ipv6_traffic_allowed"] = is_ipv6_traffic_allowed
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["scope"] = scope
            __props__.__dict__["state"] = state
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_references"] = vpc_references
            __props__.__dict__["created_by"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_system_defined"] = None
            __props__.__dict__["last_update_time"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["secured_groups"] = None
            __props__.__dict__["tenant_id"] = None
        super(NetworkSecurityPolicyV2, __self__).__init__(
            'nutanix:index/networkSecurityPolicyV2:NetworkSecurityPolicyV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_hitlog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_ipv6_traffic_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_system_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2LinkArgs', 'NetworkSecurityPolicyV2LinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2RuleArgs', 'NetworkSecurityPolicyV2RuleArgsDict']]]]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            secured_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_references: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NetworkSecurityPolicyV2':
        """
        Get an existing NetworkSecurityPolicyV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: created by.
        :param pulumi.Input[_builtins.str] creation_time: creation time of NSP
        :param pulumi.Input[_builtins.str] description: A user defined annotation for a policy.
        :param pulumi.Input[_builtins.str] ext_id: A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.bool] is_hitlog_enabled: If Hitlog is enabled.
        :param pulumi.Input[_builtins.bool] is_ipv6_traffic_allowed: If Ipv6 Traffic is allowed.
        :param pulumi.Input[_builtins.bool] is_system_defined: Is system defined NSP
        :param pulumi.Input[_builtins.str] last_update_time: last updated time
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2LinkArgs', 'NetworkSecurityPolicyV2LinkArgsDict']]]] links: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[_builtins.str] name: Name of the Flow Network Security Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkSecurityPolicyV2RuleArgs', 'NetworkSecurityPolicyV2RuleArgsDict']]]] rules: A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        :param pulumi.Input[_builtins.str] scope: Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secured_groups: Uuids of the secured groups in the NSP.
        :param pulumi.Input[_builtins.str] state: Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        :param pulumi.Input[_builtins.str] tenant_id: A globally unique identifier that represents the tenant that owns this entity
        :param pulumi.Input[_builtins.str] type: Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_references: A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSecurityPolicyV2State.__new__(_NetworkSecurityPolicyV2State)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_hitlog_enabled"] = is_hitlog_enabled
        __props__.__dict__["is_ipv6_traffic_allowed"] = is_ipv6_traffic_allowed
        __props__.__dict__["is_system_defined"] = is_system_defined
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["scope"] = scope
        __props__.__dict__["secured_groups"] = secured_groups
        __props__.__dict__["state"] = state
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_references"] = vpc_references
        return NetworkSecurityPolicyV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        created by.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        creation time of NSP
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user defined annotation for a policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isHitlogEnabled")
    def is_hitlog_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If Hitlog is enabled.
        """
        return pulumi.get(self, "is_hitlog_enabled")

    @_builtins.property
    @pulumi.getter(name="isIpv6TrafficAllowed")
    def is_ipv6_traffic_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If Ipv6 Traffic is allowed.
        """
        return pulumi.get(self, "is_ipv6_traffic_allowed")

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        Is system defined NSP
        """
        return pulumi.get(self, "is_system_defined")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[_builtins.str]:
        """
        last updated time
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.NetworkSecurityPolicyV2Link']]:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Flow Network Security Policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkSecurityPolicyV2Rule']]]:
        """
        A list of rules that form a policy. For isolation policies, use isolation rules; for application or quarantine policies, use application rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the scope of the policy. Currently, only ALL_VLAN and VPC_LIST are supported. If scope is not provided, the default is set based on whether vpcReferences field is provided or not.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="securedGroups")
    def secured_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Uuids of the secured groups in the NSP.
        """
        return pulumi.get(self, "secured_groups")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether the policy is applied or monitored; can be omitted or set null to save the policy without applying or monitoring it. Acceptable values are "SAVE", "MONITOR", "ENFORCE".
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the type of rules that can be used in a policy. Acceptable values are "QUARANTINE", "ISOLATION", "APPLICATION".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcReferences")
    def vpc_references(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of external ids for VPCs, used only when the scope of policy is a list of VPCs.
        """
        return pulumi.get(self, "vpc_references")

