# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgtInstallationV2Args', 'NgtInstallationV2']

@pulumi.input_type
class NgtInstallationV2Args:
    def __init__(__self__, *,
                 ext_id: pulumi.Input[_builtins.str],
                 capablities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential: Optional[pulumi.Input['NgtInstallationV2CredentialArgs']] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_preference: Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']] = None):
        """
        The set of arguments for constructing a NgtInstallationV2 resource.
        :param pulumi.Input[_builtins.str] ext_id: uuid of the Virtual Machine.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capablities: The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        :param pulumi.Input['NgtInstallationV2CredentialArgs'] credential: Sign in credentials for the server.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates whether Nutanix Guest Tools is enabled or not.
        :param pulumi.Input['NgtInstallationV2RebootPreferenceArgs'] reboot_preference: The restart schedule after installing or upgrading Nutanix Guest Tools.
        """
        pulumi.set(__self__, "ext_id", ext_id)
        if capablities is not None:
            pulumi.set(__self__, "capablities", capablities)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if reboot_preference is not None:
            pulumi.set(__self__, "reboot_preference", reboot_preference)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        uuid of the Virtual Machine.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def capablities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        """
        return pulumi.get(self, "capablities")

    @capablities.setter
    def capablities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capablities", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['NgtInstallationV2CredentialArgs']]:
        """
        Sign in credentials for the server.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['NgtInstallationV2CredentialArgs']]):
        pulumi.set(self, "credential", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether Nutanix Guest Tools is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="rebootPreference")
    def reboot_preference(self) -> Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']]:
        """
        The restart schedule after installing or upgrading Nutanix Guest Tools.
        """
        return pulumi.get(self, "reboot_preference")

    @reboot_preference.setter
    def reboot_preference(self, value: Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']]):
        pulumi.set(self, "reboot_preference", value)


@pulumi.input_type
class _NgtInstallationV2State:
    def __init__(__self__, *,
                 available_version: Optional[pulumi.Input[_builtins.str]] = None,
                 capablities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential: Optional[pulumi.Input['NgtInstallationV2CredentialArgs']] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_installed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_iso_inserted: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vm_mobility_drivers_installed: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_vss_snapshot_capable: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_preference: Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgtInstallationV2 resources.
        :param pulumi.Input[_builtins.str] available_version: Version of Nutanix Guest Tools available on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capablities: The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        :param pulumi.Input['NgtInstallationV2CredentialArgs'] credential: Sign in credentials for the server.
        :param pulumi.Input[_builtins.str] ext_id: uuid of the Virtual Machine.
        :param pulumi.Input[_builtins.str] guest_os_version: Version of the operating system on the VM.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates whether Nutanix Guest Tools is enabled or not.
        :param pulumi.Input[_builtins.bool] is_installed: Indicates whether Nutanix Guest Tools is installed on the VM or not.
        :param pulumi.Input[_builtins.bool] is_iso_inserted: Indicates whether Nutanix Guest Tools ISO is inserted or not.
        :param pulumi.Input[_builtins.bool] is_reachable: Indicates whether the communication from VM to CVM is active or not.
        :param pulumi.Input[_builtins.bool] is_vm_mobility_drivers_installed: Indicates whether the VM mobility drivers are installed on the VM or not.
        :param pulumi.Input[_builtins.bool] is_vss_snapshot_capable: Indicates whether the VM is configured to take VSS snapshots through NGT or not.
        :param pulumi.Input['NgtInstallationV2RebootPreferenceArgs'] reboot_preference: The restart schedule after installing or upgrading Nutanix Guest Tools.
        :param pulumi.Input[_builtins.str] version: Version of Nutanix Guest Tools installed on the VM.
        """
        if available_version is not None:
            pulumi.set(__self__, "available_version", available_version)
        if capablities is not None:
            pulumi.set(__self__, "capablities", capablities)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if guest_os_version is not None:
            pulumi.set(__self__, "guest_os_version", guest_os_version)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_installed is not None:
            pulumi.set(__self__, "is_installed", is_installed)
        if is_iso_inserted is not None:
            pulumi.set(__self__, "is_iso_inserted", is_iso_inserted)
        if is_reachable is not None:
            pulumi.set(__self__, "is_reachable", is_reachable)
        if is_vm_mobility_drivers_installed is not None:
            pulumi.set(__self__, "is_vm_mobility_drivers_installed", is_vm_mobility_drivers_installed)
        if is_vss_snapshot_capable is not None:
            pulumi.set(__self__, "is_vss_snapshot_capable", is_vss_snapshot_capable)
        if reboot_preference is not None:
            pulumi.set(__self__, "reboot_preference", reboot_preference)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="availableVersion")
    def available_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Nutanix Guest Tools available on the cluster.
        """
        return pulumi.get(self, "available_version")

    @available_version.setter
    def available_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "available_version", value)

    @_builtins.property
    @pulumi.getter
    def capablities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        """
        return pulumi.get(self, "capablities")

    @capablities.setter
    def capablities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capablities", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['NgtInstallationV2CredentialArgs']]:
        """
        Sign in credentials for the server.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['NgtInstallationV2CredentialArgs']]):
        pulumi.set(self, "credential", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        uuid of the Virtual Machine.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="guestOsVersion")
    def guest_os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the operating system on the VM.
        """
        return pulumi.get(self, "guest_os_version")

    @guest_os_version.setter
    def guest_os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_os_version", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether Nutanix Guest Tools is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isInstalled")
    def is_installed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether Nutanix Guest Tools is installed on the VM or not.
        """
        return pulumi.get(self, "is_installed")

    @is_installed.setter
    def is_installed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_installed", value)

    @_builtins.property
    @pulumi.getter(name="isIsoInserted")
    def is_iso_inserted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether Nutanix Guest Tools ISO is inserted or not.
        """
        return pulumi.get(self, "is_iso_inserted")

    @is_iso_inserted.setter
    def is_iso_inserted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_iso_inserted", value)

    @_builtins.property
    @pulumi.getter(name="isReachable")
    def is_reachable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the communication from VM to CVM is active or not.
        """
        return pulumi.get(self, "is_reachable")

    @is_reachable.setter
    def is_reachable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_reachable", value)

    @_builtins.property
    @pulumi.getter(name="isVmMobilityDriversInstalled")
    def is_vm_mobility_drivers_installed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM mobility drivers are installed on the VM or not.
        """
        return pulumi.get(self, "is_vm_mobility_drivers_installed")

    @is_vm_mobility_drivers_installed.setter
    def is_vm_mobility_drivers_installed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vm_mobility_drivers_installed", value)

    @_builtins.property
    @pulumi.getter(name="isVssSnapshotCapable")
    def is_vss_snapshot_capable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the VM is configured to take VSS snapshots through NGT or not.
        """
        return pulumi.get(self, "is_vss_snapshot_capable")

    @is_vss_snapshot_capable.setter
    def is_vss_snapshot_capable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_vss_snapshot_capable", value)

    @_builtins.property
    @pulumi.getter(name="rebootPreference")
    def reboot_preference(self) -> Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']]:
        """
        The restart schedule after installing or upgrading Nutanix Guest Tools.
        """
        return pulumi.get(self, "reboot_preference")

    @reboot_preference.setter
    def reboot_preference(self, value: Optional[pulumi.Input['NgtInstallationV2RebootPreferenceArgs']]):
        pulumi.set(self, "reboot_preference", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Nutanix Guest Tools installed on the VM.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("nutanix:index/ngtInstallationV2:NgtInstallationV2")
class NgtInstallationV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capablities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential: Optional[pulumi.Input[Union['NgtInstallationV2CredentialArgs', 'NgtInstallationV2CredentialArgsDict']]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_preference: Optional[pulumi.Input[Union['NgtInstallationV2RebootPreferenceArgs', 'NgtInstallationV2RebootPreferenceArgsDict']]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to Installs Nutanix Guest Tools in a Virtual Machine by using the provided credentials.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.NgtInstallationV2("example",
            ext_id="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            credential={
                "username": "username",
                "password": "pass.1234567890",
            },
            reboot_preference={
                "schedule_type": "IMMEDIATE",
            },
            capablities=["VSS_SNAPSHOT"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capablities: The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        :param pulumi.Input[Union['NgtInstallationV2CredentialArgs', 'NgtInstallationV2CredentialArgsDict']] credential: Sign in credentials for the server.
        :param pulumi.Input[_builtins.str] ext_id: uuid of the Virtual Machine.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates whether Nutanix Guest Tools is enabled or not.
        :param pulumi.Input[Union['NgtInstallationV2RebootPreferenceArgs', 'NgtInstallationV2RebootPreferenceArgsDict']] reboot_preference: The restart schedule after installing or upgrading Nutanix Guest Tools.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgtInstallationV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to Installs Nutanix Guest Tools in a Virtual Machine by using the provided credentials.

        ## Example

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.NgtInstallationV2("example",
            ext_id="ab520e1d-4950-1db1-917f-a9e2ea35b8e3",
            credential={
                "username": "username",
                "password": "pass.1234567890",
            },
            reboot_preference={
                "schedule_type": "IMMEDIATE",
            },
            capablities=["VSS_SNAPSHOT"])
        ```

        :param str resource_name: The name of the resource.
        :param NgtInstallationV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgtInstallationV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capablities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential: Optional[pulumi.Input[Union['NgtInstallationV2CredentialArgs', 'NgtInstallationV2CredentialArgsDict']]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 reboot_preference: Optional[pulumi.Input[Union['NgtInstallationV2RebootPreferenceArgs', 'NgtInstallationV2RebootPreferenceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgtInstallationV2Args.__new__(NgtInstallationV2Args)

            __props__.__dict__["capablities"] = capablities
            __props__.__dict__["credential"] = credential
            if ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'ext_id'")
            __props__.__dict__["ext_id"] = ext_id
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["reboot_preference"] = reboot_preference
            __props__.__dict__["available_version"] = None
            __props__.__dict__["guest_os_version"] = None
            __props__.__dict__["is_installed"] = None
            __props__.__dict__["is_iso_inserted"] = None
            __props__.__dict__["is_reachable"] = None
            __props__.__dict__["is_vm_mobility_drivers_installed"] = None
            __props__.__dict__["is_vss_snapshot_capable"] = None
            __props__.__dict__["version"] = None
        super(NgtInstallationV2, __self__).__init__(
            'nutanix:index/ngtInstallationV2:NgtInstallationV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_version: Optional[pulumi.Input[_builtins.str]] = None,
            capablities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            credential: Optional[pulumi.Input[Union['NgtInstallationV2CredentialArgs', 'NgtInstallationV2CredentialArgsDict']]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            guest_os_version: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_installed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_iso_inserted: Optional[pulumi.Input[_builtins.bool]] = None,
            is_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
            is_vm_mobility_drivers_installed: Optional[pulumi.Input[_builtins.bool]] = None,
            is_vss_snapshot_capable: Optional[pulumi.Input[_builtins.bool]] = None,
            reboot_preference: Optional[pulumi.Input[Union['NgtInstallationV2RebootPreferenceArgs', 'NgtInstallationV2RebootPreferenceArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgtInstallationV2':
        """
        Get an existing NgtInstallationV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] available_version: Version of Nutanix Guest Tools available on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capablities: The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        :param pulumi.Input[Union['NgtInstallationV2CredentialArgs', 'NgtInstallationV2CredentialArgsDict']] credential: Sign in credentials for the server.
        :param pulumi.Input[_builtins.str] ext_id: uuid of the Virtual Machine.
        :param pulumi.Input[_builtins.str] guest_os_version: Version of the operating system on the VM.
        :param pulumi.Input[_builtins.bool] is_enabled: Indicates whether Nutanix Guest Tools is enabled or not.
        :param pulumi.Input[_builtins.bool] is_installed: Indicates whether Nutanix Guest Tools is installed on the VM or not.
        :param pulumi.Input[_builtins.bool] is_iso_inserted: Indicates whether Nutanix Guest Tools ISO is inserted or not.
        :param pulumi.Input[_builtins.bool] is_reachable: Indicates whether the communication from VM to CVM is active or not.
        :param pulumi.Input[_builtins.bool] is_vm_mobility_drivers_installed: Indicates whether the VM mobility drivers are installed on the VM or not.
        :param pulumi.Input[_builtins.bool] is_vss_snapshot_capable: Indicates whether the VM is configured to take VSS snapshots through NGT or not.
        :param pulumi.Input[Union['NgtInstallationV2RebootPreferenceArgs', 'NgtInstallationV2RebootPreferenceArgsDict']] reboot_preference: The restart schedule after installing or upgrading Nutanix Guest Tools.
        :param pulumi.Input[_builtins.str] version: Version of Nutanix Guest Tools installed on the VM.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgtInstallationV2State.__new__(_NgtInstallationV2State)

        __props__.__dict__["available_version"] = available_version
        __props__.__dict__["capablities"] = capablities
        __props__.__dict__["credential"] = credential
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["guest_os_version"] = guest_os_version
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["is_installed"] = is_installed
        __props__.__dict__["is_iso_inserted"] = is_iso_inserted
        __props__.__dict__["is_reachable"] = is_reachable
        __props__.__dict__["is_vm_mobility_drivers_installed"] = is_vm_mobility_drivers_installed
        __props__.__dict__["is_vss_snapshot_capable"] = is_vss_snapshot_capable
        __props__.__dict__["reboot_preference"] = reboot_preference
        __props__.__dict__["version"] = version
        return NgtInstallationV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availableVersion")
    def available_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Nutanix Guest Tools available on the cluster.
        """
        return pulumi.get(self, "available_version")

    @_builtins.property
    @pulumi.getter
    def capablities(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        """
        return pulumi.get(self, "capablities")

    @_builtins.property
    @pulumi.getter
    def credential(self) -> pulumi.Output[Optional['outputs.NgtInstallationV2Credential']]:
        """
        Sign in credentials for the server.
        """
        return pulumi.get(self, "credential")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        uuid of the Virtual Machine.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="guestOsVersion")
    def guest_os_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the operating system on the VM.
        """
        return pulumi.get(self, "guest_os_version")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether Nutanix Guest Tools is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="isInstalled")
    def is_installed(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether Nutanix Guest Tools is installed on the VM or not.
        """
        return pulumi.get(self, "is_installed")

    @_builtins.property
    @pulumi.getter(name="isIsoInserted")
    def is_iso_inserted(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether Nutanix Guest Tools ISO is inserted or not.
        """
        return pulumi.get(self, "is_iso_inserted")

    @_builtins.property
    @pulumi.getter(name="isReachable")
    def is_reachable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the communication from VM to CVM is active or not.
        """
        return pulumi.get(self, "is_reachable")

    @_builtins.property
    @pulumi.getter(name="isVmMobilityDriversInstalled")
    def is_vm_mobility_drivers_installed(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VM mobility drivers are installed on the VM or not.
        """
        return pulumi.get(self, "is_vm_mobility_drivers_installed")

    @_builtins.property
    @pulumi.getter(name="isVssSnapshotCapable")
    def is_vss_snapshot_capable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the VM is configured to take VSS snapshots through NGT or not.
        """
        return pulumi.get(self, "is_vss_snapshot_capable")

    @_builtins.property
    @pulumi.getter(name="rebootPreference")
    def reboot_preference(self) -> pulumi.Output[Optional['outputs.NgtInstallationV2RebootPreference']]:
        """
        The restart schedule after installing or upgrading Nutanix Guest Tools.
        """
        return pulumi.get(self, "reboot_preference")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Nutanix Guest Tools installed on the VM.
        """
        return pulumi.get(self, "version")

