# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectStoreCertificateV2Args', 'ObjectStoreCertificateV2']

@pulumi.input_type
class ObjectStoreCertificateV2Args:
    def __init__(__self__, *,
                 object_store_ext_id: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ObjectStoreCertificateV2 resource.
        :param pulumi.Input[_builtins.str] object_store_ext_id: -(Required) The UUID of the Object store.
        :param pulumi.Input[_builtins.str] path: -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        pulumi.set(__self__, "object_store_ext_id", object_store_ext_id)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="objectStoreExtId")
    def object_store_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) The UUID of the Object store.
        """
        return pulumi.get(self, "object_store_ext_id")

    @object_store_ext_id.setter
    def object_store_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_store_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class _ObjectStoreCertificateV2State:
    def __init__(__self__, *,
                 alternate_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateFqdnArgs']]]] = None,
                 alternate_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateIpArgs']]]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2LinkArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2MetadataArgs']]]] = None,
                 object_store_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectStoreCertificateV2 resources.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The UUID of the certificate of an Object store.
        :param pulumi.Input[_builtins.str] object_store_ext_id: -(Required) The UUID of the Object store.
        :param pulumi.Input[_builtins.str] path: -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        if alternate_fqdns is not None:
            pulumi.set(__self__, "alternate_fqdns", alternate_fqdns)
        if alternate_ips is not None:
            pulumi.set(__self__, "alternate_ips", alternate_ips)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if object_store_ext_id is not None:
            pulumi.set(__self__, "object_store_ext_id", object_store_ext_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="alternateFqdns")
    def alternate_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateFqdnArgs']]]]:
        return pulumi.get(self, "alternate_fqdns")

    @alternate_fqdns.setter
    def alternate_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateFqdnArgs']]]]):
        pulumi.set(self, "alternate_fqdns", value)

    @_builtins.property
    @pulumi.getter(name="alternateIps")
    def alternate_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateIpArgs']]]]:
        return pulumi.get(self, "alternate_ips")

    @alternate_ips.setter
    def alternate_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2AlternateIpArgs']]]]):
        pulumi.set(self, "alternate_ips", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The UUID of the certificate of an Object store.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2MetadataArgs']]]]:
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreCertificateV2MetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="objectStoreExtId")
    def object_store_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The UUID of the Object store.
        """
        return pulumi.get(self, "object_store_ext_id")

    @object_store_ext_id.setter
    def object_store_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_store_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/objectStoreCertificateV2:ObjectStoreCertificateV2")
class ObjectStoreCertificateV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_store_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This operation creates a new default certificate and keys. It also creates the alternate FQDNs and alternate IPs for the Object store. The certificate of an Object store can be created when it is in a OBJECT_STORE_AVAILABLE or OBJECT_STORE_CERT_CREATION_FAILED state. If the publicCert, privateKey, and ca values are provided in the request body, these values are used to create the new certificate. If these values are not provided, a new certificate will be generated if 'shouldGenerate' is set to true and if it is set to false, the existing certificate will be used as the new certificate. Optionally, a list of additional alternate FQDNs and alternate IPs can be provided. These alternateFqdns and alternateIps must be included in the CA certificate if it has been provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.get_certificate_v2(object_store_ext_id="ac91151a-28b4-4ffe-b150-6bcb2ec80cd4",
            ext_id="ef0a9a54-e7e1-42e2-a59f-de779ec1c9ea")
        ```

        ## JSON Example

        See detailed information in [Nutanix Create a SSL certificate for an Object store V4 ](https://developers.nutanix.com/api-reference?namespace=objects&version=v4.0#tag/ObjectStores/operation/createCertificate).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_store_ext_id: -(Required) The UUID of the Object store.
        :param pulumi.Input[_builtins.str] path: -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectStoreCertificateV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This operation creates a new default certificate and keys. It also creates the alternate FQDNs and alternate IPs for the Object store. The certificate of an Object store can be created when it is in a OBJECT_STORE_AVAILABLE or OBJECT_STORE_CERT_CREATION_FAILED state. If the publicCert, privateKey, and ca values are provided in the request body, these values are used to create the new certificate. If these values are not provided, a new certificate will be generated if 'shouldGenerate' is set to true and if it is set to false, the existing certificate will be used as the new certificate. Optionally, a list of additional alternate FQDNs and alternate IPs can be provided. These alternateFqdns and alternateIps must be included in the CA certificate if it has been provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.get_certificate_v2(object_store_ext_id="ac91151a-28b4-4ffe-b150-6bcb2ec80cd4",
            ext_id="ef0a9a54-e7e1-42e2-a59f-de779ec1c9ea")
        ```

        ## JSON Example

        See detailed information in [Nutanix Create a SSL certificate for an Object store V4 ](https://developers.nutanix.com/api-reference?namespace=objects&version=v4.0#tag/ObjectStores/operation/createCertificate).

        :param str resource_name: The name of the resource.
        :param ObjectStoreCertificateV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStoreCertificateV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_store_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStoreCertificateV2Args.__new__(ObjectStoreCertificateV2Args)

            if object_store_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_store_ext_id'")
            __props__.__dict__["object_store_ext_id"] = object_store_ext_id
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["alternate_fqdns"] = None
            __props__.__dict__["alternate_ips"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["tenant_id"] = None
        super(ObjectStoreCertificateV2, __self__).__init__(
            'nutanix:index/objectStoreCertificateV2:ObjectStoreCertificateV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreCertificateV2AlternateFqdnArgs', 'ObjectStoreCertificateV2AlternateFqdnArgsDict']]]]] = None,
            alternate_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreCertificateV2AlternateIpArgs', 'ObjectStoreCertificateV2AlternateIpArgsDict']]]]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreCertificateV2LinkArgs', 'ObjectStoreCertificateV2LinkArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreCertificateV2MetadataArgs', 'ObjectStoreCertificateV2MetadataArgsDict']]]]] = None,
            object_store_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObjectStoreCertificateV2':
        """
        Get an existing ObjectStoreCertificateV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ext_id: -(Required) The UUID of the certificate of an Object store.
        :param pulumi.Input[_builtins.str] object_store_ext_id: -(Required) The UUID of the Object store.
        :param pulumi.Input[_builtins.str] path: -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStoreCertificateV2State.__new__(_ObjectStoreCertificateV2State)

        __props__.__dict__["alternate_fqdns"] = alternate_fqdns
        __props__.__dict__["alternate_ips"] = alternate_ips
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["links"] = links
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["object_store_ext_id"] = object_store_ext_id
        __props__.__dict__["path"] = path
        __props__.__dict__["tenant_id"] = tenant_id
        return ObjectStoreCertificateV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alternateFqdns")
    def alternate_fqdns(self) -> pulumi.Output[Sequence['outputs.ObjectStoreCertificateV2AlternateFqdn']]:
        return pulumi.get(self, "alternate_fqdns")

    @_builtins.property
    @pulumi.getter(name="alternateIps")
    def alternate_ips(self) -> pulumi.Output[Sequence['outputs.ObjectStoreCertificateV2AlternateIp']]:
        return pulumi.get(self, "alternate_ips")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The UUID of the certificate of an Object store.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ObjectStoreCertificateV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.ObjectStoreCertificateV2Metadata']]:
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="objectStoreExtId")
    def object_store_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The UUID of the Object store.
        """
        return pulumi.get(self, "object_store_ext_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) Path to a JSON file which contains the public certificates, private key, and CA certificate or chain, along with a list of alternate FQDNs and alternate IPs to create a certificate for the Object store.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

