# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectStoreV2Args', 'ObjectStoreV2']

@pulumi.input_type
class ObjectStoreV2Args:
    def __init__(__self__, *,
                 certificate_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_worker_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 public_network_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]] = None,
                 public_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_dns_ip: Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']] = None,
                 storage_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_vip: Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']] = None,
                 total_capacity_gib: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ObjectStoreV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ext_ids: - A list of the UUIDs of the certificates of an Object store.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Optional) UUID of the AHV or ESXi cluster.
        :param pulumi.Input[_builtins.str] deployment_version: -(Optional) The deployment version of the Object store.
        :param pulumi.Input[_builtins.str] description: -(Optional) A brief description of the Object store.
        :param pulumi.Input[_builtins.str] domain: -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]] metadatas: -(Optional) Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: -(Required) The name of the Object store.
        :param pulumi.Input[_builtins.int] num_worker_nodes: -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]] public_network_ips: -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        :param pulumi.Input[_builtins.str] public_network_reference: -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[_builtins.str] region: -(Optional) The region in which the Object store is deployed.
        :param pulumi.Input[_builtins.str] state: -(Optional) Enum for the state of the Object store.
               | Enum                                   | Description                                                     |
               |----------------------------------------|-----------------------------------------------------------------|
               | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
               | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
               | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
               | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
               | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
               | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
               | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
               | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
               | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
               | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        :param pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs'] storage_network_dns_ip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] storage_network_reference: -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input['ObjectStoreV2StorageNetworkVipArgs'] storage_network_vip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.int] total_capacity_gib: -(Optional) Size of the Object store in GiB.
        """
        if certificate_ext_ids is not None:
            pulumi.set(__self__, "certificate_ext_ids", certificate_ext_ids)
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if deployment_version is not None:
            pulumi.set(__self__, "deployment_version", deployment_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_worker_nodes is not None:
            pulumi.set(__self__, "num_worker_nodes", num_worker_nodes)
        if public_network_ips is not None:
            pulumi.set(__self__, "public_network_ips", public_network_ips)
        if public_network_reference is not None:
            pulumi.set(__self__, "public_network_reference", public_network_reference)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_network_dns_ip is not None:
            pulumi.set(__self__, "storage_network_dns_ip", storage_network_dns_ip)
        if storage_network_reference is not None:
            pulumi.set(__self__, "storage_network_reference", storage_network_reference)
        if storage_network_vip is not None:
            pulumi.set(__self__, "storage_network_vip", storage_network_vip)
        if total_capacity_gib is not None:
            pulumi.set(__self__, "total_capacity_gib", total_capacity_gib)

    @_builtins.property
    @pulumi.getter(name="certificateExtIds")
    def certificate_ext_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - A list of the UUIDs of the certificates of an Object store.
        """
        return pulumi.get(self, "certificate_ext_ids")

    @certificate_ext_ids.setter
    def certificate_ext_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_ext_ids", value)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) UUID of the AHV or ESXi cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="deploymentVersion")
    def deployment_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The deployment version of the Object store.
        """
        return pulumi.get(self, "deployment_version")

    @deployment_version.setter
    def deployment_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A brief description of the Object store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]]:
        """
        -(Optional) Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The name of the Object store.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numWorkerNodes")
    def num_worker_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        """
        return pulumi.get(self, "num_worker_nodes")

    @num_worker_nodes.setter
    def num_worker_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_worker_nodes", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkIps")
    def public_network_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]]:
        """
        -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        """
        return pulumi.get(self, "public_network_ips")

    @public_network_ips.setter
    def public_network_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]]):
        pulumi.set(self, "public_network_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkReference")
    def public_network_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "public_network_reference")

    @public_network_reference.setter
    def public_network_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_reference", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The region in which the Object store is deployed.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Enum for the state of the Object store.
        | Enum                                   | Description                                                     |
        |----------------------------------------|-----------------------------------------------------------------|
        | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
        | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
        | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
        | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
        | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
        | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
        | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
        | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
        | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
        | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkDnsIp")
    def storage_network_dns_ip(self) -> Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']]:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_dns_ip")

    @storage_network_dns_ip.setter
    def storage_network_dns_ip(self, value: Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']]):
        pulumi.set(self, "storage_network_dns_ip", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkReference")
    def storage_network_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "storage_network_reference")

    @storage_network_reference.setter
    def storage_network_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_network_reference", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkVip")
    def storage_network_vip(self) -> Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']]:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_vip")

    @storage_network_vip.setter
    def storage_network_vip(self, value: Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']]):
        pulumi.set(self, "storage_network_vip", value)

    @_builtins.property
    @pulumi.getter(name="totalCapacityGib")
    def total_capacity_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Size of the Object store in GiB.
        """
        return pulumi.get(self, "total_capacity_gib")

    @total_capacity_gib.setter
    def total_capacity_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_capacity_gib", value)


@pulumi.input_type
class _ObjectStoreV2State:
    def __init__(__self__, *,
                 certificate_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2LinkArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_worker_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 public_network_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]] = None,
                 public_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_dns_ip: Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']] = None,
                 storage_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_vip: Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 total_capacity_gib: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ObjectStoreV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ext_ids: - A list of the UUIDs of the certificates of an Object store.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Optional) UUID of the AHV or ESXi cluster.
        :param pulumi.Input[_builtins.str] creation_time: - The time when the Object store was created.
        :param pulumi.Input[_builtins.str] deployment_version: -(Optional) The deployment version of the Object store.
        :param pulumi.Input[_builtins.str] description: -(Optional) A brief description of the Object store.
        :param pulumi.Input[_builtins.str] domain: -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] last_update_time: - The time when the Object store was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2LinkArgs']]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]] metadatas: -(Optional) Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: -(Required) The name of the Object store.
        :param pulumi.Input[_builtins.int] num_worker_nodes: -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]] public_network_ips: -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        :param pulumi.Input[_builtins.str] public_network_reference: -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[_builtins.str] region: -(Optional) The region in which the Object store is deployed.
        :param pulumi.Input[_builtins.str] state: -(Optional) Enum for the state of the Object store.
               | Enum                                   | Description                                                     |
               |----------------------------------------|-----------------------------------------------------------------|
               | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
               | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
               | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
               | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
               | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
               | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
               | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
               | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
               | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
               | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        :param pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs'] storage_network_dns_ip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] storage_network_reference: -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input['ObjectStoreV2StorageNetworkVipArgs'] storage_network_vip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        :param pulumi.Input[_builtins.int] total_capacity_gib: -(Optional) Size of the Object store in GiB.
        """
        if certificate_ext_ids is not None:
            pulumi.set(__self__, "certificate_ext_ids", certificate_ext_ids)
        if cluster_ext_id is not None:
            pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deployment_version is not None:
            pulumi.set(__self__, "deployment_version", deployment_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_worker_nodes is not None:
            pulumi.set(__self__, "num_worker_nodes", num_worker_nodes)
        if public_network_ips is not None:
            pulumi.set(__self__, "public_network_ips", public_network_ips)
        if public_network_reference is not None:
            pulumi.set(__self__, "public_network_reference", public_network_reference)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_network_dns_ip is not None:
            pulumi.set(__self__, "storage_network_dns_ip", storage_network_dns_ip)
        if storage_network_reference is not None:
            pulumi.set(__self__, "storage_network_reference", storage_network_reference)
        if storage_network_vip is not None:
            pulumi.set(__self__, "storage_network_vip", storage_network_vip)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if total_capacity_gib is not None:
            pulumi.set(__self__, "total_capacity_gib", total_capacity_gib)

    @_builtins.property
    @pulumi.getter(name="certificateExtIds")
    def certificate_ext_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        - A list of the UUIDs of the certificates of an Object store.
        """
        return pulumi.get(self, "certificate_ext_ids")

    @certificate_ext_ids.setter
    def certificate_ext_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_ext_ids", value)

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) UUID of the AHV or ESXi cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @cluster_ext_id.setter
    def cluster_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the Object store was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="deploymentVersion")
    def deployment_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The deployment version of the Object store.
        """
        return pulumi.get(self, "deployment_version")

    @deployment_version.setter
    def deployment_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) A brief description of the Object store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - The time when the Object store was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2LinkArgs']]]]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]]:
        """
        -(Optional) Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2MetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) The name of the Object store.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numWorkerNodes")
    def num_worker_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        """
        return pulumi.get(self, "num_worker_nodes")

    @num_worker_nodes.setter
    def num_worker_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_worker_nodes", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkIps")
    def public_network_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]]:
        """
        -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        """
        return pulumi.get(self, "public_network_ips")

    @public_network_ips.setter
    def public_network_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStoreV2PublicNetworkIpArgs']]]]):
        pulumi.set(self, "public_network_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkReference")
    def public_network_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "public_network_reference")

    @public_network_reference.setter
    def public_network_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_reference", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) The region in which the Object store is deployed.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Enum for the state of the Object store.
        | Enum                                   | Description                                                     |
        |----------------------------------------|-----------------------------------------------------------------|
        | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
        | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
        | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
        | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
        | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
        | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
        | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
        | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
        | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
        | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkDnsIp")
    def storage_network_dns_ip(self) -> Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']]:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_dns_ip")

    @storage_network_dns_ip.setter
    def storage_network_dns_ip(self, value: Optional[pulumi.Input['ObjectStoreV2StorageNetworkDnsIpArgs']]):
        pulumi.set(self, "storage_network_dns_ip", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkReference")
    def storage_network_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "storage_network_reference")

    @storage_network_reference.setter
    def storage_network_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_network_reference", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworkVip")
    def storage_network_vip(self) -> Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']]:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_vip")

    @storage_network_vip.setter
    def storage_network_vip(self, value: Optional[pulumi.Input['ObjectStoreV2StorageNetworkVipArgs']]):
        pulumi.set(self, "storage_network_vip", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="totalCapacityGib")
    def total_capacity_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        -(Optional) Size of the Object store in GiB.
        """
        return pulumi.get(self, "total_capacity_gib")

    @total_capacity_gib.setter
    def total_capacity_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_capacity_gib", value)


@pulumi.type_token("nutanix:index/objectStoreV2:ObjectStoreV2")
class ObjectStoreV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2MetadataArgs', 'ObjectStoreV2MetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_worker_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 public_network_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2PublicNetworkIpArgs', 'ObjectStoreV2PublicNetworkIpArgsDict']]]]] = None,
                 public_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_dns_ip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkDnsIpArgs', 'ObjectStoreV2StorageNetworkDnsIpArgsDict']]] = None,
                 storage_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_vip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkVipArgs', 'ObjectStoreV2StorageNetworkVipArgsDict']]] = None,
                 total_capacity_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix
        import pulumi_std as std

        example = nutanix.ObjectStoreV2("example",
            name="tf-example-os",
            description="terraform create object store example",
            deployment_version="5.1.1",
            domain="msp.pc-idbc.nutanix.com",
            num_worker_nodes=1,
            cluster_ext_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            total_capacity_gib=20 * std.pow(base=1024,
                exponent=3).result,
            public_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            public_network_ips=[{
                "ipv4": {
                    "value": "10.44.77.123",
                },
            }],
            storage_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            storage_network_dns_ip={
                "ipv4": {
                    "value": "10.44.77.124",
                },
            },
            storage_network_vip={
                "ipv4": {
                    "value": "10.44.77.125",
                },
            })
        # Deploying Object Store in draft state
        example_draft = nutanix.ObjectStoreV2("example-draft",
            name="tf-draft-os",
            description="terraform deploy object store draft example",
            deployment_version="5.1.1",
            domain="msp.pc-idbc.nutanix.com",
            num_worker_nodes=1,
            cluster_ext_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            total_capacity_gib=20 * std.pow(base=1024,
                exponent=3).result,
            public_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            state="UNDEPLOYED_OBJECT_STORE",
            public_network_ips=[{
                "ipv4": {
                    "value": "10.44.77.126",
                },
            }],
            storage_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            storage_network_dns_ip={
                "ipv4": {
                    "value": "10.44.77.127",
                },
            },
            storage_network_vip={
                "ipv4": {
                    "value": "10.44.77.128",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ext_ids: - A list of the UUIDs of the certificates of an Object store.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Optional) UUID of the AHV or ESXi cluster.
        :param pulumi.Input[_builtins.str] deployment_version: -(Optional) The deployment version of the Object store.
        :param pulumi.Input[_builtins.str] description: -(Optional) A brief description of the Object store.
        :param pulumi.Input[_builtins.str] domain: -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2MetadataArgs', 'ObjectStoreV2MetadataArgsDict']]]] metadatas: -(Optional) Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: -(Required) The name of the Object store.
        :param pulumi.Input[_builtins.int] num_worker_nodes: -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2PublicNetworkIpArgs', 'ObjectStoreV2PublicNetworkIpArgsDict']]]] public_network_ips: -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        :param pulumi.Input[_builtins.str] public_network_reference: -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[_builtins.str] region: -(Optional) The region in which the Object store is deployed.
        :param pulumi.Input[_builtins.str] state: -(Optional) Enum for the state of the Object store.
               | Enum                                   | Description                                                     |
               |----------------------------------------|-----------------------------------------------------------------|
               | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
               | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
               | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
               | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
               | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
               | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
               | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
               | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
               | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
               | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        :param pulumi.Input[Union['ObjectStoreV2StorageNetworkDnsIpArgs', 'ObjectStoreV2StorageNetworkDnsIpArgsDict']] storage_network_dns_ip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] storage_network_reference: -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[Union['ObjectStoreV2StorageNetworkVipArgs', 'ObjectStoreV2StorageNetworkVipArgsDict']] storage_network_vip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.int] total_capacity_gib: -(Optional) Size of the Object store in GiB.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ObjectStoreV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix
        import pulumi_std as std

        example = nutanix.ObjectStoreV2("example",
            name="tf-example-os",
            description="terraform create object store example",
            deployment_version="5.1.1",
            domain="msp.pc-idbc.nutanix.com",
            num_worker_nodes=1,
            cluster_ext_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            total_capacity_gib=20 * std.pow(base=1024,
                exponent=3).result,
            public_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            public_network_ips=[{
                "ipv4": {
                    "value": "10.44.77.123",
                },
            }],
            storage_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            storage_network_dns_ip={
                "ipv4": {
                    "value": "10.44.77.124",
                },
            },
            storage_network_vip={
                "ipv4": {
                    "value": "10.44.77.125",
                },
            })
        # Deploying Object Store in draft state
        example_draft = nutanix.ObjectStoreV2("example-draft",
            name="tf-draft-os",
            description="terraform deploy object store draft example",
            deployment_version="5.1.1",
            domain="msp.pc-idbc.nutanix.com",
            num_worker_nodes=1,
            cluster_ext_id="ba250e3e-1db1-4950-917f-a9e2ea35b8e3",
            total_capacity_gib=20 * std.pow(base=1024,
                exponent=3).result,
            public_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            state="UNDEPLOYED_OBJECT_STORE",
            public_network_ips=[{
                "ipv4": {
                    "value": "10.44.77.126",
                },
            }],
            storage_network_reference="57c4caf1-67e3-457e-8265-6d872f2a3135",
            storage_network_dns_ip={
                "ipv4": {
                    "value": "10.44.77.127",
                },
            },
            storage_network_vip={
                "ipv4": {
                    "value": "10.44.77.128",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param ObjectStoreV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStoreV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2MetadataArgs', 'ObjectStoreV2MetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_worker_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 public_network_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2PublicNetworkIpArgs', 'ObjectStoreV2PublicNetworkIpArgsDict']]]]] = None,
                 public_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_dns_ip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkDnsIpArgs', 'ObjectStoreV2StorageNetworkDnsIpArgsDict']]] = None,
                 storage_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_network_vip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkVipArgs', 'ObjectStoreV2StorageNetworkVipArgsDict']]] = None,
                 total_capacity_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStoreV2Args.__new__(ObjectStoreV2Args)

            __props__.__dict__["certificate_ext_ids"] = certificate_ext_ids
            __props__.__dict__["cluster_ext_id"] = cluster_ext_id
            __props__.__dict__["deployment_version"] = deployment_version
            __props__.__dict__["description"] = description
            __props__.__dict__["domain"] = domain
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["name"] = name
            __props__.__dict__["num_worker_nodes"] = num_worker_nodes
            __props__.__dict__["public_network_ips"] = public_network_ips
            __props__.__dict__["public_network_reference"] = public_network_reference
            __props__.__dict__["region"] = region
            __props__.__dict__["state"] = state
            __props__.__dict__["storage_network_dns_ip"] = storage_network_dns_ip
            __props__.__dict__["storage_network_reference"] = storage_network_reference
            __props__.__dict__["storage_network_vip"] = storage_network_vip
            __props__.__dict__["total_capacity_gib"] = total_capacity_gib
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["last_update_time"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
        super(ObjectStoreV2, __self__).__init__(
            'nutanix:index/objectStoreV2:ObjectStoreV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_ext_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_version: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_update_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2LinkArgs', 'ObjectStoreV2LinkArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2MetadataArgs', 'ObjectStoreV2MetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            num_worker_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            public_network_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2PublicNetworkIpArgs', 'ObjectStoreV2PublicNetworkIpArgsDict']]]]] = None,
            public_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_network_dns_ip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkDnsIpArgs', 'ObjectStoreV2StorageNetworkDnsIpArgsDict']]] = None,
            storage_network_reference: Optional[pulumi.Input[_builtins.str]] = None,
            storage_network_vip: Optional[pulumi.Input[Union['ObjectStoreV2StorageNetworkVipArgs', 'ObjectStoreV2StorageNetworkVipArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            total_capacity_gib: Optional[pulumi.Input[_builtins.int]] = None) -> 'ObjectStoreV2':
        """
        Get an existing ObjectStoreV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_ext_ids: - A list of the UUIDs of the certificates of an Object store.
        :param pulumi.Input[_builtins.str] cluster_ext_id: -(Optional) UUID of the AHV or ESXi cluster.
        :param pulumi.Input[_builtins.str] creation_time: - The time when the Object store was created.
        :param pulumi.Input[_builtins.str] deployment_version: -(Optional) The deployment version of the Object store.
        :param pulumi.Input[_builtins.str] description: -(Optional) A brief description of the Object store.
        :param pulumi.Input[_builtins.str] domain: -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        :param pulumi.Input[_builtins.str] ext_id: - A globally unique identifier of an instance that is suitable for external consumption.
        :param pulumi.Input[_builtins.str] last_update_time: - The time when the Object store was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2LinkArgs', 'ObjectStoreV2LinkArgsDict']]]] links: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2MetadataArgs', 'ObjectStoreV2MetadataArgsDict']]]] metadatas: -(Optional) Metadata associated with this resource.
        :param pulumi.Input[_builtins.str] name: -(Required) The name of the Object store.
        :param pulumi.Input[_builtins.int] num_worker_nodes: -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStoreV2PublicNetworkIpArgs', 'ObjectStoreV2PublicNetworkIpArgsDict']]]] public_network_ips: -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        :param pulumi.Input[_builtins.str] public_network_reference: -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[_builtins.str] region: -(Optional) The region in which the Object store is deployed.
        :param pulumi.Input[_builtins.str] state: -(Optional) Enum for the state of the Object store.
               | Enum                                   | Description                                                     |
               |----------------------------------------|-----------------------------------------------------------------|
               | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
               | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
               | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
               | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
               | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
               | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
               | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
               | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
               | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
               | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        :param pulumi.Input[Union['ObjectStoreV2StorageNetworkDnsIpArgs', 'ObjectStoreV2StorageNetworkDnsIpArgsDict']] storage_network_dns_ip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] storage_network_reference: -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        :param pulumi.Input[Union['ObjectStoreV2StorageNetworkVipArgs', 'ObjectStoreV2StorageNetworkVipArgsDict']] storage_network_vip: -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        :param pulumi.Input[_builtins.str] tenant_id: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        :param pulumi.Input[_builtins.int] total_capacity_gib: -(Optional) Size of the Object store in GiB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStoreV2State.__new__(_ObjectStoreV2State)

        __props__.__dict__["certificate_ext_ids"] = certificate_ext_ids
        __props__.__dict__["cluster_ext_id"] = cluster_ext_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deployment_version"] = deployment_version
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["last_update_time"] = last_update_time
        __props__.__dict__["links"] = links
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["num_worker_nodes"] = num_worker_nodes
        __props__.__dict__["public_network_ips"] = public_network_ips
        __props__.__dict__["public_network_reference"] = public_network_reference
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_network_dns_ip"] = storage_network_dns_ip
        __props__.__dict__["storage_network_reference"] = storage_network_reference
        __props__.__dict__["storage_network_vip"] = storage_network_vip
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["total_capacity_gib"] = total_capacity_gib
        return ObjectStoreV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateExtIds")
    def certificate_ext_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        - A list of the UUIDs of the certificates of an Object store.
        """
        return pulumi.get(self, "certificate_ext_ids")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) UUID of the AHV or ESXi cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the Object store was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="deploymentVersion")
    def deployment_version(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) The deployment version of the Object store.
        """
        return pulumi.get(self, "deployment_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) A brief description of the Object store.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[_builtins.str]:
        """
        - The time when the Object store was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.ObjectStoreV2Link']]:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.ObjectStoreV2Metadata']]:
        """
        -(Optional) Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) The name of the Object store.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numWorkerNodes")
    def num_worker_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        """
        return pulumi.get(self, "num_worker_nodes")

    @_builtins.property
    @pulumi.getter(name="publicNetworkIps")
    def public_network_ips(self) -> pulumi.Output[Sequence['outputs.ObjectStoreV2PublicNetworkIp']]:
        """
        -(Optional) A list of static IP addresses used as public IPs to access the Object store.
        """
        return pulumi.get(self, "public_network_ips")

    @_builtins.property
    @pulumi.getter(name="publicNetworkReference")
    def public_network_reference(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "public_network_reference")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) The region in which the Object store is deployed.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Enum for the state of the Object store.
        | Enum                                   | Description                                                     |
        |----------------------------------------|-----------------------------------------------------------------|
        | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
        | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
        | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
        | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
        | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
        | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
        | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
        | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
        | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
        | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageNetworkDnsIp")
    def storage_network_dns_ip(self) -> pulumi.Output['outputs.ObjectStoreV2StorageNetworkDnsIp']:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_dns_ip")

    @_builtins.property
    @pulumi.getter(name="storageNetworkReference")
    def storage_network_reference(self) -> pulumi.Output[_builtins.str]:
        """
        -(Optional) Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "storage_network_reference")

    @_builtins.property
    @pulumi.getter(name="storageNetworkVip")
    def storage_network_vip(self) -> pulumi.Output['outputs.ObjectStoreV2StorageNetworkVip']:
        """
        -(Optional) An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_vip")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="totalCapacityGib")
    def total_capacity_gib(self) -> pulumi.Output[_builtins.int]:
        """
        -(Optional) Size of the Object store in GiB.
        """
        return pulumi.get(self, "total_capacity_gib")

