# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PbrArgs', 'Pbr']

@pulumi.input_type
class PbrArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 destination: pulumi.Input['PbrDestinationArgs'],
                 priority: pulumi.Input[_builtins.int],
                 protocol_type: pulumi.Input[_builtins.str],
                 source: pulumi.Input['PbrSourceArgs'],
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_bidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_parameters: Optional[pulumi.Input['PbrProtocolParametersArgs']] = None,
                 service_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Pbr resource.
        :param pulumi.Input[_builtins.str] action: Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        :param pulumi.Input[_builtins.int] priority: priority of policy
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.bool] is_bidirectional: Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        :param pulumi.Input[_builtins.str] name: name of policy
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_ip_lists: IP addresses of network services. This field is valid only when action is REROUTE.
        :param pulumi.Input[_builtins.str] vpc_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc . Should not be used with {vpc_name} .
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "source", source)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if is_bidirectional is not None:
            pulumi.set(__self__, "is_bidirectional", is_bidirectional)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_parameters is not None:
            pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        if service_ip_lists is not None:
            pulumi.set(__self__, "service_ip_lists", service_ip_lists)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['PbrDestinationArgs']:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['PbrDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        priority of policy
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['PbrSourceArgs']:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['PbrSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="isBidirectional")
    def is_bidirectional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        """
        return pulumi.get(self, "is_bidirectional")

    @is_bidirectional.setter
    def is_bidirectional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_bidirectional", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PbrProtocolParametersArgs']]:
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PbrProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpLists")
    def service_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP addresses of network services. This field is valid only when action is REROUTE.
        """
        return pulumi.get(self, "service_ip_lists")

    @service_ip_lists.setter
    def service_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc . Should not be used with {vpc_name} .
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)


@pulumi.input_type
class _PbrState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['PbrDestinationArgs']] = None,
                 is_bidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input['PbrProtocolParametersArgs']] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input['PbrSourceArgs']] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Pbr resources.
        :param pulumi.Input[_builtins.str] action: Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.bool] is_bidirectional: Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The routing policies kind metadata.
        :param pulumi.Input[_builtins.str] name: name of policy
        :param pulumi.Input[_builtins.int] priority: priority of policy
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_ip_lists: IP addresses of network services. This field is valid only when action is REROUTE.
        :param pulumi.Input[_builtins.str] vpc_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc . Should not be used with {vpc_name} .
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if is_bidirectional is not None:
            pulumi.set(__self__, "is_bidirectional", is_bidirectional)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol_parameters is not None:
            pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if service_ip_lists is not None:
            pulumi.set(__self__, "service_ip_lists", service_ip_lists)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if vpc_reference_uuid is not None:
            pulumi.set(__self__, "vpc_reference_uuid", vpc_reference_uuid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['PbrDestinationArgs']]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['PbrDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="isBidirectional")
    def is_bidirectional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        """
        return pulumi.get(self, "is_bidirectional")

    @is_bidirectional.setter
    def is_bidirectional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_bidirectional", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The routing policies kind metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        priority of policy
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PbrProtocolParametersArgs']]:
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PbrProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpLists")
    def service_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP addresses of network services. This field is valid only when action is REROUTE.
        """
        return pulumi.get(self, "service_ip_lists")

    @service_ip_lists.setter
    def service_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_ip_lists", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['PbrSourceArgs']]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['PbrSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reference to a vpc . Should not be used with {vpc_name} .
        """
        return pulumi.get(self, "vpc_reference_uuid")

    @vpc_reference_uuid.setter
    def vpc_reference_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_reference_uuid", value)


@pulumi.type_token("nutanix:index/pbr:Pbr")
class Pbr(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['PbrDestinationArgs', 'PbrDestinationArgsDict']]] = None,
                 is_bidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input[Union['PbrProtocolParametersArgs', 'PbrProtocolParametersArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['PbrSourceArgs', 'PbrSourceArgsDict']]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Nutanix resource to create Policy Based Routing inside VPCs.

        ## Example Usage

        ### pbr creation with vpc name with any source or destination or protocol with permit action

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        pbr = nutanix.Pbr("pbr",
            name="test-policy-1",
            priority=123,
            protocol_type="ALL",
            action="PERMIT",
            vpc_name="test123",
            source={
                "address_type": "ALL",
            },
            destination={
                "address_type": "ALL",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.bool] is_bidirectional: Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        :param pulumi.Input[_builtins.str] name: name of policy
        :param pulumi.Input[_builtins.int] priority: priority of policy
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_ip_lists: IP addresses of network services. This field is valid only when action is REROUTE.
        :param pulumi.Input[_builtins.str] vpc_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc . Should not be used with {vpc_name} .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PbrArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Nutanix resource to create Policy Based Routing inside VPCs.

        ## Example Usage

        ### pbr creation with vpc name with any source or destination or protocol with permit action

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        pbr = nutanix.Pbr("pbr",
            name="test-policy-1",
            priority=123,
            protocol_type="ALL",
            action="PERMIT",
            vpc_name="test123",
            source={
                "address_type": "ALL",
            },
            destination={
                "address_type": "ALL",
            })
        ```

        :param str resource_name: The name of the resource.
        :param PbrArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PbrArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['PbrDestinationArgs', 'PbrDestinationArgsDict']]] = None,
                 is_bidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input[Union['PbrProtocolParametersArgs', 'PbrProtocolParametersArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[Union['PbrSourceArgs', 'PbrSourceArgsDict']]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PbrArgs.__new__(PbrArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["api_version"] = api_version
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["is_bidirectional"] = is_bidirectional
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["protocol_parameters"] = protocol_parameters
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["service_ip_lists"] = service_ip_lists
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["vpc_name"] = vpc_name
            __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
            __props__.__dict__["metadata"] = None
        super(Pbr, __self__).__init__(
            'nutanix:index/pbr:Pbr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['PbrDestinationArgs', 'PbrDestinationArgsDict']]] = None,
            is_bidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            protocol_parameters: Optional[pulumi.Input[Union['PbrProtocolParametersArgs', 'PbrProtocolParametersArgsDict']]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source: Optional[pulumi.Input[Union['PbrSourceArgs', 'PbrSourceArgsDict']]] = None,
            vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_reference_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'Pbr':
        """
        Get an existing Pbr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        :param pulumi.Input[_builtins.str] api_version: The version of the API.
        :param pulumi.Input[_builtins.bool] is_bidirectional: Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The routing policies kind metadata.
        :param pulumi.Input[_builtins.str] name: name of policy
        :param pulumi.Input[_builtins.int] priority: priority of policy
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_ip_lists: IP addresses of network services. This field is valid only when action is REROUTE.
        :param pulumi.Input[_builtins.str] vpc_name: The reference to a vpc. Should not be used with {vpc_reference_uuid}
        :param pulumi.Input[_builtins.str] vpc_reference_uuid: The reference to a vpc . Should not be used with {vpc_name} .
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PbrState.__new__(_PbrState)

        __props__.__dict__["action"] = action
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["destination"] = destination
        __props__.__dict__["is_bidirectional"] = is_bidirectional
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol_parameters"] = protocol_parameters
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["service_ip_lists"] = service_ip_lists
        __props__.__dict__["source"] = source
        __props__.__dict__["vpc_name"] = vpc_name
        __props__.__dict__["vpc_reference_uuid"] = vpc_reference_uuid
        return Pbr(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Routing policy action. Must be one of {DENY, PERMIT, REROUTE} .
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.PbrDestination']:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="isBidirectional")
    def is_bidirectional(self) -> pulumi.Output[_builtins.bool]:
        """
        Additionally create Policy in reverse direction. Should be used with {TCP, UDP with start and end port ranges and ICMP with icmp code and type}. Supported with 2022.x.
        """
        return pulumi.get(self, "is_bidirectional")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The routing policies kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        name of policy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        priority of policy
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> pulumi.Output[Optional['outputs.PbrProtocolParameters']]:
        return pulumi.get(self, "protocol_parameters")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol type of policy based routing. Must be one of {TCP, UDP, ICMP, PROTOCOL_NUMBER, ALL} .
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="serviceIpLists")
    def service_ip_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        IP addresses of network services. This field is valid only when action is REROUTE.
        """
        return pulumi.get(self, "service_ip_lists")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.PbrSource']:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[_builtins.str]:
        """
        The reference to a vpc. Should not be used with {vpc_reference_uuid}
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceUuid")
    def vpc_reference_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The reference to a vpc . Should not be used with {vpc_name} .
        """
        return pulumi.get(self, "vpc_reference_uuid")

