# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PcBackupTargetV2Args', 'PcBackupTargetV2']

@pulumi.input_type
class PcBackupTargetV2Args:
    def __init__(__self__, *,
                 domain_manager_ext_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input['PcBackupTargetV2LocationArgs']):
        """
        The set of arguments for constructing a PcBackupTargetV2 resource.
        :param pulumi.Input[_builtins.str] domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input['PcBackupTargetV2LocationArgs'] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        pulumi.set(__self__, "domain_manager_ext_id", domain_manager_ext_id)
        pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter(name="domainManagerExtId")
    def domain_manager_ext_id(self) -> pulumi.Input[_builtins.str]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "domain_manager_ext_id")

    @domain_manager_ext_id.setter
    def domain_manager_ext_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_manager_ext_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input['PcBackupTargetV2LocationArgs']:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['PcBackupTargetV2LocationArgs']):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _PcBackupTargetV2State:
    def __init__(__self__, *,
                 backup_pause_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_backup_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['PcBackupTargetV2LinkArgs']]]] = None,
                 location: Optional[pulumi.Input['PcBackupTargetV2LocationArgs']] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PcBackupTargetV2 resources.
        :param pulumi.Input[_builtins.str] domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input['PcBackupTargetV2LocationArgs'] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        if backup_pause_reason is not None:
            pulumi.set(__self__, "backup_pause_reason", backup_pause_reason)
        if domain_manager_ext_id is not None:
            pulumi.set(__self__, "domain_manager_ext_id", domain_manager_ext_id)
        if ext_id is not None:
            pulumi.set(__self__, "ext_id", ext_id)
        if is_backup_paused is not None:
            pulumi.set(__self__, "is_backup_paused", is_backup_paused)
        if last_sync_time is not None:
            pulumi.set(__self__, "last_sync_time", last_sync_time)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="backupPauseReason")
    def backup_pause_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_pause_reason")

    @backup_pause_reason.setter
    def backup_pause_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_pause_reason", value)

    @_builtins.property
    @pulumi.getter(name="domainManagerExtId")
    def domain_manager_ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "domain_manager_ext_id")

    @domain_manager_ext_id.setter
    def domain_manager_ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_manager_ext_id", value)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ext_id")

    @ext_id.setter
    def ext_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ext_id", value)

    @_builtins.property
    @pulumi.getter(name="isBackupPaused")
    def is_backup_paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_backup_paused")

    @is_backup_paused.setter
    def is_backup_paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_backup_paused", value)

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_sync_time")

    @last_sync_time.setter
    def last_sync_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_sync_time", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PcBackupTargetV2LinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PcBackupTargetV2LinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['PcBackupTargetV2LocationArgs']]:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['PcBackupTargetV2LocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("nutanix:index/pcBackupTargetV2:PcBackupTargetV2")
class PcBackupTargetV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[Union['PcBackupTargetV2LocationArgs', 'PcBackupTargetV2LocationArgsDict']]] = None,
                 __props__=None):
        """
        Create a cluster or object store as the backup target. For a given Prism Central, there can be up to 3 clusters as backup targets and 1 object store as backup target. If any cluster or object store is not eligible for backup or lacks appropriate permissions, the API request will fail. For object store backup targets, specifying backup policy is mandatory along with the location of the object store.

        ## Example Usage

        ### Cluster Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cluster_location = nutanix.PcBackupTargetV2("cluster-location",
            domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
            location={
                "cluster_locations": [{
                    "configs": [{
                        "ext_id": "323860ca-bd10-411e-9fe0-1430b62eaf45",
                    }],
                }],
            })
        ```

        ### Object Store Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        #using object store location
        object_store_location = nutanix.PcBackupTargetV2("object-store-location",
            domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
            location={
                "object_store_locations": [{
                    "provider_configs": [{
                        "bucket_name": "nutanix-terraform-bucket",
                        "region": "us-west-1",
                        "credentials": {
                            "access_key_id": "IHSAJHDHADFWYTKJHFGCJKHASGJHKDSA",
                            "secret_access_key": "JGSDHJYHGFHGHDS+JKBASDF/HSDAFHJ+SjkfbdsASDfdJFdSDFJfk",
                        },
                    }],
                    "backup_policies": [{
                        "rpo_in_minutes": 120,
                    }],
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[Union['PcBackupTargetV2LocationArgs', 'PcBackupTargetV2LocationArgsDict']] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcBackupTargetV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a cluster or object store as the backup target. For a given Prism Central, there can be up to 3 clusters as backup targets and 1 object store as backup target. If any cluster or object store is not eligible for backup or lacks appropriate permissions, the API request will fail. For object store backup targets, specifying backup policy is mandatory along with the location of the object store.

        ## Example Usage

        ### Cluster Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        cluster_location = nutanix.PcBackupTargetV2("cluster-location",
            domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
            location={
                "cluster_locations": [{
                    "configs": [{
                        "ext_id": "323860ca-bd10-411e-9fe0-1430b62eaf45",
                    }],
                }],
            })
        ```

        ### Object Store Location

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        #using object store location
        object_store_location = nutanix.PcBackupTargetV2("object-store-location",
            domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
            location={
                "object_store_locations": [{
                    "provider_configs": [{
                        "bucket_name": "nutanix-terraform-bucket",
                        "region": "us-west-1",
                        "credentials": {
                            "access_key_id": "IHSAJHDHADFWYTKJHFGCJKHASGJHKDSA",
                            "secret_access_key": "JGSDHJYHGFHGHDS+JKBASDF/HSDAFHJ+SjkfbdsASDfdJFdSDFJfk",
                        },
                    }],
                    "backup_policies": [{
                        "rpo_in_minutes": 120,
                    }],
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param PcBackupTargetV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcBackupTargetV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[Union['PcBackupTargetV2LocationArgs', 'PcBackupTargetV2LocationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcBackupTargetV2Args.__new__(PcBackupTargetV2Args)

            if domain_manager_ext_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_manager_ext_id'")
            __props__.__dict__["domain_manager_ext_id"] = domain_manager_ext_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["backup_pause_reason"] = None
            __props__.__dict__["ext_id"] = None
            __props__.__dict__["is_backup_paused"] = None
            __props__.__dict__["last_sync_time"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tenant_id"] = None
        super(PcBackupTargetV2, __self__).__init__(
            'nutanix:index/pcBackupTargetV2:PcBackupTargetV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_pause_reason: Optional[pulumi.Input[_builtins.str]] = None,
            domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            ext_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_backup_paused: Optional[pulumi.Input[_builtins.bool]] = None,
            last_sync_time: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PcBackupTargetV2LinkArgs', 'PcBackupTargetV2LinkArgsDict']]]]] = None,
            location: Optional[pulumi.Input[Union['PcBackupTargetV2LocationArgs', 'PcBackupTargetV2LocationArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PcBackupTargetV2':
        """
        Get an existing PcBackupTargetV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
        :param pulumi.Input[Union['PcBackupTargetV2LocationArgs', 'PcBackupTargetV2LocationArgsDict']] location: -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcBackupTargetV2State.__new__(_PcBackupTargetV2State)

        __props__.__dict__["backup_pause_reason"] = backup_pause_reason
        __props__.__dict__["domain_manager_ext_id"] = domain_manager_ext_id
        __props__.__dict__["ext_id"] = ext_id
        __props__.__dict__["is_backup_paused"] = is_backup_paused
        __props__.__dict__["last_sync_time"] = last_sync_time
        __props__.__dict__["links"] = links
        __props__.__dict__["location"] = location
        __props__.__dict__["tenant_id"] = tenant_id
        return PcBackupTargetV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPauseReason")
    def backup_pause_reason(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "backup_pause_reason")

    @_builtins.property
    @pulumi.getter(name="domainManagerExtId")
    def domain_manager_ext_id(self) -> pulumi.Output[_builtins.str]:
        """
        -(Required) A unique identifier for the domain manager.
        """
        return pulumi.get(self, "domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="isBackupPaused")
    def is_backup_paused(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_backup_paused")

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "last_sync_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.PcBackupTargetV2Link']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output['outputs.PcBackupTargetV2Location']:
        """
        -(Required) Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

