# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PcDeployV2Args', 'PcDeployV2']

@pulumi.input_type
class PcDeployV2Args:
    def __init__(__self__, *,
                 config: pulumi.Input['PcDeployV2ConfigArgs'],
                 network: pulumi.Input['PcDeployV2NetworkArgs'],
                 should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PcDeployV2 resource.
        :param pulumi.Input['PcDeployV2ConfigArgs'] config: -(Required) Domain manager (Prism Central) cluster configuration details.
        :param pulumi.Input['PcDeployV2NetworkArgs'] network: -(Required) Domain manager (Prism Central) network configuration details.
        :param pulumi.Input[_builtins.bool] should_enable_high_availability: -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "network", network)
        if should_enable_high_availability is not None:
            pulumi.set(__self__, "should_enable_high_availability", should_enable_high_availability)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['PcDeployV2ConfigArgs']:
        """
        -(Required) Domain manager (Prism Central) cluster configuration details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['PcDeployV2ConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input['PcDeployV2NetworkArgs']:
        """
        -(Required) Domain manager (Prism Central) network configuration details.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input['PcDeployV2NetworkArgs']):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        return pulumi.get(self, "should_enable_high_availability")

    @should_enable_high_availability.setter
    def should_enable_high_availability(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_high_availability", value)


@pulumi.input_type
class _PcDeployV2State:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['PcDeployV2ConfigArgs']] = None,
                 network: Optional[pulumi.Input['PcDeployV2NetworkArgs']] = None,
                 should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering PcDeployV2 resources.
        :param pulumi.Input['PcDeployV2ConfigArgs'] config: -(Required) Domain manager (Prism Central) cluster configuration details.
        :param pulumi.Input['PcDeployV2NetworkArgs'] network: -(Required) Domain manager (Prism Central) network configuration details.
        :param pulumi.Input[_builtins.bool] should_enable_high_availability: -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if should_enable_high_availability is not None:
            pulumi.set(__self__, "should_enable_high_availability", should_enable_high_availability)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['PcDeployV2ConfigArgs']]:
        """
        -(Required) Domain manager (Prism Central) cluster configuration details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['PcDeployV2ConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['PcDeployV2NetworkArgs']]:
        """
        -(Required) Domain manager (Prism Central) network configuration details.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['PcDeployV2NetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        return pulumi.get(self, "should_enable_high_availability")

    @should_enable_high_availability.setter
    def should_enable_high_availability(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_high_availability", value)


@pulumi.type_token("nutanix:index/pcDeployV2:PcDeployV2")
class PcDeployV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['PcDeployV2ConfigArgs', 'PcDeployV2ConfigArgsDict']]] = None,
                 network: Optional[pulumi.Input[Union['PcDeployV2NetworkArgs', 'PcDeployV2NetworkArgsDict']]] = None,
                 should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        > - The Pc Deploy V2 resource is an action-only resource that supports creating actions. The update and delete operations have no effect. To run it again, destroy and reapply the resource.
        > - We need to increase the timeout for deploying the PC resource because the deployment takes longer than the default timeout allows for the operation to complete.

        Deploys a Prism Central using the provided details. Prism Central Size, Network Config are mandatory fields to deploy Prism Central. The response from this endpoint contains the URL in the task object location header that can be used to track the request status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.PcDeployV2("example",
            config={
                "build_info": {
                    "version": "pc.2024.3",
                },
                "size": "STARTER",
                "name": "PC_EXAMPLE",
            },
            network={
                "external_networks": [{
                    "network_ext_id": "ba416f8d-00f2-499d-bc4c-19da8d104af9",
                    "default_gateway": {
                        "ipv4s": [{
                            "value": "10.97.64.1",
                        }],
                    },
                    "subnet_mask": {
                        "ipv4s": [{
                            "value": "255.255.252.0",
                        }],
                    },
                    "ip_ranges": [{
                        "begin": {
                            "ipv4s": [{
                                "value": "10.97.64.91",
                            }],
                        },
                        "end": {
                            "ipv4s": [{
                                "value": "10.97.64.91",
                            }],
                        },
                    }],
                }],
                "name_servers": [
                    {
                        "ipv4s": [{
                            "value": "10.40.64.16",
                        }],
                    },
                    {
                        "ipv4s": [{
                            "value": "10.40.64.15",
                        }],
                    },
                ],
                "ntp_servers": [
                    {
                        "fqdns": [{
                            "value": "2.centos.pool.ntp.org",
                        }],
                    },
                    {
                        "fqdns": [{
                            "value": "3.centos.pool.ntp.org",
                        }],
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcDeployV2ConfigArgs', 'PcDeployV2ConfigArgsDict']] config: -(Required) Domain manager (Prism Central) cluster configuration details.
        :param pulumi.Input[Union['PcDeployV2NetworkArgs', 'PcDeployV2NetworkArgsDict']] network: -(Required) Domain manager (Prism Central) network configuration details.
        :param pulumi.Input[_builtins.bool] should_enable_high_availability: -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PcDeployV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > - The Pc Deploy V2 resource is an action-only resource that supports creating actions. The update and delete operations have no effect. To run it again, destroy and reapply the resource.
        > - We need to increase the timeout for deploying the PC resource because the deployment takes longer than the default timeout allows for the operation to complete.

        Deploys a Prism Central using the provided details. Prism Central Size, Network Config are mandatory fields to deploy Prism Central. The response from this endpoint contains the URL in the task object location header that can be used to track the request status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_nutanix as nutanix

        example = nutanix.PcDeployV2("example",
            config={
                "build_info": {
                    "version": "pc.2024.3",
                },
                "size": "STARTER",
                "name": "PC_EXAMPLE",
            },
            network={
                "external_networks": [{
                    "network_ext_id": "ba416f8d-00f2-499d-bc4c-19da8d104af9",
                    "default_gateway": {
                        "ipv4s": [{
                            "value": "10.97.64.1",
                        }],
                    },
                    "subnet_mask": {
                        "ipv4s": [{
                            "value": "255.255.252.0",
                        }],
                    },
                    "ip_ranges": [{
                        "begin": {
                            "ipv4s": [{
                                "value": "10.97.64.91",
                            }],
                        },
                        "end": {
                            "ipv4s": [{
                                "value": "10.97.64.91",
                            }],
                        },
                    }],
                }],
                "name_servers": [
                    {
                        "ipv4s": [{
                            "value": "10.40.64.16",
                        }],
                    },
                    {
                        "ipv4s": [{
                            "value": "10.40.64.15",
                        }],
                    },
                ],
                "ntp_servers": [
                    {
                        "fqdns": [{
                            "value": "2.centos.pool.ntp.org",
                        }],
                    },
                    {
                        "fqdns": [{
                            "value": "3.centos.pool.ntp.org",
                        }],
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param PcDeployV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PcDeployV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['PcDeployV2ConfigArgs', 'PcDeployV2ConfigArgsDict']]] = None,
                 network: Optional[pulumi.Input[Union['PcDeployV2NetworkArgs', 'PcDeployV2NetworkArgsDict']]] = None,
                 should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PcDeployV2Args.__new__(PcDeployV2Args)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["should_enable_high_availability"] = should_enable_high_availability
        super(PcDeployV2, __self__).__init__(
            'nutanix:index/pcDeployV2:PcDeployV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['PcDeployV2ConfigArgs', 'PcDeployV2ConfigArgsDict']]] = None,
            network: Optional[pulumi.Input[Union['PcDeployV2NetworkArgs', 'PcDeployV2NetworkArgsDict']]] = None,
            should_enable_high_availability: Optional[pulumi.Input[_builtins.bool]] = None) -> 'PcDeployV2':
        """
        Get an existing PcDeployV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PcDeployV2ConfigArgs', 'PcDeployV2ConfigArgsDict']] config: -(Required) Domain manager (Prism Central) cluster configuration details.
        :param pulumi.Input[Union['PcDeployV2NetworkArgs', 'PcDeployV2NetworkArgsDict']] network: -(Required) Domain manager (Prism Central) network configuration details.
        :param pulumi.Input[_builtins.bool] should_enable_high_availability: -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PcDeployV2State.__new__(_PcDeployV2State)

        __props__.__dict__["config"] = config
        __props__.__dict__["network"] = network
        __props__.__dict__["should_enable_high_availability"] = should_enable_high_availability
        return PcDeployV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.PcDeployV2Config']:
        """
        -(Required) Domain manager (Prism Central) cluster configuration details.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.PcDeployV2Network']:
        """
        -(Required) Domain manager (Prism Central) network configuration details.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        -(Optional) This configuration enables Prism Central to be deployed in scale-out mode. Default is `false`.
        """
        return pulumi.get(self, "should_enable_high_availability")

